/*
 * Decompiled with CFR 0.152.
 */
package org.rust.lang.core.types.infer;

import com.intellij.openapi.progress.ProgressManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.lang.core.types.infer.PendingPredicateObligation;
import org.rust.lang.core.types.infer.Predicate;
import org.rust.lang.core.types.infer.ProcessPredicateResult;
import org.rust.lang.core.types.infer.TypeInferenceMarks;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0003%&'B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u001b\u001a\u00020\u0003J\u001a\u0010\u001c\u001a\u0004\u0018\u00010\b2\u0006\u0010\u001d\u001a\u00020\u00182\b\u0010\u001e\u001a\u0004\u0018\u00010\bJ$\u0010\u001f\u001a\u00020 2\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020#0\"2\b\b\u0002\u0010$\u001a\u00020\u0003R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR9\u0010\u0011\u001a*\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0012j\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u0007`\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0017\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006("}, d2={"Lorg/rust/lang/core/types/infer/ObligationForest;", "", "traceObligations", "", "<init>", "(Z)V", "nodes", "", "Lorg/rust/lang/core/types/infer/ObligationForest$Node;", "doneCache", "", "Lorg/rust/lang/core/types/infer/Predicate;", "errors", "getErrors", "()Ljava/util/List;", "roots", "getRoots", "parentToChildren", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "getParentToChildren", "()Ljava/util/HashMap;", "pendingObligations", "Lkotlin/sequences/Sequence;", "Lorg/rust/lang/core/types/infer/PendingPredicateObligation;", "getPendingObligations", "()Lkotlin/sequences/Sequence;", "checkObligationsLimit", "registerObligationAt", "obligation", "parent", "processObligations", "Lorg/rust/lang/core/types/infer/ObligationForest$ProcessObligationsResult;", "processor", "Lkotlin/Function1;", "Lorg/rust/lang/core/types/infer/ProcessPredicateResult;", "breakOnFirstError", "NodeState", "ProcessObligationsResult", "Node", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nFulfillment.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Fulfillment.kt\norg/rust/lang/core/types/infer/ObligationForest\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,325:1\n382#2,7:326\n*S KotlinDebug\n*F\n+ 1 Fulfillment.kt\norg/rust/lang/core/types/infer/ObligationForest\n*L\n169#1:326,7\n*E\n"})
public final class ObligationForest {
    private final boolean traceObligations;
    @NotNull
    private final List<Node> nodes;
    @NotNull
    private final Set<Predicate> doneCache;
    @NotNull
    private final List<Node> errors;
    @NotNull
    private final List<Node> roots;
    @NotNull
    private final HashMap<Node, List<Node>> parentToChildren;
    @NotNull
    private final Sequence<PendingPredicateObligation> pendingObligations;

    public ObligationForest(boolean traceObligations) {
        this.traceObligations = traceObligations;
        this.nodes = new ArrayList();
        this.doneCache = new HashSet();
        this.errors = new ArrayList();
        this.roots = new ArrayList();
        this.parentToChildren = new HashMap();
        this.pendingObligations = SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)this.nodes), ObligationForest::pendingObligations$lambda$0), ObligationForest::pendingObligations$lambda$1);
    }

    @NotNull
    public final List<Node> getErrors() {
        return this.errors;
    }

    @NotNull
    public final List<Node> getRoots() {
        return this.roots;
    }

    @NotNull
    public final HashMap<Node, List<Node>> getParentToChildren() {
        return this.parentToChildren;
    }

    @NotNull
    public final Sequence<PendingPredicateObligation> getPendingObligations() {
        return this.pendingObligations;
    }

    public final boolean checkObligationsLimit() {
        if (this.doneCache.size() > 500000 || this.nodes.size() > 500000) {
            TypeInferenceMarks.ObligationForestLimitExceeded.INSTANCE.hit();
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Node registerObligationAt(@NotNull PendingPredicateObligation obligation, @Nullable Node parent2) {
        Intrinsics.checkNotNullParameter((Object)obligation, (String)"obligation");
        if (!this.checkObligationsLimit()) {
            return null;
        }
        if (this.doneCache.add(obligation.getObligation().getPredicate())) {
            Node node = new Node(obligation, parent2);
            this.nodes.add(node);
            if (this.traceObligations) {
                if (parent2 == null) {
                    ((Collection)this.roots).add(node);
                } else {
                    Object object;
                    void $this$getOrPut$iv;
                    Map map2 = this.parentToChildren;
                    Node key$iv = parent2;
                    boolean $i$f$getOrPut = false;
                    Object value$iv = $this$getOrPut$iv.get(key$iv);
                    if (value$iv == null) {
                        boolean bl = false;
                        List answer$iv = new ArrayList();
                        $this$getOrPut$iv.put(key$iv, answer$iv);
                        object = answer$iv;
                    } else {
                        object = value$iv;
                    }
                    ((Collection)object).add(node);
                }
            }
            return node;
        }
        return null;
    }

    @NotNull
    public final ProcessObligationsResult processObligations(@NotNull Function1<? super PendingPredicateObligation, ? extends ProcessPredicateResult> processor2, boolean breakOnFirstError) {
        Intrinsics.checkNotNullParameter(processor2, (String)"processor");
        boolean hasErrors = false;
        boolean stalled = true;
        int n = this.nodes.size();
        for (int index = 0; index < n; ++index) {
            ProcessPredicateResult result2;
            ProgressManager.checkCanceled();
            Node node = this.nodes.get(index);
            if (node.getState() != NodeState.Pending || (result2 = (ProcessPredicateResult)processor2.invoke((Object)node.getObligation())) instanceof ProcessPredicateResult.NoChanges) continue;
            if (result2 instanceof ProcessPredicateResult.Ok) {
                stalled = false;
                node.setState(NodeState.Success);
                for (PendingPredicateObligation child : ((ProcessPredicateResult.Ok)result2).getChildren()) {
                    this.registerObligationAt(child, node);
                }
                continue;
            }
            if (result2 instanceof ProcessPredicateResult.Err) {
                hasErrors = true;
                stalled = false;
                node.setState(NodeState.Error);
                this.errors.add(node);
                if (!breakOnFirstError) continue;
                return new ProcessObligationsResult(hasErrors, stalled);
            }
            throw new NoWhenBranchMatchedException();
        }
        if (!stalled) {
            this.nodes.removeIf(arg_0 -> ObligationForest.processObligations$lambda$1(ObligationForest::processObligations$lambda$0, arg_0));
        }
        return new ProcessObligationsResult(hasErrors, stalled);
    }

    public static /* synthetic */ ProcessObligationsResult processObligations$default(ObligationForest obligationForest, Function1 function1, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return obligationForest.processObligations((Function1<? super PendingPredicateObligation, ? extends ProcessPredicateResult>)function1, bl);
    }

    private static final boolean pendingObligations$lambda$0(Node it2) {
        Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
        return it2.getState() == NodeState.Pending;
    }

    private static final PendingPredicateObligation pendingObligations$lambda$1(Node it2) {
        Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
        return it2.getObligation();
    }

    private static final boolean processObligations$lambda$0(Node it2) {
        Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
        return it2.getState() != NodeState.Pending;
    }

    private static final boolean processObligations$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0006\u0010\u0011\u001a\u00020\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0012"}, d2={"Lorg/rust/lang/core/types/infer/ObligationForest$Node;", "", "obligation", "Lorg/rust/lang/core/types/infer/PendingPredicateObligation;", "parent", "<init>", "(Lorg/rust/lang/core/types/infer/PendingPredicateObligation;Lorg/rust/lang/core/types/infer/ObligationForest$Node;)V", "getObligation", "()Lorg/rust/lang/core/types/infer/PendingPredicateObligation;", "getParent", "()Lorg/rust/lang/core/types/infer/ObligationForest$Node;", "state", "Lorg/rust/lang/core/types/infer/ObligationForest$NodeState;", "getState", "()Lorg/rust/lang/core/types/infer/ObligationForest$NodeState;", "setState", "(Lorg/rust/lang/core/types/infer/ObligationForest$NodeState;)V", "getRoot", "intellij.rustrover.core"})
    public static final class Node {
        @NotNull
        private final PendingPredicateObligation obligation;
        @Nullable
        private final Node parent;
        @NotNull
        private NodeState state;

        public Node(@NotNull PendingPredicateObligation obligation, @Nullable Node parent2) {
            Intrinsics.checkNotNullParameter((Object)obligation, (String)"obligation");
            this.obligation = obligation;
            this.parent = parent2;
            this.state = NodeState.Pending;
        }

        @NotNull
        public final PendingPredicateObligation getObligation() {
            return this.obligation;
        }

        @Nullable
        public final Node getParent() {
            return this.parent;
        }

        @NotNull
        public final NodeState getState() {
            return this.state;
        }

        public final void setState(@NotNull NodeState nodeState) {
            Intrinsics.checkNotNullParameter((Object)((Object)nodeState), (String)"<set-?>");
            this.state = nodeState;
        }

        @NotNull
        public final Node getRoot() {
            Node root = this;
            Node parent2 = root.parent;
            while (parent2 != null) {
                root = parent2;
                parent2 = root.parent;
            }
            return root;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lorg/rust/lang/core/types/infer/ObligationForest$NodeState;", "", "<init>", "(Ljava/lang/String;I)V", "Pending", "Success", "Error", "intellij.rustrover.core"})
    public static final class NodeState
    extends Enum<NodeState> {
        public static final /* enum */ NodeState Pending = new NodeState();
        public static final /* enum */ NodeState Success = new NodeState();
        public static final /* enum */ NodeState Error = new NodeState();
        private static final /* synthetic */ NodeState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static NodeState[] values() {
            return (NodeState[])$VALUES.clone();
        }

        public static NodeState valueOf(String value) {
            return Enum.valueOf(NodeState.class, value);
        }

        @NotNull
        public static EnumEntries<NodeState> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = nodeStateArray = new NodeState[]{NodeState.Pending, NodeState.Success, NodeState.Error};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u00032\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0013"}, d2={"Lorg/rust/lang/core/types/infer/ObligationForest$ProcessObligationsResult;", "", "hasErrors", "", "stalled", "<init>", "(ZZ)V", "getHasErrors", "()Z", "getStalled", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "", "intellij.rustrover.core"})
    public static final class ProcessObligationsResult {
        private final boolean hasErrors;
        private final boolean stalled;

        public ProcessObligationsResult(boolean hasErrors, boolean stalled) {
            this.hasErrors = hasErrors;
            this.stalled = stalled;
        }

        public final boolean getHasErrors() {
            return this.hasErrors;
        }

        public final boolean getStalled() {
            return this.stalled;
        }

        public final boolean component1() {
            return this.hasErrors;
        }

        public final boolean component2() {
            return this.stalled;
        }

        @NotNull
        public final ProcessObligationsResult copy(boolean hasErrors, boolean stalled) {
            return new ProcessObligationsResult(hasErrors, stalled);
        }

        public static /* synthetic */ ProcessObligationsResult copy$default(ProcessObligationsResult processObligationsResult, boolean bl, boolean bl2, int n, Object object) {
            if ((n & 1) != 0) {
                bl = processObligationsResult.hasErrors;
            }
            if ((n & 2) != 0) {
                bl2 = processObligationsResult.stalled;
            }
            return processObligationsResult.copy(bl, bl2);
        }

        @NotNull
        public String toString() {
            return "ProcessObligationsResult(hasErrors=" + this.hasErrors + ", stalled=" + this.stalled + ")";
        }

        public int hashCode() {
            int result2 = Boolean.hashCode(this.hasErrors);
            result2 = result2 * 31 + Boolean.hashCode(this.stalled);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ProcessObligationsResult)) {
                return false;
            }
            ProcessObligationsResult processObligationsResult = (ProcessObligationsResult)other;
            if (this.hasErrors != processObligationsResult.hasErrors) {
                return false;
            }
            return this.stalled == processObligationsResult.stalled;
        }
    }
}

