/*
 * Decompiled with CFR 0.152.
 */
package org.rust.lang.core.types.infer;

import com.intellij.openapi.util.Key;
import com.intellij.psi.util.CachedValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.rust.lang.core.dfa.BorrowKind;
import org.rust.lang.core.psi.RsLambdaExpr;
import org.rust.lang.core.psi.RsPatBinding;
import org.rust.lang.core.psi.ext.RsElement;
import org.rust.lang.core.types.infer.CaptureBy;
import org.rust.lang.core.types.infer.CaptureInfo;
import org.rust.lang.core.types.infer.CapturedPlace;
import org.rust.lang.core.types.infer.Place;
import org.rust.lang.core.types.infer.PlaceAncestryRelation;
import org.rust.lang.core.types.infer.PlaceBase;
import org.rust.lang.core.types.infer.Projection;
import org.rust.lang.core.types.infer.UpvarCapture;
import org.rust.lang.core.types.ty.Mutability;
import org.rust.lang.core.types.ty.TyRawPtr;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000P\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\u001a<\u0010\u0000\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00062\u0018\u0010\u0007\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00020\u0001H\u0002\u001a$\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00022\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0004H\u0002\u001a$\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00022\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0004H\u0002\u001a$\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00022\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0004H\u0002\u001a4\u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u00010\u000e2\u0018\u0010\u0007\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00020\u0001H\u0002\u001a,\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00022\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u001a\u0018\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0004H\u0002\u001a\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0003H\u0002\",\u0010\u0019\u001a \u0012\u001c\u0012\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u001c\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001e0\u001d0\u000e0\u001b0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"processCollectedCaptureInformation", "", "Lkotlin/Pair;", "Lorg/rust/lang/core/types/infer/Place;", "Lorg/rust/lang/core/types/infer/CaptureInfo;", "captureBy", "Lorg/rust/lang/core/types/infer/CaptureBy;", "captureInfo", "adjustForMoveClosure", "place", "info", "adjustForNonMoveClosure", "restrictCapturePrecision", "computeMinCaptures", "", "Lorg/rust/lang/core/psi/ext/RsElement;", "Lorg/rust/lang/core/types/infer/CapturedPlace;", "truncatePlaceToLenAndUpdateCaptureKind", "len", "", "determineCaptureInfo", "left", "right", "determinePlaceAncestryRelation", "Lorg/rust/lang/core/types/infer/PlaceAncestryRelation;", "UPVARS_MENTIONED_KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/psi/util/CachedValue;", "Lorg/rust/lang/core/psi/RsLambdaExpr;", "", "Lorg/rust/lang/core/psi/RsPatBinding;", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nInferBorrowKindVisitor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InferBorrowKindVisitor.kt\norg/rust/lang/core/types/infer/InferBorrowKindVisitorKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,1199:1\n1563#2:1200\n1634#2,3:1201\n360#2,7:1204\n360#2,7:1211\n1740#2,3:1219\n19#3:1218\n*S KotlinDebug\n*F\n+ 1 InferBorrowKindVisitor.kt\norg/rust/lang/core/types/infer/InferBorrowKindVisitorKt\n*L\n80#1:1200\n80#1:1201,3\n91#1:1204,7\n100#1:1211,7\n254#1:1219,3\n155#1:1218\n*E\n"})
public final class InferBorrowKindVisitorKt {
    @NotNull
    private static final Key<CachedValue<Map<RsLambdaExpr, Set<RsPatBinding>>>> UPVARS_MENTIONED_KEY;

    /*
     * WARNING - void declaration
     */
    private static final List<Pair<Place, CaptureInfo>> processCollectedCaptureInformation(CaptureBy captureBy, List<Pair<Place, CaptureInfo>> captureInfo) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = captureInfo;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Pair<Place, CaptureInfo> pair2 = InferBorrowKindVisitorKt.restrictCapturePrecision((Place)it2.getFirst(), (CaptureInfo)it2.getSecond());
            Place place = (Place)pair2.component1();
            CaptureInfo info = (CaptureInfo)pair2.component2();
            collection.add(switch (WhenMappings.$EnumSwitchMapping$0[captureBy.ordinal()]) {
                case 1 -> InferBorrowKindVisitorKt.adjustForMoveClosure(place, info);
                case 2 -> InferBorrowKindVisitorKt.adjustForNonMoveClosure(place, info);
                default -> throw new NoWhenBranchMatchedException();
            });
        }
        return (List)destination$iv$iv;
    }

    private static final Pair<Place, CaptureInfo> adjustForMoveClosure(Place place, CaptureInfo info) {
        int n;
        block2: {
            List<Projection> $this$indexOfFirst$iv = place.getProjections();
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            Iterator<Projection> iterator2 = $this$indexOfFirst$iv.iterator();
            while (iterator2.hasNext()) {
                Projection item$iv;
                Projection it2 = item$iv = iterator2.next();
                boolean bl = false;
                if (it2 instanceof Projection.Deref) {
                    n = index$iv;
                    break block2;
                }
                ++index$iv;
            }
            n = -1;
        }
        int firstDeref = n;
        return firstDeref != -1 ? InferBorrowKindVisitorKt.truncatePlaceToLenAndUpdateCaptureKind(place, info, firstDeref) : TuplesKt.to((Object)place, (Object)CaptureInfo.copy$default(info, null, UpvarCapture.ByValue.INSTANCE, 1, null));
    }

    private static final Pair<Place, CaptureInfo> adjustForNonMoveClosure(Place place, CaptureInfo info) {
        int firstDeref;
        block3: {
            int n;
            List<Projection> $this$indexOfFirst$iv = place.getProjections();
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            Iterator<Projection> iterator2 = $this$indexOfFirst$iv.iterator();
            while (iterator2.hasNext()) {
                Projection item$iv;
                Projection it2 = item$iv = iterator2.next();
                boolean bl = false;
                if (it2 instanceof Projection.Deref) {
                    n = index$iv;
                    break block3;
                }
                ++index$iv;
            }
            n = firstDeref = -1;
        }
        if (info.getKind() instanceof UpvarCapture.ByRef && firstDeref != -1) {
            return InferBorrowKindVisitorKt.truncatePlaceToLenAndUpdateCaptureKind(place, info, firstDeref);
        }
        return TuplesKt.to((Object)place, (Object)info);
    }

    private static final Pair<Place, CaptureInfo> restrictCapturePrecision(Place place, CaptureInfo info) {
        Projection projection;
        Object object;
        Place place2 = place;
        CaptureInfo info2 = info;
        if (place2.getBaseType() instanceof TyRawPtr) {
            object = InferBorrowKindVisitorKt.truncatePlaceToLenAndUpdateCaptureKind(place2, info2, 0);
            Place p = (Place)object.component1();
            CaptureInfo i2 = (CaptureInfo)object.component2();
            place2 = p;
            info2 = i2;
        }
        object = ((Iterable)place2.getProjections()).iterator();
        int n = 0;
        while (object.hasNext()) {
            int index = n++;
            projection = (Projection)object.next();
            if (!(projection.getTy() instanceof TyRawPtr)) continue;
            Pair<Place, CaptureInfo> pair = InferBorrowKindVisitorKt.truncatePlaceToLenAndUpdateCaptureKind(place2, info2, index + 1);
            Place p = (Place)pair.component1();
            CaptureInfo i3 = (CaptureInfo)pair.component2();
            place2 = p;
            info2 = i3;
        }
        object = ((Iterable)place2.getProjections()).iterator();
        n = 0;
        while (object.hasNext()) {
            int index = n++;
            projection = (Projection)object.next();
            if (!(projection instanceof Projection.Subslice) && !(projection instanceof Projection.Index)) continue;
            return InferBorrowKindVisitorKt.truncatePlaceToLenAndUpdateCaptureKind(place2, info2, index);
        }
        return TuplesKt.to((Object)place2, (Object)info2);
    }

    private static final Map<RsElement, List<CapturedPlace>> computeMinCaptures(List<Pair<Place, CaptureInfo>> captureInfo) {
        Map rootVarMinCaptureList = new LinkedHashMap();
        for (Pair<Place, CaptureInfo> pair : captureInfo) {
            Object object;
            Place place = (Place)pair.component1();
            CaptureInfo info = (CaptureInfo)pair.component2();
            Ref.ObjectRef place2 = new Ref.ObjectRef();
            place2.element = place;
            PlaceBase $this$asSafely$iv = ((Place)place2.element).getBase();
            boolean $i$f$asSafely2 = false;
            PlaceBase placeBase = $this$asSafely$iv;
            if (!(placeBase instanceof PlaceBase.Upvar)) {
                placeBase = null;
            }
            if ((object = (PlaceBase.Upvar)placeBase) == null || (object = ((PlaceBase.Upvar)object).getDeclaration()) == null) continue;
            Object upvarDecl = object;
            List captureList = (List)rootVarMinCaptureList.get(upvarDecl);
            if (captureList == null) {
                Mutability mutability = Mutability.IMMUTABLE;
                Map $i$f$asSafely2 = rootVarMinCaptureList;
                Object object2 = new CapturedPlace[]{new CapturedPlace((Place)place2.element, info, mutability)};
                object2 = CollectionsKt.mutableListOf((Object[])object2);
                $i$f$asSafely2.put(upvarDecl, object2);
                continue;
            }
            Ref.BooleanRef descendantsFound = new Ref.BooleanRef();
            Ref.ObjectRef updatedCaptureInfo = new Ref.ObjectRef();
            updatedCaptureInfo.element = info;
            CollectionsKt.retainAll((List)captureList, arg_0 -> InferBorrowKindVisitorKt.computeMinCaptures$lambda$0(place2, descendantsFound, updatedCaptureInfo, arg_0));
            boolean ancestorFound = false;
            if (!descendantsFound.element) {
                int n = ((Collection)captureList).size();
                block5: for (int i2 = 0; i2 < n; ++i2) {
                    CapturedPlace possibleAncestor = (CapturedPlace)captureList.get(i2);
                    switch (WhenMappings.$EnumSwitchMapping$1[InferBorrowKindVisitorKt.determinePlaceAncestryRelation((Place)place2.element, possibleAncestor.getPlace()).ordinal()]) {
                        case 1: {
                            ancestorFound = true;
                            captureList.set(i2, CapturedPlace.copy$default(possibleAncestor, null, InferBorrowKindVisitorKt.determineCaptureInfo(possibleAncestor.getInfo(), (CaptureInfo)updatedCaptureInfo.element), null, 5, null));
                            continue block5;
                        }
                        case 2: {
                            ancestorFound = true;
                            Pair<Place, CaptureInfo> pair2 = InferBorrowKindVisitorKt.truncatePlaceToLenAndUpdateCaptureKind((Place)place2.element, (CaptureInfo)updatedCaptureInfo.element, possibleAncestor.getPlace().getProjections().size());
                            Place possibleAncestorPlace = (Place)pair2.component1();
                            CaptureInfo possibleAncestorInfo = (CaptureInfo)pair2.component2();
                            place2.element = possibleAncestorPlace;
                            updatedCaptureInfo.element = possibleAncestorInfo;
                            captureList.set(i2, CapturedPlace.copy$default(possibleAncestor, null, InferBorrowKindVisitorKt.determineCaptureInfo(possibleAncestor.getInfo(), (CaptureInfo)updatedCaptureInfo.element), null, 5, null));
                            continue block5;
                        }
                    }
                }
            }
            if (ancestorFound) continue;
            Mutability mutability = Mutability.MUTABLE;
            captureList.add(new CapturedPlace((Place)place2.element, (CaptureInfo)updatedCaptureInfo.element, mutability));
        }
        Iterator<Object> iterator2 = rootVarMinCaptureList.entrySet().iterator();
        while (iterator2.hasNext()) {
            List captures = (List)((Map.Entry)iterator2.next()).getValue();
            CollectionsKt.sortWith((List)captures, (arg_0, arg_1) -> InferBorrowKindVisitorKt.computeMinCaptures$lambda$2(InferBorrowKindVisitorKt::computeMinCaptures$lambda$1, arg_0, arg_1));
        }
        return rootVarMinCaptureList;
    }

    private static final Pair<Place, CaptureInfo> truncatePlaceToLenAndUpdateCaptureKind(Place place, CaptureInfo info, int len) {
        return TuplesKt.to((Object)Place.copy$default(place, null, null, CollectionsKt.take((Iterable)place.getProjections(), (int)len), 3, null), (Object)info);
    }

    private static final CaptureInfo determineCaptureInfo(CaptureInfo left, CaptureInfo right) {
        if (left.getKind() instanceof UpvarCapture.ByValue || right.getKind() instanceof UpvarCapture.ByValue) {
            return left;
        }
        UpvarCapture upvarCapture = left.getKind();
        UpvarCapture.ByRef byRef = upvarCapture instanceof UpvarCapture.ByRef ? (UpvarCapture.ByRef)upvarCapture : null;
        if (Intrinsics.areEqual((Object)(byRef != null ? byRef.getBk() : null), (Object)BorrowKind.MutableBorrow.INSTANCE)) {
            return left;
        }
        return right;
    }

    private static final PlaceAncestryRelation determinePlaceAncestryRelation(Place left, Place right) {
        boolean sameProjectionPrefix;
        block5: {
            if (!Intrinsics.areEqual((Object)left.getBase(), (Object)right.getBase())) {
                return PlaceAncestryRelation.Divergent;
            }
            Iterable $this$all$iv = CollectionsKt.zip((Iterable)left.getProjections(), (Iterable)right.getProjections());
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                v0 = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    Projection r;
                    Pair pair = (Pair)element$iv;
                    boolean bl = false;
                    Projection l = (Projection)pair.component1();
                    if (l.sameAs(r = (Projection)pair.component2())) continue;
                    v0 = false;
                    break block5;
                }
                v0 = sameProjectionPrefix = true;
            }
        }
        if (!sameProjectionPrefix) {
            return PlaceAncestryRelation.Divergent;
        }
        int rightSize = right.getProjections().size();
        int leftSize = left.getProjections().size();
        return rightSize > leftSize ? PlaceAncestryRelation.Ancestor : (rightSize == leftSize ? PlaceAncestryRelation.SamePlace : PlaceAncestryRelation.Descendant);
    }

    private static final boolean computeMinCaptures$lambda$0(Ref.ObjectRef $place, Ref.BooleanRef $descendantsFound, Ref.ObjectRef $updatedCaptureInfo, CapturedPlace possibleDescendant) {
        Intrinsics.checkNotNullParameter((Object)possibleDescendant, (String)"possibleDescendant");
        if (InferBorrowKindVisitorKt.determinePlaceAncestryRelation((Place)$place.element, possibleDescendant.getPlace()) != PlaceAncestryRelation.Ancestor) {
            return true;
        }
        $descendantsFound.element = true;
        CaptureInfo possibleDescendantUpdatedInfo = (CaptureInfo)InferBorrowKindVisitorKt.truncatePlaceToLenAndUpdateCaptureKind(possibleDescendant.getPlace(), possibleDescendant.getInfo(), ((Place)$place.element).getProjections().size()).component2();
        $updatedCaptureInfo.element = InferBorrowKindVisitorKt.determineCaptureInfo((CaptureInfo)$updatedCaptureInfo.element, possibleDescendantUpdatedInfo);
        return false;
    }

    private static final int computeMinCaptures$lambda$1(CapturedPlace leftCapture, CapturedPlace rightCapture) {
        for (Pair pair : CollectionsKt.zip((Iterable)leftCapture.getPlace().getProjections(), (Iterable)rightCapture.getPlace().getProjections())) {
            Projection leftProj = (Projection)pair.component1();
            Projection rightProj = (Projection)pair.component2();
            if (leftProj instanceof Projection.Deref && rightProj instanceof Projection.Deref || !(leftProj instanceof Projection.Field) || !(rightProj instanceof Projection.Field) || ((Projection.Field)leftProj).getField().getIndex() == ((Projection.Field)rightProj).getField().getIndex()) continue;
            return Intrinsics.compare((int)((Projection.Field)leftProj).getField().getIndex(), (int)((Projection.Field)rightProj).getField().getIndex());
        }
        return 0;
    }

    private static final int computeMinCaptures$lambda$2(Function2 $tmp0, Object p0, Object p1) {
        return ((Number)$tmp0.invoke(p0, p1)).intValue();
    }

    public static final /* synthetic */ List access$processCollectedCaptureInformation(CaptureBy captureBy, List captureInfo) {
        return InferBorrowKindVisitorKt.processCollectedCaptureInformation(captureBy, captureInfo);
    }

    public static final /* synthetic */ Map access$computeMinCaptures(List captureInfo) {
        return InferBorrowKindVisitorKt.computeMinCaptures(captureInfo);
    }

    static {
        Key key = Key.create((String)"org.rust.lang.core.types.infer.UPVARS_MENTIONED_KEY");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        UPVARS_MENTIONED_KEY = key;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[CaptureBy.values().length];
            try {
                nArray[CaptureBy.Value.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CaptureBy.Ref.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[PlaceAncestryRelation.values().length];
            try {
                nArray[PlaceAncestryRelation.SamePlace.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PlaceAncestryRelation.Descendant.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

