/*
 * Decompiled with CFR 0.152.
 */
package org.rust.lang.core.types.infer;

import com.intellij.psi.PsiElement;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.rust.lang.core.psi.RsLambdaExpr;
import org.rust.lang.core.psi.RsPatBinding;
import org.rust.lang.core.psi.ext.RsElement;
import org.rust.lang.core.psi.ext.RsInferenceContextOwner;
import org.rust.lang.core.resolve.ImplLookup;
import org.rust.lang.core.thir.hir.RsHirMap;
import org.rust.lang.core.types.ExtensionsKt;
import org.rust.lang.core.types.infer.CaptureBy;
import org.rust.lang.core.types.infer.CapturedPlace;
import org.rust.lang.core.types.infer.InferBorrowKind;
import org.rust.lang.core.types.infer.InferBorrowKindVisitorKt;
import org.rust.lang.core.types.infer.PlaceExprUseWalker;
import org.rust.lang.core.types.infer.PlaceMemoryCategorizationContext;
import org.rust.lang.core.types.infer.RsInferenceResult;
import org.rust.lang.core.types.infer.UpvarsMentioned;
import org.rust.openapiext.PsiKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ$\u0010\u0011\u001a \u0012\u0004\u0012\u00020\f\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\r0\rJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R,\u0010\n\u001a \u0012\u0004\u0012\u00020\f\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/rust/lang/core/types/infer/InferBorrowKindContext;", "", "owner", "Lorg/rust/lang/core/psi/ext/RsInferenceContextOwner;", "hirMap", "Lorg/rust/lang/core/thir/hir/RsHirMap;", "upvarsMentioned", "Lorg/rust/lang/core/types/infer/UpvarsMentioned;", "<init>", "(Lorg/rust/lang/core/psi/ext/RsInferenceContextOwner;Lorg/rust/lang/core/thir/hir/RsHirMap;Lorg/rust/lang/core/types/infer/UpvarsMentioned;)V", "lambdaMinCaptures", "", "Lorg/rust/lang/core/psi/RsLambdaExpr;", "", "Lorg/rust/lang/core/psi/ext/RsElement;", "", "Lorg/rust/lang/core/types/infer/CapturedPlace;", "analyzeAllLambdas", "analyzeClosure", "", "closure", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nInferBorrowKindVisitor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InferBorrowKindVisitor.kt\norg/rust/lang/core/types/infer/InferBorrowKindContext\n+ 2 PsiElement.kt\norg/rust/lang/core/psi/ext/PsiElementKt\n*L\n1#1,1199:1\n213#2:1200\n*S KotlinDebug\n*F\n+ 1 InferBorrowKindVisitor.kt\norg/rust/lang/core/types/infer/InferBorrowKindContext\n*L\n56#1:1200\n*E\n"})
final class InferBorrowKindContext {
    @NotNull
    private final RsInferenceContextOwner owner;
    @NotNull
    private final RsHirMap hirMap;
    @NotNull
    private final UpvarsMentioned upvarsMentioned;
    @NotNull
    private final Map<RsLambdaExpr, Map<RsElement, List<CapturedPlace>>> lambdaMinCaptures;

    public InferBorrowKindContext(@NotNull RsInferenceContextOwner owner, @NotNull RsHirMap hirMap, @NotNull UpvarsMentioned upvarsMentioned) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Intrinsics.checkNotNullParameter((Object)hirMap, (String)"hirMap");
        Intrinsics.checkNotNullParameter((Object)upvarsMentioned, (String)"upvarsMentioned");
        this.owner = owner;
        this.hirMap = hirMap;
        this.upvarsMentioned = upvarsMentioned;
        this.lambdaMinCaptures = new HashMap();
    }

    @NotNull
    public final Map<RsLambdaExpr, Map<RsElement, List<CapturedPlace>>> analyzeAllLambdas() {
        PsiElement $this$descendantsWithMacrosOfType$iv = this.owner;
        boolean $i$f$descendantsWithMacrosOfType = false;
        Class[] classArray = new Class[]{RsLambdaExpr.class};
        for (RsLambdaExpr lambda : PsiKt.findDescendantsWithMacrosOfAnyType($this$descendantsWithMacrosOfType$iv, true, classArray)) {
            this.analyzeClosure(lambda);
        }
        return this.lambdaMinCaptures;
    }

    private final void analyzeClosure(RsLambdaExpr closure) {
        InferBorrowKind inferrer = new InferBorrowKind();
        Set<RsPatBinding> upvars = this.upvarsMentioned.get(closure);
        ImplLookup implLookup = ExtensionsKt.getImplLookup(closure);
        RsInferenceResult rsInferenceResult = ExtensionsKt.getInference(closure);
        Intrinsics.checkNotNull((Object)rsInferenceResult);
        PlaceMemoryCategorizationContext mc = new PlaceMemoryCategorizationContext(implLookup, rsInferenceResult, upvars, closure);
        PlaceExprUseWalker walker = new PlaceExprUseWalker(inferrer, mc);
        walker.consumeLambdaBody(closure);
        List captureInfo = InferBorrowKindVisitorKt.access$processCollectedCaptureInformation(CaptureBy.Companion.of(closure), inferrer.getCaptureInfo());
        this.lambdaMinCaptures.put(closure, InferBorrowKindVisitorKt.access$computeMinCaptures(captureInfo));
    }
}

