/*
 * Decompiled with CFR 0.152.
 */
package org.rust.lang.core.types.infer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.lang.core.psi.RsExpr;
import org.rust.lang.core.types.infer.Adjustment;
import org.rust.lang.core.types.infer.CoerceOk;
import org.rust.lang.core.types.infer.Expectation;
import org.rust.lang.core.types.infer.Obligation;
import org.rust.lang.core.types.infer.RsInferenceContext;
import org.rust.lang.core.types.infer.TypeError;
import org.rust.lang.core.types.infer.TypeFoldable;
import org.rust.lang.core.types.ty.FnSig;
import org.rust.lang.core.types.ty.Ty;
import org.rust.lang.core.types.ty.TyClosure;
import org.rust.lang.core.types.ty.TyFnDef;
import org.rust.lang.core.types.ty.TyFnPtr;
import org.rust.lang.core.types.ty.TyInfer;
import org.rust.lang.core.types.ty.TyNever;
import org.rust.lang.core.types.ty.TyTuple;
import org.rust.openapiext.UtilsKt;
import org.rust.stdext.RsResult;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007Jc\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\r2K\u0010\u0016\u001aG\u0012\u0013\u0012\u00110\u0018\u00a2\u0006\f\b\u0019\u0012\b\b\u001a\u0012\u0004\b\b(\u001b\u0012\u0013\u0012\u00110\r\u00a2\u0006\f\b\u0019\u0012\b\b\u001a\u0012\u0004\b\b(\u001c\u0012\u0013\u0012\u00110\r\u00a2\u0006\f\b\u0019\u0012\b\b\u001a\u0012\u0004\b\b(\u001d\u0012\u0004\u0012\u00020\u00130\u0017J\b\u0010\u001e\u001a\u00020\rH\u0002J\u0006\u0010\u001f\u001a\u00020\rJ&\u0010 \u001a\u00020\u00132\u001e\u0010\u0016\u001a\u001a\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00130\u0017Jm\u0010!\u001a\u00020\r2\u0006\u0010\"\u001a\u00020\r2\u0006\u0010#\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u00102K\u0010\u0016\u001aG\u0012\u0013\u0012\u00110\u0018\u00a2\u0006\f\b\u0019\u0012\b\b\u001a\u0012\u0004\b\b(\u001b\u0012\u0013\u0012\u00110\r\u00a2\u0006\f\b\u0019\u0012\b\b\u001a\u0012\u0004\b\b(\u001c\u0012\u0013\u0012\u00110\r\u00a2\u0006\f\b\u0019\u0012\b\b\u001a\u0012\u0004\b\b(\u001d\u0012\u0004\u0012\u00020\u00130\u0017H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lorg/rust/lang/core/types/infer/CoerceMany;", "", "ctx", "Lorg/rust/lang/core/types/infer/RsInferenceContext;", "expectation", "Lorg/rust/lang/core/types/infer/Expectation;", "<init>", "(Lorg/rust/lang/core/types/infer/RsInferenceContext;Lorg/rust/lang/core/types/infer/Expectation;)V", "getCtx", "()Lorg/rust/lang/core/types/infer/RsInferenceContext;", "getExpectation", "()Lorg/rust/lang/core/types/infer/Expectation;", "expectedTy", "Lorg/rust/lang/core/types/ty/Ty;", "expressions", "", "Lorg/rust/lang/core/psi/RsExpr;", "finalTy", "coerce", "", "expr", "ty", "reportTypeMismatch", "Lkotlin/Function3;", "Lorg/rust/lang/core/types/infer/TypeError;", "Lkotlin/ParameterName;", "name", "error", "inferred", "expected", "getMergedTy", "getFinalTy", "coerceForcedUnit", "tryFindCoercionLub", "prevTy", "newTy", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nCoerceMany.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CoerceMany.kt\norg/rust/lang/core/types/infer/CoerceMany\n+ 2 utils.kt\norg/rust/openapiext/UtilsKt\n*L\n1#1,180:1\n305#2,10:181\n305#2,10:191\n*S KotlinDebug\n*F\n+ 1 CoerceMany.kt\norg/rust/lang/core/types/infer/CoerceMany\n*L\n118#1:181,10\n126#1:191,10\n*E\n"})
public final class CoerceMany {
    @NotNull
    private final RsInferenceContext ctx;
    @NotNull
    private final Expectation expectation;
    @NotNull
    private final Ty expectedTy;
    @NotNull
    private final List<RsExpr> expressions;
    @Nullable
    private Ty finalTy;

    public CoerceMany(@NotNull RsInferenceContext ctx, @NotNull Expectation expectation) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)expectation, (String)"expectation");
        this.ctx = ctx;
        this.expectation = expectation;
        Ty ty2 = this.expectation.onlyHasTy(this.ctx);
        if (ty2 == null) {
            ty2 = new TyInfer.TyVar(null, null, 3, null);
        }
        this.expectedTy = ty2;
        this.expressions = new ArrayList();
    }

    @NotNull
    public final RsInferenceContext getCtx() {
        return this.ctx;
    }

    @NotNull
    public final Expectation getExpectation() {
        return this.expectation;
    }

    public final void coerce(@NotNull RsExpr expr, @NotNull Ty ty2, @NotNull Function3<? super TypeError, ? super Ty, ? super Ty, Unit> reportTypeMismatch) {
        Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
        Intrinsics.checkNotNullParameter((Object)ty2, (String)"ty");
        Intrinsics.checkNotNullParameter(reportTypeMismatch, (String)"reportTypeMismatch");
        if (ty2 instanceof TyNever) {
            Adjustment lastAdjustment = (Adjustment)CollectionsKt.lastOrNull(this.ctx.getExprAdjustments(expr));
            if (!(lastAdjustment instanceof Adjustment.NeverToAny) || !Intrinsics.areEqual((Object)((Adjustment.NeverToAny)lastAdjustment).getTarget(), (Object)this.expectedTy)) {
                this.ctx.applyAdjustment(expr, new Adjustment.NeverToAny(this.expectedTy));
            }
        } else {
            this.finalTy = this.tryFindCoercionLub(this.getMergedTy(), ty2, expr, reportTypeMismatch);
        }
        this.expressions.add(expr);
    }

    private final Ty getMergedTy() {
        Ty ty2 = this.finalTy;
        if (ty2 == null) {
            ty2 = this.expectedTy;
        }
        return ty2;
    }

    @NotNull
    public final Ty getFinalTy() {
        Ty ty2 = this.finalTy;
        if (ty2 == null) {
            ty2 = TyNever.INSTANCE;
        }
        return ty2;
    }

    public final void coerceForcedUnit(@NotNull Function3<? super TypeError, ? super Ty, ? super Ty, Unit> reportTypeMismatch) {
        Intrinsics.checkNotNullParameter(reportTypeMismatch, (String)"reportTypeMismatch");
        Ty prevTy = (Ty)this.ctx.resolveTypeVarsIfPossible((TypeFoldable)this.getMergedTy());
        TyTuple newTy = TyTuple.Companion.getUNIT();
        RsResult<CoerceOk, TypeError> res2 = this.ctx.tryCoerce(prevTy, newTy);
        if (res2 instanceof RsResult.Ok) {
            this.ctx.getFulfill().registerPredicateObligations((Collection<Obligation>)((CoerceOk)((RsResult.Ok)res2).getOk()).getObligations());
            this.finalTy = newTy;
        } else if (res2 instanceof RsResult.Err) {
            reportTypeMismatch.invoke(((RsResult.Err)res2).getErr(), (Object)newTy, (Object)prevTy);
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Ty tryFindCoercionLub(Ty prevTy, Ty newTy, RsExpr expr, Function3<? super TypeError, ? super Ty, ? super Ty, Unit> reportTypeMismatch) {
        RsResult<CoerceOk, TypeError> res2;
        Pair pair;
        Ty newTy2;
        TypeError firstError = null;
        Ty prevTy2 = (Ty)this.ctx.resolveTypeVarsIfPossible((TypeFoldable)prevTy);
        if (Intrinsics.areEqual((Object)prevTy2, (Object)(newTy2 = (Ty)this.ctx.resolveTypeVarsIfPossible((TypeFoldable)newTy)))) {
            return prevTy2;
        }
        if (prevTy2 instanceof TyFnDef && newTy2 instanceof TyFnDef) {
            RsResult<Unit, TypeError> rsResult = this.ctx.combineTypes(prevTy2, newTy2);
            if (rsResult instanceof RsResult.Ok) {
                return prevTy2;
            }
            if (!(rsResult instanceof RsResult.Err)) throw new NoWhenBranchMatchedException();
            pair = TuplesKt.to((Object)((TyFnDef)prevTy2).getFnSig(), (Object)((TyFnDef)newTy2).getFnSig());
        } else {
            pair = prevTy2 instanceof TyClosure && newTy2 instanceof TyClosure ? TuplesKt.to((Object)((TyClosure)prevTy2).getFnSig(), (Object)((TyClosure)newTy2).getFnSig()) : (prevTy2 instanceof TyClosure && newTy2 instanceof TyFnDef ? TuplesKt.to((Object)((TyClosure)prevTy2).getFnSig(), (Object)((TyFnDef)newTy2).getFnSig()) : (prevTy2 instanceof TyFnDef && newTy2 instanceof TyClosure ? TuplesKt.to((Object)((TyFnDef)prevTy2).getFnSig(), (Object)((TyClosure)newTy2).getFnSig()) : TuplesKt.to(null, null)));
        }
        Pair pair2 = pair;
        FnSig aSig = (FnSig)pair2.component1();
        FnSig bSig = (FnSig)pair2.component2();
        if (aSig != null && bSig != null) {
            Adjustment nextAdjustment;
            boolean $i$f$testAssert;
            Adjustment adjustment;
            if (prevTy2 instanceof TyFnDef && ((TyFnDef)prevTy2).getDef().isIntrinsic() || newTy2 instanceof TyFnDef && ((TyFnDef)newTy2).getDef().isIntrinsic()) {
                reportTypeMismatch.invoke((Object)new TypeError.TypeMismatch(newTy2, prevTy2), (Object)newTy2, (Object)prevTy2);
                return prevTy2;
            }
            RsResult<Unit, TypeError> res3 = this.ctx.combineFnSigs(aSig, bSig, prevTy2, newTy2);
            if (!(res3 instanceof RsResult.Ok)) {
                if (!(res3 instanceof RsResult.Err)) throw new NoWhenBranchMatchedException();
                reportTypeMismatch.invoke(((RsResult.Err)res3).getErr(), (Object)newTy2, (Object)prevTy2);
                return prevTy2;
            }
            FnSig resSig = aSig;
            TyFnPtr finalPointer = new TyFnPtr(resSig, null, 2, null);
            Ty ty2 = prevTy2;
            if (ty2 instanceof TyClosure) {
                adjustment = new Adjustment.ClosureFnPointer(finalPointer);
            } else if (ty2 instanceof TyFnDef) {
                adjustment = new Adjustment.ReifyFnPointer(finalPointer);
            } else {
                boolean $i$f$testAssert2 = false;
                $i$f$testAssert = false;
                if (UtilsKt.isUnitTestMode()) {
                    boolean bl = false;
                    if (!false) {
                        boolean bl2 = false;
                        String message$iv$iv = "Assertion failed";
                        throw new AssertionError((Object)message$iv$iv);
                    }
                }
                adjustment = null;
            }
            Adjustment prevAdjustment = adjustment;
            Ty ty3 = newTy2;
            if (ty3 instanceof TyClosure) {
                v2 = new Adjustment.ClosureFnPointer(finalPointer);
            } else if (ty3 instanceof TyFnDef) {
                v2 = new Adjustment.ReifyFnPointer(finalPointer);
            } else {
                $i$f$testAssert = false;
                boolean $i$f$testAssert3 = false;
                if (UtilsKt.isUnitTestMode()) {
                    boolean bl = false;
                    if (!false) {
                        boolean bl3 = false;
                        String message$iv$iv = "Assertion failed";
                        throw new AssertionError((Object)message$iv$iv);
                    }
                }
                v2 = nextAdjustment = null;
            }
            if (prevAdjustment != null) {
                for (Object e : this.expressions) {
                    Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                    RsExpr previousExpr = (RsExpr)e;
                    this.ctx.applyAdjustment(previousExpr, prevAdjustment);
                }
            }
            if (nextAdjustment == null) return finalPointer;
            this.ctx.applyAdjustment(expr, nextAdjustment);
            return finalPointer;
        }
        if (this.ctx.getExprAdjustments(expr).isEmpty()) {
            res2 = this.ctx.tryCoerce(newTy2, prevTy2);
            if (res2 instanceof RsResult.Ok) {
                this.ctx.applyAdjustments(expr, ((CoerceOk)((RsResult.Ok)res2).getOk()).getAdjustments());
                this.ctx.getFulfill().registerPredicateObligations((Collection<Obligation>)((CoerceOk)((RsResult.Ok)res2).getOk()).getObligations());
                return prevTy2;
            }
            if (!(res2 instanceof RsResult.Err)) throw new NoWhenBranchMatchedException();
            firstError = (TypeError)((RsResult.Err)res2).getErr();
        }
        if ((res2 = this.ctx.tryCoerce(prevTy2, newTy2)) instanceof RsResult.Ok) {
            Iterator<RsExpr> iterator2 = this.expressions.iterator();
            while (iterator2.hasNext()) {
                RsExpr previousExpr;
                Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
                this.ctx.applyAdjustments(previousExpr, ((CoerceOk)((RsResult.Ok)res2).getOk()).getAdjustments());
            }
            this.ctx.getFulfill().registerPredicateObligations((Collection<Obligation>)((CoerceOk)((RsResult.Ok)res2).getOk()).getObligations());
            return newTy2;
        }
        if (!(res2 instanceof RsResult.Err)) throw new NoWhenBranchMatchedException();
        if (firstError != null) {
            reportTypeMismatch.invoke(((RsResult.Err)res2).getErr(), (Object)newTy2, (Object)prevTy2);
            return prevTy2;
        } else {
            reportTypeMismatch.invoke(((RsResult.Err)res2).getErr(), (Object)prevTy2, (Object)newTy2);
        }
        return prevTy2;
    }
}

