/*
 * Decompiled with CFR 0.152.
 */
package org.rust.lang.core.types.infer;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.cargo.project.workspace.PackageOrigin;
import org.rust.lang.core.mir.schemas.MirCastTy;
import org.rust.lang.core.mir.schemas.MirIntTy;
import org.rust.lang.core.mir.schemas.MirUintTy;
import org.rust.lang.core.psi.RsCastExpr;
import org.rust.lang.core.psi.RsEnumItem;
import org.rust.lang.core.psi.RsEnumVariant;
import org.rust.lang.core.psi.RsExpr;
import org.rust.lang.core.psi.RsStructItem;
import org.rust.lang.core.psi.RsTraitItem;
import org.rust.lang.core.psi.ext.RsDocAndAttributeOwnerKt;
import org.rust.lang.core.psi.ext.RsEnumItemKt;
import org.rust.lang.core.psi.ext.RsFieldDecl;
import org.rust.lang.core.psi.ext.RsFieldDeclKt;
import org.rust.lang.core.psi.ext.RsFieldsOwner;
import org.rust.lang.core.psi.ext.RsFieldsOwnerKt;
import org.rust.lang.core.psi.ext.RsTraitItemKt;
import org.rust.lang.core.types.BoundElement;
import org.rust.lang.core.types.infer.CoerceOk;
import org.rust.lang.core.types.infer.FoldKt;
import org.rust.lang.core.types.infer.RsInferenceContext;
import org.rust.lang.core.types.infer.TyWithObligations;
import org.rust.lang.core.types.infer.TypeError;
import org.rust.lang.core.types.infer.TypeFoldable;
import org.rust.lang.core.types.ty.FnSig;
import org.rust.lang.core.types.ty.Mutability;
import org.rust.lang.core.types.ty.Ty;
import org.rust.lang.core.types.ty.TyAdt;
import org.rust.lang.core.types.ty.TyArray;
import org.rust.lang.core.types.ty.TyDynamic;
import org.rust.lang.core.types.ty.TyFloat;
import org.rust.lang.core.types.ty.TyFnDef;
import org.rust.lang.core.types.ty.TyFnPtr;
import org.rust.lang.core.types.ty.TyInfer;
import org.rust.lang.core.types.ty.TyInteger;
import org.rust.lang.core.types.ty.TyOpaque;
import org.rust.lang.core.types.ty.TyPlaceholder;
import org.rust.lang.core.types.ty.TyProjection;
import org.rust.lang.core.types.ty.TyRawPtr;
import org.rust.lang.core.types.ty.TyRef;
import org.rust.lang.core.types.ty.TySlice;
import org.rust.lang.core.types.ty.TyStr;
import org.rust.lang.core.types.ty.TyTuple;
import org.rust.lang.core.types.ty.TyTypeParameter;
import org.rust.lang.core.types.ty.TyUnknown;
import org.rust.lang.utils.RsDiagnostic;
import org.rust.stdext.RsResult;
import org.rust.stdext.RsResultKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 ,2\u00020\u0001:\u0003,-.B)\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ#\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u0002H\u00180\u0016\"\u0004\b\u0000\u0010\u0018*\u0002H\u0018H\u0002\u00a2\u0006\u0002\u0010\u0019J\u0006\u0010\u001a\u001a\u00020\u0014J\u0014\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u001c0\u0016H\u0002J$\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u001c0\u00162\u0006\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020\u0007H\u0002J\u001c\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u001c0\u00162\u0006\u0010\u001e\u001a\u00020\u0007H\u0002J\u001c\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u001c0\u00162\u0006\u0010\u001f\u001a\u00020\u0007H\u0002J\u001c\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u001c0\u00162\u0006\u0010\u001f\u001a\u00020\u0007H\u0002J\"\u0010#\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010$\u0012\u0004\u0012\u00020\u00140\u0016*\u00020%2\u0006\u0010&\u001a\u00020\u0007H\u0002J4\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u001c0\u00162\u0006\u0010\u001e\u001a\u00020\u00072\u0006\u0010(\u001a\u00020)2\u0006\u0010\u001f\u001a\u00020\u00072\u0006\u0010*\u001a\u00020)H\u0002J\b\u0010+\u001a\u00020\u0014H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\r\u001a\u00070\u000e\u00a2\u0006\u0002\b\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lorg/rust/lang/core/types/infer/CastCheck;", "", "ctx", "Lorg/rust/lang/core/types/infer/RsInferenceContext;", "expr", "Lorg/rust/lang/core/psi/RsExpr;", "exprTy", "Lorg/rust/lang/core/types/ty/Ty;", "castTy", "<init>", "(Lorg/rust/lang/core/types/infer/RsInferenceContext;Lorg/rust/lang/core/psi/RsExpr;Lorg/rust/lang/core/types/ty/Ty;Lorg/rust/lang/core/types/ty/Ty;)V", "cast", "Lorg/rust/lang/core/psi/RsCastExpr;", "castKeyword", "Lcom/intellij/psi/PsiElement;", "Lorg/jetbrains/annotations/Nullable;", "getCastKeyword", "()Lcom/intellij/psi/PsiElement;", "ok", "Lorg/rust/stdext/RsResult$Ok;", "", "toErr", "Lorg/rust/stdext/RsResult;", "", "E", "(Ljava/lang/Object;)Lorg/rust/stdext/RsResult;", "check", "doCheck", "Lorg/rust/lang/core/types/infer/CastCheck$CastError;", "checkPtrPtrCast", "tyExpr", "tyCast", "checkPtrAddrCast", "checkAddrPtrCast", "checkFptrPtrCast", "from", "Lorg/rust/lang/core/types/infer/CastCheck$PointerKind;", "Lorg/rust/lang/core/types/infer/CastCheck$PointerKind$Companion;", "rawTy", "checkRefCast", "mutExpr", "Lorg/rust/lang/core/types/ty/Mutability;", "mutCast", "reportCastToUnsizedType", "Companion", "CastError", "PointerKind", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nCastCheck.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CastCheck.kt\norg/rust/lang/core/types/infer/CastCheck\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 RsResult.kt\norg/rust/stdext/RsResultKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,372:1\n1761#2,3:373\n1617#2,9:396\n1869#2:405\n1870#2:408\n1626#2:409\n60#3,4:376\n60#3,4:380\n60#3,4:384\n60#3,4:388\n60#3,4:392\n60#3,4:410\n1#4:406\n1#4:407\n*S KotlinDebug\n*F\n+ 1 CastCheck.kt\norg/rust/lang/core/types/infer/CastCheck\n*L\n110#1:373,3\n199#1:396,9\n199#1:405\n199#1:408\n199#1:409\n140#1:376,4\n141#1:380,4\n162#1:384,4\n171#1:388,4\n182#1:392,4\n240#1:410,4\n199#1:407\n*E\n"})
public final class CastCheck {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RsInferenceContext ctx;
    @NotNull
    private final RsExpr expr;
    @NotNull
    private Ty exprTy;
    @NotNull
    private Ty castTy;
    @NotNull
    private final RsCastExpr cast;
    @NotNull
    private final RsResult.Ok<Unit> ok;

    private CastCheck(RsInferenceContext ctx, RsExpr expr, Ty exprTy, Ty castTy) {
        this.ctx = ctx;
        this.expr = expr;
        this.exprTy = exprTy;
        this.castTy = castTy;
        PsiElement psiElement2 = this.expr.getParent();
        Intrinsics.checkNotNull((Object)psiElement2, (String)"null cannot be cast to non-null type org.rust.lang.core.psi.RsCastExpr");
        this.cast = (RsCastExpr)psiElement2;
        this.ok = new RsResult.Ok<Unit>(Unit.INSTANCE);
    }

    private final PsiElement getCastKeyword() {
        PsiElement psiElement2 = this.cast.getAs();
        if (psiElement2 == null) {
            PsiElement psiElement3 = this.cast.getColon();
            psiElement2 = psiElement3;
            Intrinsics.checkNotNull((Object)psiElement3);
        }
        return psiElement2;
    }

    private final <E> RsResult toErr(E $this$toErr) {
        return new RsResult.Err<E>($this$toErr);
    }

    public final void check() {
        this.exprTy = this.ctx.resolveTypeVarsWithObligations(this.exprTy);
        this.castTy = this.ctx.resolveTypeVarsWithObligations(this.castTy);
        if (!this.ctx.getLookup().isSized(this.castTy) && !FoldKt.getHasTyInfer(this.castTy)) {
            this.reportCastToUnsizedType();
            return;
        }
        RsResult<CoerceOk, TypeError> res2 = this.ctx.tryCoerce(this.exprTy, this.castTy);
        if (res2 instanceof RsResult.Ok) {
            this.ctx.addCoercionCast(this.expr);
            this.ctx.applyAdjustments(this.expr, ((CoerceOk)((RsResult.Ok)res2).getOk()).getAdjustments());
            return;
        }
        if (!(res2 instanceof RsResult.Err)) {
            throw new NoWhenBranchMatchedException();
        }
        if (RsInferenceContext.isTypeMismatchErrorMuted$default(this.ctx, this.expr, this.exprTy, null, false, 12, null) || RsInferenceContext.isTypeMismatchErrorMuted$default(this.ctx, this.expr, this.castTy, null, false, 12, null)) {
            return;
        }
        RsResult<Unit, CastError> result2 = this.doCheck();
        if (!(result2 instanceof RsResult.Ok)) {
            if (result2 instanceof RsResult.Err) {
                ((CastError)((RsResult.Err)result2).getErr()).report(this);
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private final RsResult<Unit, CastError> doCheck() {
        RsResult rsResult;
        Pair pair;
        Object[] objectArray;
        MirCastTy tyCast;
        MirCastTy tyFrom;
        Object[] exprTy;
        block31: {
            exprTy = this.exprTy;
            tyFrom = MirCastTy.Companion.from((Ty)exprTy);
            if (tyFrom == null) {
                MirCastTy mirCastTy = MirCastTy.Companion.from(this.castTy);
                if (mirCastTy == null) {
                    return this.toErr(CastError.NonScalar.INSTANCE);
                }
                tyCast = mirCastTy;
                objectArray = exprTy;
                if (objectArray instanceof TyFnDef) {
                    TyWithObligations f = RsInferenceContext.normalizeAssociatedTypesIn$default(this.ctx, ((TyFnDef)exprTy).getFnSig(), 0, 2, null);
                    RsResult<CoerceOk, TypeError> res2 = this.ctx.tryCoerce((Ty)exprTy, new TyFnPtr((FnSig)f.getValue(), null, 2, null));
                    if (res2.isErr() && ((TyFnDef)exprTy).getDef().isIntrinsic()) {
                        return this.toErr(CastError.IllegalCast.INSTANCE);
                    }
                    if (res2.isErr()) {
                        return this.toErr(CastError.NonScalar.INSTANCE);
                    }
                    pair = TuplesKt.to((Object)MirCastTy.FnPtr.INSTANCE, (Object)tyCast);
                    break block31;
                } else {
                    RsResult<Unit, CastError> rsResult2;
                    if (!(objectArray instanceof TyRef)) return this.toErr(CastError.NonScalar.INSTANCE);
                    MirCastTy f = tyCast;
                    if (Intrinsics.areEqual((Object)f, (Object)MirCastTy.Float.INSTANCE) || f instanceof MirCastTy.Int) {
                        Ty ty2 = ((TyRef)exprTy).getReferenced();
                        if (!(ty2 instanceof TyInteger || ty2 instanceof TyFloat || ty2 instanceof TyInfer.IntVar || ty2 instanceof TyInfer.FloatVar)) {
                            rsResult2 = this.toErr(CastError.NeedViaPtr.INSTANCE);
                            return rsResult2;
                        }
                        rsResult2 = this.toErr(CastError.NeedDeref.INSTANCE);
                        return rsResult2;
                    }
                    if (f instanceof MirCastTy.Pointer) {
                        rsResult2 = this.checkRefCast(((TyRef)exprTy).getReferenced(), ((TyRef)exprTy).getMutability(), ((MirCastTy.Pointer)tyCast).getTy(), ((MirCastTy.Pointer)tyCast).getMutability());
                        return rsResult2;
                    }
                    rsResult2 = this.toErr(CastError.NonScalar.INSTANCE);
                    return rsResult2;
                }
            }
            MirCastTy mirCastTy = MirCastTy.Companion.from(this.castTy);
            if (mirCastTy == null) {
                return this.toErr(CastError.NonScalar.INSTANCE);
            }
            tyCast = mirCastTy;
            pair = TuplesKt.to((Object)tyFrom, (Object)tyCast);
        }
        Pair pair2 = pair;
        tyFrom = (MirCastTy)pair2.component1();
        tyCast = (MirCastTy)pair2.component2();
        if (exprTy instanceof TyAdt && ((TyAdt)exprTy).getItem().getContainingCrate().getOrigin() != PackageOrigin.WORKSPACE && ((TyAdt)exprTy).getItem() instanceof RsEnumItem) {
            boolean bl;
            block32: {
                Iterable $this$any$iv = RsEnumItemKt.getVariants((RsEnumItem)((TyAdt)exprTy).getItem());
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        RsEnumVariant it2 = (RsEnumVariant)element$iv;
                        boolean bl2 = false;
                        if (!RsDocAndAttributeOwnerKt.getQueryAttributes(it2).hasAttribute("non_exhaustive")) continue;
                        bl = true;
                        break block32;
                    }
                    bl = false;
                }
            }
            if (bl) {
                return this.toErr(CastError.ForeignNonExhaustiveAdt.INSTANCE);
            }
        }
        if (Intrinsics.areEqual((Object)tyCast, (Object)new MirCastTy.Int(MirIntTy.CEnum.INSTANCE)) || Intrinsics.areEqual((Object)tyCast, (Object)MirCastTy.FnPtr.INSTANCE)) {
            rsResult = this.toErr(CastError.NonScalar.INSTANCE);
            return rsResult;
        }
        if (Intrinsics.areEqual((Object)tyCast, (Object)new MirCastTy.Int(MirIntTy.Bool.INSTANCE))) {
            rsResult = this.toErr(CastError.CastToBool.INSTANCE);
            return rsResult;
        }
        if (Intrinsics.areEqual((Object)tyFrom, (Object)new MirCastTy.Int(new MirIntTy.U(MirUintTy.U8))) && Intrinsics.areEqual((Object)tyCast, (Object)new MirCastTy.Int(MirIntTy.Char.INSTANCE))) {
            rsResult = this.ok;
            return rsResult;
        }
        if (Intrinsics.areEqual((Object)tyCast, (Object)new MirCastTy.Int(MirIntTy.Char.INSTANCE))) {
            rsResult = this.toErr(CastError.CastToChar.INSTANCE);
            return rsResult;
        }
        objectArray = new MirCastTy.Int[]{new MirCastTy.Int(MirIntTy.Bool.INSTANCE), new MirCastTy.Int(MirIntTy.CEnum.INSTANCE), new MirCastTy.Int(MirIntTy.Char.INSTANCE)};
        if (CollectionsKt.contains((Iterable)CollectionsKt.listOf((Object[])objectArray), (Object)tyFrom) && Intrinsics.areEqual((Object)tyCast, (Object)MirCastTy.Float.INSTANCE)) {
            rsResult = this.toErr(CastError.NeedViaInt.INSTANCE);
            return rsResult;
        }
        objectArray = new MirCastTy[]{new MirCastTy.Int(MirIntTy.Bool.INSTANCE), new MirCastTy.Int(MirIntTy.CEnum.INSTANCE), new MirCastTy.Int(MirIntTy.Char.INSTANCE), MirCastTy.Float.INSTANCE};
        if (CollectionsKt.listOf((Object[])objectArray).contains(tyFrom) && tyCast instanceof MirCastTy.Pointer) {
            rsResult = this.toErr(CastError.IllegalCast.INSTANCE);
            return rsResult;
        }
        if ((tyFrom instanceof MirCastTy.Pointer || Intrinsics.areEqual((Object)tyFrom, (Object)MirCastTy.FnPtr.INSTANCE)) && Intrinsics.areEqual((Object)tyCast, (Object)MirCastTy.Float.INSTANCE)) {
            rsResult = this.toErr(CastError.IllegalCast.INSTANCE);
            return rsResult;
        }
        if (tyFrom instanceof MirCastTy.Pointer && tyCast instanceof MirCastTy.Pointer) {
            rsResult = this.checkPtrPtrCast(((MirCastTy.Pointer)tyFrom).getTy(), ((MirCastTy.Pointer)tyCast).getTy());
            return rsResult;
        }
        if (tyFrom instanceof MirCastTy.Pointer && tyCast instanceof MirCastTy.Int) {
            rsResult = this.checkPtrAddrCast(((MirCastTy.Pointer)tyFrom).getTy());
            return rsResult;
        }
        if (Intrinsics.areEqual((Object)tyFrom, (Object)MirCastTy.FnPtr.INSTANCE) && tyCast instanceof MirCastTy.Int) {
            rsResult = this.ok;
            return rsResult;
        }
        if (tyFrom instanceof MirCastTy.Int && tyCast instanceof MirCastTy.Pointer) {
            rsResult = this.checkAddrPtrCast(((MirCastTy.Pointer)tyCast).getTy());
            return rsResult;
        }
        if (Intrinsics.areEqual((Object)tyFrom, (Object)MirCastTy.FnPtr.INSTANCE) && tyCast instanceof MirCastTy.Pointer) {
            rsResult = this.checkFptrPtrCast(((MirCastTy.Pointer)tyCast).getTy());
            return rsResult;
        }
        if (Intrinsics.areEqual((Object)tyFrom, (Object)new MirCastTy.Int(MirIntTy.CEnum.INSTANCE)) && tyCast instanceof MirCastTy.Int) {
            rsResult = this.ok;
            return rsResult;
        }
        objectArray = new MirCastTy.Int[]{new MirCastTy.Int(MirIntTy.Char.INSTANCE), new MirCastTy.Int(MirIntTy.Bool.INSTANCE)};
        if (CollectionsKt.contains((Iterable)CollectionsKt.listOf((Object[])objectArray), (Object)tyFrom) && tyCast instanceof MirCastTy.Int) {
            rsResult = this.ok;
            return rsResult;
        }
        if ((tyFrom instanceof MirCastTy.Int || Intrinsics.areEqual((Object)tyFrom, (Object)MirCastTy.Float.INSTANCE)) && (tyCast instanceof MirCastTy.Int || Intrinsics.areEqual((Object)tyCast, (Object)MirCastTy.Float.INSTANCE))) {
            rsResult = this.ok;
            return rsResult;
        }
        if (Intrinsics.areEqual((Object)tyCast, (Object)MirCastTy.DynStar.INSTANCE)) {
            rsResult = this.ok;
            return rsResult;
        }
        if (!Intrinsics.areEqual((Object)tyFrom, (Object)MirCastTy.DynStar.INSTANCE)) throw new IllegalStateException("This match should be exhaustive".toString());
        rsResult = this.ok;
        return rsResult;
    }

    private final RsResult<Unit, CastError> checkPtrPtrCast(Ty tyExpr, Ty tyCast) {
        RsResult<PointerKind, Unit> $this$unwrapOrElse$iv = this.from(PointerKind.Companion, tyExpr);
        boolean $i$f$unwrapOrElse = false;
        RsResult<PointerKind, Unit> rsResult = $this$unwrapOrElse$iv;
        if (!(rsResult instanceof RsResult.Ok)) {
            if (rsResult instanceof RsResult.Err) {
                Unit it2 = (Unit)((RsResult.Err)$this$unwrapOrElse$iv).getErr();
                boolean bl = false;
                return this.ok;
            }
            throw new NoWhenBranchMatchedException();
        }
        PointerKind exprKind = (PointerKind)((RsResult.Ok)$this$unwrapOrElse$iv).getOk();
        RsResult<PointerKind, Unit> $this$unwrapOrElse$iv2 = this.from(PointerKind.Companion, tyCast);
        boolean $i$f$unwrapOrElse2 = false;
        RsResult<PointerKind, Unit> rsResult2 = $this$unwrapOrElse$iv2;
        if (!(rsResult2 instanceof RsResult.Ok)) {
            if (rsResult2 instanceof RsResult.Err) {
                Unit it3 = (Unit)((RsResult.Err)$this$unwrapOrElse$iv2).getErr();
                boolean bl = false;
                return this.ok;
            }
            throw new NoWhenBranchMatchedException();
        }
        PointerKind castKind = (PointerKind)((RsResult.Ok)$this$unwrapOrElse$iv2).getOk();
        if (castKind == null) {
            return new RsResult.Err<CastError.UnknownCastPtrKind>(CastError.UnknownCastPtrKind.INSTANCE);
        }
        if (Intrinsics.areEqual((Object)castKind, (Object)PointerKind.Thin.INSTANCE)) {
            return this.ok;
        }
        if (exprKind == null) {
            return new RsResult.Err<CastError.UnknownExprPtrKind>(CastError.UnknownExprPtrKind.INSTANCE);
        }
        if (Intrinsics.areEqual((Object)exprKind, (Object)PointerKind.Thin.INSTANCE)) {
            return new RsResult.Err<CastError.SizedUnsizedCast>(CastError.SizedUnsizedCast.INSTANCE);
        }
        return Intrinsics.areEqual((Object)castKind, (Object)exprKind) ? (RsResult)this.ok : (RsResult)new RsResult.Err<CastError.DifferingKinds>(CastError.DifferingKinds.INSTANCE);
    }

    private final RsResult<Unit, CastError> checkPtrAddrCast(Ty tyExpr) {
        RsResult<PointerKind, Unit> $this$unwrapOrElse$iv = this.from(PointerKind.Companion, tyExpr);
        boolean $i$f$unwrapOrElse = false;
        RsResult<PointerKind, Unit> rsResult = $this$unwrapOrElse$iv;
        if (!(rsResult instanceof RsResult.Ok)) {
            if (rsResult instanceof RsResult.Err) {
                Unit it2 = (Unit)((RsResult.Err)$this$unwrapOrElse$iv).getErr();
                boolean bl = false;
                return this.ok;
            }
            throw new NoWhenBranchMatchedException();
        }
        PointerKind result2 = (PointerKind)((RsResult.Ok)$this$unwrapOrElse$iv).getOk();
        PointerKind pointerKind = result2;
        return pointerKind == null ? this.toErr(CastError.UnknownExprPtrKind.INSTANCE) : (Intrinsics.areEqual((Object)pointerKind, (Object)PointerKind.Thin.INSTANCE) ? (RsResult)this.ok : this.toErr(CastError.NeedViaThinPtr.INSTANCE));
    }

    private final RsResult<Unit, CastError> checkAddrPtrCast(Ty tyCast) {
        RsResult rsResult;
        RsResult<PointerKind, Unit> $this$unwrapOrElse$iv = this.from(PointerKind.Companion, tyCast);
        boolean $i$f$unwrapOrElse = false;
        RsResult<PointerKind, Unit> rsResult2 = $this$unwrapOrElse$iv;
        if (!(rsResult2 instanceof RsResult.Ok)) {
            if (rsResult2 instanceof RsResult.Err) {
                Unit it2 = (Unit)((RsResult.Err)$this$unwrapOrElse$iv).getErr();
                boolean bl = false;
                return this.ok;
            }
            throw new NoWhenBranchMatchedException();
        }
        PointerKind result2 = (PointerKind)((RsResult.Ok)$this$unwrapOrElse$iv).getOk();
        PointerKind pointerKind = result2;
        if (pointerKind == null) {
            rsResult = this.toErr(CastError.UnknownCastPtrKind.INSTANCE);
        } else if (Intrinsics.areEqual((Object)pointerKind, (Object)PointerKind.Thin.INSTANCE)) {
            rsResult = this.ok;
        } else if (pointerKind instanceof PointerKind.VTable) {
            rsResult = this.toErr(new CastError.IntToFatCast("a vtable"));
        } else if (Intrinsics.areEqual((Object)pointerKind, (Object)PointerKind.Length.INSTANCE)) {
            rsResult = this.toErr(new CastError.IntToFatCast("a length"));
        } else if (pointerKind instanceof PointerKind.OfAlias || pointerKind instanceof PointerKind.OfParam) {
            rsResult = this.toErr(new CastError.IntToFatCast(null));
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return rsResult;
    }

    private final RsResult<Unit, CastError> checkFptrPtrCast(Ty tyCast) {
        RsResult<PointerKind, Unit> $this$unwrapOrElse$iv = this.from(PointerKind.Companion, tyCast);
        boolean $i$f$unwrapOrElse = false;
        RsResult<PointerKind, Unit> rsResult = $this$unwrapOrElse$iv;
        if (!(rsResult instanceof RsResult.Ok)) {
            if (rsResult instanceof RsResult.Err) {
                Unit it2 = (Unit)((RsResult.Err)$this$unwrapOrElse$iv).getErr();
                boolean bl = false;
                return this.ok;
            }
            throw new NoWhenBranchMatchedException();
        }
        PointerKind result2 = (PointerKind)((RsResult.Ok)$this$unwrapOrElse$iv).getOk();
        PointerKind pointerKind = result2;
        return pointerKind == null ? this.toErr(CastError.UnknownCastPtrKind.INSTANCE) : (Intrinsics.areEqual((Object)pointerKind, (Object)PointerKind.Thin.INSTANCE) ? (RsResult)this.ok : this.toErr(CastError.IllegalCast.INSTANCE));
    }

    /*
     * Unable to fully structure code
     */
    private final RsResult<PointerKind, Unit> from(PointerKind.Companion $this$from, Ty rawTy) {
        block14: {
            block19: {
                block20: {
                    block16: {
                        block18: {
                            block17: {
                                block15: {
                                    block13: {
                                        ty = (Ty)this.ctx.resolveTypeVarsIfPossible((TypeFoldable)rawTy);
                                        if (ty instanceof TyUnknown) {
                                            return new RsResult.Err<Unit>(Unit.INSTANCE);
                                        }
                                        if (this.ctx.getLookup().isSized(ty)) {
                                            return new RsResult.Ok<PointerKind.Thin>(PointerKind.Thin.INSTANCE);
                                        }
                                        var4_4 = ty;
                                        if (!(var4_4 instanceof TySlice) && !(var4_4 instanceof TyStr)) break block13;
                                        v0 = RsResultKt.toResult(PointerKind.Length.INSTANCE);
                                        break block14;
                                    }
                                    if (!(var4_4 instanceof TyDynamic)) break block15;
                                    $this$mapNotNull$iv = ((TyDynamic)ty).getTraits();
                                    $i$f$mapNotNull = false;
                                    var8_7 = $this$mapNotNull$iv;
                                    destination$iv$iv = new ArrayList<E>();
                                    $i$f$mapNotNullTo = false;
                                    $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                                    $i$f$forEach = false;
                                    var13_19 = $this$forEach$iv$iv$iv.iterator();
                                    while (var13_19.hasNext()) {
                                        element$iv$iv = element$iv$iv$iv = var13_19.next();
                                        $i$a$-forEach-CollectionsKt___CollectionsKt$mapNotNullTo$1$iv$iv = false;
                                        be = (BoundElement)element$iv$iv;
                                        $i$a$-mapNotNull-CastCheck$from$nonAutoTraits$1 = false;
                                        var19_27 = be.getElement();
                                        it = (RsTraitItem)var19_27;
                                        $i$a$-takeIf-CastCheck$from$nonAutoTraits$1$1 = false;
                                        if ((RsTraitItem)(RsTraitItemKt.isAuto(it) == false != false ? var19_27 : null) == null) continue;
                                        $i$a$-let-CollectionsKt___CollectionsKt$mapNotNullTo$1$1$iv$iv = false;
                                        destination$iv$iv.add(it$iv$iv);
                                    }
                                    nonAutoTraits = (List)destination$iv$iv;
                                    switch (nonAutoTraits.size()) {
                                        case 0: {
                                            v1 = null;
                                            break;
                                        }
                                        case 1: {
                                            v1 = (RsTraitItem)CollectionsKt.single((List)nonAutoTraits);
                                            break;
                                        }
                                        default: {
                                            return new RsResult.Err<Unit>(Unit.INSTANCE);
                                        }
                                    }
                                    principal = v1;
                                    v0 = RsResultKt.toResult(new PointerKind.VTable(principal));
                                    break block14;
                                }
                                if (!(var4_4 instanceof TyAdt)) break block16;
                                if (((TyAdt)ty).getItem() instanceof RsStructItem) break block17;
                                v0 = new RsResult.Err<Unit>(Unit.INSTANCE);
                                break block14;
                            }
                            v0 = (RsFieldDecl)CollectionsKt.lastOrNull(RsFieldsOwnerKt.getExpandedFields((RsFieldsOwner)((TyAdt)ty).getItem()));
                            if (v0 == null) break block18;
                            field = v0;
                            $i$a$-let-CastCheck$from$1 = false;
                            var10_14 = RsFieldDeclKt.ty(field, (TyAdt)ty);
                            if (var10_14 == null) ** GOTO lbl-1000
                            it = var10_14;
                            $i$a$-let-CastCheck$from$1$fieldTy$1 = false;
                            var13_20 = (Ty)RsInferenceContext.normalizeAssociatedTypesIn$default(this.ctx, it, 0, 2, null).getValue();
                            if (var13_20 != null) {
                                v2 = var13_20;
                            } else lbl-1000:
                            // 2 sources

                            {
                                v2 = TyUnknown.INSTANCE;
                            }
                            fieldTy = v2;
                            v3 = this.from($this$from, fieldTy);
                            v0 = v3;
                            if (v3 != null) break block14;
                        }
                        v0 = RsResultKt.toResult(PointerKind.Thin.INSTANCE);
                        break block14;
                    }
                    if (!(var4_4 instanceof TyTuple)) break block19;
                    v0 = (Ty)CollectionsKt.lastOrNull(((TyTuple)ty).getTypes());
                    if (v0 == null) break block20;
                    it = v0;
                    $i$a$-let-CastCheck$from$2 = false;
                    v4 = this.from($this$from, (Ty)it);
                    v0 = v4;
                    if (v4 != null) break block14;
                }
                v0 = RsResultKt.toResult(PointerKind.Thin.INSTANCE);
                break block14;
            }
            v0 = var4_4 instanceof TyProjection != false || var4_4 instanceof TyOpaque != false ? RsResultKt.toResult(new PointerKind.OfAlias(ty)) : (var4_4 instanceof TyTypeParameter != false ? RsResultKt.toResult(new PointerKind.OfParam(ty)) : (var4_4 instanceof TyPlaceholder != false || var4_4 instanceof TyInfer != false ? (RsResult)new RsResult.Ok<Object>(null) : (RsResult)new RsResult.Err<Unit>(Unit.INSTANCE)));
        }
        return v0;
    }

    private final RsResult<Unit, CastError> checkRefCast(Ty tyExpr, Mutability mutExpr, Ty tyCast, Mutability mutCast) {
        if (mutExpr.compareTo((Enum)mutCast) < 0 || !(tyExpr instanceof TyArray)) {
            return this.toErr(CastError.IllegalCast.INSTANCE);
        }
        RsResult<CoerceOk, TypeError> $this$unwrapOrElse$iv = this.ctx.tryCoerce(this.exprTy, new TyRawPtr(tyExpr, mutExpr, null, 4, null));
        boolean $i$f$unwrapOrElse = false;
        RsResult<CoerceOk, TypeError> rsResult = $this$unwrapOrElse$iv;
        if (!(rsResult instanceof RsResult.Ok)) {
            if (rsResult instanceof RsResult.Err) {
                TypeError it2 = (TypeError)((RsResult.Err)$this$unwrapOrElse$iv).getErr();
                boolean bl = false;
                throw new IllegalStateException("could not cast from reference to array to pointer to array".toString());
            }
            throw new NoWhenBranchMatchedException();
        }
        ((RsResult.Ok)$this$unwrapOrElse$iv).getOk();
        this.ctx.demandEq(this.getCastKeyword(), ((TyArray)tyExpr).getBase(), tyCast);
        return this.ok;
    }

    private final void reportCastToUnsizedType() {
        if (this.castTy instanceof TyUnknown || this.exprTy instanceof TyUnknown) {
            return;
        }
        this.ctx.addDiagnostic(new RsDiagnostic.CastToUnsized(this.getCastKeyword(), (Ty)this.ctx.resolveTypeVarsIfPossible((TypeFoldable)this.exprTy), this.castTy, CollectionsKt.emptyList()));
    }

    public /* synthetic */ CastCheck(RsInferenceContext ctx, RsExpr expr, Ty exprTy, Ty castTy, DefaultConstructorMarker $constructor_marker) {
        this(ctx, expr, exprTy, castTy);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b2\u0018\u00002\u00020\u0001:\u000e\f\r\u000e\u000f\u0010\u0011\u0012\u0013\u0014\u0015\u0016\u0017\u0018\u0019B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007R\u0016\u0010\b\u001a\u00020\t*\u00020\u0007X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u0082\u0001\u000e\u001a\u001b\u001c\u001d\u001e\u001f !\"#$%&'\u00a8\u0006("}, d2={"Lorg/rust/lang/core/types/infer/CastCheck$CastError;", "", "<init>", "()V", "report", "", "check", "Lorg/rust/lang/core/types/infer/CastCheck;", "diagnostic", "Lorg/rust/lang/utils/RsDiagnostic;", "getDiagnostic", "(Lorg/rust/lang/core/types/infer/CastCheck;)Lorg/rust/lang/utils/RsDiagnostic;", "CastToBool", "CastToChar", "DifferingKinds", "SizedUnsizedCast", "IllegalCast", "NeedDeref", "NeedViaPtr", "NeedViaThinPtr", "NeedViaInt", "NonScalar", "UnknownExprPtrKind", "UnknownCastPtrKind", "IntToFatCast", "ForeignNonExhaustiveAdt", "Lorg/rust/lang/core/types/infer/CastCheck$CastError$CastToBool;", "Lorg/rust/lang/core/types/infer/CastCheck$CastError$CastToChar;", "Lorg/rust/lang/core/types/infer/CastCheck$CastError$DifferingKinds;", "Lorg/rust/lang/core/types/infer/CastCheck$CastError$ForeignNonExhaustiveAdt;", "Lorg/rust/lang/core/types/infer/CastCheck$CastError$IllegalCast;", "Lorg/rust/lang/core/types/infer/CastCheck$CastError$IntToFatCast;", "Lorg/rust/lang/core/types/infer/CastCheck$CastError$NeedDeref;", "Lorg/rust/lang/core/types/infer/CastCheck$CastError$NeedViaInt;", "Lorg/rust/lang/core/types/infer/CastCheck$CastError$NeedViaPtr;", "Lorg/rust/lang/core/types/infer/CastCheck$CastError$NeedViaThinPtr;", "Lorg/rust/lang/core/types/infer/CastCheck$CastError$NonScalar;", "Lorg/rust/lang/core/types/infer/CastCheck$CastError$SizedUnsizedCast;", "Lorg/rust/lang/core/types/infer/CastCheck$CastError$UnknownCastPtrKind;", "Lorg/rust/lang/core/types/infer/CastCheck$CastError$UnknownExprPtrKind;", "intellij.rustrover.core"})
    private static abstract sealed class CastError {
        private CastError() {
        }

        public final void report(@NotNull CastCheck check2) {
            Intrinsics.checkNotNullParameter((Object)check2, (String)"check");
            check2.ctx.addDiagnostic(this.getDiagnostic(check2));
        }

        @NotNull
        protected abstract RsDiagnostic getDiagnostic(@NotNull CastCheck var1);

        public /* synthetic */ CastError(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0018\u0010\u0004\u001a\u00020\u0005*\u00020\u00068TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0011"}, d2={"Lorg/rust/lang/core/types/infer/CastCheck$CastError$CastToBool;", "Lorg/rust/lang/core/types/infer/CastCheck$CastError;", "<init>", "()V", "diagnostic", "Lorg/rust/lang/utils/RsDiagnostic;", "Lorg/rust/lang/core/types/infer/CastCheck;", "getDiagnostic", "(Lorg/rust/lang/core/types/infer/CastCheck;)Lorg/rust/lang/utils/RsDiagnostic;", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.rustrover.core"})
        public static final class CastToBool
        extends CastError {
            @NotNull
            public static final CastToBool INSTANCE = new CastToBool();

            private CastToBool() {
                super(null);
            }

            @Override
            @NotNull
            protected RsDiagnostic getDiagnostic(@NotNull CastCheck $this$diagnostic) {
                Intrinsics.checkNotNullParameter((Object)$this$diagnostic, (String)"<this>");
                return new RsDiagnostic.CastToBool($this$diagnostic.getCastKeyword(), $this$diagnostic.exprTy, $this$diagnostic.castTy, $this$diagnostic.cast);
            }

            @NotNull
            public String toString() {
                return "CastToBool";
            }

            public int hashCode() {
                return -1406152142;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof CastToBool)) {
                    return false;
                }
                CastToBool cfr_ignored_0 = (CastToBool)other;
                return true;
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0018\u0010\u0004\u001a\u00020\u0005*\u00020\u00068TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0011"}, d2={"Lorg/rust/lang/core/types/infer/CastCheck$CastError$CastToChar;", "Lorg/rust/lang/core/types/infer/CastCheck$CastError;", "<init>", "()V", "diagnostic", "Lorg/rust/lang/utils/RsDiagnostic;", "Lorg/rust/lang/core/types/infer/CastCheck;", "getDiagnostic", "(Lorg/rust/lang/core/types/infer/CastCheck;)Lorg/rust/lang/utils/RsDiagnostic;", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.rustrover.core"})
        public static final class CastToChar
        extends CastError {
            @NotNull
            public static final CastToChar INSTANCE = new CastToChar();

            private CastToChar() {
                super(null);
            }

            @Override
            @NotNull
            protected RsDiagnostic getDiagnostic(@NotNull CastCheck $this$diagnostic) {
                Intrinsics.checkNotNullParameter((Object)$this$diagnostic, (String)"<this>");
                return new RsDiagnostic.CastToChar($this$diagnostic.getCastKeyword(), $this$diagnostic.exprTy, $this$diagnostic.castTy, $this$diagnostic.cast);
            }

            @NotNull
            public String toString() {
                return "CastToChar";
            }

            public int hashCode() {
                return -1406129506;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof CastToChar)) {
                    return false;
                }
                CastToChar cfr_ignored_0 = (CastToChar)other;
                return true;
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0018\u0010\u0004\u001a\u00020\u0005*\u00020\u00068TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0011"}, d2={"Lorg/rust/lang/core/types/infer/CastCheck$CastError$DifferingKinds;", "Lorg/rust/lang/core/types/infer/CastCheck$CastError;", "<init>", "()V", "diagnostic", "Lorg/rust/lang/utils/RsDiagnostic;", "Lorg/rust/lang/core/types/infer/CastCheck;", "getDiagnostic", "(Lorg/rust/lang/core/types/infer/CastCheck;)Lorg/rust/lang/utils/RsDiagnostic;", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.rustrover.core"})
        public static final class DifferingKinds
        extends CastError {
            @NotNull
            public static final DifferingKinds INSTANCE = new DifferingKinds();

            private DifferingKinds() {
                super(null);
            }

            @Override
            @NotNull
            protected RsDiagnostic getDiagnostic(@NotNull CastCheck $this$diagnostic) {
                Intrinsics.checkNotNullParameter((Object)$this$diagnostic, (String)"<this>");
                return new RsDiagnostic.InvalidCasting($this$diagnostic.getCastKeyword(), $this$diagnostic.exprTy, $this$diagnostic.castTy, $this$diagnostic.cast);
            }

            @NotNull
            public String toString() {
                return "DifferingKinds";
            }

            public int hashCode() {
                return -520798947;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof DifferingKinds)) {
                    return false;
                }
                DifferingKinds cfr_ignored_0 = (DifferingKinds)other;
                return true;
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0018\u0010\u0004\u001a\u00020\u0005*\u00020\u00068TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0011"}, d2={"Lorg/rust/lang/core/types/infer/CastCheck$CastError$ForeignNonExhaustiveAdt;", "Lorg/rust/lang/core/types/infer/CastCheck$CastError;", "<init>", "()V", "diagnostic", "Lorg/rust/lang/utils/RsDiagnostic;", "Lorg/rust/lang/core/types/infer/CastCheck;", "getDiagnostic", "(Lorg/rust/lang/core/types/infer/CastCheck;)Lorg/rust/lang/utils/RsDiagnostic;", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.rustrover.core"})
        public static final class ForeignNonExhaustiveAdt
        extends CastError {
            @NotNull
            public static final ForeignNonExhaustiveAdt INSTANCE = new ForeignNonExhaustiveAdt();

            private ForeignNonExhaustiveAdt() {
                super(null);
            }

            @Override
            @NotNull
            protected RsDiagnostic getDiagnostic(@NotNull CastCheck $this$diagnostic) {
                Intrinsics.checkNotNullParameter((Object)$this$diagnostic, (String)"<this>");
                return new RsDiagnostic.ForeignNonExhaustiveAdtCast($this$diagnostic.getCastKeyword(), $this$diagnostic.exprTy, $this$diagnostic.castTy, $this$diagnostic.cast);
            }

            @NotNull
            public String toString() {
                return "ForeignNonExhaustiveAdt";
            }

            public int hashCode() {
                return -667912644;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof ForeignNonExhaustiveAdt)) {
                    return false;
                }
                ForeignNonExhaustiveAdt cfr_ignored_0 = (ForeignNonExhaustiveAdt)other;
                return true;
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0018\u0010\u0004\u001a\u00020\u0005*\u00020\u00068TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0011"}, d2={"Lorg/rust/lang/core/types/infer/CastCheck$CastError$IllegalCast;", "Lorg/rust/lang/core/types/infer/CastCheck$CastError;", "<init>", "()V", "diagnostic", "Lorg/rust/lang/utils/RsDiagnostic;", "Lorg/rust/lang/core/types/infer/CastCheck;", "getDiagnostic", "(Lorg/rust/lang/core/types/infer/CastCheck;)Lorg/rust/lang/utils/RsDiagnostic;", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.rustrover.core"})
        public static final class IllegalCast
        extends CastError {
            @NotNull
            public static final IllegalCast INSTANCE = new IllegalCast();

            private IllegalCast() {
                super(null);
            }

            @Override
            @NotNull
            protected RsDiagnostic getDiagnostic(@NotNull CastCheck $this$diagnostic) {
                Intrinsics.checkNotNullParameter((Object)$this$diagnostic, (String)"<this>");
                return new RsDiagnostic.InvalidCasting($this$diagnostic.getCastKeyword(), $this$diagnostic.exprTy, $this$diagnostic.castTy, $this$diagnostic.cast);
            }

            @NotNull
            public String toString() {
                return "IllegalCast";
            }

            public int hashCode() {
                return -1985213561;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof IllegalCast)) {
                    return false;
                }
                IllegalCast cfr_ignored_0 = (IllegalCast)other;
                return true;
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000b\u0010\r\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0015\u0010\u000e\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0003H\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0018\u0010\b\u001a\u00020\t*\u00020\n8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0016"}, d2={"Lorg/rust/lang/core/types/infer/CastCheck$CastError$IntToFatCast;", "Lorg/rust/lang/core/types/infer/CastCheck$CastError;", "knownMetadata", "", "<init>", "(Ljava/lang/String;)V", "getKnownMetadata", "()Ljava/lang/String;", "diagnostic", "Lorg/rust/lang/utils/RsDiagnostic;", "Lorg/rust/lang/core/types/infer/CastCheck;", "getDiagnostic", "(Lorg/rust/lang/core/types/infer/CastCheck;)Lorg/rust/lang/utils/RsDiagnostic;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intellij.rustrover.core"})
        public static final class IntToFatCast
        extends CastError {
            @Nullable
            private final String knownMetadata;

            public IntToFatCast(@Nullable String knownMetadata) {
                super(null);
                this.knownMetadata = knownMetadata;
            }

            @Nullable
            public final String getKnownMetadata() {
                return this.knownMetadata;
            }

            @Override
            @NotNull
            protected RsDiagnostic getDiagnostic(@NotNull CastCheck $this$diagnostic) {
                Intrinsics.checkNotNullParameter((Object)$this$diagnostic, (String)"<this>");
                return new RsDiagnostic.IntToFatCast($this$diagnostic.getCastKeyword(), $this$diagnostic.exprTy, $this$diagnostic.castTy, $this$diagnostic.cast, this.knownMetadata != null);
            }

            @Nullable
            public final String component1() {
                return this.knownMetadata;
            }

            @NotNull
            public final IntToFatCast copy(@Nullable String knownMetadata) {
                return new IntToFatCast(knownMetadata);
            }

            public static /* synthetic */ IntToFatCast copy$default(IntToFatCast intToFatCast, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    string = intToFatCast.knownMetadata;
                }
                return intToFatCast.copy(string);
            }

            @NotNull
            public String toString() {
                return "IntToFatCast(knownMetadata=" + this.knownMetadata + ")";
            }

            public int hashCode() {
                return this.knownMetadata == null ? 0 : this.knownMetadata.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof IntToFatCast)) {
                    return false;
                }
                IntToFatCast intToFatCast = (IntToFatCast)other;
                return Intrinsics.areEqual((Object)this.knownMetadata, (Object)intToFatCast.knownMetadata);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0018\u0010\u0004\u001a\u00020\u0005*\u00020\u00068TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0011"}, d2={"Lorg/rust/lang/core/types/infer/CastCheck$CastError$NeedDeref;", "Lorg/rust/lang/core/types/infer/CastCheck$CastError;", "<init>", "()V", "diagnostic", "Lorg/rust/lang/utils/RsDiagnostic;", "Lorg/rust/lang/core/types/infer/CastCheck;", "getDiagnostic", "(Lorg/rust/lang/core/types/infer/CastCheck;)Lorg/rust/lang/utils/RsDiagnostic;", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.rustrover.core"})
        public static final class NeedDeref
        extends CastError {
            @NotNull
            public static final NeedDeref INSTANCE = new NeedDeref();

            private NeedDeref() {
                super(null);
            }

            @Override
            @NotNull
            protected RsDiagnostic getDiagnostic(@NotNull CastCheck $this$diagnostic) {
                Intrinsics.checkNotNullParameter((Object)$this$diagnostic, (String)"<this>");
                return new RsDiagnostic.InvalidCasting($this$diagnostic.getCastKeyword(), $this$diagnostic.exprTy, $this$diagnostic.castTy, $this$diagnostic.cast);
            }

            @NotNull
            public String toString() {
                return "NeedDeref";
            }

            public int hashCode() {
                return -84460114;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof NeedDeref)) {
                    return false;
                }
                NeedDeref cfr_ignored_0 = (NeedDeref)other;
                return true;
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0018\u0010\u0004\u001a\u00020\u0005*\u00020\u00068TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0011"}, d2={"Lorg/rust/lang/core/types/infer/CastCheck$CastError$NeedViaInt;", "Lorg/rust/lang/core/types/infer/CastCheck$CastError;", "<init>", "()V", "diagnostic", "Lorg/rust/lang/utils/RsDiagnostic;", "Lorg/rust/lang/core/types/infer/CastCheck;", "getDiagnostic", "(Lorg/rust/lang/core/types/infer/CastCheck;)Lorg/rust/lang/utils/RsDiagnostic;", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.rustrover.core"})
        public static final class NeedViaInt
        extends CastError {
            @NotNull
            public static final NeedViaInt INSTANCE = new NeedViaInt();

            private NeedViaInt() {
                super(null);
            }

            @Override
            @NotNull
            protected RsDiagnostic getDiagnostic(@NotNull CastCheck $this$diagnostic) {
                Intrinsics.checkNotNullParameter((Object)$this$diagnostic, (String)"<this>");
                return new RsDiagnostic.InvalidCasting($this$diagnostic.getCastKeyword(), $this$diagnostic.exprTy, $this$diagnostic.castTy, $this$diagnostic.cast);
            }

            @NotNull
            public String toString() {
                return "NeedViaInt";
            }

            public int hashCode() {
                return -2099777723;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof NeedViaInt)) {
                    return false;
                }
                NeedViaInt cfr_ignored_0 = (NeedViaInt)other;
                return true;
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0018\u0010\u0004\u001a\u00020\u0005*\u00020\u00068TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0011"}, d2={"Lorg/rust/lang/core/types/infer/CastCheck$CastError$NeedViaPtr;", "Lorg/rust/lang/core/types/infer/CastCheck$CastError;", "<init>", "()V", "diagnostic", "Lorg/rust/lang/utils/RsDiagnostic;", "Lorg/rust/lang/core/types/infer/CastCheck;", "getDiagnostic", "(Lorg/rust/lang/core/types/infer/CastCheck;)Lorg/rust/lang/utils/RsDiagnostic;", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.rustrover.core"})
        public static final class NeedViaPtr
        extends CastError {
            @NotNull
            public static final NeedViaPtr INSTANCE = new NeedViaPtr();

            private NeedViaPtr() {
                super(null);
            }

            @Override
            @NotNull
            protected RsDiagnostic getDiagnostic(@NotNull CastCheck $this$diagnostic) {
                Intrinsics.checkNotNullParameter((Object)$this$diagnostic, (String)"<this>");
                return new RsDiagnostic.InvalidCasting($this$diagnostic.getCastKeyword(), $this$diagnostic.exprTy, $this$diagnostic.castTy, $this$diagnostic.cast);
            }

            @NotNull
            public String toString() {
                return "NeedViaPtr";
            }

            public int hashCode() {
                return -2099770812;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof NeedViaPtr)) {
                    return false;
                }
                NeedViaPtr cfr_ignored_0 = (NeedViaPtr)other;
                return true;
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0018\u0010\u0004\u001a\u00020\u0005*\u00020\u00068TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0011"}, d2={"Lorg/rust/lang/core/types/infer/CastCheck$CastError$NeedViaThinPtr;", "Lorg/rust/lang/core/types/infer/CastCheck$CastError;", "<init>", "()V", "diagnostic", "Lorg/rust/lang/utils/RsDiagnostic;", "Lorg/rust/lang/core/types/infer/CastCheck;", "getDiagnostic", "(Lorg/rust/lang/core/types/infer/CastCheck;)Lorg/rust/lang/utils/RsDiagnostic;", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.rustrover.core"})
        public static final class NeedViaThinPtr
        extends CastError {
            @NotNull
            public static final NeedViaThinPtr INSTANCE = new NeedViaThinPtr();

            private NeedViaThinPtr() {
                super(null);
            }

            @Override
            @NotNull
            protected RsDiagnostic getDiagnostic(@NotNull CastCheck $this$diagnostic) {
                Intrinsics.checkNotNullParameter((Object)$this$diagnostic, (String)"<this>");
                return new RsDiagnostic.InvalidCasting($this$diagnostic.getCastKeyword(), $this$diagnostic.exprTy, $this$diagnostic.castTy, $this$diagnostic.cast);
            }

            @NotNull
            public String toString() {
                return "NeedViaThinPtr";
            }

            public int hashCode() {
                return -1504414229;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof NeedViaThinPtr)) {
                    return false;
                }
                NeedViaThinPtr cfr_ignored_0 = (NeedViaThinPtr)other;
                return true;
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0018\u0010\u0004\u001a\u00020\u0005*\u00020\u00068TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0011"}, d2={"Lorg/rust/lang/core/types/infer/CastCheck$CastError$NonScalar;", "Lorg/rust/lang/core/types/infer/CastCheck$CastError;", "<init>", "()V", "diagnostic", "Lorg/rust/lang/utils/RsDiagnostic;", "Lorg/rust/lang/core/types/infer/CastCheck;", "getDiagnostic", "(Lorg/rust/lang/core/types/infer/CastCheck;)Lorg/rust/lang/utils/RsDiagnostic;", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.rustrover.core"})
        public static final class NonScalar
        extends CastError {
            @NotNull
            public static final NonScalar INSTANCE = new NonScalar();

            private NonScalar() {
                super(null);
            }

            @Override
            @NotNull
            protected RsDiagnostic getDiagnostic(@NotNull CastCheck $this$diagnostic) {
                Intrinsics.checkNotNullParameter((Object)$this$diagnostic, (String)"<this>");
                return new RsDiagnostic.NonPrimitiveCast($this$diagnostic.getCastKeyword(), $this$diagnostic.exprTy, $this$diagnostic.castTy, $this$diagnostic.cast);
            }

            @NotNull
            public String toString() {
                return "NonScalar";
            }

            public int hashCode() {
                return -896818869;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof NonScalar)) {
                    return false;
                }
                NonScalar cfr_ignored_0 = (NonScalar)other;
                return true;
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0018\u0010\u0004\u001a\u00020\u0005*\u00020\u00068TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0011"}, d2={"Lorg/rust/lang/core/types/infer/CastCheck$CastError$SizedUnsizedCast;", "Lorg/rust/lang/core/types/infer/CastCheck$CastError;", "<init>", "()V", "diagnostic", "Lorg/rust/lang/utils/RsDiagnostic;", "Lorg/rust/lang/core/types/infer/CastCheck;", "getDiagnostic", "(Lorg/rust/lang/core/types/infer/CastCheck;)Lorg/rust/lang/utils/RsDiagnostic;", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.rustrover.core"})
        public static final class SizedUnsizedCast
        extends CastError {
            @NotNull
            public static final SizedUnsizedCast INSTANCE = new SizedUnsizedCast();

            private SizedUnsizedCast() {
                super(null);
            }

            @Override
            @NotNull
            protected RsDiagnostic getDiagnostic(@NotNull CastCheck $this$diagnostic) {
                Intrinsics.checkNotNullParameter((Object)$this$diagnostic, (String)"<this>");
                return new RsDiagnostic.SizedUnsizedCast($this$diagnostic.getCastKeyword(), $this$diagnostic.exprTy, $this$diagnostic.castTy, $this$diagnostic.cast);
            }

            @NotNull
            public String toString() {
                return "SizedUnsizedCast";
            }

            public int hashCode() {
                return -1430628620;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof SizedUnsizedCast)) {
                    return false;
                }
                SizedUnsizedCast cfr_ignored_0 = (SizedUnsizedCast)other;
                return true;
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0018\u0010\u0004\u001a\u00020\u0005*\u00020\u00068TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0011"}, d2={"Lorg/rust/lang/core/types/infer/CastCheck$CastError$UnknownCastPtrKind;", "Lorg/rust/lang/core/types/infer/CastCheck$CastError;", "<init>", "()V", "diagnostic", "Lorg/rust/lang/utils/RsDiagnostic;", "Lorg/rust/lang/core/types/infer/CastCheck;", "getDiagnostic", "(Lorg/rust/lang/core/types/infer/CastCheck;)Lorg/rust/lang/utils/RsDiagnostic;", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.rustrover.core"})
        public static final class UnknownCastPtrKind
        extends CastError {
            @NotNull
            public static final UnknownCastPtrKind INSTANCE = new UnknownCastPtrKind();

            private UnknownCastPtrKind() {
                super(null);
            }

            @Override
            @NotNull
            protected RsDiagnostic getDiagnostic(@NotNull CastCheck $this$diagnostic) {
                Intrinsics.checkNotNullParameter((Object)$this$diagnostic, (String)"<this>");
                return new RsDiagnostic.UnknownCastKind($this$diagnostic.getCastKeyword(), $this$diagnostic.exprTy, $this$diagnostic.castTy, $this$diagnostic.cast, true);
            }

            @NotNull
            public String toString() {
                return "UnknownCastPtrKind";
            }

            public int hashCode() {
                return 45247687;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof UnknownCastPtrKind)) {
                    return false;
                }
                UnknownCastPtrKind cfr_ignored_0 = (UnknownCastPtrKind)other;
                return true;
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0018\u0010\u0004\u001a\u00020\u0005*\u00020\u00068TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0011"}, d2={"Lorg/rust/lang/core/types/infer/CastCheck$CastError$UnknownExprPtrKind;", "Lorg/rust/lang/core/types/infer/CastCheck$CastError;", "<init>", "()V", "diagnostic", "Lorg/rust/lang/utils/RsDiagnostic;", "Lorg/rust/lang/core/types/infer/CastCheck;", "getDiagnostic", "(Lorg/rust/lang/core/types/infer/CastCheck;)Lorg/rust/lang/utils/RsDiagnostic;", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.rustrover.core"})
        public static final class UnknownExprPtrKind
        extends CastError {
            @NotNull
            public static final UnknownExprPtrKind INSTANCE = new UnknownExprPtrKind();

            private UnknownExprPtrKind() {
                super(null);
            }

            @Override
            @NotNull
            protected RsDiagnostic getDiagnostic(@NotNull CastCheck $this$diagnostic) {
                Intrinsics.checkNotNullParameter((Object)$this$diagnostic, (String)"<this>");
                return new RsDiagnostic.UnknownCastKind($this$diagnostic.getCastKeyword(), $this$diagnostic.exprTy, $this$diagnostic.castTy, $this$diagnostic.cast, false);
            }

            @NotNull
            public String toString() {
                return "UnknownExprPtrKind";
            }

            public int hashCode() {
                return -1836755631;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof UnknownExprPtrKind)) {
                    return false;
                }
                UnknownExprPtrKind cfr_ignored_0 = (UnknownExprPtrKind)other;
                return true;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b\u00a8\u0006\r"}, d2={"Lorg/rust/lang/core/types/infer/CastCheck$Companion;", "", "<init>", "()V", "create", "Lorg/rust/lang/core/types/infer/CastCheck;", "ctx", "Lorg/rust/lang/core/types/infer/RsInferenceContext;", "expr", "Lorg/rust/lang/core/psi/RsExpr;", "exprTy", "Lorg/rust/lang/core/types/ty/Ty;", "castTy", "intellij.rustrover.core"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final CastCheck create(@NotNull RsInferenceContext ctx, @NotNull RsExpr expr, @NotNull Ty exprTy, @NotNull Ty castTy) {
            CastCheck castCheck;
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
            Intrinsics.checkNotNullParameter((Object)exprTy, (String)"exprTy");
            Intrinsics.checkNotNullParameter((Object)castTy, (String)"castTy");
            CastCheck check2 = new CastCheck(ctx, expr, exprTy, castTy, null);
            if (castTy instanceof TyDynamic || castTy instanceof TySlice) {
                check2.reportCastToUnsizedType();
                castCheck = null;
            } else {
                castCheck = check2;
            }
            return castCheck;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b2\u0018\u0000 \t2\u00020\u0001:\u0006\u0004\u0005\u0006\u0007\b\tB\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003\u0082\u0001\u0005\n\u000b\f\r\u000e\u00a8\u0006\u000f"}, d2={"Lorg/rust/lang/core/types/infer/CastCheck$PointerKind;", "", "<init>", "()V", "Thin", "VTable", "Length", "OfAlias", "OfParam", "Companion", "Lorg/rust/lang/core/types/infer/CastCheck$PointerKind$Length;", "Lorg/rust/lang/core/types/infer/CastCheck$PointerKind$OfAlias;", "Lorg/rust/lang/core/types/infer/CastCheck$PointerKind$OfParam;", "Lorg/rust/lang/core/types/infer/CastCheck$PointerKind$Thin;", "Lorg/rust/lang/core/types/infer/CastCheck$PointerKind$VTable;", "intellij.rustrover.core"})
    private static abstract sealed class PointerKind {
        @NotNull
        public static final Companion Companion = new Companion(null);

        private PointerKind() {
        }

        public /* synthetic */ PointerKind(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lorg/rust/lang/core/types/infer/CastCheck$PointerKind$Companion;", "", "<init>", "()V", "intellij.rustrover.core"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00d6\u0003J\t\u0010\b\u001a\u00020\tH\u00d6\u0001J\t\u0010\n\u001a\u00020\u000bH\u00d6\u0001\u00a8\u0006\f"}, d2={"Lorg/rust/lang/core/types/infer/CastCheck$PointerKind$Length;", "Lorg/rust/lang/core/types/infer/CastCheck$PointerKind;", "<init>", "()V", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.rustrover.core"})
        public static final class Length
        extends PointerKind {
            @NotNull
            public static final Length INSTANCE = new Length();

            private Length() {
                super(null);
            }

            @NotNull
            public String toString() {
                return "Length";
            }

            public int hashCode() {
                return -1968377012;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Length)) {
                    return false;
                }
                Length cfr_ignored_0 = (Length)other;
                return true;
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lorg/rust/lang/core/types/infer/CastCheck$PointerKind$OfAlias;", "Lorg/rust/lang/core/types/infer/CastCheck$PointerKind;", "ty", "Lorg/rust/lang/core/types/ty/Ty;", "<init>", "(Lorg/rust/lang/core/types/ty/Ty;)V", "getTy", "()Lorg/rust/lang/core/types/ty/Ty;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.rustrover.core"})
        public static final class OfAlias
        extends PointerKind {
            @NotNull
            private final Ty ty;

            public OfAlias(@NotNull Ty ty2) {
                Intrinsics.checkNotNullParameter((Object)ty2, (String)"ty");
                super(null);
                this.ty = ty2;
            }

            @NotNull
            public final Ty getTy() {
                return this.ty;
            }

            @NotNull
            public final Ty component1() {
                return this.ty;
            }

            @NotNull
            public final OfAlias copy(@NotNull Ty ty2) {
                Intrinsics.checkNotNullParameter((Object)ty2, (String)"ty");
                return new OfAlias(ty2);
            }

            public static /* synthetic */ OfAlias copy$default(OfAlias ofAlias, Ty ty2, int n, Object object) {
                if ((n & 1) != 0) {
                    ty2 = ofAlias.ty;
                }
                return ofAlias.copy(ty2);
            }

            @NotNull
            public String toString() {
                return "OfAlias(ty=" + this.ty + ")";
            }

            public int hashCode() {
                return this.ty.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof OfAlias)) {
                    return false;
                }
                OfAlias ofAlias = (OfAlias)other;
                return Intrinsics.areEqual((Object)this.ty, (Object)ofAlias.ty);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lorg/rust/lang/core/types/infer/CastCheck$PointerKind$OfParam;", "Lorg/rust/lang/core/types/infer/CastCheck$PointerKind;", "ty", "Lorg/rust/lang/core/types/ty/Ty;", "<init>", "(Lorg/rust/lang/core/types/ty/Ty;)V", "getTy", "()Lorg/rust/lang/core/types/ty/Ty;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.rustrover.core"})
        public static final class OfParam
        extends PointerKind {
            @NotNull
            private final Ty ty;

            public OfParam(@NotNull Ty ty2) {
                Intrinsics.checkNotNullParameter((Object)ty2, (String)"ty");
                super(null);
                this.ty = ty2;
            }

            @NotNull
            public final Ty getTy() {
                return this.ty;
            }

            @NotNull
            public final Ty component1() {
                return this.ty;
            }

            @NotNull
            public final OfParam copy(@NotNull Ty ty2) {
                Intrinsics.checkNotNullParameter((Object)ty2, (String)"ty");
                return new OfParam(ty2);
            }

            public static /* synthetic */ OfParam copy$default(OfParam ofParam, Ty ty2, int n, Object object) {
                if ((n & 1) != 0) {
                    ty2 = ofParam.ty;
                }
                return ofParam.copy(ty2);
            }

            @NotNull
            public String toString() {
                return "OfParam(ty=" + this.ty + ")";
            }

            public int hashCode() {
                return this.ty.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof OfParam)) {
                    return false;
                }
                OfParam ofParam = (OfParam)other;
                return Intrinsics.areEqual((Object)this.ty, (Object)ofParam.ty);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00d6\u0003J\t\u0010\b\u001a\u00020\tH\u00d6\u0001J\t\u0010\n\u001a\u00020\u000bH\u00d6\u0001\u00a8\u0006\f"}, d2={"Lorg/rust/lang/core/types/infer/CastCheck$PointerKind$Thin;", "Lorg/rust/lang/core/types/infer/CastCheck$PointerKind;", "<init>", "()V", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.rustrover.core"})
        public static final class Thin
        extends PointerKind {
            @NotNull
            public static final Thin INSTANCE = new Thin();

            private Thin() {
                super(null);
            }

            @NotNull
            public String toString() {
                return "Thin";
            }

            public int hashCode() {
                return -1110185857;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Thin)) {
                    return false;
                }
                Thin cfr_ignored_0 = (Thin)other;
                return true;
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000b\u0010\b\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0015\u0010\t\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lorg/rust/lang/core/types/infer/CastCheck$PointerKind$VTable;", "Lorg/rust/lang/core/types/infer/CastCheck$PointerKind;", "trait", "Lorg/rust/lang/core/psi/RsTraitItem;", "<init>", "(Lorg/rust/lang/core/psi/RsTraitItem;)V", "getTrait", "()Lorg/rust/lang/core/psi/RsTraitItem;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.rustrover.core"})
        public static final class VTable
        extends PointerKind {
            @Nullable
            private final RsTraitItem trait;

            public VTable(@Nullable RsTraitItem trait) {
                super(null);
                this.trait = trait;
            }

            @Nullable
            public final RsTraitItem getTrait() {
                return this.trait;
            }

            @Nullable
            public final RsTraitItem component1() {
                return this.trait;
            }

            @NotNull
            public final VTable copy(@Nullable RsTraitItem trait) {
                return new VTable(trait);
            }

            public static /* synthetic */ VTable copy$default(VTable vTable, RsTraitItem rsTraitItem, int n, Object object) {
                if ((n & 1) != 0) {
                    rsTraitItem = vTable.trait;
                }
                return vTable.copy(rsTraitItem);
            }

            @NotNull
            public String toString() {
                return "VTable(trait=" + this.trait + ")";
            }

            public int hashCode() {
                return this.trait == null ? 0 : this.trait.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof VTable)) {
                    return false;
                }
                VTable vTable = (VTable)other;
                return Intrinsics.areEqual((Object)this.trait, (Object)vTable.trait);
            }
        }
    }
}

