/*
 * Decompiled with CFR 0.152.
 */
package org.rust.lang.core.types;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.lang.core.psi.RsCallExpr;
import org.rust.lang.core.psi.RsExpr;
import org.rust.lang.core.psi.RsFunction;
import org.rust.lang.core.psi.RsMethodCall;
import org.rust.lang.core.psi.RsValueArgumentList;
import org.rust.lang.core.psi.ext.RsElement;
import org.rust.lang.core.psi.ext.RsFunctionKt;
import org.rust.lang.core.types.ExtensionsKt;
import org.rust.lang.core.types.FunctionCallContext;
import org.rust.lang.core.types.RsCallable;
import org.rust.lang.core.types.infer.TypeInferenceWalkerKt;
import org.rust.lang.core.types.ty.Ty;
import org.rust.lang.core.types.ty.TyClosure;
import org.rust.lang.core.types.ty.TyFnDef;
import org.rust.lang.core.types.ty.TyFnPtr;
import org.rust.lang.utils.RsDiagnostic;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u0014\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\f\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u0002\u001a\f\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u0003\u001a\f\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u0004\u00a8\u0006\u0005"}, d2={"getFunctionCallContext", "Lorg/rust/lang/core/types/FunctionCallContext;", "Lorg/rust/lang/core/psi/RsValueArgumentList;", "Lorg/rust/lang/core/psi/RsCallExpr;", "Lorg/rust/lang/core/psi/RsMethodCall;", "intellij.rustrover.core"})
public final class FunctionCallContextKt {
    @Nullable
    public static final FunctionCallContext getFunctionCallContext(@NotNull RsValueArgumentList $this$getFunctionCallContext) {
        Intrinsics.checkNotNullParameter((Object)$this$getFunctionCallContext, (String)"<this>");
        PsiElement parent2 = $this$getFunctionCallContext.getParent();
        return parent2 instanceof RsCallExpr ? FunctionCallContextKt.getFunctionCallContext((RsCallExpr)parent2) : (parent2 instanceof RsMethodCall ? FunctionCallContextKt.getFunctionCallContext((RsMethodCall)parent2) : null);
    }

    @Nullable
    public static final FunctionCallContext getFunctionCallContext(@NotNull RsCallExpr $this$getFunctionCallContext) {
        FunctionCallContext functionCallContext;
        Intrinsics.checkNotNullParameter((Object)$this$getFunctionCallContext, (String)"<this>");
        RsExpr rsExpr = $this$getFunctionCallContext.getExpr();
        Intrinsics.checkNotNullExpressionValue((Object)rsExpr, (String)"getExpr(...)");
        Ty calleeType = ExtensionsKt.getAdjustedType(rsExpr);
        if (calleeType instanceof TyFnDef) {
            int s;
            RsCallable callable = ((TyFnDef)calleeType).getDef();
            int count = callable.getParameterTypes().size();
            int n = s = callable.getSelfParameter() != null ? 1 : 0;
            RsDiagnostic.IncorrectFunctionArgumentCountError.FunctionType functionType = callable.isVariadic() ? RsDiagnostic.IncorrectFunctionArgumentCountError.FunctionType.VARIADIC_FUNCTION : (callable instanceof RsCallable.StructItem ? RsDiagnostic.IncorrectFunctionArgumentCountError.FunctionType.STRUCT : (callable instanceof RsCallable.EnumVariant ? RsDiagnostic.IncorrectFunctionArgumentCountError.FunctionType.ENUM_VARIANT : RsDiagnostic.IncorrectFunctionArgumentCountError.FunctionType.FUNCTION));
            RsCallable.Function function = callable instanceof RsCallable.Function ? (RsCallable.Function)callable : null;
            functionCallContext = new FunctionCallContext(count + s, functionType, function != null ? function.getFn() : null);
        } else {
            functionCallContext = calleeType instanceof TyClosure ? new FunctionCallContext(((TyClosure)calleeType).getParamTypes().size(), RsDiagnostic.IncorrectFunctionArgumentCountError.FunctionType.CLOSURE, null, 4, null) : (calleeType instanceof TyFnPtr ? new FunctionCallContext(((TyFnPtr)calleeType).getParamTypes().size(), RsDiagnostic.IncorrectFunctionArgumentCountError.FunctionType.FUNCTION, null, 4, null) : null);
        }
        return functionCallContext;
    }

    @Nullable
    public static final FunctionCallContext getFunctionCallContext(@NotNull RsMethodCall $this$getFunctionCallContext) {
        Intrinsics.checkNotNullParameter((Object)$this$getFunctionCallContext, (String)"<this>");
        RsElement rsElement = $this$getFunctionCallContext.getReference().resolve();
        RsFunction rsFunction = rsElement instanceof RsFunction ? (RsFunction)rsElement : null;
        if (rsFunction == null) {
            return null;
        }
        RsFunction fn = rsFunction;
        int it2 = TypeInferenceWalkerKt.getType(fn).getDef().getParameterTypes().size();
        boolean bl = false;
        return new FunctionCallContext(it2, RsFunctionKt.isVariadic(fn) ? RsDiagnostic.IncorrectFunctionArgumentCountError.FunctionType.VARIADIC_FUNCTION : RsDiagnostic.IncorrectFunctionArgumentCountError.FunctionType.FUNCTION, fn);
    }
}

