/*
 * Decompiled with CFR 0.152.
 */
package org.rust.lang.core.thir.scopes;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.lang.core.thir.hir.RsHir;
import org.rust.lang.core.thir.scopes.RvalueCandidateType;
import org.rust.lang.core.thir.scopes.Scope;
import org.rust.lang.core.thir.scopes.ScopeInfo;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\f2\b\u0010\u0019\u001a\u0004\u0018\u00010\rJ\u0016\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\fJ\u0016\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020\u0013J\u0010\u0010 \u001a\u0004\u0018\u00010\f2\u0006\u0010!\u001a\u00020\fJ\u0010\u0010\"\u001a\u0004\u0018\u00010\f2\u0006\u0010\u001b\u001a\u00020\u000fJ\u0016\u0010#\u001a\u00020\f2\u0006\u0010$\u001a\u00020\f2\u0006\u0010%\u001a\u00020\fJ\u0013\u0010&\u001a\u00020'2\b\u0010(\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010)\u001a\u00020*H\u0016R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006+"}, d2={"Lorg/rust/lang/core/thir/scopes/ScopeTree;", "", "<init>", "()V", "rootBody", "Lorg/rust/lang/core/thir/hir/RsHir;", "getRootBody", "()Lorg/rust/lang/core/thir/hir/RsHir;", "setRootBody", "(Lorg/rust/lang/core/thir/hir/RsHir;)V", "parentMap", "", "Lorg/rust/lang/core/thir/scopes/Scope;", "Lorg/rust/lang/core/thir/scopes/ScopeInfo;", "varMap", "Lorg/rust/lang/core/thir/hir/RsHir$LocalVar;", "destructionScopes", "rvalueCandidates", "Lorg/rust/lang/core/thir/hir/RsHir$Expr;", "Lorg/rust/lang/core/thir/scopes/RvalueCandidateType;", "getRvalueCandidates", "()Ljava/util/Map;", "recordScopeParent", "", "childScope", "parentInfo", "recordVarScope", "variable", "parentScope", "recordRvalueCandidate", "expr", "candidateType", "getEnclosingScope", "scope", "getVariableScope", "getLowestCommonAncestor", "scope1", "scope2", "equals", "", "other", "hashCode", "", "intellij.rustrover.core"})
public final class ScopeTree {
    @Nullable
    private RsHir rootBody;
    @NotNull
    private final Map<Scope, ScopeInfo> parentMap = new HashMap();
    @NotNull
    private final Map<RsHir.LocalVar, Scope> varMap = new HashMap();
    @NotNull
    private final Map<RsHir, Scope> destructionScopes = new HashMap();
    @NotNull
    private final Map<RsHir.Expr, RvalueCandidateType> rvalueCandidates = new LinkedHashMap();

    @Nullable
    public final RsHir getRootBody() {
        return this.rootBody;
    }

    public final void setRootBody(@Nullable RsHir rsHir) {
        this.rootBody = rsHir;
    }

    @NotNull
    public final Map<RsHir.Expr, RvalueCandidateType> getRvalueCandidates() {
        return this.rvalueCandidates;
    }

    public final void recordScopeParent(@NotNull Scope childScope, @Nullable ScopeInfo parentInfo) {
        ScopeInfo prev;
        Intrinsics.checkNotNullParameter((Object)childScope, (String)"childScope");
        if (parentInfo != null && !((prev = this.parentMap.put(childScope, parentInfo)) == null)) {
            throw new IllegalStateException("Check failed.");
        }
        if (childScope instanceof Scope.Destruction) {
            this.destructionScopes.put(((Scope.Destruction)childScope).getElement(), childScope);
        }
    }

    public final void recordVarScope(@NotNull RsHir.LocalVar variable, @NotNull Scope parentScope) {
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        Intrinsics.checkNotNullParameter((Object)parentScope, (String)"parentScope");
        if (!(!Intrinsics.areEqual((Object)variable, (Object)parentScope.getElement()))) {
            throw new IllegalStateException("Check failed.");
        }
        this.varMap.put(variable, parentScope);
    }

    public final void recordRvalueCandidate(@NotNull RsHir.Expr expr, @NotNull RvalueCandidateType candidateType) {
        Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
        Intrinsics.checkNotNullParameter((Object)candidateType, (String)"candidateType");
        Scope lifetime = candidateType.getLifetime();
        if (lifetime != null && !(!Intrinsics.areEqual((Object)expr, (Object)lifetime.getElement()))) {
            throw new IllegalStateException("Check failed.");
        }
        this.rvalueCandidates.put(expr, candidateType);
    }

    @Nullable
    public final Scope getEnclosingScope(@NotNull Scope scope) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        ScopeInfo scopeInfo = this.parentMap.get(scope);
        return scopeInfo != null ? scopeInfo.getScope() : null;
    }

    @Nullable
    public final Scope getVariableScope(@NotNull RsHir.LocalVar variable) {
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        return this.varMap.get(variable);
    }

    @NotNull
    public final Scope getLowestCommonAncestor(@NotNull Scope scope1, @NotNull Scope scope2) {
        Intrinsics.checkNotNullParameter((Object)scope1, (String)"scope1");
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope2");
        if (Intrinsics.areEqual((Object)scope1, (Object)scope2)) {
            return scope1;
        }
        Scope currentScope1 = null;
        currentScope1 = scope1;
        Scope currentScope2 = null;
        currentScope2 = scope2;
        ScopeInfo scopeInfo = this.parentMap.get(currentScope1);
        if (scopeInfo == null) {
            return currentScope1;
        }
        ScopeInfo scopeInfo2 = scopeInfo;
        Scope parentScope1 = scopeInfo2.component1();
        int parentDepth1 = scopeInfo2.component2();
        ScopeInfo scopeInfo3 = this.parentMap.get(currentScope2);
        if (scopeInfo3 == null) {
            return currentScope2;
        }
        ScopeInfo scopeInfo4 = scopeInfo3;
        Scope parentScope2 = scopeInfo4.component1();
        int parentDepth2 = scopeInfo4.component2();
        if (parentDepth1 > parentDepth2) {
            currentScope1 = parentScope1;
            var11_11 = parentDepth1 - parentDepth2 - 1;
            var12_12 = 0;
            while (var12_12 < var11_11) {
                it = var12_12++;
                boolean bl = false;
                ScopeInfo scopeInfo5 = this.parentMap.get(currentScope1);
                if (scopeInfo5 == null) {
                    String string = "Required value was null.";
                    throw new IllegalStateException(string.toString());
                }
                currentScope1 = scopeInfo5.getScope();
            }
        } else if (parentDepth2 > parentDepth1) {
            currentScope2 = parentScope2;
            var11_11 = parentDepth2 - parentDepth1 - 1;
            var12_12 = 0;
            while (var12_12 < var11_11) {
                it = var12_12++;
                boolean bl = false;
                ScopeInfo scopeInfo6 = this.parentMap.get(currentScope2);
                if (scopeInfo6 == null) {
                    String string = "Required value was null.";
                    throw new IllegalStateException(string.toString());
                }
                currentScope2 = scopeInfo6.getScope();
            }
        } else {
            if (!(parentDepth1 != 0)) {
                throw new IllegalStateException("Check failed.");
            }
            currentScope1 = parentScope1;
            currentScope2 = parentScope2;
        }
        while (!Intrinsics.areEqual((Object)currentScope1, (Object)currentScope2)) {
            ScopeInfo scopeInfo7 = this.parentMap.get(currentScope1);
            if (scopeInfo7 == null) {
                String string = "Required value was null.";
                throw new IllegalStateException(string.toString());
            }
            currentScope1 = scopeInfo7.getScope();
            ScopeInfo scopeInfo8 = this.parentMap.get(currentScope2);
            if (scopeInfo8 == null) {
                String string = "Required value was null.";
                throw new IllegalStateException(string.toString());
            }
            currentScope2 = scopeInfo8.getScope();
        }
        return currentScope1;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Object object2 = other;
        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type org.rust.lang.core.thir.scopes.ScopeTree");
        ScopeTree cfr_ignored_0 = (ScopeTree)object2;
        if (!Intrinsics.areEqual((Object)this.rootBody, (Object)((ScopeTree)other).rootBody)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.parentMap, ((ScopeTree)other).parentMap)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.varMap, ((ScopeTree)other).varMap)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.destructionScopes, ((ScopeTree)other).destructionScopes)) {
            return false;
        }
        return Intrinsics.areEqual(this.rvalueCandidates, ((ScopeTree)other).rvalueCandidates);
    }

    public int hashCode() {
        RsHir rsHir = this.rootBody;
        int result2 = rsHir != null ? rsHir.hashCode() : 0;
        result2 = 31 * result2 + ((Object)this.parentMap).hashCode();
        result2 = 31 * result2 + ((Object)this.varMap).hashCode();
        result2 = 31 * result2 + ((Object)this.destructionScopes).hashCode();
        result2 = 31 * result2 + ((Object)this.rvalueCandidates).hashCode();
        return result2;
    }
}

