/*
 * Decompiled with CFR 0.152.
 */
package org.rust.lang.core.thir.scopes;

import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.rust.lang.core.psi.RsExpr;
import org.rust.lang.core.psi.RsFieldLookupExpr;
import org.rust.lang.core.psi.RsIndexExpr;
import org.rust.lang.core.psi.RsUnaryExpr;
import org.rust.lang.core.psi.ext.RsExprKt;
import org.rust.lang.core.psi.ext.RsIndexExprKt;
import org.rust.lang.core.psi.ext.UnaryOperator;
import org.rust.lang.core.thir.hir.RsHir;
import org.rust.lang.core.thir.hir.RsHirMap;
import org.rust.lang.core.thir.scopes.RvalueCandidateType;
import org.rust.lang.core.thir.scopes.RvalueScopes;
import org.rust.lang.core.thir.scopes.Scope;
import org.rust.lang.core.thir.scopes.ScopeTree;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a*\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\"\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"resolveRvalueScopes", "Lorg/rust/lang/core/thir/scopes/RvalueScopes;", "scopeTree", "Lorg/rust/lang/core/thir/scopes/ScopeTree;", "hirMap", "Lorg/rust/lang/core/thir/hir/RsHirMap;", "recordRvalueScopeRec", "", "rvalueScopes", "expr", "Lorg/rust/lang/core/thir/hir/RsHir$Expr;", "lifetime", "Lorg/rust/lang/core/thir/scopes/Scope;", "REF_AND_DEREF_OPS", "", "Lorg/rust/lang/core/psi/ext/UnaryOperator;", "intellij.rustrover.core"})
public final class RvalueScopesKt {
    @NotNull
    private static final Set<UnaryOperator> REF_AND_DEREF_OPS;

    @NotNull
    public static final RvalueScopes resolveRvalueScopes(@NotNull ScopeTree scopeTree, @NotNull RsHirMap hirMap) {
        Intrinsics.checkNotNullParameter((Object)scopeTree, (String)"scopeTree");
        Intrinsics.checkNotNullParameter((Object)hirMap, (String)"hirMap");
        RvalueScopes rvalueScopes = new RvalueScopes();
        for (Map.Entry<RsHir.Expr, RvalueCandidateType> entry2 : scopeTree.getRvalueCandidates().entrySet()) {
            RsHir.Expr expr = entry2.getKey();
            RvalueCandidateType candidate = entry2.getValue();
            RvalueScopesKt.recordRvalueScopeRec(rvalueScopes, expr, candidate.getLifetime(), hirMap);
        }
        return rvalueScopes;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final void recordRvalueScopeRec(RvalueScopes rvalueScopes, RsHir.Expr expr, Scope lifetime, RsHirMap hirMap) {
        RsHir.Expr exprVar = expr;
        while (true) {
            RsHir.Expr expr2;
            rvalueScopes.recordRvalueScope(exprVar, lifetime);
            RsHir.Expr expr3 = exprVar;
            if (expr3 instanceof RsHir.Expr.Assign || expr3 instanceof RsHir.Expr.Block || expr3 instanceof RsHir.Expr.FormatMacroArgs || expr3 instanceof RsHir.Expr.PathExpr || expr3 instanceof RsHir.Expr.Binary || expr3 instanceof RsHir.Expr.DropTemps || expr3 instanceof RsHir.Expr.If || expr3 instanceof RsHir.Expr.Break || expr3 instanceof RsHir.Expr.Loop || expr3 instanceof RsHir.Expr.Call || expr3 instanceof RsHir.Expr.Match || expr3 instanceof RsHir.Expr.Return || expr3 instanceof RsHir.Expr.AddrOf || expr3 instanceof RsHir.Expr.Uncontrolled || expr3 instanceof RsHir.Expr.UncontrolledAll) {
                return;
            }
            if (!(expr3 instanceof RsHir.Expr.Delegated)) throw new NoWhenBranchMatchedException();
            Object expr4 = ((RsHir.Expr.Delegated)exprVar).getDelegate();
            if (expr4 instanceof RsIndexExpr) {
                expr2 = hirMap.get(RsIndexExprKt.getContainerExpr((RsIndexExpr)expr4));
            } else if (expr4 instanceof RsUnaryExpr && REF_AND_DEREF_OPS.contains((Object)RsExprKt.getOperatorType((RsUnaryExpr)expr4))) {
                RsExpr rsExpr = ((RsUnaryExpr)expr4).getExpr();
                if (rsExpr == null) {
                    throw new NotImplementedError(null, 1, null);
                }
                expr2 = hirMap.get(rsExpr);
            } else {
                if (!(expr4 instanceof RsFieldLookupExpr)) return;
                RsExpr rsExpr = ((RsFieldLookupExpr)expr4).getReceiver();
                Intrinsics.checkNotNullExpressionValue((Object)rsExpr, (String)"<get-receiver>(...)");
                expr2 = hirMap.get(rsExpr);
            }
            exprVar = expr2;
        }
    }

    static {
        UnaryOperator[] unaryOperatorArray = new UnaryOperator[]{UnaryOperator.REF, UnaryOperator.REF_MUT, UnaryOperator.DEREF};
        REF_AND_DEREF_OPS = SetsKt.setOf((Object[])unaryOperatorArray);
    }
}

