/*
 * Decompiled with CFR 0.152.
 */
package org.rust.lang.core.thir;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.lang.core.mir.MirBuilder;
import org.rust.lang.core.mir.UtilsKt;
import org.rust.lang.core.mir.schemas.MirSpan;
import org.rust.lang.core.psi.RsBlock;
import org.rust.lang.core.psi.RsConstant;
import org.rust.lang.core.psi.RsDebuggerExpressionCodeFragment;
import org.rust.lang.core.psi.RsExpr;
import org.rust.lang.core.psi.RsFunction;
import org.rust.lang.core.psi.RsLambdaExpr;
import org.rust.lang.core.psi.RsPat;
import org.rust.lang.core.psi.RsPatBinding;
import org.rust.lang.core.psi.RsPath;
import org.rust.lang.core.psi.RsRetType;
import org.rust.lang.core.psi.RsSelfParameter;
import org.rust.lang.core.psi.RsStructLiteralField;
import org.rust.lang.core.psi.RsTypeReference;
import org.rust.lang.core.psi.RsValueParameter;
import org.rust.lang.core.psi.RsValueParameterList;
import org.rust.lang.core.psi.ext.RsFunctionKt;
import org.rust.lang.core.psi.ext.RsReferenceElement;
import org.rust.lang.core.psi.ext.RsStructLiteralFieldKt;
import org.rust.lang.core.thir.ImplicitSelfKind;
import org.rust.lang.core.thir.LocalVar;
import org.rust.lang.core.thir.MirrorContext;
import org.rust.lang.core.thir.ThirBindingMode;
import org.rust.lang.core.thir.ThirExpr;
import org.rust.lang.core.thir.ThirParam;
import org.rust.lang.core.thir.ThirPat;
import org.rust.lang.core.types.ExtensionsKt;
import org.rust.lang.core.types.infer.TypeInferenceWalkerKt;
import org.rust.lang.core.types.ty.Mutability;
import org.rust.lang.core.types.ty.Ty;
import org.rust.lang.core.types.ty.TyTuple;
import org.rust.lang.core.types.ty.TyUnknown;
import org.rust.openapiext.PsiKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0018"}, d2={"Lorg/rust/lang/core/thir/Thir;", "", "expr", "Lorg/rust/lang/core/thir/ThirExpr;", "params", "", "Lorg/rust/lang/core/thir/ThirParam;", "<init>", "(Lorg/rust/lang/core/thir/ThirExpr;Ljava/util/List;)V", "getExpr", "()Lorg/rust/lang/core/thir/ThirExpr;", "getParams", "()Ljava/util/List;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "Companion", "intellij.rustrover.core"})
public final class Thir {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ThirExpr expr;
    @NotNull
    private final List<ThirParam> params;

    public Thir(@NotNull ThirExpr expr, @NotNull List<ThirParam> params) {
        Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
        Intrinsics.checkNotNullParameter(params, (String)"params");
        this.expr = expr;
        this.params = params;
    }

    @NotNull
    public final ThirExpr getExpr() {
        return this.expr;
    }

    @NotNull
    public final List<ThirParam> getParams() {
        return this.params;
    }

    @NotNull
    public final ThirExpr component1() {
        return this.expr;
    }

    @NotNull
    public final List<ThirParam> component2() {
        return this.params;
    }

    @NotNull
    public final Thir copy(@NotNull ThirExpr expr, @NotNull List<ThirParam> params) {
        Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
        Intrinsics.checkNotNullParameter(params, (String)"params");
        return new Thir(expr, params);
    }

    public static /* synthetic */ Thir copy$default(Thir thir, ThirExpr thirExpr, List list, int n, Object object) {
        if ((n & 1) != 0) {
            thirExpr = thir.expr;
        }
        if ((n & 2) != 0) {
            list = thir.params;
        }
        return thir.copy(thirExpr, list);
    }

    @NotNull
    public String toString() {
        return "Thir(expr=" + this.expr + ", params=" + this.params + ")";
    }

    public int hashCode() {
        int result2 = this.expr.hashCode();
        result2 = result2 * 31 + ((Object)this.params).hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Thir)) {
            return false;
        }
        Thir thir = (Thir)other;
        if (!Intrinsics.areEqual((Object)this.expr, (Object)thir.expr)) {
            return false;
        }
        return Intrinsics.areEqual(this.params, thir.params);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rJ\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rJ\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rJ\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J \u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0002J&\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00160\u00132\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u001a"}, d2={"Lorg/rust/lang/core/thir/Thir$Companion;", "", "<init>", "()V", "from", "Lorg/rust/lang/core/thir/Thir;", "constant", "Lorg/rust/lang/core/psi/RsConstant;", "mirrorContext", "Lorg/rust/lang/core/thir/MirrorContext;", "function", "Lorg/rust/lang/core/psi/RsFunction;", "buildContext", "Lorg/rust/lang/core/mir/MirBuilder$BuildContext;", "lambda", "Lorg/rust/lang/core/psi/RsLambdaExpr;", "codeFragment", "Lorg/rust/lang/core/psi/RsDebuggerExpressionCodeFragment;", "calculateExternalParams", "", "Lorg/rust/lang/core/psi/RsPatBinding;", "closureEnvParam", "Lorg/rust/lang/core/thir/ThirParam;", "explicitParams", "params", "Lorg/rust/lang/core/psi/RsValueParameterList;", "intellij.rustrover.core"})
    @SourceDebugExtension(value={"SMAP\nThir.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Thir.kt\norg/rust/lang/core/thir/Thir$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 PsiElement.kt\norg/rust/lang/core/psi/ext/PsiElementKt\n+ 4 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,156:1\n1563#2:157\n1634#2,3:158\n1869#2,2:164\n213#3:161\n19#4:162\n1#5:163\n*S KotlinDebug\n*F\n+ 1 Thir.kt\norg/rust/lang/core/thir/Thir$Companion\n*L\n60#1:157\n60#1:158,3\n142#1:164,2\n88#1:161\n98#1:162\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Thir from(@NotNull RsConstant constant, @NotNull MirrorContext mirrorContext) {
            Intrinsics.checkNotNullParameter((Object)constant, (String)"constant");
            Intrinsics.checkNotNullParameter((Object)mirrorContext, (String)"mirrorContext");
            RsExpr rsExpr = constant.getExpr();
            if (rsExpr == null) {
                throw new IllegalStateException("Could not get expression of constant".toString());
            }
            RsExpr body = rsExpr;
            ThirExpr expr = MirrorContext.mirrorExprPublic$default(mirrorContext, body, null, null, 6, null);
            return new Thir(expr, CollectionsKt.emptyList());
        }

        @NotNull
        public final Thir from(@NotNull RsFunction function, @NotNull MirrorContext mirrorContext, @NotNull MirBuilder.BuildContext buildContext) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)function, (String)"function");
            Intrinsics.checkNotNullParameter((Object)mirrorContext, (String)"mirrorContext");
            Intrinsics.checkNotNullParameter((Object)buildContext, (String)"buildContext");
            RsBlock rsBlock = RsFunctionKt.getBlock(function);
            if (rsBlock == null) {
                throw new IllegalStateException("Could not get block of function".toString());
            }
            RsBlock body = rsBlock;
            RsFunction $this$from_u24lambda_u240 = function;
            boolean bl = false;
            RsRetType rsRetType = $this$from_u24lambda_u240.getRetType();
            if (rsRetType == null) {
                object = TyTuple.Companion.getUNIT();
            } else {
                RsRetType retType = rsRetType;
                object = retType.getTypeReference();
                if (object == null || (object = ExtensionsKt.normType((RsTypeReference)object, buildContext.getImplLookup())) == null) {
                    object = TyUnknown.INSTANCE;
                }
            }
            Object normReturnType = object;
            ThirExpr expr = MirrorContext.mirrorBlockPublic$default(mirrorContext, body, (Ty)normReturnType, null, 4, null);
            RsValueParameterList rsValueParameterList = function.getValueParameterList();
            if (rsValueParameterList == null) {
                throw new IllegalStateException("Could not get function's parameters".toString());
            }
            RsValueParameterList paramsList = rsValueParameterList;
            List<ThirParam> params = this.explicitParams(paramsList, mirrorContext, buildContext);
            return new Thir(expr, params);
        }

        @NotNull
        public final Thir from(@NotNull RsLambdaExpr lambda, @NotNull MirrorContext mirrorContext, @NotNull MirBuilder.BuildContext buildContext) {
            Intrinsics.checkNotNullParameter((Object)lambda, (String)"lambda");
            Intrinsics.checkNotNullParameter((Object)mirrorContext, (String)"mirrorContext");
            Intrinsics.checkNotNullParameter((Object)buildContext, (String)"buildContext");
            RsExpr rsExpr = lambda.getExpr();
            if (rsExpr == null) {
                throw new IllegalStateException("Could not get expression of lambda".toString());
            }
            RsExpr body = rsExpr;
            ThirExpr expr = MirrorContext.mirrorExprPublic$default(mirrorContext, body, null, null, 6, null);
            ThirParam closureEnvParam = this.closureEnvParam(lambda, mirrorContext, buildContext);
            RsValueParameterList rsValueParameterList = lambda.getValueParameterList();
            Intrinsics.checkNotNullExpressionValue((Object)rsValueParameterList, (String)"<get-valueParameterList>(...)");
            List<ThirParam> params = this.explicitParams(rsValueParameterList, mirrorContext, buildContext);
            return new Thir(expr, CollectionsKt.plus((Collection)CollectionsKt.listOfNotNull((Object)closureEnvParam), (Iterable)params));
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Thir from(@NotNull RsDebuggerExpressionCodeFragment codeFragment, @NotNull MirrorContext mirrorContext, @NotNull MirBuilder.BuildContext buildContext) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)codeFragment, (String)"codeFragment");
            Intrinsics.checkNotNullParameter((Object)mirrorContext, (String)"mirrorContext");
            Intrinsics.checkNotNullParameter((Object)buildContext, (String)"buildContext");
            RsExpr rsExpr = codeFragment.getExpr();
            if (rsExpr == null) {
                throw new IllegalStateException("Could not get expression".toString());
            }
            ThirExpr expr = MirrorContext.mirrorExprPublic$default(mirrorContext, rsExpr, null, null, 6, null);
            Iterable $this$map$iv = this.calculateExternalParams(codeFragment);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                RsPatBinding rsPatBinding = (RsPatBinding)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Ty ty2 = buildContext.getInference().getBindingType((RsPatBinding)it2);
                String string = it2.getName();
                if (string == null) {
                    throw new IllegalStateException("Could not get name of parameter".toString());
                }
                collection.add(new ThirParam(new ThirPat.Binding(Mutability.MUTABLE, string, ThirBindingMode.ByValue.INSTANCE, LocalVar.Companion.invoke(buildContext.getHirMap().get((RsPatBinding)it2)), ty2, null, true, ty2, UtilsKt.getAsSpan((PsiElement)it2)), ty2, null, null));
            }
            List params = (List)destination$iv$iv;
            return new Thir(expr, params);
        }

        private final List<RsPatBinding> calculateExternalParams(RsDebuggerExpressionCodeFragment codeFragment) {
            List list;
            RsExpr rsExpr = codeFragment.getExpr();
            if (rsExpr == null) {
                return CollectionsKt.emptyList();
            }
            RsExpr expr = rsExpr;
            PsiElement $this$descendantsWithMacrosOfType$iv = expr;
            boolean $i$f$descendantsWithMacrosOfType = false;
            Class[] classArray = new Class[]{RsPatBinding.class};
            Set locals = CollectionsKt.toSet((Iterable)PsiKt.findDescendantsWithMacrosOfAnyType($this$descendantsWithMacrosOfType$iv, true, classArray));
            List $this$calculateExternalParams_u24lambda_u240 = list = CollectionsKt.createListBuilder();
            boolean bl = false;
            Class[] classArray2 = new Class[]{RsPath.class, RsStructLiteralField.class};
            Collection<RsReferenceElement> descendants = PsiKt.findDescendantsWithMacrosOfAnyType(expr, true, classArray2);
            for (RsReferenceElement descendant : descendants) {
                RsPatBinding binding;
                RsPatBinding rsPatBinding;
                RsReferenceElement rsReferenceElement = descendant;
                if (rsReferenceElement instanceof RsPath) {
                    Object object = ((RsPath)descendant).getReference();
                    if (object != null && (object = object.resolve()) != null) {
                        Object $this$asSafely$iv = object;
                        boolean $i$f$asSafely = false;
                        Object object2 = $this$asSafely$iv;
                        if (!(object2 instanceof RsPatBinding)) {
                            object2 = null;
                        }
                        rsPatBinding = (RsPatBinding)object2;
                    } else {
                        rsPatBinding = null;
                    }
                } else {
                    rsPatBinding = rsReferenceElement instanceof RsStructLiteralField && RsStructLiteralFieldKt.isShorthand((RsStructLiteralField)descendant) ? RsStructLiteralFieldKt.resolveToBinding((RsStructLiteralField)descendant) : null;
                }
                if ((binding = rsPatBinding) == null || locals.contains(binding)) continue;
                $this$calculateExternalParams_u24lambda_u240.add(binding);
            }
            return CollectionsKt.build((List)list);
        }

        private final ThirParam closureEnvParam(RsLambdaExpr lambda, MirrorContext mirrorContext, MirBuilder.BuildContext buildContext) {
            return new ThirParam(null, buildContext.getInference().getExprType(lambda), null, null);
        }

        private final List<ThirParam> explicitParams(RsValueParameterList params, MirrorContext mirrorContext, MirBuilder.BuildContext buildContext) {
            List list;
            List $this$explicitParams_u24lambda_u240 = list = CollectionsKt.createListBuilder();
            boolean bl = false;
            RsSelfParameter self = params.getSelfParameter();
            if (self != null) {
                Object object;
                ImplicitSelfKind selfKind;
                ImplicitSelfKind implicitSelfKind;
                ImplicitSelfKind it2 = implicitSelfKind = ImplicitSelfKind.Companion.from(self);
                boolean bl2 = false;
                ImplicitSelfKind implicitSelfKind2 = selfKind = it2.getHasImplicitSelf() ? implicitSelfKind : null;
                if (self.getColon() != null) {
                    object = self.getTypeReference();
                    if (object == null || (object = UtilsKt.getAsSpan((PsiElement)object)) == null) {
                        throw new IllegalStateException("Could not get self parameter's type".toString());
                    }
                } else {
                    object = null;
                }
                RsTypeReference tySpan = object;
                ThirParam thirParam = new ThirParam(mirrorContext.newPatContext().from(self), TypeInferenceWalkerKt.getTypeOfValue(self), (MirSpan)((Object)tySpan), selfKind);
                $this$explicitParams_u24lambda_u240.add(thirParam);
            }
            List<RsValueParameter> list2 = params.getValueParameterList();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"getValueParameterList(...)");
            Iterable $this$forEach$iv = list2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                RsPat pat;
                MirSpan tySpan;
                RsValueParameter param = (RsValueParameter)element$iv;
                boolean bl3 = false;
                RsTypeReference rsTypeReference = param.getTypeReference();
                MirSpan mirSpan = tySpan = rsTypeReference != null ? UtilsKt.getAsSpan(rsTypeReference) : null;
                if (param.getPat() == null) {
                    throw new IllegalStateException("Could not extract pat from parameter".toString());
                }
                ThirParam thirParam = new ThirParam(mirrorContext.newPatContext().from(pat), buildContext.getInference().getPatType(pat), tySpan, null);
                $this$explicitParams_u24lambda_u240.add(thirParam);
            }
            return CollectionsKt.build((List)list);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

