/*
 * Decompiled with CFR 0.152.
 */
package org.rust.lang.core.stubs;

import com.intellij.lang.ASTNode;
import com.intellij.lang.FileASTNode;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.StringRef;
import java.io.DataInput;
import java.io.DataOutput;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.rust.lang.core.psi.RsElementTypes;
import org.rust.lang.core.psi.RsTokenTypeKt;
import org.rust.lang.core.stubs.ItemSeekingVisitor;
import org.rust.lang.core.stubs.RsAliasStub;
import org.rust.lang.core.stubs.RsArrayTypeStub;
import org.rust.lang.core.stubs.RsBinaryOpStub;
import org.rust.lang.core.stubs.RsBlockExprStub;
import org.rust.lang.core.stubs.RsBlockStubType;
import org.rust.lang.core.stubs.RsConstParameterStub;
import org.rust.lang.core.stubs.RsConstantStub;
import org.rust.lang.core.stubs.RsEmptyItemStub;
import org.rust.lang.core.stubs.RsEmptyStmtType;
import org.rust.lang.core.stubs.RsEnumItemStub;
import org.rust.lang.core.stubs.RsEnumVariantStub;
import org.rust.lang.core.stubs.RsExprStmtStub;
import org.rust.lang.core.stubs.RsExprStubType;
import org.rust.lang.core.stubs.RsExternCrateItemStub;
import org.rust.lang.core.stubs.RsFnPointerTypeStub;
import org.rust.lang.core.stubs.RsForeignModStub;
import org.rust.lang.core.stubs.RsFunctionStub;
import org.rust.lang.core.stubs.RsImplItemStub;
import org.rust.lang.core.stubs.RsInnerAttrStub;
import org.rust.lang.core.stubs.RsLetDeclStub;
import org.rust.lang.core.stubs.RsLifetimeParameterStub;
import org.rust.lang.core.stubs.RsLifetimeStub;
import org.rust.lang.core.stubs.RsLitExprStub;
import org.rust.lang.core.stubs.RsMacro2Stub;
import org.rust.lang.core.stubs.RsMacroCallStub;
import org.rust.lang.core.stubs.RsMacroStub;
import org.rust.lang.core.stubs.RsMacroTypeStub;
import org.rust.lang.core.stubs.RsMatchArmStubType;
import org.rust.lang.core.stubs.RsMetaItemArgsStub;
import org.rust.lang.core.stubs.RsMetaItemStub;
import org.rust.lang.core.stubs.RsModDeclItemStub;
import org.rust.lang.core.stubs.RsModItemStub;
import org.rust.lang.core.stubs.RsNamedFieldDeclStub;
import org.rust.lang.core.stubs.RsNeverTypeStub;
import org.rust.lang.core.stubs.RsOuterAttributeOwnerStubType;
import org.rust.lang.core.stubs.RsParenTypeStub;
import org.rust.lang.core.stubs.RsPathStub;
import org.rust.lang.core.stubs.RsPathTypeStub;
import org.rust.lang.core.stubs.RsPlaceholderStub;
import org.rust.lang.core.stubs.RsPolyboundStub;
import org.rust.lang.core.stubs.RsRefLikeTypeStub;
import org.rust.lang.core.stubs.RsSelfParameterStub;
import org.rust.lang.core.stubs.RsStructItemStub;
import org.rust.lang.core.stubs.RsStubElementType;
import org.rust.lang.core.stubs.RsStubElementTypeKt;
import org.rust.lang.core.stubs.RsStubLiteralKind;
import org.rust.lang.core.stubs.RsTraitAliasStub;
import org.rust.lang.core.stubs.RsTraitItemStub;
import org.rust.lang.core.stubs.RsTraitRefStub;
import org.rust.lang.core.stubs.RsTraitTypeStub;
import org.rust.lang.core.stubs.RsTupleTypeStub;
import org.rust.lang.core.stubs.RsTypeAliasStub;
import org.rust.lang.core.stubs.RsTypeParameterListStub;
import org.rust.lang.core.stubs.RsTypeParameterStub;
import org.rust.lang.core.stubs.RsUnaryExprStub;
import org.rust.lang.core.stubs.RsUnitTypeStub;
import org.rust.lang.core.stubs.RsUseItemStub;
import org.rust.lang.core.stubs.RsUseSpeckStub;
import org.rust.lang.core.stubs.RsValueParameterStub;
import org.rust.lang.core.stubs.RsVisStub;
import org.rust.lang.core.stubs.StubImplementationsKt;
import org.rust.lang.core.types.ty.TyFloat;
import org.rust.lang.core.types.ty.TyInteger;
import org.rust.openapiext.AstKt;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000D\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0004\u001a\u0016\u0010\u0000\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\f\u0010\t\u001a\u00020\u0005*\u00020\u0007H\u0002\u001a\u0016\u0010\n\u001a\u00020\u000b*\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u001a\u000e\u0010\u000f\u001a\u0004\u0018\u00010\u0003*\u00020\u0010H\u0002\u001a\u000e\u0010\u0011\u001a\u0004\u0018\u00010\u0003*\u00020\u0010H\u0002\u001a\u0016\u0010\u0012\u001a\u00020\u000b*\u00020\u000e2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0003H\u0002\u001a\u001b\u0010\u0014\u001a\u00020\u000b*\u00020\u000e2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0015H\u0002\u00a2\u0006\u0002\u0010\u0016\u001a\u0013\u0010\u0017\u001a\u0004\u0018\u00010\u0015*\u00020\u0010H\u0002\u00a2\u0006\u0002\u0010\u0018\u001a\u001b\u0010\u0019\u001a\u00020\u000b*\u00020\u000e2\b\u0010\u0013\u001a\u0004\u0018\u00010\u001aH\u0002\u00a2\u0006\u0002\u0010\u001b\u001a\u0013\u0010\u001c\u001a\u0004\u0018\u00010\u001a*\u00020\u0010H\u0002\u00a2\u0006\u0002\u0010\u001d\u00a8\u0006\u001e"}, d2={"factory", "Lorg/rust/lang/core/stubs/RsStubElementType;", "name", "", "shouldCreateExprStub", "", "node", "Lcom/intellij/lang/ASTNode;", "shouldCreateStmtStub", "isFunctionBody", "serialize", "", "Lorg/rust/lang/core/stubs/RsStubLiteralKind;", "dataStream", "Lcom/intellij/psi/stubs/StubOutputStream;", "readNameAsString", "Lcom/intellij/psi/stubs/StubInputStream;", "readUTFFastAsNullable", "writeUTFFastAsNullable", "value", "writeLongAsNullable", "", "(Lcom/intellij/psi/stubs/StubOutputStream;Ljava/lang/Long;)V", "readLongAsNullable", "(Lcom/intellij/psi/stubs/StubInputStream;)Ljava/lang/Long;", "writeDoubleAsNullable", "", "(Lcom/intellij/psi/stubs/StubOutputStream;Ljava/lang/Double;)V", "readDoubleAsNullable", "(Lcom/intellij/psi/stubs/StubInputStream;)Ljava/lang/Double;", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nStubImplementations.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StubImplementations.kt\norg/rust/lang/core/stubs/StubImplementationsKt\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,2498:1\n183#2,2:2499\n*S KotlinDebug\n*F\n+ 1 StubImplementations.kt\norg/rust/lang/core/stubs/StubImplementationsKt\n*L\n2334#1:2499,2\n*E\n"})
public final class StubImplementationsKt {
    @NotNull
    public static final RsStubElementType<?, ?> factory(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        return switch (name2) {
            case "EXTERN_CRATE_ITEM" -> RsExternCrateItemStub.Type.INSTANCE;
            case "USE_ITEM" -> RsUseItemStub.Type.INSTANCE;
            case "STRUCT_ITEM" -> RsStructItemStub.Type.INSTANCE;
            case "ENUM_ITEM" -> RsEnumItemStub.Type.INSTANCE;
            case "ENUM_BODY" -> new RsPlaceholderStub.Type("ENUM_BODY", factory.1.INSTANCE);
            case "ENUM_VARIANT" -> RsEnumVariantStub.Type.INSTANCE;
            case "MOD_DECL_ITEM" -> RsModDeclItemStub.Type.INSTANCE;
            case "MOD_ITEM" -> RsModItemStub.Type.INSTANCE;
            case "TRAIT_ITEM" -> RsTraitItemStub.Type.INSTANCE;
            case "IMPL_ITEM" -> RsImplItemStub.Type.INSTANCE;
            case "MEMBERS" -> new RsPlaceholderStub.Type("MEMBERS", factory.2.INSTANCE);
            case "TRAIT_ALIAS" -> RsTraitAliasStub.Type.INSTANCE;
            case "TRAIT_ALIAS_BOUNDS" -> new RsPlaceholderStub.Type("TRAIT_ALIAS_BOUNDS", factory.3.INSTANCE);
            case "EMPTY_ITEM" -> RsEmptyItemStub.Type.INSTANCE;
            case "FUNCTION" -> RsFunctionStub.Type.INSTANCE;
            case "CONSTANT" -> RsConstantStub.Type.INSTANCE;
            case "TYPE_ALIAS" -> RsTypeAliasStub.Type.INSTANCE;
            case "FOREIGN_MOD_ITEM" -> RsForeignModStub.Type.INSTANCE;
            case "BLOCK_FIELDS" -> new RsPlaceholderStub.Type("BLOCK_FIELDS", factory.4.INSTANCE);
            case "TUPLE_FIELDS" -> new RsPlaceholderStub.Type("TUPLE_FIELDS", factory.5.INSTANCE);
            case "TUPLE_FIELD_DECL" -> new RsPlaceholderStub.Type("TUPLE_FIELD_DECL", factory.6.INSTANCE);
            case "NAMED_FIELD_DECL" -> RsNamedFieldDeclStub.Type.INSTANCE;
            case "ALIAS" -> RsAliasStub.Type.INSTANCE;
            case "USE_SPECK" -> RsUseSpeckStub.Type.INSTANCE;
            case "USE_GROUP" -> new RsPlaceholderStub.Type("USE_GROUP", factory.7.INSTANCE);
            case "PATH" -> RsPathStub.Type.INSTANCE;
            case "TYPE_QUAL" -> new RsPlaceholderStub.Type("TYPE_QUAL", factory.8.INSTANCE);
            case "TRAIT_REF" -> RsTraitRefStub.Type.INSTANCE;
            case "TYPE_REFERENCE" -> new RsPlaceholderStub.Type("TYPE_REFERENCE", factory.9.INSTANCE);
            case "ARRAY_TYPE" -> RsArrayTypeStub.Type.INSTANCE;
            case "REF_LIKE_TYPE" -> RsRefLikeTypeStub.Type.INSTANCE;
            case "FN_POINTER_TYPE" -> RsFnPointerTypeStub.Type.INSTANCE;
            case "TUPLE_TYPE" -> RsTupleTypeStub.Type.INSTANCE;
            case "PAREN_TYPE" -> RsParenTypeStub.Type.INSTANCE;
            case "UNIT_TYPE" -> RsUnitTypeStub.Type.INSTANCE;
            case "NEVER_TYPE" -> RsNeverTypeStub.Type.INSTANCE;
            case "INFER_TYPE" -> new RsPlaceholderStub.Type("INFER_TYPE", factory.10.INSTANCE);
            case "PATH_TYPE" -> RsPathTypeStub.Type.INSTANCE;
            case "FOR_IN_TYPE" -> new RsPlaceholderStub.Type("FOR_IN_TYPE", factory.11.INSTANCE);
            case "TRAIT_TYPE" -> RsTraitTypeStub.Type.INSTANCE;
            case "MACRO_TYPE" -> RsMacroTypeStub.Type.INSTANCE;
            case "VALUE_PARAMETER_LIST" -> new RsPlaceholderStub.Type("VALUE_PARAMETER_LIST", factory.12.INSTANCE);
            case "VALUE_PARAMETER" -> RsValueParameterStub.Type.INSTANCE;
            case "SELF_PARAMETER" -> RsSelfParameterStub.Type.INSTANCE;
            case "VARIADIC" -> new RsPlaceholderStub.Type("VARIADIC", factory.13.INSTANCE);
            case "TYPE_PARAMETER_LIST" -> RsTypeParameterListStub.Type.INSTANCE;
            case "TYPE_PARAMETER" -> RsTypeParameterStub.Type.INSTANCE;
            case "CONST_PARAMETER" -> RsConstParameterStub.Type.INSTANCE;
            case "LIFETIME" -> RsLifetimeStub.Type.INSTANCE;
            case "LIFETIME_PARAMETER" -> RsLifetimeParameterStub.Type.INSTANCE;
            case "FOR_LIFETIMES" -> new RsPlaceholderStub.Type("FOR_LIFETIMES", factory.14.INSTANCE);
            case "TYPE_ARGUMENT_LIST" -> new RsPlaceholderStub.Type("TYPE_ARGUMENT_LIST", factory.15.INSTANCE);
            case "ASSOC_TYPE_BINDING" -> new RsPlaceholderStub.Type("ASSOC_TYPE_BINDING", factory.16.INSTANCE);
            case "TYPE_PARAM_BOUNDS" -> new RsPlaceholderStub.Type("TYPE_PARAM_BOUNDS", factory.17.INSTANCE);
            case "POLYBOUND" -> RsPolyboundStub.Type.INSTANCE;
            case "BOUND" -> new RsPlaceholderStub.Type("BOUND", factory.18.INSTANCE);
            case "WHERE_CLAUSE" -> new RsPlaceholderStub.Type("WHERE_CLAUSE", factory.19.INSTANCE);
            case "WHERE_PRED" -> new RsPlaceholderStub.Type("WHERE_PRED", factory.20.INSTANCE);
            case "RET_TYPE" -> new RsPlaceholderStub.Type("RET_TYPE", factory.21.INSTANCE);
            case "MACRO" -> RsMacroStub.Type.INSTANCE;
            case "MACRO_2" -> RsMacro2Stub.Type.INSTANCE;
            case "MACRO_CALL" -> RsMacroCallStub.Type.INSTANCE;
            case "INCLUDE_MACRO_ARGUMENT" -> new RsPlaceholderStub.Type("INCLUDE_MACRO_ARGUMENT", factory.22.INSTANCE);
            case "CONCAT_MACRO_ARGUMENT" -> new RsPlaceholderStub.Type("CONCAT_MACRO_ARGUMENT", factory.23.INSTANCE);
            case "ENV_MACRO_ARGUMENT" -> new RsPlaceholderStub.Type("ENV_MACRO_ARGUMENT", factory.24.INSTANCE);
            case "INNER_ATTR" -> RsInnerAttrStub.Type.INSTANCE;
            case "OUTER_ATTR" -> new RsPlaceholderStub.Type("OUTER_ATTR", factory.25.INSTANCE);
            case "META_ITEM" -> RsMetaItemStub.Type.INSTANCE;
            case "META_ITEM_ARGS" -> RsMetaItemArgsStub.Type.INSTANCE;
            case "BLOCK" -> RsBlockStubType.INSTANCE;
            case "BINARY_OP" -> RsBinaryOpStub.Type.INSTANCE;
            case "EXPR_STMT" -> RsExprStmtStub.Type.INSTANCE;
            case "LET_DECL" -> RsLetDeclStub.Type.INSTANCE;
            case "EMPTY_STMT" -> RsEmptyStmtType.INSTANCE;
            case "ARRAY_EXPR" -> new RsExprStubType("ARRAY_EXPR", factory.26.INSTANCE);
            case "BINARY_EXPR" -> new RsExprStubType("BINARY_EXPR", factory.27.INSTANCE);
            case "BLOCK_EXPR" -> RsBlockExprStub.Type.INSTANCE;
            case "BREAK_EXPR" -> new RsExprStubType("BREAK_EXPR", factory.28.INSTANCE);
            case "CALL_EXPR" -> new RsExprStubType("CALL_EXPR", factory.29.INSTANCE);
            case "CAST_EXPR" -> new RsExprStubType("CAST_EXPR", factory.30.INSTANCE);
            case "CONT_EXPR" -> new RsExprStubType("CONT_EXPR", factory.31.INSTANCE);
            case "FIELD_LOOKUP_EXPR" -> new RsExprStubType("FIELD_LOOKUP_EXPR", factory.32.INSTANCE);
            case "METHOD_CALL_EXPR" -> new RsExprStubType("METHOD_CALL_EXPR", factory.33.INSTANCE);
            case "EMPTY_DOT_EXPR" -> new RsExprStubType("EMPTY_DOT_EXPR", factory.34.INSTANCE);
            case "FOR_EXPR" -> new RsExprStubType("FOR_EXPR", factory.35.INSTANCE);
            case "IF_EXPR" -> new RsExprStubType("IF_EXPR", factory.36.INSTANCE);
            case "LET_EXPR" -> new RsExprStubType("LET_EXPR", factory.37.INSTANCE);
            case "INDEX_EXPR" -> new RsExprStubType("INDEX_EXPR", factory.38.INSTANCE);
            case "LAMBDA_EXPR" -> new RsExprStubType("LAMBDA_EXPR", factory.39.INSTANCE);
            case "LIT_EXPR" -> RsLitExprStub.Type.INSTANCE;
            case "LOOP_EXPR" -> new RsExprStubType("LOOP_EXPR", factory.40.INSTANCE);
            case "MACRO_EXPR" -> new RsExprStubType("MACRO_EXPR", factory.41.INSTANCE);
            case "CLASSIC_MATCH_EXPR" -> new RsExprStubType("CLASSIC_MATCH_EXPR", factory.42.INSTANCE);
            case "POSTFIX_MATCH_EXPR" -> new RsExprStubType("POSTFIX_MATCH_EXPR", factory.43.INSTANCE);
            case "PAREN_EXPR" -> new RsExprStubType("PAREN_EXPR", factory.44.INSTANCE);
            case "PATH_EXPR" -> new RsExprStubType("PATH_EXPR", factory.45.INSTANCE);
            case "RANGE_EXPR" -> new RsExprStubType("RANGE_EXPR", factory.46.INSTANCE);
            case "RET_EXPR" -> new RsExprStubType("RET_EXPR", factory.47.INSTANCE);
            case "YIELD_EXPR" -> new RsExprStubType("YIELD_EXPR", factory.48.INSTANCE);
            case "STRUCT_LITERAL" -> new RsExprStubType("STRUCT_LITERAL", factory.49.INSTANCE);
            case "TRY_EXPR" -> new RsExprStubType("TRY_EXPR", factory.50.INSTANCE);
            case "TUPLE_EXPR" -> new RsExprStubType("TUPLE_EXPR", factory.51.INSTANCE);
            case "UNARY_EXPR" -> RsUnaryExprStub.Type.INSTANCE;
            case "UNIT_EXPR" -> new RsExprStubType("UNIT_EXPR", factory.52.INSTANCE);
            case "WHILE_EXPR" -> new RsExprStubType("WHILE_EXPR", factory.53.INSTANCE);
            case "UNDERSCORE_EXPR" -> new RsExprStubType("UNDERSCORE_EXPR", factory.54.INSTANCE);
            case "PREFIX_INC_EXPR" -> new RsExprStubType("PREFIX_INC_EXPR", factory.55.INSTANCE);
            case "POSTFIX_INC_EXPR" -> new RsExprStubType("POSTFIX_INC_EXPR", factory.56.INSTANCE);
            case "POSTFIX_DEC_EXPR" -> new RsExprStubType("POSTFIX_DEC_EXPR", factory.57.INSTANCE);
            case "INC" -> new RsPlaceholderStub.Type("INC", factory.58.INSTANCE);
            case "DEC" -> new RsPlaceholderStub.Type("DEC", factory.59.INSTANCE);
            case "VIS" -> RsVisStub.Type.INSTANCE;
            case "VIS_RESTRICTION" -> new RsPlaceholderStub.Type("VIS_RESTRICTION", factory.60.INSTANCE);
            case "DEFAULT_PARAMETER_VALUE" -> new RsPlaceholderStub.Type("DEFAULT_PARAMETER_VALUE", factory.61.INSTANCE);
            case "OUTER_ATTRIBUTED_EXPR" -> RsOuterAttributeOwnerStubType.INSTANCE;
            case "MATCH_ARM" -> RsMatchArmStubType.INSTANCE;
            default -> throw new IllegalStateException(("Unknown element " + name2).toString());
        };
    }

    private static final boolean shouldCreateExprStub(ASTNode node) {
        Object v1;
        block1: {
            Sequence<ASTNode> $this$firstOrNull$iv = AstKt.getAncestors(node);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                ASTNode it2 = (ASTNode)element$iv;
                boolean bl = false;
                ASTNode parent2 = it2.getTreeParent();
                ASTNode aSTNode = parent2;
                if (!(RsTokenTypeKt.getRS_ITEMS().contains((IElementType)(aSTNode != null ? aSTNode.getElementType() : null)) || parent2 instanceof FileASTNode)) continue;
                v1 = element$iv;
                break block1;
            }
            v1 = null;
        }
        ASTNode element = v1;
        return element != null && !StubImplementationsKt.isFunctionBody(element) && RsStubElementTypeKt.createStubIfParentIsStub(node);
    }

    private static final boolean shouldCreateStmtStub(ASTNode node) {
        return StubImplementationsKt.shouldCreateExprStub(node) || node.findChildByType(RsElementTypes.OUTER_ATTR) != null && ItemSeekingVisitor.Companion.containsItems(node);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isFunctionBody(ASTNode $this$isFunctionBody) {
        if (!Intrinsics.areEqual((Object)$this$isFunctionBody.getElementType(), (Object)RsElementTypes.BLOCK)) return false;
        ASTNode aSTNode = $this$isFunctionBody.getTreeParent();
        if (!Intrinsics.areEqual((Object)(aSTNode != null ? aSTNode.getElementType() : null), (Object)RsElementTypes.FUNCTION)) return false;
        return true;
    }

    private static final void serialize(RsStubLiteralKind $this$serialize, StubOutputStream dataStream) {
        if ($this$serialize == null) {
            dataStream.writeByte(-1);
            return;
        }
        dataStream.writeByte($this$serialize.getKindOrdinal());
        RsStubLiteralKind rsStubLiteralKind = $this$serialize;
        if (rsStubLiteralKind instanceof RsStubLiteralKind.Boolean) {
            dataStream.writeBoolean(((RsStubLiteralKind.Boolean)$this$serialize).getValue());
        } else if (rsStubLiteralKind instanceof RsStubLiteralKind.Char) {
            StubImplementationsKt.writeUTFFastAsNullable(dataStream, ((RsStubLiteralKind.Char)$this$serialize).getValue());
            dataStream.writeBoolean(((RsStubLiteralKind.Char)$this$serialize).isByte());
        } else if (rsStubLiteralKind instanceof RsStubLiteralKind.String) {
            StubImplementationsKt.writeUTFFastAsNullable(dataStream, ((RsStubLiteralKind.String)$this$serialize).getValue());
            dataStream.writeBoolean(((RsStubLiteralKind.String)$this$serialize).isByte());
            dataStream.writeBoolean(((RsStubLiteralKind.String)$this$serialize).isCStr());
        } else if (rsStubLiteralKind instanceof RsStubLiteralKind.Integer) {
            StubImplementationsKt.writeLongAsNullable(dataStream, ((RsStubLiteralKind.Integer)$this$serialize).getValue());
            TyInteger tyInteger = ((RsStubLiteralKind.Integer)$this$serialize).getTy();
            dataStream.writeByte(tyInteger != null ? tyInteger.getOrdinal() : -1);
        } else if (rsStubLiteralKind instanceof RsStubLiteralKind.Float) {
            StubImplementationsKt.writeDoubleAsNullable(dataStream, ((RsStubLiteralKind.Float)$this$serialize).getValue());
            TyFloat tyFloat = ((RsStubLiteralKind.Float)$this$serialize).getTy();
            dataStream.writeByte(tyFloat != null ? tyFloat.getOrdinal() : -1);
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    private static final String readNameAsString(StubInputStream $this$readNameAsString) {
        StringRef stringRef = $this$readNameAsString.readName();
        return stringRef != null ? stringRef.getString() : null;
    }

    private static final String readUTFFastAsNullable(StubInputStream $this$readUTFFastAsNullable) {
        return (String)DataInputOutputUtil.readNullable((DataInput)((DataInput)$this$readUTFFastAsNullable), () -> ((StubInputStream)$this$readUTFFastAsNullable).readUTFFast());
    }

    private static final void writeUTFFastAsNullable(StubOutputStream $this$writeUTFFastAsNullable, String value) {
        DataInputOutputUtil.writeNullable((DataOutput)((DataOutput)$this$writeUTFFastAsNullable), (Object)value, arg_0 -> StubImplementationsKt.writeUTFFastAsNullable$lambda$0((Function1)new Function1<String, Unit>((Object)$this$writeUTFFastAsNullable){

            public final void invoke(String p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                ((StubOutputStream)this.receiver).writeUTFFast(p0);
            }
        }, arg_0));
    }

    private static final void writeLongAsNullable(StubOutputStream $this$writeLongAsNullable, Long value) {
        DataInputOutputUtil.writeNullable((DataOutput)((DataOutput)$this$writeLongAsNullable), (Object)value, arg_0 -> StubImplementationsKt.writeLongAsNullable$lambda$0((Function1)new Function1<Long, Unit>((Object)$this$writeLongAsNullable){

            public final void invoke(long p0) {
                ((StubOutputStream)this.receiver).writeLong(p0);
            }
        }, arg_0));
    }

    private static final Long readLongAsNullable(StubInputStream $this$readLongAsNullable) {
        return (Long)DataInputOutputUtil.readNullable((DataInput)((DataInput)$this$readLongAsNullable), () -> $this$readLongAsNullable.readLong());
    }

    private static final void writeDoubleAsNullable(StubOutputStream $this$writeDoubleAsNullable, Double value) {
        DataInputOutputUtil.writeNullable((DataOutput)((DataOutput)$this$writeDoubleAsNullable), (Object)value, arg_0 -> StubImplementationsKt.writeDoubleAsNullable$lambda$0((Function1)new Function1<Double, Unit>((Object)$this$writeDoubleAsNullable){

            public final void invoke(double p0) {
                ((StubOutputStream)this.receiver).writeDouble(p0);
            }
        }, arg_0));
    }

    private static final Double readDoubleAsNullable(StubInputStream $this$readDoubleAsNullable) {
        return (Double)DataInputOutputUtil.readNullable((DataInput)((DataInput)$this$readDoubleAsNullable), () -> $this$readDoubleAsNullable.readDouble());
    }

    private static final void writeUTFFastAsNullable$lambda$0(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void writeLongAsNullable$lambda$0(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void writeDoubleAsNullable$lambda$0(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ String access$readNameAsString(StubInputStream $receiver) {
        return StubImplementationsKt.readNameAsString($receiver);
    }

    public static final /* synthetic */ String access$readUTFFastAsNullable(StubInputStream $receiver) {
        return StubImplementationsKt.readUTFFastAsNullable($receiver);
    }

    public static final /* synthetic */ void access$writeUTFFastAsNullable(StubOutputStream $receiver, String value) {
        StubImplementationsKt.writeUTFFastAsNullable($receiver, value);
    }

    public static final /* synthetic */ boolean access$isFunctionBody(ASTNode $receiver) {
        return StubImplementationsKt.isFunctionBody($receiver);
    }

    public static final /* synthetic */ boolean access$shouldCreateStmtStub(ASTNode node) {
        return StubImplementationsKt.shouldCreateStmtStub(node);
    }

    public static final /* synthetic */ boolean access$shouldCreateExprStub(ASTNode node) {
        return StubImplementationsKt.shouldCreateExprStub(node);
    }

    public static final /* synthetic */ void access$serialize(RsStubLiteralKind $receiver, StubOutputStream dataStream) {
        StubImplementationsKt.serialize($receiver, dataStream);
    }

    public static final /* synthetic */ Long access$readLongAsNullable(StubInputStream $receiver) {
        return StubImplementationsKt.readLongAsNullable($receiver);
    }

    public static final /* synthetic */ Double access$readDoubleAsNullable(StubInputStream $receiver) {
        return StubImplementationsKt.readDoubleAsNullable($receiver);
    }
}

