/*
 * Decompiled with CFR 0.152.
 */
package org.rust.lang.core.stubs;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.psi.PsiFile;
import com.intellij.psi.StubBuilder;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.stubs.DefaultStubBuilder;
import com.intellij.psi.stubs.PsiFileStubImpl;
import com.intellij.psi.stubs.StubBase;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IStubFileElementType;
import com.intellij.util.BitUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.lang.RsLanguage;
import org.rust.lang.core.psi.RsElementTypes;
import org.rust.lang.core.psi.RsFile;
import org.rust.lang.core.psi.RsReplCodeFragment;
import org.rust.lang.core.psi.RsTokenTypeKt;
import org.rust.lang.core.psi.ext.RsDocAndAttributeOwner;
import org.rust.lang.core.psi.ext.RsInnerAttributeOwnerRegistry;
import org.rust.lang.core.stubs.BlockMayHaveStubsHeuristic;
import org.rust.lang.core.stubs.RsAttributeOwnerStub;
import org.rust.lang.core.stubs.RsMetaItemStub;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0002$%B\u0019\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\"\u001a\u00020#H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\fR\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\fR\u0014\u0010\u0016\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\fR\u0014\u0010\u0018\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\fR\u0011\u0010\u001a\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\fR\u0014\u0010\u001c\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\fR\u0014\u0010\u001e\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\fR\u0014\u0010 \u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\f\u00a8\u0006&"}, d2={"Lorg/rust/lang/core/stubs/RsFileStub;", "Lcom/intellij/psi/stubs/PsiFileStubImpl;", "Lorg/rust/lang/core/psi/RsFile;", "Lorg/rust/lang/core/stubs/RsAttributeOwnerStub;", "file", "flags", "", "<init>", "(Lorg/rust/lang/core/psi/RsFile;I)V", "mayHaveStdlibAttributes", "", "getMayHaveStdlibAttributes", "()Z", "mayHaveRecursionLimitAttribute", "getMayHaveRecursionLimitAttribute", "rawMetaItems", "Lkotlin/sequences/Sequence;", "Lorg/rust/lang/core/stubs/RsMetaItemStub;", "getRawMetaItems", "()Lkotlin/sequences/Sequence;", "hasAttrs", "getHasAttrs", "mayHaveCfg", "getMayHaveCfg", "hasCfgAttr", "getHasCfgAttr", "mayHaveMacroUse", "getMayHaveMacroUse", "mayHaveCustomDerive", "getMayHaveCustomDerive", "mayHaveCustomAttrs", "getMayHaveCustomAttrs", "mayHaveDocHidden", "getMayHaveDocHidden", "getType", "Lorg/rust/lang/core/stubs/RsFileStub$Type;", "RsStubFileElementType", "Type", "intellij.rustrover.core"})
public final class RsFileStub
extends PsiFileStubImpl<RsFile>
implements RsAttributeOwnerStub {
    private final int flags;

    public RsFileStub(@Nullable RsFile file, int flags) {
        super((PsiFile)file);
        this.flags = flags;
    }

    public final boolean getMayHaveStdlibAttributes() {
        return BitUtil.isSet((int)this.flags, (int)RsAttributeOwnerStub.FileStubAttrFlags.INSTANCE.getMAY_HAVE_STDLIB_ATTRIBUTES());
    }

    public final boolean getMayHaveRecursionLimitAttribute() {
        return BitUtil.isSet((int)this.flags, (int)RsAttributeOwnerStub.FileStubAttrFlags.INSTANCE.getMAY_HAVE_RECURSION_LIMIT());
    }

    @Override
    @NotNull
    public Sequence<RsMetaItemStub> getRawMetaItems() {
        return RsInnerAttributeOwnerRegistry.INSTANCE.rawMetaItems((StubBase)this);
    }

    @Override
    public boolean getHasAttrs() {
        return BitUtil.isSet((int)this.flags, (int)RsAttributeOwnerStub.CommonStubAttrFlags.INSTANCE.getHAS_ATTRS());
    }

    @Override
    public boolean getMayHaveCfg() {
        return BitUtil.isSet((int)this.flags, (int)RsAttributeOwnerStub.CommonStubAttrFlags.INSTANCE.getMAY_HAVE_CFG());
    }

    @Override
    public boolean getHasCfgAttr() {
        return BitUtil.isSet((int)this.flags, (int)RsAttributeOwnerStub.CommonStubAttrFlags.INSTANCE.getHAS_CFG_ATTR());
    }

    public final boolean getMayHaveMacroUse() {
        return BitUtil.isSet((int)this.flags, (int)RsAttributeOwnerStub.ModStubAttrFlags.INSTANCE.getMAY_HAVE_MACRO_USE());
    }

    @Override
    public boolean getMayHaveCustomDerive() {
        return false;
    }

    @Override
    public boolean getMayHaveCustomAttrs() {
        return false;
    }

    @Override
    public boolean getMayHaveDocHidden() {
        return BitUtil.isSet((int)this.flags, (int)RsAttributeOwnerStub.CommonStubAttrFlags.INSTANCE.getMAY_HAVE_DOC_HIDDEN());
    }

    @NotNull
    public Type getType() {
        return Type.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0011\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006B\u0019\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\tJ\b\u0010\f\u001a\u00020\u000bH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u001e\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0017H\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/rust/lang/core/stubs/RsFileStub$RsStubFileElementType;", "Lcom/intellij/psi/tree/IStubFileElementType;", "Lorg/rust/lang/core/stubs/RsFileStub;", "language", "Lcom/intellij/lang/Language;", "<init>", "(Lcom/intellij/lang/Language;)V", "debugName", "", "(Ljava/lang/String;Lcom/intellij/lang/Language;)V", "STUB_VERSION", "", "getStubVersion", "getBuilder", "Lcom/intellij/psi/StubBuilder;", "serialize", "", "stub", "dataStream", "Lcom/intellij/psi/stubs/StubOutputStream;", "deserialize", "Lcom/intellij/psi/stubs/StubInputStream;", "parentStub", "Lcom/intellij/psi/stubs/StubElement;", "intellij.rustrover.core"})
    public static abstract class RsStubFileElementType
    extends IStubFileElementType<RsFileStub> {
        private final int STUB_VERSION;

        public RsStubFileElementType(@NotNull Language language) {
            Intrinsics.checkNotNullParameter((Object)language, (String)"language");
            super(language);
            this.STUB_VERSION = 245;
        }

        public RsStubFileElementType(@NotNull String debugName, @NotNull Language language) {
            Intrinsics.checkNotNullParameter((Object)debugName, (String)"debugName");
            Intrinsics.checkNotNullParameter((Object)language, (String)"language");
            super(debugName, language);
            this.STUB_VERSION = 245;
        }

        public int getStubVersion() {
            return 96 + this.STUB_VERSION;
        }

        @NotNull
        public StubBuilder getBuilder() {
            return (StubBuilder)new DefaultStubBuilder(){

                protected StubElement<?> createStubForFile(PsiFile file) {
                    Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                    TreeUtil.ensureParsed((ASTNode)((ASTNode)file.getNode()));
                    if (file instanceof RsReplCodeFragment) {
                        return (StubElement)new RsFileStub(null, 0);
                    }
                    if (!(file instanceof RsFile)) {
                        throw new IllegalStateException("Check failed.");
                    }
                    int flags = RsAttributeOwnerStub.Companion.extractFlags((RsDocAndAttributeOwner)file, (Object)RsAttributeOwnerStub.FileStubAttrFlags.INSTANCE);
                    return (StubElement)new RsFileStub((RsFile)file, flags);
                }

                public boolean skipChildProcessingWhenBuildingStubs(ASTNode parent2, ASTNode child) {
                    Intrinsics.checkNotNullParameter((Object)parent2, (String)"parent");
                    Intrinsics.checkNotNullParameter((Object)child, (String)"child");
                    IElementType iElementType = child.getElementType();
                    Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"getElementType(...)");
                    IElementType elementType = iElementType;
                    return Intrinsics.areEqual((Object)elementType, (Object)RsElementTypes.MACRO_ARGUMENT) || Intrinsics.areEqual((Object)elementType, (Object)RsElementTypes.MACRO_BODY) || RsTokenTypeKt.getRS_DOC_COMMENTS().contains(elementType) || Intrinsics.areEqual((Object)elementType, (Object)RsElementTypes.BLOCK) && Intrinsics.areEqual((Object)parent2.getElementType(), (Object)RsElementTypes.FUNCTION) && this.skipChildForFunctionBody(child);
                }

                private final boolean skipChildForFunctionBody(ASTNode child) {
                    return !BlockMayHaveStubsHeuristic.INSTANCE.getAndClearCached(child);
                }
            };
        }

        public void serialize(@NotNull RsFileStub stub, @NotNull StubOutputStream dataStream) {
            Intrinsics.checkNotNullParameter((Object)stub, (String)"stub");
            Intrinsics.checkNotNullParameter((Object)dataStream, (String)"dataStream");
            dataStream.writeShort(stub.flags);
        }

        @NotNull
        public RsFileStub deserialize(@NotNull StubInputStream dataStream, @Nullable StubElement<?> parentStub) {
            Intrinsics.checkNotNullParameter((Object)dataStream, (String)"dataStream");
            return new RsFileStub(null, dataStream.readUnsignedShort());
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lorg/rust/lang/core/stubs/RsFileStub$Type;", "Lorg/rust/lang/core/stubs/RsFileStub$RsStubFileElementType;", "<init>", "()V", "getExternalId", "", "intellij.rustrover.core"})
    public static final class Type
    extends RsStubFileElementType {
        @NotNull
        public static final Type INSTANCE = new Type();

        private Type() {
            super(RsLanguage.INSTANCE);
        }

        @NotNull
        public String getExternalId() {
            return "Rust.file";
        }
    }
}

