/*
 * Decompiled with CFR 0.152.
 */
package org.rust.lang.core.stubs;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiBuilderFactory;
import com.intellij.openapi.util.Key;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.rust.lang.RsLanguage;
import org.rust.lang.core.psi.RsElementTypes;
import org.rust.lang.core.psi.RsTokenTypeKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/rust/lang/core/stubs/BlockMayHaveStubsHeuristic;", "", "<init>", "()V", "RS_HAS_ITEMS_OR_ATTRS", "Lcom/intellij/openapi/util/Key;", "", "ITEM_DEF_KWS", "Lcom/intellij/psi/tree/TokenSet;", "UNEXPECTED_NEXT_CONST_TOKENS", "computeAndCache", "node", "Lcom/intellij/lang/ASTNode;", "getAndClearCached", "assertIsBlock", "", "computeBlockMayHaveStubs", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nStubImplementations.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StubImplementations.kt\norg/rust/lang/core/stubs/BlockMayHaveStubsHeuristic\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,2498:1\n1#2:2499\n*E\n"})
final class BlockMayHaveStubsHeuristic {
    @NotNull
    public static final BlockMayHaveStubsHeuristic INSTANCE = new BlockMayHaveStubsHeuristic();
    @NotNull
    private static final Key<Boolean> RS_HAS_ITEMS_OR_ATTRS;
    @NotNull
    private static final TokenSet ITEM_DEF_KWS;
    @NotNull
    private static final TokenSet UNEXPECTED_NEXT_CONST_TOKENS;

    private BlockMayHaveStubsHeuristic() {
    }

    public final boolean computeAndCache(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        this.assertIsBlock(node);
        boolean hasItemsOrAttrs = this.computeBlockMayHaveStubs(node);
        node.putUserData(RS_HAS_ITEMS_OR_ATTRS, (Object)hasItemsOrAttrs);
        return hasItemsOrAttrs;
    }

    public final boolean getAndClearCached(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        this.assertIsBlock(node);
        Boolean cachedHasItemsOrAttrs = (Boolean)node.getUserData(RS_HAS_ITEMS_OR_ATTRS);
        if (cachedHasItemsOrAttrs != null) {
            node.putUserData(RS_HAS_ITEMS_OR_ATTRS, null);
            return cachedHasItemsOrAttrs;
        }
        return this.computeBlockMayHaveStubs(node);
    }

    private final void assertIsBlock(ASTNode node) {
        if (!Intrinsics.areEqual((Object)node.getElementType(), (Object)RsElementTypes.BLOCK)) {
            boolean bl = false;
            String string = "Expected block, found: " + node.getElementType() + ", text: `" + node.getText() + "`";
            throw new IllegalStateException(string.toString());
        }
    }

    private final boolean computeBlockMayHaveStubs(ASTNode node) {
        PsiBuilder psiBuilder = PsiBuilderFactory.getInstance().createBuilder(node.getPsi().getProject(), node, null, (Language)RsLanguage.INSTANCE, node.getChars());
        Intrinsics.checkNotNullExpressionValue((Object)psiBuilder, (String)"createBuilder(...)");
        PsiBuilder b = psiBuilder;
        IElementType prevToken = null;
        String prevTokenText = null;
        while (b.getTokenType() != null) {
            IElementType token;
            boolean looksLikeStubElement;
            boolean bl = looksLikeStubElement = ITEM_DEF_KWS.contains(token) || Intrinsics.areEqual((Object)token, (Object)RsElementTypes.CONST) && !Intrinsics.areEqual(prevToken, (Object)RsElementTypes.MUL) && (!Intrinsics.areEqual((Object)prevToken, (Object)RsElementTypes.IDENTIFIER) || !Intrinsics.areEqual((Object)prevTokenText, (Object)"raw")) && !UNEXPECTED_NEXT_CONST_TOKENS.contains(b.lookAhead(1)) || Intrinsics.areEqual((Object)token, (Object)RsElementTypes.EXCL) && Intrinsics.areEqual((Object)prevToken, (Object)RsElementTypes.SHA) || Intrinsics.areEqual((Object)token, (Object)RsElementTypes.EXCL) && Intrinsics.areEqual((Object)prevToken, (Object)RsElementTypes.IDENTIFIER) && Intrinsics.areEqual((Object)prevTokenText, (Object)"macro_rules") || Intrinsics.areEqual((Object)token, (Object)RsElementTypes.IDENTIFIER) && Intrinsics.areEqual((Object)prevToken, (Object)RsElementTypes.FN) || Intrinsics.areEqual((Object)token, (Object)RsElementTypes.IDENTIFIER) && Intrinsics.areEqual((Object)b.getTokenText(), (Object)"union") && Intrinsics.areEqual((Object)b.lookAhead(1), (Object)RsElementTypes.IDENTIFIER);
            if (looksLikeStubElement) {
                return true;
            }
            prevToken = token;
            prevTokenText = Intrinsics.areEqual((Object)token, (Object)RsElementTypes.IDENTIFIER) ? b.getTokenText() : null;
            b.advanceLexer();
        }
        return false;
    }

    static {
        Key key = Key.create((String)"RS_HAS_ITEMS_OR_ATTRS");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        RS_HAS_ITEMS_OR_ATTRS = key;
        IElementType[] iElementTypeArray = new IElementType[10];
        Intrinsics.checkNotNullExpressionValue((Object)RsElementTypes.STATIC, (String)"STATIC");
        Intrinsics.checkNotNullExpressionValue((Object)RsElementTypes.ENUM, (String)"ENUM");
        Intrinsics.checkNotNullExpressionValue((Object)RsElementTypes.IMPL, (String)"IMPL");
        Intrinsics.checkNotNullExpressionValue((Object)RsElementTypes.MACRO_KW, (String)"MACRO_KW");
        Intrinsics.checkNotNullExpressionValue((Object)RsElementTypes.MOD, (String)"MOD");
        Intrinsics.checkNotNullExpressionValue((Object)RsElementTypes.STRUCT, (String)"STRUCT");
        Intrinsics.checkNotNullExpressionValue((Object)RsElementTypes.UNION, (String)"UNION");
        Intrinsics.checkNotNullExpressionValue((Object)RsElementTypes.TRAIT, (String)"TRAIT");
        Intrinsics.checkNotNullExpressionValue((Object)RsElementTypes.TYPE_KW, (String)"TYPE_KW");
        Intrinsics.checkNotNullExpressionValue((Object)RsElementTypes.USE, (String)"USE");
        ITEM_DEF_KWS = RsTokenTypeKt.tokenSetOf(iElementTypeArray);
        iElementTypeArray = new IElementType[3];
        Intrinsics.checkNotNullExpressionValue((Object)RsElementTypes.LBRACE, (String)"LBRACE");
        Intrinsics.checkNotNullExpressionValue((Object)RsElementTypes.MOVE, (String)"MOVE");
        Intrinsics.checkNotNullExpressionValue((Object)RsElementTypes.OR, (String)"OR");
        UNEXPECTED_NEXT_CONST_TOKENS = RsTokenTypeKt.tokenSetOf(iElementTypeArray);
    }
}

