/*
 * Decompiled with CFR 0.152.
 */
package org.rust.lang.core.resolve2.util;

import gnu.trove.THash;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.lang.core.resolve2.util.THashMapBase;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\t\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00022\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00030\u00050\u0004B\u0007\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\u000f\u001a\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u00052\u0006\u0010\u0010\u001a\u00020\fH\u0016J\u001e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00010\u0005H\u0016J\u001b\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00028\u00002\u0006\u0010\u0013\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u0016J\u0010\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\fH\u0014J\u0010\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\fH\u0014R\u0018\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\tX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001b"}, d2={"Lorg/rust/lang/core/resolve2/util/SmartListMap;", "K", "", "V", "Lorg/rust/lang/core/resolve2/util/THashMapBase;", "", "<init>", "()V", "items", "", "[Ljava/lang/Object;", "size", "", "getSize", "()I", "getValueAtIndex", "index", "setValueAtIndex", "", "value", "addValue", "key", "(Ljava/lang/Object;Ljava/lang/Object;)V", "createNewArrays", "capacity", "rehash", "newCapacity", "intellij.rustrover.core"})
public final class SmartListMap<K, V>
extends THashMapBase<K, List<? extends V>> {
    @NotNull
    private Object[] items;

    public SmartListMap() {
        Intrinsics.checkNotNullExpressionValue((Object)THash.EMPTY_OBJECT_ARRAY, (String)"EMPTY_OBJECT_ARRAY");
        this.items = THash.EMPTY_OBJECT_ARRAY;
    }

    @Override
    public int getSize() {
        return this._size;
    }

    @Override
    @Nullable
    public List<V> getValueAtIndex(int index) {
        Object object = this.items[index];
        if (object == null) {
            return null;
        }
        Object value = object;
        return value instanceof List ? (List)value : CollectionsKt.listOf((Object)value);
    }

    @Override
    public void setValueAtIndex(int index, @NotNull List<? extends V> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        List<V> list = CollectionsKt.singleOrNull(value);
        if (list == null) {
            list = value;
        }
        this.items[index] = list;
    }

    public final void addValue(@NotNull K key, @NotNull V value) {
        boolean alreadyStored;
        Intrinsics.checkNotNullParameter(key, (String)"key");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        int index = this.insertionIndex(key);
        boolean bl = alreadyStored = index < 0;
        if (alreadyStored) {
            int indexAdjusted = -index - 1;
            Object existing = this.items[indexAdjusted];
            if (TypeIntrinsics.isMutableList((Object)existing)) {
                Object object = existing;
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.collections.MutableList<V of org.rust.lang.core.resolve2.util.SmartListMap>");
                ((Collection)TypeIntrinsics.asMutableList((Object)object)).add(value);
            } else {
                Object[] objectArray = new Object[]{existing, value};
                this.items[indexAdjusted] = CollectionsKt.mutableListOf((Object[])objectArray);
            }
        } else {
            this._set[index] = key;
            this.items[index] = value;
            this.postInsertHook();
        }
    }

    @Override
    protected void createNewArrays(int capacity) {
        this.items = new Object[capacity];
    }

    protected void rehash(int newCapacity) {
        Object[] oldItems = this.items;
        this.rehashTemplate(newCapacity, (Function2<Integer, Integer, Unit>)((Function2)(arg_0, arg_1) -> SmartListMap.rehash$lambda$0(this, oldItems, arg_0, arg_1)));
    }

    private static final Unit rehash$lambda$0(SmartListMap this$0, Object[] $oldItems, int newIndex, int oldIndex) {
        this$0.items[newIndex] = $oldItems[oldIndex];
        return Unit.INSTANCE;
    }
}

