/*
 * Decompiled with CFR 0.152.
 */
package org.rust.lang.core.resolve2.util;

import com.intellij.util.ArrayUtil;
import gnu.trove.THash;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.lang.core.resolve.Namespace;
import org.rust.lang.core.resolve2.ModData;
import org.rust.lang.core.resolve2.ModPath;
import org.rust.lang.core.resolve2.PerNs;
import org.rust.lang.core.resolve2.VisItem;
import org.rust.lang.core.resolve2.Visibility;
import org.rust.lang.core.resolve2.util.PerNsHashMapKt;
import org.rust.lang.core.resolve2.util.THashMapBase;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010\u0005\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u00020\u00040\u0003B\u0017\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0004H\u0016J\u0010\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0011H\u0014J\u0010\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0011H\u0014J\u001f\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0002\u00a2\u0006\u0002\u0010\"J\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0011H\u0002J\u0010\u0010&\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0011H\u0002J\u0010\u0010'\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0011H\u0002J\u0010\u0010(\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0011H\u0002J\u0010\u0010)\u001a\u00020!2\u0006\u0010%\u001a\u00020\u0011H\u0002J\u0010\u0010*\u001a\u00020+2\u0006\u0010%\u001a\u00020\u0011H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u000bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006,"}, d2={"Lorg/rust/lang/core/resolve2/util/PerNsHashMap;", "K", "", "Lorg/rust/lang/core/resolve2/util/THashMapBase;", "Lorg/rust/lang/core/resolve2/PerNs;", "containingMod", "Lorg/rust/lang/core/resolve2/ModData;", "rootMod", "<init>", "(Lorg/rust/lang/core/resolve2/ModData;Lorg/rust/lang/core/resolve2/ModData;)V", "items", "", "[Ljava/lang/Object;", "masks", "", "getValueAtIndex", "index", "", "setValueAtIndex", "", "value", "createNewArrays", "capacity", "rehash", "newCapacity", "size", "getSize", "()I", "encodeMask", "", "visItem", "Lorg/rust/lang/core/resolve2/VisItem;", "namespace", "Lorg/rust/lang/core/resolve/Namespace;", "(Lorg/rust/lang/core/resolve2/VisItem;Lorg/rust/lang/core/resolve/Namespace;)Ljava/lang/Byte;", "decodeIsFromNamedImport", "", "mask", "decodeIsModOrEnum", "decodeIsTrait", "decodeIsTypeAlias", "decodeNamespace", "decodeVisibility", "Lorg/rust/lang/core/resolve2/Visibility;", "intellij.rustrover.core"})
public final class PerNsHashMap<K>
extends THashMapBase<K, PerNs> {
    @NotNull
    private final ModData containingMod;
    @NotNull
    private final ModData rootMod;
    @NotNull
    private Object[] items;
    @NotNull
    private byte[] masks;

    public PerNsHashMap(@NotNull ModData containingMod, @NotNull ModData rootMod) {
        Intrinsics.checkNotNullParameter((Object)containingMod, (String)"containingMod");
        Intrinsics.checkNotNullParameter((Object)rootMod, (String)"rootMod");
        this.containingMod = containingMod;
        this.rootMod = rootMod;
        Intrinsics.checkNotNullExpressionValue((Object)THash.EMPTY_OBJECT_ARRAY, (String)"EMPTY_OBJECT_ARRAY");
        this.items = THash.EMPTY_OBJECT_ARRAY;
        Intrinsics.checkNotNullExpressionValue((Object)ArrayUtil.EMPTY_BYTE_ARRAY, (String)"EMPTY_BYTE_ARRAY");
        this.masks = ArrayUtil.EMPTY_BYTE_ARRAY;
    }

    @Override
    @Nullable
    public PerNs getValueAtIndex(int index) {
        Object object = this.items[index];
        if (object == null) {
            return null;
        }
        Object path = object;
        if (!(path instanceof ModPath)) {
            return (PerNs)path;
        }
        byte mask = this.masks[index];
        boolean isModOrEnum = this.decodeIsModOrEnum(mask);
        boolean isTrait = this.decodeIsTrait(mask);
        boolean isTypeAlias = this.decodeIsTypeAlias(mask);
        Namespace namespace = this.decodeNamespace(mask);
        Visibility visibility = this.decodeVisibility(mask);
        boolean isFromNamedImport = this.decodeIsFromNamedImport(mask);
        VisItem visItem = new VisItem((ModPath)path, visibility, isModOrEnum, isTrait, isFromNamedImport, isTypeAlias);
        VisItem[] visItemArray = new VisItem[]{visItem};
        VisItem[] visItemArray2 = visItemArray;
        return switch (WhenMappings.$EnumSwitchMapping$0[namespace.ordinal()]) {
            case 1 -> new PerNs(visItemArray2, null, null, 6, null);
            case 2 -> new PerNs(null, visItemArray2, null, 5, null);
            case 3 -> new PerNs(null, null, visItemArray2, 3, null);
            default -> throw new IllegalStateException("unreachable".toString());
        };
    }

    @Override
    public void setValueAtIndex(int index, @NotNull PerNs value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Pair<VisItem, Namespace> pair = PerNsHashMapKt.asSingleVisItem(value);
        if (pair == null) {
            PerNsHashMap $this$setValueAtIndex_u24lambda_u240 = this;
            boolean bl = false;
            $this$setValueAtIndex_u24lambda_u240.items[index] = value;
            return;
        }
        Pair<VisItem, Namespace> pair2 = pair;
        VisItem visItem = (VisItem)pair2.component1();
        Namespace namespace = (Namespace)((Object)pair2.component2());
        Byte by = this.encodeMask(visItem, namespace);
        if (by == null) {
            PerNsHashMap $this$setValueAtIndex_u24lambda_u241 = this;
            boolean bl = false;
            $this$setValueAtIndex_u24lambda_u241.items[index] = value;
            return;
        }
        byte mask = by;
        this.items[index] = visItem.getPath();
        this.masks[index] = mask;
    }

    @Override
    protected void createNewArrays(int capacity) {
        this.items = new Object[capacity];
        this.masks = new byte[capacity];
    }

    protected void rehash(int newCapacity) {
        Object[] oldItems = this.items;
        byte[] oldMasks = this.masks;
        this.rehashTemplate(newCapacity, (Function2<Integer, Integer, Unit>)((Function2)(arg_0, arg_1) -> PerNsHashMap.rehash$lambda$0(this, oldItems, oldMasks, arg_0, arg_1)));
    }

    @Override
    public int getSize() {
        return this._size;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Byte encodeMask(VisItem visItem, Namespace namespace) {
        int n;
        int n2;
        if (visItem.isModOrEnum()) {
            n2 = 0;
        } else if (visItem.isTrait()) {
            n2 = 1;
        } else if (visItem.isTypeAlias()) {
            n2 = 5;
        } else if (namespace == Namespace.Types) {
            n2 = 2;
        } else if (namespace == Namespace.Values) {
            n2 = 3;
        } else {
            if (namespace != Namespace.Macros) throw new IllegalStateException("unreachable".toString());
            n2 = 4;
        }
        int namespaceMask = n2;
        Visibility visibility = visItem.getVisibility();
        if (visibility == Visibility.CfgDisabled.INSTANCE) {
            n = 0;
        } else if (visibility == Visibility.Invisible.INSTANCE) {
            n = 1;
        } else if (visibility == Visibility.Public.INSTANCE) {
            n = 2;
        } else {
            if (!(visibility instanceof Visibility.Restricted)) throw new IllegalStateException("unreachable".toString());
            ModData scope = ((Visibility.Restricted)visibility).getInMod();
            if (scope == this.containingMod) {
                n = 3;
            } else if (scope.isCrateRoot()) {
                n = 4;
            } else {
                if (scope != this.containingMod.getParent()) return null;
                n = 5;
            }
        }
        int visibilityMask = n;
        int isFromNamedImportMask = visItem.isFromNamedImport() ? 1 : 0;
        int mask = namespaceMask | visibilityMask << 3 | isFromNamedImportMask << 6;
        return (byte)mask;
    }

    private final boolean decodeIsFromNamedImport(int mask) {
        return (mask & 0x40) != 0;
    }

    private final boolean decodeIsModOrEnum(int mask) {
        return (mask & 7) == 0;
    }

    private final boolean decodeIsTrait(int mask) {
        return (mask & 7) == 1;
    }

    private final boolean decodeIsTypeAlias(int mask) {
        return (mask & 7) == 5;
    }

    private final Namespace decodeNamespace(int mask) {
        return switch (mask & 7) {
            case 0, 1, 2, 5 -> Namespace.Types;
            case 3 -> Namespace.Values;
            case 4 -> Namespace.Macros;
            default -> throw new IllegalStateException("unreachable".toString());
        };
    }

    private final Visibility decodeVisibility(int mask) {
        return switch (mask >> 3 & 7) {
            case 0 -> Visibility.CfgDisabled.INSTANCE;
            case 1 -> Visibility.Invisible.INSTANCE;
            case 2 -> Visibility.Public.INSTANCE;
            case 3 -> this.containingMod.getVisibilityInSelf();
            case 4 -> this.rootMod.getVisibilityInSelf();
            case 5 -> {
                ModData v1 = this.containingMod.getParent();
                if (v1 == null) {
                    throw new IllegalStateException("Inconsistent mask in PerNsHashMap".toString());
                }
                ModData parent = v1;
                yield parent.getVisibilityInSelf();
            }
            default -> throw new IllegalStateException("unreachable".toString());
        };
    }

    private static final Unit rehash$lambda$0(PerNsHashMap this$0, Object[] $oldItems, byte[] $oldMasks, int newIndex, int oldIndex) {
        this$0.items[newIndex] = $oldItems[oldIndex];
        this$0.masks[newIndex] = $oldMasks[oldIndex];
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Namespace.values().length];
            try {
                nArray[Namespace.Types.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Namespace.Values.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Namespace.Macros.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

