/*
 * Decompiled with CFR 0.152.
 */
package org.rust.lang.core.resolve2.util;

import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.rust.lang.core.macros.RangeMap;
import org.rust.lang.core.resolve2.CrateDefMapKt;
import org.rust.lang.core.resolve2.util.DollarCrateMap;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0016\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u0006\u0012\b\u0012\u00060\u0006j\u0002`\u00070\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u0012\n\u0010\n\u001a\u00060\u0006j\u0002`\u0007\u00a2\u0006\u0004\b\u000b\u0010\fJ1\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0011\u001a\u00020\u00062\b\b\u0002\u0010\u0012\u001a\u00020\t\u00a2\u0006\u0002\u0010\u0013J\u0016\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u0006J(\u0010\u0018\u001a\u0012\u0012\u0004\u0012\u00020\u0006\u0012\b\u0012\u00060\u0006j\u0002`\u00070\u00052\u0006\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u0006H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u0006\u0012\b\u0012\u00060\u0006j\u0002`\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\n\u001a\u00060\u0006j\u0002`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/rust/lang/core/resolve2/util/DollarCrateHelper;", "", "ranges", "Lorg/rust/lang/core/macros/RangeMap;", "rangesInExpansion", "", "", "Lorg/rust/lang/core/crate/CratePersistentId;", "defHasLocalInnerMacros", "", "defCrate", "<init>", "(Lorg/rust/lang/core/macros/RangeMap;Ljava/util/Map;ZI)V", "convertPath", "", "", "path", "offsetInExpansion", "isFunctionLikeMacroPath", "([Ljava/lang/String;IZ)[Ljava/lang/String;", "getDollarCrateMap", "Lorg/rust/lang/core/resolve2/util/DollarCrateMap;", "startOffsetInExpansion", "endOffsetInExpansion", "filterRangesInside", "macroStart", "macroEnd", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nDollarCrateUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DollarCrateUtil.kt\norg/rust/lang/core/resolve2/util/DollarCrateHelper\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,153:1\n478#2:154\n424#2:155\n488#2,7:160\n1252#3,4:156\n*S KotlinDebug\n*F\n+ 1 DollarCrateUtil.kt\norg/rust/lang/core/resolve2/util/DollarCrateHelper\n*L\n92#1:154\n92#1:155\n99#1:160,7\n92#1:156,4\n*E\n"})
public final class DollarCrateHelper {
    @NotNull
    private final RangeMap ranges;
    @NotNull
    private final Map<Integer, Integer> rangesInExpansion;
    private final boolean defHasLocalInnerMacros;
    private final int defCrate;

    public DollarCrateHelper(@NotNull RangeMap ranges, @NotNull Map<Integer, Integer> rangesInExpansion, boolean defHasLocalInnerMacros, int defCrate) {
        Intrinsics.checkNotNullParameter((Object)ranges, (String)"ranges");
        Intrinsics.checkNotNullParameter(rangesInExpansion, (String)"rangesInExpansion");
        this.ranges = ranges;
        this.rangesInExpansion = rangesInExpansion;
        this.defHasLocalInnerMacros = defHasLocalInnerMacros;
        this.defCrate = defCrate;
    }

    @NotNull
    public final String[] convertPath(@NotNull String[] path, int offsetInExpansion, boolean isFunctionLikeMacroPath) {
        String[] stringArray;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        if (Intrinsics.areEqual((Object)path[0], (Object)"IntellijRustDollarCrate")) {
            Integer crateId = this.rangesInExpansion.get(offsetInExpansion);
            if (crateId != null) {
                Object[] objectArray = new String[]{"IntellijRustDollarCrate", String.valueOf(crateId)};
                stringArray = (String[])ArraysKt.plus((Object[])objectArray, (Object[])ArraysKt.copyOfRange((Object[])path, (int)1, (int)path.length));
            } else {
                CrateDefMapKt.getRESOLVE_LOG().error("Can't find crate for path starting with $crate");
                stringArray = path;
            }
        } else if (this.defHasLocalInnerMacros) {
            boolean isExpandedFromDef;
            if (!isFunctionLikeMacroPath) {
                return path;
            }
            Integer pathOffsetInCall = this.ranges.mapOffsetFromExpansionToCallBody(offsetInExpansion, false);
            boolean bl = isExpandedFromDef = pathOffsetInCall == null;
            if (!isExpandedFromDef) {
                return path;
            }
            Object[] objectArray = new String[]{"IntellijRustDollarCrate", String.valueOf(this.defCrate)};
            stringArray = (String[])ArraysKt.plus((Object[])objectArray, (Object[])path);
        } else {
            stringArray = path;
        }
        return stringArray;
    }

    public static /* synthetic */ String[] convertPath$default(DollarCrateHelper dollarCrateHelper, String[] stringArray, int n, boolean bl, int n2, Object object) {
        if ((n2 & 4) != 0) {
            bl = false;
        }
        return dollarCrateHelper.convertPath(stringArray, n, bl);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final DollarCrateMap getDollarCrateMap(int startOffsetInExpansion, int endOffsetInExpansion) {
        void $this$associateByTo$iv$iv$iv;
        void $this$mapKeysTo$iv$iv;
        void $this$mapKeys$iv;
        Map<Integer, Integer> map2 = this.filterRangesInside(startOffsetInExpansion, endOffsetInExpansion);
        boolean $i$f$mapKeys = false;
        void var6_5 = $this$mapKeys$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
        boolean $i$f$mapKeysTo = false;
        Iterable iterable = $this$mapKeysTo$iv$iv.entrySet();
        Map destination$iv$iv$iv = destination$iv$iv;
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Map map3 = destination$iv$iv$iv;
            boolean bl = false;
            int offsetInExpansion = ((Number)entry2.getKey()).intValue();
            Map.Entry entry3 = (Map.Entry)element$iv$iv$iv;
            Integer n = offsetInExpansion - startOffsetInExpansion;
            Map map4 = map3;
            boolean bl2 = false;
            Object v = it$iv$iv.getValue();
            map4.put(n, v);
        }
        Map rangesInMacro = destination$iv$iv$iv;
        return new DollarCrateMap(rangesInMacro);
    }

    private final Map<Integer, Integer> filterRangesInside(int macroStart, int macroEnd) {
        Map<Integer, Integer> $this$filterKeys$iv = this.rangesInExpansion;
        boolean $i$f$filterKeys = false;
        LinkedHashMap<Integer, Integer> result$iv = new LinkedHashMap<Integer, Integer>();
        for (Map.Entry<Integer, Integer> entry$iv : $this$filterKeys$iv.entrySet()) {
            int rangeStart = ((Number)entry$iv.getKey()).intValue();
            boolean bl = false;
            int rangeEnd = rangeStart + 23;
            if (!(macroStart <= rangeStart && rangeEnd <= macroEnd)) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        return result$iv;
    }
}

