/*
 * Decompiled with CFR 0.152.
 */
package org.rust.lang.core.resolve2;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.rust.lang.core.resolve2.ModData;
import org.rust.lang.core.resolve2.VisibilityType;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0004\u0014\u0015\u0016\u0017B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005J\u000e\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0000J\u000e\u0010\u000b\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u0000J\b\u0010\u0012\u001a\u00020\u0013H\u0016R\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u0082\u0001\u0004\u0018\u0019\u001a\u001b\u00a8\u0006\u001c"}, d2={"Lorg/rust/lang/core/resolve2/Visibility;", "", "<init>", "()V", "isVisibleFromOtherCrate", "", "isVisibleFromMod", "mod", "Lorg/rust/lang/core/resolve2/ModData;", "isStrictlyMorePermissive", "other", "intersect", "type", "Lorg/rust/lang/core/resolve2/VisibilityType;", "getType", "()Lorg/rust/lang/core/resolve2/VisibilityType;", "isInvisible", "()Z", "toString", "", "Public", "Restricted", "Invisible", "CfgDisabled", "Lorg/rust/lang/core/resolve2/Visibility$CfgDisabled;", "Lorg/rust/lang/core/resolve2/Visibility$Invisible;", "Lorg/rust/lang/core/resolve2/Visibility$Public;", "Lorg/rust/lang/core/resolve2/Visibility$Restricted;", "intellij.rustrover.core"})
public abstract sealed class Visibility {
    private Visibility() {
    }

    public final boolean isVisibleFromOtherCrate() {
        return Intrinsics.areEqual((Object)this, (Object)Public.INSTANCE);
    }

    public final boolean isVisibleFromMod(@NotNull ModData mod) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)mod, (String)"mod");
        Visibility visibility = this;
        if (Intrinsics.areEqual((Object)visibility, (Object)Public.INSTANCE)) {
            bl = true;
        } else if (visibility instanceof Restricted) {
            bl = ((Restricted)this).getInMod().getPath().isSubPathOf(mod.getPath());
        } else if (Intrinsics.areEqual((Object)visibility, (Object)Invisible.INSTANCE) || Intrinsics.areEqual((Object)visibility, (Object)CfgDisabled.INSTANCE)) {
            bl = false;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }

    public final boolean isStrictlyMorePermissive(@NotNull Visibility other) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (this instanceof Restricted && other instanceof Restricted) {
            bl = ((Restricted)this).getInMod().getCrate() == ((Restricted)other).getInMod().getCrate() && !Intrinsics.areEqual((Object)((Restricted)this).getInMod(), (Object)((Restricted)other).getInMod()) && SequencesKt.contains(((Restricted)other).getInMod().getParents(), (Object)((Restricted)this).getInMod());
        } else {
            Visibility visibility = this;
            if (Intrinsics.areEqual((Object)visibility, (Object)Public.INSTANCE)) {
                bl = !(other instanceof Public);
            } else if (visibility instanceof Restricted) {
                bl = Intrinsics.areEqual((Object)other, (Object)Invisible.INSTANCE) || Intrinsics.areEqual((Object)other, (Object)CfgDisabled.INSTANCE);
            } else if (Intrinsics.areEqual((Object)visibility, (Object)Invisible.INSTANCE)) {
                bl = Intrinsics.areEqual((Object)other, (Object)CfgDisabled.INSTANCE);
            } else if (Intrinsics.areEqual((Object)visibility, (Object)CfgDisabled.INSTANCE)) {
                bl = false;
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    @NotNull
    public final Visibility intersect(@NotNull Visibility other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.isStrictlyMorePermissive(other) ? other : this;
    }

    @NotNull
    public final VisibilityType getType() {
        VisibilityType visibilityType;
        Visibility visibility = this;
        if (Intrinsics.areEqual((Object)visibility, (Object)Public.INSTANCE)) {
            visibilityType = VisibilityType.Normal;
        } else if (visibility instanceof Restricted) {
            visibilityType = VisibilityType.Normal;
        } else if (Intrinsics.areEqual((Object)visibility, (Object)Invisible.INSTANCE)) {
            visibilityType = VisibilityType.Invisible;
        } else if (Intrinsics.areEqual((Object)visibility, (Object)CfgDisabled.INSTANCE)) {
            visibilityType = VisibilityType.CfgDisabled;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return visibilityType;
    }

    public final boolean isInvisible() {
        return Intrinsics.areEqual((Object)this, (Object)Invisible.INSTANCE) || Intrinsics.areEqual((Object)this, (Object)CfgDisabled.INSTANCE);
    }

    @NotNull
    public String toString() {
        Object object;
        Visibility visibility = this;
        if (Intrinsics.areEqual((Object)visibility, (Object)Public.INSTANCE)) {
            object = "Public";
        } else if (visibility instanceof Restricted) {
            object = "Restricted(in " + ((Restricted)this).getInMod().getPath() + ")";
        } else if (Intrinsics.areEqual((Object)visibility, (Object)Invisible.INSTANCE)) {
            object = "Invisible";
        } else if (Intrinsics.areEqual((Object)visibility, (Object)CfgDisabled.INSTANCE)) {
            object = "CfgDisabled";
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return object;
    }

    public /* synthetic */ Visibility(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lorg/rust/lang/core/resolve2/Visibility$CfgDisabled;", "Lorg/rust/lang/core/resolve2/Visibility;", "<init>", "()V", "intellij.rustrover.core"})
    public static final class CfgDisabled
    extends Visibility {
        @NotNull
        public static final CfgDisabled INSTANCE = new CfgDisabled();

        private CfgDisabled() {
            super(null);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lorg/rust/lang/core/resolve2/Visibility$Invisible;", "Lorg/rust/lang/core/resolve2/Visibility;", "<init>", "()V", "intellij.rustrover.core"})
    public static final class Invisible
    extends Visibility {
        @NotNull
        public static final Invisible INSTANCE = new Invisible();

        private Invisible() {
            super(null);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lorg/rust/lang/core/resolve2/Visibility$Public;", "Lorg/rust/lang/core/resolve2/Visibility;", "<init>", "()V", "intellij.rustrover.core"})
    public static final class Public
    extends Visibility {
        @NotNull
        public static final Public INSTANCE = new Public();

        private Public() {
            super(null);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \b2\u00020\u0001:\u0001\bB\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\t"}, d2={"Lorg/rust/lang/core/resolve2/Visibility$Restricted;", "Lorg/rust/lang/core/resolve2/Visibility;", "inMod", "Lorg/rust/lang/core/resolve2/ModData;", "<init>", "(Lorg/rust/lang/core/resolve2/ModData;)V", "getInMod", "()Lorg/rust/lang/core/resolve2/ModData;", "Companion", "intellij.rustrover.core"})
    public static final class Restricted
    extends Visibility {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final ModData inMod;

        private Restricted(ModData inMod) {
            super(null);
            this.inMod = inMod;
        }

        @NotNull
        public final ModData getInMod() {
            return this.inMod;
        }

        public /* synthetic */ Restricted(ModData inMod, DefaultConstructorMarker $constructor_marker) {
            this(inMod);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lorg/rust/lang/core/resolve2/Visibility$Restricted$Companion;", "", "<init>", "()V", "create", "Lorg/rust/lang/core/resolve2/Visibility$Restricted;", "inMod", "Lorg/rust/lang/core/resolve2/ModData;", "intellij.rustrover.core"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Restricted create(@NotNull ModData inMod) {
                Intrinsics.checkNotNullParameter((Object)inMod, (String)"inMod");
                return new Restricted(inMod, null);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

