/*
 * Decompiled with CFR 0.152.
 */
package org.rust.lang.core.resolve2;

import com.intellij.psi.stubs.StubElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.lang.core.crate.Crate;
import org.rust.lang.core.psi.RsFile;
import org.rust.lang.core.psi.ext.RsDocAndAttributeOwnerKt;
import org.rust.lang.core.psi.ext.RsEnumItemKt;
import org.rust.lang.core.resolve2.EnumLight;
import org.rust.lang.core.resolve2.EnumVariantLight;
import org.rust.lang.core.resolve2.FileModificationTrackerKt;
import org.rust.lang.core.resolve2.HashCalculator;
import org.rust.lang.core.resolve2.ImplItemLight;
import org.rust.lang.core.resolve2.ImportLight;
import org.rust.lang.core.resolve2.Macro2DefLight;
import org.rust.lang.core.resolve2.MacroCallLight;
import org.rust.lang.core.resolve2.MacroDefLight;
import org.rust.lang.core.resolve2.ModCollectorBase;
import org.rust.lang.core.resolve2.ModDataLight;
import org.rust.lang.core.resolve2.ModOrEnumItemLight;
import org.rust.lang.core.resolve2.ModVisitor;
import org.rust.lang.core.resolve2.ProcMacroCallLight;
import org.rust.lang.core.resolve2.SimpleItemLight;
import org.rust.lang.core.resolve2.TypeAliasItemLight;
import org.rust.lang.core.stubs.RsConstantStub;
import org.rust.lang.core.stubs.RsEnumItemStub;
import org.rust.lang.core.stubs.RsEnumVariantStub;
import org.rust.lang.core.stubs.RsImplItemStub;
import org.rust.lang.core.stubs.RsMacroCallStub;
import org.rust.lang.core.stubs.RsModItemStub;
import org.rust.lang.core.stubs.RsNamedStub;
import org.rust.lang.core.stubs.RsTypeAliasStub;
import org.rust.stdext.HashCode;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00ae\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u001c\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u0017H\u0016J\u0018\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u001aH\u0016J\u0018\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u0010\u001f\u001a\u00020\u00132\u0006\u0010 \u001a\u00020!H\u0016J\u0018\u0010\"\u001a\u00020\u00132\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0016J\u0018\u0010'\u001a\u00020\u00132\u0006\u0010(\u001a\u00020)2\u0006\u0010\u0016\u001a\u00020*H\u0016J\u001c\u0010+\u001a\u00020\u00132\u0006\u0010(\u001a\u00020,2\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u0017H\u0016J\u001c\u0010-\u001a\u00020\u00132\u0006\u0010.\u001a\u00020/2\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u0017H\u0016J\u001c\u00100\u001a\u00020\u00132\u0006\u0010.\u001a\u0002012\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u0017H\u0016J\u0018\u00102\u001a\u00020\u00132\u0006\u00103\u001a\u0002042\u0006\u0010\u0016\u001a\u000205H\u0016J\u0018\u00106\u001a\u00020\u00132\u0006\u00107\u001a\u0002082\u0006\u0010\u0016\u001a\u000209H\u0016J\b\u0010:\u001a\u00020\u0013H\u0016J \u0010;\u001a\u00020\u00132\u0006\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020\u00072\u0006\u0010?\u001a\u00020\tH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006@"}, d2={"Lorg/rust/lang/core/resolve2/ModLightCollector;", "Lorg/rust/lang/core/resolve2/ModVisitor;", "crate", "Lorg/rust/lang/core/crate/Crate;", "hashCalculator", "Lorg/rust/lang/core/resolve2/HashCalculator;", "fileRelativePath", "", "collectChildModules", "", "stdlibAttributes", "Lorg/rust/lang/core/psi/RsFile$Attributes;", "<init>", "(Lorg/rust/lang/core/crate/Crate;Lorg/rust/lang/core/resolve2/HashCalculator;Ljava/lang/String;ZLorg/rust/lang/core/psi/RsFile$Attributes;)V", "modData", "Lorg/rust/lang/core/resolve2/ModDataLight;", "getModData", "()Lorg/rust/lang/core/resolve2/ModDataLight;", "collectSimpleItem", "", "item", "Lorg/rust/lang/core/resolve2/SimpleItemLight;", "stub", "Lcom/intellij/psi/stubs/StubElement;", "collectModOrEnumItem", "Lorg/rust/lang/core/resolve2/ModOrEnumItemLight;", "Lorg/rust/lang/core/stubs/RsNamedStub;", "collectEnum", "enum", "enumStub", "Lorg/rust/lang/core/stubs/RsEnumItemStub;", "collectImport", "import", "Lorg/rust/lang/core/resolve2/ImportLight;", "collectUnnamedConst", "const", "Lorg/rust/lang/core/stubs/RsConstantStub;", "macroIndexInParent", "", "collectMacroCall", "call", "Lorg/rust/lang/core/resolve2/MacroCallLight;", "Lorg/rust/lang/core/stubs/RsMacroCallStub;", "collectProcMacroCall", "Lorg/rust/lang/core/resolve2/ProcMacroCallLight;", "collectMacroDef", "def", "Lorg/rust/lang/core/resolve2/MacroDefLight;", "collectMacro2Def", "Lorg/rust/lang/core/resolve2/Macro2DefLight;", "collectImplItem", "impl", "Lorg/rust/lang/core/resolve2/ImplItemLight;", "Lorg/rust/lang/core/stubs/RsImplItemStub;", "collectTypeAlias", "typeAlias", "Lorg/rust/lang/core/resolve2/TypeAliasItemLight;", "Lorg/rust/lang/core/stubs/RsTypeAliasStub;", "afterCollectMod", "collectMod", "mod", "Lorg/rust/lang/core/stubs/RsModItemStub;", "modName", "isDeeplyEnabledByCfg", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nFileModificationTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileModificationTracker.kt\norg/rust/lang/core/resolve2/ModLightCollector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,261:1\n1625#2:262\n1869#2:263\n1870#2:265\n1626#2:266\n1011#2,2:267\n1#3:264\n*S KotlinDebug\n*F\n+ 1 FileModificationTracker.kt\norg/rust/lang/core/resolve2/ModLightCollector\n*L\n163#1:262\n163#1:263\n163#1:265\n163#1:266\n170#1:267,2\n163#1:264\n*E\n"})
final class ModLightCollector
implements ModVisitor {
    @NotNull
    private final Crate crate;
    @NotNull
    private final HashCalculator hashCalculator;
    @NotNull
    private final String fileRelativePath;
    private final boolean collectChildModules;
    @Nullable
    private final RsFile.Attributes stdlibAttributes;
    @NotNull
    private final ModDataLight modData;

    public ModLightCollector(@NotNull Crate crate, @NotNull HashCalculator hashCalculator, @NotNull String fileRelativePath, boolean collectChildModules, @Nullable RsFile.Attributes stdlibAttributes) {
        Intrinsics.checkNotNullParameter((Object)crate, (String)"crate");
        Intrinsics.checkNotNullParameter((Object)hashCalculator, (String)"hashCalculator");
        Intrinsics.checkNotNullParameter((Object)fileRelativePath, (String)"fileRelativePath");
        this.crate = crate;
        this.hashCalculator = hashCalculator;
        this.fileRelativePath = fileRelativePath;
        this.collectChildModules = collectChildModules;
        this.stdlibAttributes = stdlibAttributes;
        this.modData = new ModDataLight();
    }

    public /* synthetic */ ModLightCollector(Crate crate, HashCalculator hashCalculator, String string, boolean bl, RsFile.Attributes attributes, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            bl = false;
        }
        this(crate, hashCalculator, string, bl, attributes);
    }

    @NotNull
    public final ModDataLight getModData() {
        return this.modData;
    }

    @Override
    public void collectSimpleItem(@NotNull SimpleItemLight item, @NotNull StubElement<?> stub) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        Intrinsics.checkNotNullParameter(stub, (String)"stub");
        ((Collection)this.modData.getItems()).add(item);
    }

    @Override
    public void collectModOrEnumItem(@NotNull ModOrEnumItemLight item, @NotNull RsNamedStub stub) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        Intrinsics.checkNotNullParameter((Object)stub, (String)"stub");
        if (stub instanceof RsEnumItemStub) {
            this.collectEnum(item, (RsEnumItemStub)stub);
            return;
        }
        ((Collection)this.modData.getItems()).add(item);
        if (this.collectChildModules && stub instanceof RsModItemStub) {
            this.collectMod((RsModItemStub)stub, item.getName(), item.isDeeplyEnabledByCfg());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void collectEnum(ModOrEnumItemLight modOrEnumItemLight, RsEnumItemStub enumStub) {
        List variants;
        void destination$iv;
        void $this$mapNotNullTo$iv;
        Iterable iterable = RsEnumItemKt.getVariants(enumStub);
        Collection collection = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv.iterator();
        while (iterator2.hasNext()) {
            EnumVariantLight enumVariantLight;
            Object element$iv$iv;
            Object element$iv = element$iv$iv = iterator2.next();
            boolean bl = false;
            RsEnumVariantStub it2 = (RsEnumVariantStub)element$iv;
            boolean bl2 = false;
            if (it2.getName() == null) {
                enumVariantLight = null;
            } else {
                String string;
                boolean bl3 = it2.getBlockFields() != null;
                boolean bl4 = modOrEnumItemLight.isDeeplyEnabledByCfg() && RsDocAndAttributeOwnerKt.isEnabledByCfgSelf(it2, this.crate);
                enumVariantLight = new EnumVariantLight(string, bl4, bl3);
            }
            if (enumVariantLight == null) continue;
            EnumVariantLight it$iv = enumVariantLight;
            boolean bl5 = false;
            destination$iv.add(it$iv);
        }
        List $this$sortBy$iv = variants = (List)destination$iv;
        boolean $i$f$sortBy = false;
        if ($this$sortBy$iv.size() > 1) {
            CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    EnumVariantLight it2 = (EnumVariantLight)a;
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)it2.getName());
                    it2 = (EnumVariantLight)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it2.getName())));
                }
            });
        }
        ((Collection)this.modData.getEnums()).add(new EnumLight(modOrEnumItemLight, variants));
    }

    @Override
    public void collectImport(@NotNull ImportLight importLight) {
        Intrinsics.checkNotNullParameter((Object)importLight, (String)"import");
        ((Collection)this.modData.getImports()).add(importLight);
    }

    @Override
    public void collectUnnamedConst(@NotNull RsConstantStub rsConstantStub, int macroIndexInParent) {
        Intrinsics.checkNotNullParameter((Object)rsConstantStub, (String)"const");
    }

    @Override
    public void collectMacroCall(@NotNull MacroCallLight call2, @NotNull RsMacroCallStub stub) {
        Intrinsics.checkNotNullParameter((Object)call2, (String)"call");
        Intrinsics.checkNotNullParameter((Object)stub, (String)"stub");
        ((Collection)this.modData.getMacroCalls()).add(call2);
    }

    @Override
    public void collectProcMacroCall(@NotNull ProcMacroCallLight call2, @NotNull StubElement<?> stub) {
        Intrinsics.checkNotNullParameter((Object)call2, (String)"call");
        Intrinsics.checkNotNullParameter(stub, (String)"stub");
        ((Collection)this.modData.getProcMacroCalls()).add(call2);
    }

    @Override
    public void collectMacroDef(@NotNull MacroDefLight def, @NotNull StubElement<?> stub) {
        Intrinsics.checkNotNullParameter((Object)def, (String)"def");
        Intrinsics.checkNotNullParameter(stub, (String)"stub");
        ((Collection)this.modData.getMacroDefs()).add(def);
    }

    @Override
    public void collectMacro2Def(@NotNull Macro2DefLight def, @NotNull StubElement<?> stub) {
        Intrinsics.checkNotNullParameter((Object)def, (String)"def");
        Intrinsics.checkNotNullParameter(stub, (String)"stub");
        ((Collection)this.modData.getMacro2Defs()).add(def);
    }

    @Override
    public void collectImplItem(@NotNull ImplItemLight impl, @NotNull RsImplItemStub stub) {
        Intrinsics.checkNotNullParameter((Object)impl, (String)"impl");
        Intrinsics.checkNotNullParameter((Object)stub, (String)"stub");
        ((Collection)this.modData.getImpls()).add(impl);
    }

    @Override
    public void collectTypeAlias(@NotNull TypeAliasItemLight typeAlias, @NotNull RsTypeAliasStub stub) {
        Intrinsics.checkNotNullParameter((Object)typeAlias, (String)"typeAlias");
        Intrinsics.checkNotNullParameter((Object)stub, (String)"stub");
        ((Collection)this.modData.getTypeAliases()).add(typeAlias);
    }

    @Override
    public void afterCollectMod() {
        HashCode fileHash = FileModificationTrackerKt.access$calculateModHash(this.modData, this.stdlibAttributes);
        this.hashCalculator.onCollectMod(this.fileRelativePath, fileHash);
    }

    private final void collectMod(RsModItemStub mod, String modName, boolean isDeeplyEnabledByCfg) {
        String fileRelativePath = this.fileRelativePath + "::" + modName;
        ModLightCollector visitor2 = new ModLightCollector(this.crate, this.hashCalculator, fileRelativePath, true, null);
        ModCollectorBase.Companion.collectMod$default(ModCollectorBase.Companion, (StubElement)mod, isDeeplyEnabledByCfg, visitor2, this.crate, false, 16, null);
    }
}

