/*
 * Decompiled with CFR 0.152.
 */
package org.rust.lang.core.resolve2;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectCloseListener;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SlowOperations;
import java.io.Closeable;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.rust.lang.core.resolve2.MacroErrorCollectorKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lorg/rust/lang/core/resolve2/MacroErrorReportGenerator;", "Lcom/intellij/openapi/project/ProjectCloseListener;", "<init>", "()V", "projectClosing", "", "project", "Lcom/intellij/openapi/project/Project;", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nMacroErrorCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MacroErrorCollector.kt\norg/rust/lang/core/resolve2/MacroErrorReportGenerator\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 Timing.kt\nkotlin/system/TimingKt\n*L\n1#1,560:1\n23#2:561\n29#3,3:562\n29#3,3:565\n*S KotlinDebug\n*F\n+ 1 MacroErrorCollector.kt\norg/rust/lang/core/resolve2/MacroErrorReportGenerator\n*L\n150#1:561\n155#1:562,3\n165#1:565,3\n*E\n"})
public final class MacroErrorReportGenerator
implements ProjectCloseListener {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void projectClosing(@NotNull Project project) {
        Object it2;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (!MacroErrorCollectorKt.access$getUseDetailedMacroErrorCollecting$p()) {
            return;
        }
        long generationStart = System.currentTimeMillis();
        AutoCloseable autoCloseable = (AutoCloseable)SlowOperations.knownIssue((String)"");
        Throwable throwable = null;
        try {
            it2 = (AccessToken)autoCloseable;
            boolean bl = false;
            it2 = MacroErrorCollectorKt.generateMacroErrorsReportFor$default(project, false, 2, null);
        }
        catch (Throwable bl) {
            throwable = bl;
            throw bl;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        Object generateReport = it2;
        long generatingDuration = System.currentTimeMillis() - generationStart;
        MacroErrorReportGenerator $this$thisLogger$iv = this;
        boolean $i$f$thisLogger22 = false;
        Logger logger = Logger.getInstance(MacroErrorReportGenerator.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        Logger logger2 = logger;
        logger2.info("Generating macro errors report took " + StringUtil.formatDuration((long)generatingDuration));
        if (generateReport.isEmpty()) {
            return;
        }
        Path path = PathManager.getLogDir();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getLogDir(...)");
        Path $i$f$thisLogger22 = path;
        Path path2 = $i$f$thisLogger22.resolve("macro-expansion-errors.json");
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
        Path reportPath = path2;
        boolean $i$f$measureTimeMillis = false;
        long start$iv22 = System.currentTimeMillis();
        boolean bl = false;
        Object object = reportPath;
        Object object2 = Charsets.UTF_8;
        OpenOption[] openOptionArray = new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING};
        object = new OutputStreamWriter(Files.newOutputStream((Path)object, Arrays.copyOf(openOptionArray, openOptionArray.length)), (Charset)object2);
        object2 = null;
        try {
            OutputStreamWriter it3 = (OutputStreamWriter)object;
            boolean bl2 = false;
            ObjectWriter mapper = MacroErrorCollectorKt.createMacroErrorsReportObjectMapper().writerWithDefaultPrettyPrinter();
            mapper.writeValue((Writer)it3, generateReport);
            it3 = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            object2 = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
        }
        long writingDuration = System.currentTimeMillis() - start$iv22;
        logger2.info("Writing macro error report to " + reportPath + ". It took " + StringUtil.formatDuration((long)writingDuration));
        Path path3 = PathManager.getLogDir();
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"getLogDir(...)");
        Path start$iv22 = path3;
        Path path4 = start$iv22.resolve("macro-expansion-errors.yaml");
        Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"resolve(...)");
        Path reportPathYaml = path4;
        boolean $i$f$measureTimeMillis2 = false;
        long start$iv = System.currentTimeMillis();
        boolean bl3 = false;
        Object object3 = reportPathYaml;
        Object object4 = Charsets.UTF_8;
        Unit unit = new Unit[]{StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING};
        object3 = new OutputStreamWriter(Files.newOutputStream((Path)object3, Arrays.copyOf(unit, ((OpenOption[])unit).length)), (Charset)object4);
        object4 = null;
        try {
            OutputStreamWriter it4 = (OutputStreamWriter)object3;
            boolean bl4 = false;
            ObjectWriter mapper = MacroErrorCollectorKt.access$configureForReport((ObjectMapper)new YAMLMapper()).writerWithDefaultPrettyPrinter();
            mapper.writeValue((Writer)it4, generateReport);
            unit = Unit.INSTANCE;
        }
        catch (Throwable throwable3) {
            object4 = throwable3;
            throw throwable3;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object3, (Throwable)object4);
        }
        long writingDurationYaml = System.currentTimeMillis() - start$iv;
        logger2.info("Writing macro error report to " + reportPathYaml + ". It took " + StringUtil.formatDuration((long)writingDurationYaml));
    }
}

