/*
 * Decompiled with CFR 0.152.
 */
package org.rust.lang.core.resolve2;

import com.intellij.util.io.DigestUtil;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.lang.core.crate.Crate;
import org.rust.lang.core.psi.RsFile;
import org.rust.lang.core.resolve2.ModLightCollector;
import org.rust.lang.core.resolve2.ModVisitor;
import org.rust.stdext.HashCode;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u0016B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010J\u0016\u0010\u0011\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0014J\u0006\u0010\u0015\u001a\u00020\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/rust/lang/core/resolve2/HashCalculator;", "", "isEnabledByCfgInner", "", "<init>", "(Z)V", "modulesHash", "", "Lorg/rust/lang/core/resolve2/HashCalculator$ModHash;", "getVisitor", "Lorg/rust/lang/core/resolve2/ModVisitor;", "crate", "Lorg/rust/lang/core/crate/Crate;", "fileRelativePath", "", "stdlibAttributes", "Lorg/rust/lang/core/psi/RsFile$Attributes;", "onCollectMod", "", "hash", "Lorg/rust/stdext/HashCode;", "getFileHash", "ModHash", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nFileModificationTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileModificationTracker.kt\norg/rust/lang/core/resolve2/HashCalculator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,261:1\n1011#2,2:262\n*S KotlinDebug\n*F\n+ 1 FileModificationTracker.kt\norg/rust/lang/core/resolve2/HashCalculator\n*L\n124#1:262,2\n*E\n"})
public final class HashCalculator {
    private final boolean isEnabledByCfgInner;
    @NotNull
    private final List<ModHash> modulesHash;

    public HashCalculator(boolean isEnabledByCfgInner) {
        this.isEnabledByCfgInner = isEnabledByCfgInner;
        this.modulesHash = new ArrayList();
    }

    @NotNull
    public final ModVisitor getVisitor(@NotNull Crate crate, @NotNull String fileRelativePath, @Nullable RsFile.Attributes stdlibAttributes) {
        Intrinsics.checkNotNullParameter((Object)crate, (String)"crate");
        Intrinsics.checkNotNullParameter((Object)fileRelativePath, (String)"fileRelativePath");
        return new ModLightCollector(crate, this, fileRelativePath, false, stdlibAttributes, 8, null);
    }

    public final void onCollectMod(@NotNull String fileRelativePath, @NotNull HashCode hash) {
        Intrinsics.checkNotNullParameter((Object)fileRelativePath, (String)"fileRelativePath");
        Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
        ((Collection)this.modulesHash).add(new ModHash(fileRelativePath, hash));
    }

    @NotNull
    public final HashCode getFileHash() {
        List<ModHash> $this$sortBy$iv = this.modulesHash;
        boolean $i$f$sortBy = false;
        if ($this$sortBy$iv.size() > 1) {
            CollectionsKt.sortWith($this$sortBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    ModHash it2 = (ModHash)a;
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)it2.getFileRelativePath());
                    it2 = (ModHash)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it2.getFileRelativePath())));
                }
            });
        }
        MessageDigest digest = DigestUtil.sha1();
        for (ModHash modHash : this.modulesHash) {
            String fileRelativePath = modHash.component1();
            HashCode modHash2 = modHash.component2();
            String string = fileRelativePath;
            byte[] byArray = string.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            digest.update(byArray);
            digest.update(modHash2.toByteArray());
        }
        digest.update(this.isEnabledByCfgInner ? (byte)1 : 0);
        byte[] byArray = digest.digest();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"digest(...)");
        return HashCode.Companion.fromByteArray(byArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lorg/rust/lang/core/resolve2/HashCalculator$ModHash;", "", "fileRelativePath", "", "hash", "Lorg/rust/stdext/HashCode;", "<init>", "(Ljava/lang/String;Lorg/rust/stdext/HashCode;)V", "getFileRelativePath", "()Ljava/lang/String;", "getHash", "()Lorg/rust/stdext/HashCode;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.rustrover.core"})
    private static final class ModHash {
        @NotNull
        private final String fileRelativePath;
        @NotNull
        private final HashCode hash;

        public ModHash(@NotNull String fileRelativePath, @NotNull HashCode hash) {
            Intrinsics.checkNotNullParameter((Object)fileRelativePath, (String)"fileRelativePath");
            Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
            this.fileRelativePath = fileRelativePath;
            this.hash = hash;
        }

        @NotNull
        public final String getFileRelativePath() {
            return this.fileRelativePath;
        }

        @NotNull
        public final HashCode getHash() {
            return this.hash;
        }

        @NotNull
        public final String component1() {
            return this.fileRelativePath;
        }

        @NotNull
        public final HashCode component2() {
            return this.hash;
        }

        @NotNull
        public final ModHash copy(@NotNull String fileRelativePath, @NotNull HashCode hash) {
            Intrinsics.checkNotNullParameter((Object)fileRelativePath, (String)"fileRelativePath");
            Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
            return new ModHash(fileRelativePath, hash);
        }

        public static /* synthetic */ ModHash copy$default(ModHash modHash, String string, HashCode hashCode, int n, Object object) {
            if ((n & 1) != 0) {
                string = modHash.fileRelativePath;
            }
            if ((n & 2) != 0) {
                hashCode = modHash.hash;
            }
            return modHash.copy(string, hashCode);
        }

        @NotNull
        public String toString() {
            return "ModHash(fileRelativePath=" + this.fileRelativePath + ", hash=" + this.hash + ")";
        }

        public int hashCode() {
            int result2 = this.fileRelativePath.hashCode();
            result2 = result2 * 31 + this.hash.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ModHash)) {
                return false;
            }
            ModHash modHash = (ModHash)other;
            if (!Intrinsics.areEqual((Object)this.fileRelativePath, (Object)modHash.fileRelativePath)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.hash, (Object)modHash.hash);
        }
    }
}

