/*
 * Decompiled with CFR 0.152.
 */
package org.rust.lang.core.resolve2;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.stubs.StubElement;
import com.intellij.util.io.DigestUtil;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.OutputStream;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.rust.lang.core.crate.Crate;
import org.rust.lang.core.macros.MacroExpansionKt;
import org.rust.lang.core.psi.RsFile;
import org.rust.lang.core.psi.ext.RsDocAndAttributeOwnerKt;
import org.rust.lang.core.resolve2.CrateDefMap;
import org.rust.lang.core.resolve2.FileInfo;
import org.rust.lang.core.resolve2.HashCalculator;
import org.rust.lang.core.resolve2.ModCollectorBase;
import org.rust.lang.core.resolve2.ModCollectorKt;
import org.rust.lang.core.resolve2.ModDataLight;
import org.rust.lang.core.resolve2.ModLightCollector;
import org.rust.lang.core.resolve2.Writeable;
import org.rust.lang.core.stubs.RsFileStub;
import org.rust.openapiext.UtilsKt;
import org.rust.stdext.HashCode;
import org.rust.stdext.IoKt;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000P\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u001a\u001e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r\u001a\u001a\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002\u001a\u001a\u0010\u0014\u001a\u00020\u0015*\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0002\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0006\u00a8\u0006\u001a"}, d2={"modificationStampForResolve", "", "Lorg/rust/lang/core/psi/RsFile;", "getModificationStampForResolve", "(Lorg/rust/lang/core/psi/RsFile;)J", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lcom/intellij/openapi/vfs/VirtualFile;)J", "isFileChanged", "", "file", "defMap", "Lorg/rust/lang/core/resolve2/CrateDefMap;", "crate", "Lorg/rust/lang/core/crate/Crate;", "calculateModHash", "Lorg/rust/stdext/HashCode;", "modData", "Lorg/rust/lang/core/resolve2/ModDataLight;", "stdlibAttributes", "Lorg/rust/lang/core/psi/RsFile$Attributes;", "writeElements", "", "Ljava/io/DataOutput;", "elements", "", "Lorg/rust/lang/core/resolve2/Writeable;", "intellij.rustrover.core"})
public final class FileModificationTrackerKt {
    public static final long getModificationStampForResolve(@NotNull RsFile $this$modificationStampForResolve) {
        long l;
        Intrinsics.checkNotNullParameter((Object)$this$modificationStampForResolve, (String)"<this>");
        if (MacroExpansionKt.isIncludedNonRustFile((PsiFile)$this$modificationStampForResolve)) {
            VirtualFile virtualFile = $this$modificationStampForResolve.getVirtualFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
            l = FileModificationTrackerKt.getModificationStampForResolve(virtualFile);
        } else {
            l = $this$modificationStampForResolve.getViewProvider().getModificationStamp();
        }
        return l;
    }

    public static final long getModificationStampForResolve(@NotNull VirtualFile $this$modificationStampForResolve) {
        Intrinsics.checkNotNullParameter((Object)$this$modificationStampForResolve, (String)"<this>");
        Document document = UtilsKt.getDocument(VirtualFileUtil.originalFileOrSelf((VirtualFile)$this$modificationStampForResolve));
        return document != null ? document.getModificationStamp() : 0L;
    }

    public static final boolean isFileChanged(@NotNull RsFile file, @NotNull CrateDefMap defMap, @NotNull Crate crate) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)defMap, (String)"defMap");
        Intrinsics.checkNotNullParameter((Object)crate, (String)"crate");
        Map<Integer, FileInfo> map2 = defMap.getFileInfos();
        VirtualFile virtualFile = file.getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
        FileInfo fileInfo = map2.get(UtilsKt.getFileId(VirtualFileUtil.originalFileOrSelf((VirtualFile)virtualFile)));
        if (fileInfo == null) {
            boolean bl = false;
            if (UtilsKt.isUnitTestMode()) {
                throw new IllegalStateException(("Can't find fileInfo for " + file.getVirtualFile() + " in " + defMap).toString());
            }
            return false;
        }
        FileInfo fileInfo2 = fileInfo;
        boolean isCrateRoot = Intrinsics.areEqual((Object)file.getVirtualFile(), (Object)crate.getRootModFile());
        if (isCrateRoot && file.getRecursionLimit(crate) != defMap.getRecursionLimitRaw()) {
            return true;
        }
        boolean isEnabledByCfgInner = RsDocAndAttributeOwnerKt.isEnabledByCfgSelf(file, crate);
        boolean isDeeplyEnabledByCfg = fileInfo2.getModData().isDeeplyEnabledByCfgOuter() && isEnabledByCfgInner;
        HashCalculator hashCalculator = new HashCalculator(isEnabledByCfgInner);
        ModLightCollector visitor2 = new ModLightCollector(crate, hashCalculator, "", true, isCrateRoot ? file.getStdlibAttributes(crate) : null);
        RsFileStub rsFileStub = ModCollectorKt.getOrBuildFileStub(file);
        if (rsFileStub == null) {
            return false;
        }
        RsFileStub fileStub = rsFileStub;
        ModCollectorBase.Companion.collectMod$default(ModCollectorBase.Companion, (StubElement)fileStub, isDeeplyEnabledByCfg, visitor2, crate, false, 16, null);
        return !Intrinsics.areEqual((Object)hashCalculator.getFileHash(), (Object)fileInfo2.getHash());
    }

    private static final HashCode calculateModHash(ModDataLight modData, RsFile.Attributes stdlibAttributes) {
        MessageDigest digest = DigestUtil.sha1();
        DataOutputStream data2 = new DataOutputStream(new DigestOutputStream(OutputStream.nullOutputStream(), digest));
        modData.sort();
        FileModificationTrackerKt.writeElements(data2, modData.getItems());
        FileModificationTrackerKt.writeElements(data2, modData.getEnums());
        FileModificationTrackerKt.writeElements(data2, modData.getImports());
        FileModificationTrackerKt.writeElements(data2, modData.getMacroCalls());
        FileModificationTrackerKt.writeElements(data2, modData.getProcMacroCalls());
        FileModificationTrackerKt.writeElements(data2, modData.getMacroDefs());
        FileModificationTrackerKt.writeElements(data2, modData.getMacro2Defs());
        FileModificationTrackerKt.writeElements(data2, modData.getImpls());
        FileModificationTrackerKt.writeElements(data2, modData.getTypeAliases());
        RsFile.Attributes attributes = stdlibAttributes;
        data2.writeByte(attributes != null ? attributes.ordinal() : RsFile.Attributes.getEntries().size());
        byte[] byArray = digest.digest();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"digest(...)");
        return HashCode.Companion.fromByteArray(byArray);
    }

    private static final void writeElements(DataOutput $this$writeElements, List<? extends Writeable> elements2) {
        IoKt.writeVarInt($this$writeElements, elements2.size());
        for (Writeable writeable : elements2) {
            writeable.writeTo($this$writeElements);
        }
    }

    public static final /* synthetic */ HashCode access$calculateModHash(ModDataLight modData, RsFile.Attributes stdlibAttributes) {
        return FileModificationTrackerKt.calculateModHash(modData, stdlibAttributes);
    }

    public static final /* synthetic */ void access$writeElements(DataOutput $receiver, List elements2) {
        FileModificationTrackerKt.writeElements($receiver, elements2);
    }
}

