/*
 * Decompiled with CFR 0.152.
 */
package org.rust.lang.core.resolve2;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.vfs.AsyncFileListener;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.messages.MessageBusConnection;
import java.lang.ref.WeakReference;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.sync.Mutex;
import kotlinx.coroutines.sync.MutexKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.cargo.project.model.CargoProjectsService;
import org.rust.lang.RsFileType;
import org.rust.lang.core.crate.Crate;
import org.rust.lang.core.macros.MacroExpansionManagerKt;
import org.rust.lang.core.macros.MacroExpansionMode;
import org.rust.lang.core.psi.RsFile;
import org.rust.lang.core.psi.RsPsiManagerKt;
import org.rust.lang.core.psi.RsPsiTreeChangeAdapter;
import org.rust.lang.core.psi.RsPsiTreeChangeEvent;
import org.rust.lang.core.psi.RustPsiChangeListener;
import org.rust.lang.core.resolve2.ChangedFile;
import org.rust.lang.core.resolve2.CrateDefMap;
import org.rust.lang.core.resolve2.DefMapHolder;
import org.rust.stdext.UtilsKt;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\f\b\u0007\u0018\u0000 C2\u00020\u0001:\u0002BCB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010!\u001a\u00020\"H\u0002J\u0012\u0010#\u001a\u00020\f2\n\u0010$\u001a\u00060\nj\u0002`\u000bJ\u0012\u0010%\u001a\u00020&2\n\u0010$\u001a\u00060\nj\u0002`\u000bJ\u001c\u0010'\u001a\u00020\"2\n\u0010$\u001a\u00060\nj\u0002`\u000b2\b\u0010(\u001a\u0004\u0018\u00010)J\u0012\u0010*\u001a\u00020&2\n\u0010+\u001a\u00060\nj\u0002`\u0013J\u001e\u0010/\u001a\u00020\"2\n\u0010$\u001a\u00060\nj\u0002`\u000b2\b\u0010(\u001a\u0004\u0018\u00010)H\u0002J\u0010\u00100\u001a\u00020\"2\u0006\u00101\u001a\u000202H\u0002J\u0010\u00103\u001a\u00020\"2\u0006\u00101\u001a\u000204H\u0002J\u0014\u00103\u001a\u00020\"2\n\u0010+\u001a\u00060\nj\u0002`\u0013H\u0002J\u0010\u00105\u001a\u00020\"2\b\u00101\u001a\u0004\u0018\u000106J\u0018\u00107\u001a\f\u0012\b\u0012\u00060\nj\u0002`\u000b082\u0006\u00101\u001a\u000204J\u0006\u00109\u001a\u00020\"J\u0012\u0010:\u001a\u00020\"2\n\u0010;\u001a\u00060\nj\u0002`\u000bJ\b\u0010<\u001a\u00020\"H\u0002J\u0014\u0010=\u001a\u00020\"2\f\u0010>\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bJ\u0006\u0010?\u001a\u00020\"J\u0006\u0010@\u001a\u00020&J\b\u0010A\u001a\u00020\"H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001e\u0010\b\u001a\u0012\u0012\b\u0012\u00060\nj\u0002`\u000b\u0012\u0004\u0012\u00020\f0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\"\u0010\u0011\u001a\u0016\u0012\b\u0012\u00060\nj\u0002`\u0013\u0012\b\u0012\u00060\nj\u0002`\u000b0\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0014\u001a\u0016\u0012\b\u0012\u00060\nj\u0002`\u0013\u0012\b\u0012\u00060\nj\u0002`\u000b0\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0015\u001a\u0012\u0012\u0004\u0012\u00020\u0017\u0012\b\u0012\u00060\nj\u0002`\u000b0\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0018\u001a\u0016\u0012\u0012\u0012\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001c0\u001b\u0018\u00010\u001a0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010,\u001a\u00020&8F\u00a2\u0006\u0006\u001a\u0004\b-\u0010.\u00a8\u0006D"}, d2={"Lorg/rust/lang/core/resolve2/DefMapService;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "defMaps", "Ljava/util/concurrent/ConcurrentMap;", "", "Lorg/rust/lang/core/crate/CratePersistentId;", "Lorg/rust/lang/core/resolve2/DefMapHolder;", "defMapsBuildLock", "Lkotlinx/coroutines/sync/Mutex;", "getDefMapsBuildLock", "()Lkotlinx/coroutines/sync/Mutex;", "fileIdToCrateId", "Lcom/intellij/util/containers/MultiMap;", "Lorg/rust/lang/core/resolve2/FileId;", "managedNonRustFiles", "missedFiles", "Ljava/util/concurrent/ConcurrentHashMap;", "Ljava/nio/file/Path;", "lastCheckedTopSortedCrates", "Ljava/util/concurrent/atomic/AtomicReference;", "Ljava/lang/ref/WeakReference;", "", "Lorg/rust/lang/core/crate/Crate;", "structureModificationTracker", "Lcom/intellij/openapi/util/ModificationTracker;", "allDefMapsUpdatedStamp", "", "setupListeners", "", "getDefMapHolder", "crate", "hasDefMapFor", "", "setDefMap", "defMap", "Lorg/rust/lang/core/resolve2/CrateDefMap;", "isManagedNonRustFile", "fileId", "hasManagedNonRustFiles", "getHasManagedNonRustFiles", "()Z", "updateFilesMaps", "onFileAdded", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "onFileRemoved", "Lorg/rust/lang/core/psi/RsFile;", "onFileChanged", "Lorg/rust/lang/core/resolve2/ChangedFile;", "findCrates", "", "scheduleRebuildAllDefMaps", "scheduleRebuildDefMap", "crateId", "scheduleRecheckAllDefMaps", "removeStaleDefMaps", "allCrates", "setAllDefMapsUpToDate", "areAllDefMapsUpToDate", "dispose", "DefMapSignificantChangeDetector", "Companion", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nDefMapService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefMapService.kt\norg/rust/lang/core/resolve2/DefMapService\n+ 2 Collections.kt\norg/rust/stdext/CollectionsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,431:1\n150#2:432\n1634#3,3:433\n*S KotlinDebug\n*F\n+ 1 DefMapService.kt\norg/rust/lang/core/resolve2/DefMapService\n*L\n304#1:432\n304#1:433,3\n*E\n"})
public final class DefMapService
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final ConcurrentMap<Integer, DefMapHolder> defMaps;
    @NotNull
    private final Mutex defMapsBuildLock;
    @NotNull
    private final MultiMap<Integer, Integer> fileIdToCrateId;
    @NotNull
    private final MultiMap<Integer, Integer> managedNonRustFiles;
    @NotNull
    private final ConcurrentHashMap<Path, Integer> missedFiles;
    @NotNull
    private final AtomicReference<WeakReference<List<Crate>>> lastCheckedTopSortedCrates;
    @NotNull
    private final ModificationTracker structureModificationTracker;
    private volatile long allDefMapsUpdatedStamp;
    @NotNull
    private static final AtomicInteger nextNonCargoCrateId = new AtomicInteger(-1);

    public DefMapService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.defMaps = new ConcurrentHashMap();
        this.defMapsBuildLock = MutexKt.Mutex$default((boolean)false, (int)1, null);
        MultiMap multiMap = MultiMap.createConcurrent();
        Intrinsics.checkNotNullExpressionValue((Object)multiMap, (String)"createConcurrent(...)");
        this.fileIdToCrateId = multiMap;
        MultiMap multiMap2 = MultiMap.createConcurrent();
        Intrinsics.checkNotNullExpressionValue((Object)multiMap2, (String)"createConcurrent(...)");
        this.managedNonRustFiles = multiMap2;
        this.missedFiles = new ConcurrentHashMap();
        this.lastCheckedTopSortedCrates = new AtomicReference<Object>(null);
        this.structureModificationTracker = RsPsiManagerKt.getRustPsiManager(this.project).getRustStructureModificationTracker();
        this.allDefMapsUpdatedStamp = -1L;
        this.setupListeners();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final Mutex getDefMapsBuildLock() {
        return this.defMapsBuildLock;
    }

    private final void setupListeners() {
        DefMapSignificantChangeDetector changeDetector = new DefMapSignificantChangeDetector();
        PsiManager.getInstance((Project)this.project).addPsiTreeChangeListener((PsiTreeChangeListener)changeDetector, (Disposable)this);
        VirtualFileManager.getInstance().addAsyncFileListener((AsyncFileListener)changeDetector, (Disposable)this);
        MessageBusConnection connection = this.project.getMessageBus().connect();
        RsPsiManagerKt.getRustPsiManager(this.project).subscribeRustPsiChange(connection, new RustPsiChangeListener(this){
            final /* synthetic */ DefMapService this$0;
            {
                this.this$0 = $receiver;
            }

            public void rustPsiChanged(PsiFile file, PsiElement element, boolean isStructureModification) {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                if (file instanceof RsFile && !(MacroExpansionManagerKt.getMacroExpansionManager(this.this$0.getProject()).getMacroExpansionMode() instanceof MacroExpansionMode.New)) {
                    this.this$0.onFileChanged(ChangedFile.Companion.rustFile((RsFile)file));
                }
            }
        });
        connection.subscribe(CargoProjectsService.Companion.getCARGO_PROJECTS_TOPIC(), (arg_0, arg_1) -> DefMapService.setupListeners$lambda$0(this, arg_0, arg_1));
    }

    @NotNull
    public final DefMapHolder getDefMapHolder(int crate) {
        DefMapHolder defMapHolder = this.defMaps.computeIfAbsent(crate, arg_0 -> DefMapService.getDefMapHolder$lambda$1(arg_0 -> DefMapService.getDefMapHolder$lambda$0(crate, this, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)defMapHolder, (String)"computeIfAbsent(...)");
        return defMapHolder;
    }

    public final boolean hasDefMapFor(int crate) {
        return this.defMaps.get(crate) != null;
    }

    public final void setDefMap(int crate, @Nullable CrateDefMap defMap) {
        this.updateFilesMaps(crate, defMap);
        DefMapHolder holder = this.getDefMapHolder(crate);
        holder.setDefMap(defMap);
    }

    public final boolean isManagedNonRustFile(int fileId) {
        Collection collection = this.managedNonRustFiles.get((Object)fileId);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"get(...)");
        return !collection.isEmpty();
    }

    public final boolean getHasManagedNonRustFiles() {
        return !this.managedNonRustFiles.isEmpty();
    }

    private final void updateFilesMaps(int crate, CrateDefMap defMap) {
        this.fileIdToCrateId.values().removeIf(arg_0 -> DefMapService.updateFilesMaps$lambda$1(arg_0 -> DefMapService.updateFilesMaps$lambda$0(crate, arg_0), arg_0));
        this.managedNonRustFiles.values().removeIf(arg_0 -> DefMapService.updateFilesMaps$lambda$3(arg_0 -> DefMapService.updateFilesMaps$lambda$2(crate, arg_0), arg_0));
        this.missedFiles.values().removeIf(arg_0 -> DefMapService.updateFilesMaps$lambda$5(arg_0 -> DefMapService.updateFilesMaps$lambda$4(crate, arg_0), arg_0));
        if (defMap != null) {
            Iterator<Comparable<Integer>> iterator2 = defMap.getFileInfos().keySet().iterator();
            while (iterator2.hasNext()) {
                int fileId = ((Number)iterator2.next()).intValue();
                this.fileIdToCrateId.putValue((Object)fileId, (Object)crate);
            }
            for (Path missedFile : defMap.getMissedFiles()) {
                ((Map)this.missedFiles).put(missedFile, crate);
            }
            iterator2 = defMap.getNonRustIncludedFiles().iterator();
            while (iterator2.hasNext()) {
                int nonRustFileId = ((Number)((Object)iterator2.next())).intValue();
                this.managedNonRustFiles.putValue((Object)nonRustFileId, (Object)crate);
            }
        }
    }

    private final void onFileAdded(VirtualFile file) {
        org.rust.openapiext.UtilsKt.checkWriteAccessAllowed();
        Path path = org.rust.openapiext.UtilsKt.getPathAsPath(VirtualFileUtil.originalFileOrSelf((VirtualFile)file));
        Integer n = this.missedFiles.get(path);
        if (n == null) {
            return;
        }
        int crate = n;
        this.getDefMapHolder(crate).setShouldRebuild(true);
    }

    private final void onFileRemoved(RsFile file) {
        org.rust.openapiext.UtilsKt.checkWriteAccessAllowed();
        Iterator<Integer> iterator2 = this.findCrates(file).iterator();
        while (iterator2.hasNext()) {
            int crate = ((Number)iterator2.next()).intValue();
            this.getDefMapHolder(crate).setShouldRebuild(true);
        }
    }

    private final void onFileRemoved(int fileId) {
        org.rust.openapiext.UtilsKt.checkWriteAccessAllowed();
        for (Integer crate : this.fileIdToCrateId.get((Object)fileId)) {
            Intrinsics.checkNotNull((Object)crate);
            this.getDefMapHolder(crate).setShouldRebuild(true);
        }
    }

    public final void onFileChanged(@Nullable ChangedFile file) {
        if (file == null) {
            return;
        }
        org.rust.openapiext.UtilsKt.checkWriteAccessAllowed();
        for (Integer crate : this.fileIdToCrateId.get((Object)file.getId())) {
            Intrinsics.checkNotNull((Object)crate);
            this.getDefMapHolder(crate).addChangedFile(file);
        }
    }

    @NotNull
    public final Collection<Integer> findCrates(@NotNull RsFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        VirtualFile virtualFile = file.getVirtualFile();
        VirtualFile virtualFile2 = virtualFile != null ? VirtualFileUtil.originalFileOrSelf((VirtualFile)virtualFile) : null;
        VirtualFileWithId virtualFileWithId = virtualFile2 instanceof VirtualFileWithId ? (VirtualFileWithId)virtualFile2 : null;
        if (virtualFileWithId == null) {
            return CollectionsKt.emptyList();
        }
        VirtualFileWithId virtualFile3 = virtualFileWithId;
        Collection collection = this.fileIdToCrateId.get((Object)virtualFile3.getId());
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"get(...)");
        return collection;
    }

    public final void scheduleRebuildAllDefMaps() {
        for (DefMapHolder defMapHolder : this.defMaps.values()) {
            defMapHolder.setShouldRebuild(true);
        }
    }

    public final void scheduleRebuildDefMap(int crateId) {
        DefMapHolder holder = this.getDefMapHolder(crateId);
        holder.setShouldRebuild(true);
    }

    private final void scheduleRecheckAllDefMaps() {
        org.rust.openapiext.UtilsKt.checkWriteAccessAllowed();
        for (DefMapHolder defMapHolder : this.defMaps.values()) {
            defMapHolder.setShouldRecheck(true);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void removeStaleDefMaps(@NotNull List<? extends Crate> allCrates) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(allCrates, (String)"allCrates");
        WeakReference<List<? extends Crate>> weakReference = this.lastCheckedTopSortedCrates.getAndSet(new WeakReference<List<? extends Crate>>(allCrates));
        if ((weakReference != null ? (List)weakReference.get() : null) == allCrates) {
            return;
        }
        Iterable $this$mapToSet$iv = allCrates;
        boolean $i$f$mapToSet = false;
        Iterable iterable = $this$mapToSet$iv;
        Collection destination$iv$iv = new HashSet(org.rust.stdext.CollectionsKt.mapCapacity(org.rust.stdext.CollectionsKt.collectionSizeOrDefault($this$mapToSet$iv, 10)));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            Crate crate = (Crate)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it2.getId());
        }
        Set allCrateIds = (Set)destination$iv$iv;
        HashSet staleCrates = new HashSet();
        this.defMaps.keySet().removeIf(arg_0 -> DefMapService.removeStaleDefMaps$lambda$2(arg_0 -> DefMapService.removeStaleDefMaps$lambda$1(allCrateIds, staleCrates, arg_0), arg_0));
        this.fileIdToCrateId.values().removeIf(arg_0 -> DefMapService.removeStaleDefMaps$lambda$4(arg_0 -> DefMapService.removeStaleDefMaps$lambda$3(staleCrates, arg_0), arg_0));
        this.missedFiles.values().removeIf(arg_0 -> DefMapService.removeStaleDefMaps$lambda$6(arg_0 -> DefMapService.removeStaleDefMaps$lambda$5(staleCrates, arg_0), arg_0));
        this.managedNonRustFiles.values().removeIf(arg_0 -> DefMapService.removeStaleDefMaps$lambda$8(arg_0 -> DefMapService.removeStaleDefMaps$lambda$7(staleCrates, arg_0), arg_0));
    }

    public final void setAllDefMapsUpToDate() {
        this.allDefMapsUpdatedStamp = this.structureModificationTracker.getModificationCount();
    }

    public final boolean areAllDefMapsUpToDate() {
        return this.allDefMapsUpdatedStamp == this.structureModificationTracker.getModificationCount();
    }

    public void dispose() {
        this.defMaps.clear();
        this.fileIdToCrateId.clear();
    }

    private static final void setupListeners$lambda$0(DefMapService this$0, CargoProjectsService cargoProjectsService, Collection collection) {
        Intrinsics.checkNotNullParameter((Object)cargoProjectsService, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)collection, (String)"<unused var>");
        this$0.scheduleRecheckAllDefMaps();
    }

    private static final DefMapHolder getDefMapHolder$lambda$0(int $crate, DefMapService this$0, Integer it2) {
        return new DefMapHolder($crate, this$0.structureModificationTracker);
    }

    private static final DefMapHolder getDefMapHolder$lambda$1(Function1 $tmp0, Object p0) {
        return (DefMapHolder)$tmp0.invoke(p0);
    }

    private static final boolean updateFilesMaps$lambda$0(int $crate, Integer it2) {
        Integer n = it2;
        int n2 = $crate;
        return n != null && n == n2;
    }

    private static final boolean updateFilesMaps$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean updateFilesMaps$lambda$2(int $crate, Integer it2) {
        Integer n = it2;
        int n2 = $crate;
        return n != null && n == n2;
    }

    private static final boolean updateFilesMaps$lambda$3(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean updateFilesMaps$lambda$4(int $crate, Integer it2) {
        Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
        int n = $crate;
        return it2 == n;
    }

    private static final boolean updateFilesMaps$lambda$5(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean removeStaleDefMaps$lambda$1(Set $allCrateIds, HashSet $staleCrates, Integer crate) {
        boolean isStale;
        boolean bl = isStale = !$allCrateIds.contains(crate);
        if (isStale) {
            ((Collection)$staleCrates).add(crate);
        }
        return isStale;
    }

    private static final boolean removeStaleDefMaps$lambda$2(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean removeStaleDefMaps$lambda$3(HashSet $staleCrates, Integer it2) {
        return $staleCrates.contains(it2);
    }

    private static final boolean removeStaleDefMaps$lambda$4(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean removeStaleDefMaps$lambda$5(HashSet $staleCrates, Integer it2) {
        Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
        return $staleCrates.contains(it2);
    }

    private static final boolean removeStaleDefMaps$lambda$6(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean removeStaleDefMaps$lambda$7(HashSet $staleCrates, Integer it2) {
        return $staleCrates.contains(it2);
    }

    private static final boolean removeStaleDefMaps$lambda$8(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ void access$onFileRemoved(DefMapService $this, int fileId) {
        $this.onFileRemoved(fileId);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0006\u001a\u00020\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/rust/lang/core/resolve2/DefMapService$Companion;", "", "<init>", "()V", "nextNonCargoCrateId", "Ljava/util/concurrent/atomic/AtomicInteger;", "getNextNonCargoCrateId", "", "intellij.rustrover.core"})
    public static final class Companion {
        private Companion() {
        }

        public final int getNextNonCargoCrateId() {
            return nextNonCargoCrateId.decrementAndGet();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u0004\u0018\u00010\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016\u00a8\u0006\u000e"}, d2={"Lorg/rust/lang/core/resolve2/DefMapService$DefMapSignificantChangeDetector;", "Lorg/rust/lang/core/psi/RsPsiTreeChangeAdapter;", "Lcom/intellij/openapi/vfs/AsyncFileListener;", "<init>", "(Lorg/rust/lang/core/resolve2/DefMapService;)V", "handleEvent", "", "event", "Lorg/rust/lang/core/psi/RsPsiTreeChangeEvent;", "prepareChange", "Lcom/intellij/openapi/vfs/AsyncFileListener$ChangeApplier;", "events", "", "Lcom/intellij/openapi/vfs/newvfs/events/VFileEvent;", "intellij.rustrover.core"})
    @SourceDebugExtension(value={"SMAP\nDefMapService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefMapService.kt\norg/rust/lang/core/resolve2/DefMapService$DefMapSignificantChangeDetector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,431:1\n1617#2,9:432\n1869#2:441\n1870#2:443\n1626#2:444\n1617#2,9:445\n1869#2:454\n1870#2:456\n1626#2:457\n1#3:442\n1#3:455\n*S KotlinDebug\n*F\n+ 1 DefMapService.kt\norg/rust/lang/core/resolve2/DefMapService$DefMapSignificantChangeDetector\n*L\n362#1:432,9\n362#1:441\n362#1:443\n362#1:444\n371#1:445,9\n371#1:454\n371#1:456\n371#1:457\n362#1:442\n371#1:455\n*E\n"})
    private final class DefMapSignificantChangeDetector
    extends RsPsiTreeChangeAdapter
    implements AsyncFileListener {
        @Override
        public void handleEvent(@NotNull RsPsiTreeChangeEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if (event.getFile() != null) {
                return;
            }
            RsPsiTreeChangeEvent rsPsiTreeChangeEvent = event;
            if (rsPsiTreeChangeEvent instanceof RsPsiTreeChangeEvent.ChildAddition.After) {
                PsiElement psiElement2 = ((RsPsiTreeChangeEvent.ChildAddition.After)event).getChild();
                RsFile rsFile = psiElement2 instanceof RsFile ? (RsFile)psiElement2 : null;
                if (rsFile == null) {
                    return;
                }
                RsFile file = rsFile;
                VirtualFile virtualFile = file.getVirtualFile();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
                DefMapService.this.onFileAdded(virtualFile);
            } else if (rsPsiTreeChangeEvent instanceof RsPsiTreeChangeEvent.ChildRemoval.Before) {
                PsiElement psiElement3 = ((RsPsiTreeChangeEvent.ChildRemoval.Before)event).getChild();
                RsFile rsFile = psiElement3 instanceof RsFile ? (RsFile)psiElement3 : null;
                if (rsFile == null) {
                    return;
                }
                RsFile file = rsFile;
                DefMapService.this.onFileRemoved(file);
            } else if (rsPsiTreeChangeEvent instanceof RsPsiTreeChangeEvent.PropertyChange.Before) {
                if (Intrinsics.areEqual((Object)((RsPsiTreeChangeEvent.PropertyChange.Before)event).getPropertyName(), (Object)"fileName")) {
                    PsiElement psiElement4 = ((RsPsiTreeChangeEvent.PropertyChange.Before)event).getChild();
                    RsFile rsFile = psiElement4 instanceof RsFile ? (RsFile)psiElement4 : null;
                    if (rsFile == null) {
                        return;
                    }
                    RsFile file = rsFile;
                    DefMapService.this.onFileRemoved(file);
                }
            } else if (rsPsiTreeChangeEvent instanceof RsPsiTreeChangeEvent.PropertyChange.After && Intrinsics.areEqual((Object)((RsPsiTreeChangeEvent.PropertyChange.After)event).getPropertyName(), (Object)"fileName")) {
                PsiElement psiElement5 = ((RsPsiTreeChangeEvent.PropertyChange.After)event).getElement();
                RsFile rsFile = psiElement5 instanceof RsFile ? (RsFile)psiElement5 : null;
                if (rsFile == null) {
                    return;
                }
                RsFile file = rsFile;
                VirtualFile virtualFile = file.getVirtualFile();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
                DefMapService.this.onFileAdded(virtualFile);
                return;
            }
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public AsyncFileListener.ChangeApplier prepareChange(@NotNull List<? extends VFileEvent> events) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            boolean bl;
            Pair it$iv$iv;
            void $this$mapNotNullTo$iv$iv2;
            void $this$mapNotNull$iv2;
            Intrinsics.checkNotNullParameter(events, (String)"events");
            if (DefMapService.this.getProject().isDisposed()) {
                return null;
            }
            Iterable iterable = events;
            Object object = DefMapService.this;
            boolean $i$f$mapNotNull = false;
            void var6_6 = $this$mapNotNull$iv2;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv2;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Pair pair;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl2 = false;
                VFileEvent event = (VFileEvent)element$iv$iv;
                boolean bl3 = false;
                if (event instanceof VFileContentChangeEvent || event instanceof VFileCreateEvent) {
                    pair = null;
                } else {
                    VirtualFile file;
                    VirtualFile virtualFile = file = event.getFile();
                    if (Intrinsics.areEqual((Object)(virtualFile != null ? virtualFile.getFileType() : null), (Object)((Object)RsFileType.INSTANCE))) {
                        pair = null;
                    } else {
                        VirtualFileWithId virtualFileWithId = file instanceof VirtualFileWithId ? (VirtualFileWithId)file : null;
                        if (virtualFileWithId == null) {
                            pair = null;
                        } else {
                            int id = virtualFileWithId.getId();
                            pair = !((DefMapService)object).isManagedNonRustFile(id) ? null : TuplesKt.to((Object)event, (Object)id);
                        }
                    }
                }
                if (pair == null) continue;
                it$iv$iv = pair;
                bl = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List nonRustFilesEvents = (List)destination$iv$iv;
            object = events;
            DefMapService defMapService = DefMapService.this;
            boolean $i$f$mapNotNull2 = false;
            destination$iv$iv = $this$mapNotNull$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo2 = false;
            void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach2 = false;
            Iterator iterator3 = $this$forEach$iv$iv$iv2.iterator();
            while (iterator3.hasNext()) {
                VFileCreateEvent vFileCreateEvent;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator3.next();
                boolean bl4 = false;
                VFileEvent event = (VFileEvent)element$iv$iv;
                boolean bl5 = false;
                if (!(event instanceof VFileCreateEvent)) {
                    vFileCreateEvent = null;
                } else {
                    String string = ((VFileCreateEvent)event).getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                    Path path = UtilsKt.toPath(string);
                    vFileCreateEvent = !defMapService.missedFiles.containsKey(path) ? null : (VFileCreateEvent)event;
                }
                if (vFileCreateEvent == null) continue;
                it$iv$iv = vFileCreateEvent;
                bl = false;
                destination$iv$iv2.add(it$iv$iv);
            }
            List creationEvents = (List)destination$iv$iv2;
            if (nonRustFilesEvents.isEmpty() && creationEvents.isEmpty()) {
                return null;
            }
            return new AsyncFileListener.ChangeApplier(nonRustFilesEvents, DefMapService.this, creationEvents){
                final /* synthetic */ List<Pair<VFileEvent, Integer>> $nonRustFilesEvents;
                final /* synthetic */ DefMapService this$0;
                final /* synthetic */ List<VFileCreateEvent> $creationEvents;
                {
                    this.$nonRustFilesEvents = $nonRustFilesEvents;
                    this.this$0 = $receiver;
                    this.$creationEvents = $creationEvents;
                }

                public void beforeVfsChange() {
                    boolean updated = false;
                    for (Pair<VFileEvent, Integer> pair : this.$nonRustFilesEvents) {
                        VFileEvent event = (VFileEvent)pair.component1();
                        int id = ((Number)pair.component2()).intValue();
                        VFileEvent vFileEvent = event;
                        if (vFileEvent instanceof VFileDeleteEvent) {
                            DefMapService.access$onFileRemoved(this.this$0, id);
                        } else if (vFileEvent instanceof VFileMoveEvent) {
                            DefMapService.access$onFileRemoved(this.this$0, id);
                        } else {
                            if (!(vFileEvent instanceof VFilePropertyChangeEvent) || !Intrinsics.areEqual((Object)((VFilePropertyChangeEvent)event).getPropertyName(), (Object)"name")) continue;
                            DefMapService.access$onFileRemoved(this.this$0, id);
                        }
                        updated = true;
                    }
                    if (updated) {
                        RsPsiManagerKt.getRustPsiManager(this.this$0.getProject()).incRustStructureModificationCount();
                    }
                }

                public void afterVfsChange() {
                    boolean updated = false;
                    for (VFileCreateEvent event : this.$creationEvents) {
                        VirtualFile file;
                        if (event.getFile() == null || Intrinsics.areEqual((Object)file.getFileType(), (Object)((Object)RsFileType.INSTANCE))) continue;
                        DefMapService.access$onFileAdded(this.this$0, file);
                        updated = true;
                    }
                    Iterator<VFileCreateEvent> iterator2 = this.$nonRustFilesEvents.iterator();
                    while (iterator2.hasNext()) {
                        VFileEvent event = (VFileEvent)((Pair)iterator2.next()).component1();
                        if (!(event instanceof VFilePropertyChangeEvent) || !Intrinsics.areEqual((Object)((VFilePropertyChangeEvent)event).getPropertyName(), (Object)"name")) continue;
                        ConcurrentHashMap concurrentHashMap = DefMapService.access$getMissedFiles$p(this.this$0);
                        String string = ((VFilePropertyChangeEvent)event).getPath();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                        if (!concurrentHashMap.containsKey(UtilsKt.toPath(string))) continue;
                        VirtualFile virtualFile = ((VFilePropertyChangeEvent)event).getFile();
                        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
                        DefMapService.access$onFileAdded(this.this$0, virtualFile);
                        updated = true;
                    }
                    if (updated) {
                        RsPsiManagerKt.getRustPsiManager(this.this$0.getProject()).incRustStructureModificationCount();
                    }
                }
            };
        }
    }
}

