/*
 * Decompiled with CFR 0.152.
 */
package org.rust.lang.core.resolve2;

import com.intellij.openapi.util.ModificationTracker;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.lang.core.crate.Crate;
import org.rust.lang.core.resolve2.ChangedFile;
import org.rust.lang.core.resolve2.CrateDefMap;
import org.rust.lang.core.resolve2.CrateDefMapKt;
import org.rust.lang.core.resolve2.CrateModificationTrackerKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u000b\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0006\u0010\u0012\u001a\u00020\u0013J\b\u0010\u0014\u001a\u00020\u0015H\u0002J\u0006\u0010\u0016\u001a\u00020\u0015J\u000e\u0010)\u001a\u00020\u00152\u0006\u0010*\u001a\u00020&J\u0010\u0010+\u001a\u00020\u00152\b\u0010\r\u001a\u0004\u0018\u00010\fJ\u000e\u0010,\u001a\u00020\u00132\u0006\u0010-\u001a\u00020.J\b\u0010/\u001a\u000200H\u0016R\u0015\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\r\u001a\u0004\u0018\u00010\f2\b\u0010\u000b\u001a\u0004\u0018\u00010\f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0017\u001a\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR$\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00020\u0013@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR$\u0010 \u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00020\u0013@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u001d\"\u0004\b\"\u0010\u001fR!\u0010#\u001a\u0012\u0012\b\u0012\u00060\u0003j\u0002`%\u0012\u0004\u0012\u00020&0$\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(\u00a8\u00061"}, d2={"Lorg/rust/lang/core/resolve2/DefMapHolder;", "", "crateId", "", "Lorg/rust/lang/core/crate/CratePersistentId;", "structureModificationTracker", "Lcom/intellij/openapi/util/ModificationTracker;", "<init>", "(ILcom/intellij/openapi/util/ModificationTracker;)V", "getCrateId", "()I", "value", "Lorg/rust/lang/core/resolve2/CrateDefMap;", "defMap", "getDefMap", "()Lorg/rust/lang/core/resolve2/CrateDefMap;", "defMapStamp", "Ljava/util/concurrent/atomic/AtomicLong;", "hasLatestStamp", "", "setLatestStamp", "", "checkHasLatestStamp", "modificationCount", "", "getModificationCount", "()J", "shouldRebuild", "getShouldRebuild", "()Z", "setShouldRebuild", "(Z)V", "shouldRecheck", "getShouldRecheck", "setShouldRecheck", "changedFiles", "", "Lorg/rust/lang/core/resolve2/FileId;", "Lorg/rust/lang/core/resolve2/ChangedFile;", "getChangedFiles", "()Ljava/util/Map;", "addChangedFile", "file", "setDefMap", "updateShouldRebuild", "crate", "Lorg/rust/lang/core/crate/Crate;", "toString", "", "intellij.rustrover.core"})
public final class DefMapHolder {
    private final int crateId;
    @NotNull
    private final ModificationTracker structureModificationTracker;
    @Nullable
    private volatile CrateDefMap defMap;
    @NotNull
    private final AtomicLong defMapStamp;
    private volatile boolean shouldRebuild;
    private volatile boolean shouldRecheck;
    @NotNull
    private final Map<Integer, ChangedFile> changedFiles;

    public DefMapHolder(int crateId, @NotNull ModificationTracker structureModificationTracker) {
        Intrinsics.checkNotNullParameter((Object)structureModificationTracker, (String)"structureModificationTracker");
        this.crateId = crateId;
        this.structureModificationTracker = structureModificationTracker;
        this.defMapStamp = new AtomicLong(-1L);
        this.shouldRebuild = true;
        this.changedFiles = new LinkedHashMap();
    }

    public final int getCrateId() {
        return this.crateId;
    }

    @Nullable
    public final CrateDefMap getDefMap() {
        return this.defMap;
    }

    public final boolean hasLatestStamp() {
        return this.defMapStamp.get() == this.structureModificationTracker.getModificationCount();
    }

    private final void setLatestStamp() {
        this.defMapStamp.set(this.structureModificationTracker.getModificationCount());
    }

    public final void checkHasLatestStamp() {
        if (this.defMap != null && !this.hasLatestStamp()) {
            CrateDefMapKt.getRESOLVE_LOG().error("DefMapHolder must have latest stamp right after DefMap(" + this.defMap + ") was updated. " + this.defMapStamp + " vs " + this.structureModificationTracker.getModificationCount());
        }
    }

    public final long getModificationCount() {
        return this.defMapStamp.get();
    }

    public final boolean getShouldRebuild() {
        return this.shouldRebuild;
    }

    public final void setShouldRebuild(boolean value) {
        this.shouldRebuild = value;
        if (value) {
            this.defMapStamp.decrementAndGet();
            this.setShouldRecheck(false);
            this.changedFiles.clear();
        }
    }

    public final boolean getShouldRecheck() {
        return this.shouldRecheck;
    }

    public final void setShouldRecheck(boolean value) {
        this.shouldRecheck = value;
        if (value) {
            this.defMapStamp.decrementAndGet();
        }
    }

    @NotNull
    public final Map<Integer, ChangedFile> getChangedFiles() {
        return this.changedFiles;
    }

    public final void addChangedFile(@NotNull ChangedFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.changedFiles.put(file.getId(), file);
        this.defMapStamp.decrementAndGet();
    }

    public final void setDefMap(@Nullable CrateDefMap defMap) {
        this.defMap = defMap;
        this.setShouldRebuild(false);
        this.setLatestStamp();
    }

    public final boolean updateShouldRebuild(@NotNull Crate crate) {
        Intrinsics.checkNotNullParameter((Object)crate, (String)"crate");
        boolean shouldRebuild = CrateModificationTrackerKt.getShouldRebuild(this, crate);
        if (shouldRebuild) {
            this.setShouldRebuild(true);
        } else {
            this.setLatestStamp();
        }
        return shouldRebuild;
    }

    @NotNull
    public String toString() {
        return "DefMapHolder(" + this.defMap + ", stamp=" + this.defMapStamp + ")";
    }
}

