/*
 * Decompiled with CFR 0.152.
 */
package org.rust.lang.core.resolve2;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.psi.PsiFile;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.rust.lang.core.crate.Crate;
import org.rust.lang.core.psi.RsFile;
import org.rust.lang.core.psi.RsFileKt;
import org.rust.lang.core.resolve2.ChangedFile;
import org.rust.lang.core.resolve2.CrateDefMap;
import org.rust.lang.core.resolve2.CrateMetaData;
import org.rust.lang.core.resolve2.DefMapHolder;
import org.rust.lang.core.resolve2.FileInfo;
import org.rust.lang.core.resolve2.FileModificationTrackerKt;
import org.rust.openapiext.UtilsKt;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0005\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a8\u0010\u0005\u001a\u0014\u0012\b\u0012\u00060\u0007j\u0002`\b\u0012\u0004\u0012\u00020\t\u0018\u00010\u0006*\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0010\u0010\r\u001a\f\u0012\b\u0012\u00060\u0007j\u0002`\b0\u000eH\u0002\u001a\u001c\u0010\u000f\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\nH\u0002\u001a\u0016\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\n\u001a\u0014\u0010\u0012\u001a\u00020\u0001*\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\u0013"}, d2={"getShouldRebuild", "", "Lorg/rust/lang/core/resolve2/DefMapHolder;", "crate", "Lorg/rust/lang/core/crate/Crate;", "getAllChangedFiles", "", "", "Lorg/rust/lang/core/resolve2/FileId;", "Lorg/rust/lang/core/resolve2/ChangedFile;", "Lorg/rust/lang/core/resolve2/CrateDefMap;", "project", "Lcom/intellij/openapi/project/Project;", "ignoredIds", "", "processChangedFiles", "defMap", "isCrateChanged", "hasAnyMissedFileCreated", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nCrateModificationTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CrateModificationTracker.kt\norg/rust/lang/core/resolve2/CrateModificationTrackerKt\n+ 2 utils.kt\norg/rust/openapiext/UtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,170:1\n310#2,5:171\n1761#3,3:176\n*S KotlinDebug\n*F\n+ 1 CrateModificationTracker.kt\norg/rust/lang/core/resolve2/CrateModificationTrackerKt\n*L\n132#1:171,5\n142#1:176,3\n*E\n"})
public final class CrateModificationTrackerKt {
    public static final boolean getShouldRebuild(@NotNull DefMapHolder $this$getShouldRebuild, @NotNull Crate crate) {
        Map changedFilesCopy;
        Intrinsics.checkNotNullParameter((Object)$this$getShouldRebuild, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)crate, (String)"crate");
        UtilsKt.checkReadAccessAllowed();
        if ($this$getShouldRebuild.getShouldRebuild()) {
            return true;
        }
        if (!$this$getShouldRebuild.getShouldRecheck() && $this$getShouldRebuild.getChangedFiles().isEmpty()) {
            return false;
        }
        CrateDefMap crateDefMap = $this$getShouldRebuild.getDefMap();
        if (crateDefMap == null) {
            return false;
        }
        CrateDefMap defMap = crateDefMap;
        Map map2 = changedFilesCopy = $this$getShouldRebuild.getShouldRecheck() ? MapsKt.toMap($this$getShouldRebuild.getChangedFiles()) : MapsKt.emptyMap();
        if (CrateModificationTrackerKt.processChangedFiles($this$getShouldRebuild, crate, defMap)) {
            return true;
        }
        if ($this$getShouldRebuild.getShouldRecheck()) {
            if (CrateModificationTrackerKt.isCrateChanged(crate, defMap)) {
                return true;
            }
            Map<Integer, ChangedFile> map3 = $this$getShouldRebuild.getChangedFiles();
            Map<Integer, ChangedFile> map4 = CrateModificationTrackerKt.getAllChangedFiles(defMap, crate.getProject(), changedFilesCopy.keySet());
            if (map4 == null) {
                return true;
            }
            map3.putAll(map4);
            $this$getShouldRebuild.setShouldRecheck(false);
            if (CrateModificationTrackerKt.processChangedFiles($this$getShouldRebuild, crate, defMap)) {
                return true;
            }
        }
        return false;
    }

    private static final Map<Integer, ChangedFile> getAllChangedFiles(CrateDefMap $this$getAllChangedFiles, Project project, Set<Integer> ignoredIds) {
        Map map2;
        ManagingFS persistentFS = ManagingFS.getInstance();
        Map $this$getAllChangedFiles_u24lambda_u240 = map2 = MapsKt.createMapBuilder();
        boolean bl = false;
        for (Map.Entry<Integer, FileInfo> entry2 : $this$getAllChangedFiles.getFileInfos().entrySet()) {
            VirtualFile vFile;
            int fileId = ((Number)entry2.getKey()).intValue();
            FileInfo fileInfo = entry2.getValue();
            if (ignoredIds.contains(fileId)) continue;
            if (persistentFS.findFileById(fileId) == null) {
                return null;
            }
            PsiFile psiFile = UtilsKt.toPsiFile(vFile, project);
            RsFile rsFile = psiFile != null ? RsFileKt.getRustFile(psiFile) : null;
            if (rsFile != null && FileModificationTrackerKt.getModificationStampForResolve(rsFile) != fileInfo.getModificationStamp()) {
                Integer n = fileId;
                ChangedFile changedFile = ChangedFile.Companion.rustFile(rsFile);
                Intrinsics.checkNotNull((Object)changedFile);
                $this$getAllChangedFiles_u24lambda_u240.put(n, changedFile);
                continue;
            }
            if (!$this$getAllChangedFiles.getNonRustIncludedFiles().contains(fileId) || FileModificationTrackerKt.getModificationStampForResolve(vFile) == fileInfo.getModificationStamp()) continue;
            $this$getAllChangedFiles_u24lambda_u240.put(fileId, ChangedFile.Companion.nonRustFile(project, vFile));
        }
        return MapsKt.build((Map)map2);
    }

    private static final boolean processChangedFiles(DefMapHolder $this$processChangedFiles, Crate crate, CrateDefMap defMap) {
        Iterator<Map.Entry<Integer, ChangedFile>> iterator2 = $this$processChangedFiles.getChangedFiles().entrySet().iterator();
        while (iterator2.hasNext()) {
            ProgressManager.checkCanceled();
            RsFile file = iterator2.next().getValue().getFile();
            if (file != null && FileModificationTrackerKt.isFileChanged(file, defMap, crate)) {
                return true;
            }
            iterator2.remove();
        }
        return false;
    }

    public static final boolean isCrateChanged(@NotNull Crate crate, @NotNull CrateDefMap defMap) {
        Intrinsics.checkNotNullParameter((Object)crate, (String)"crate");
        Intrinsics.checkNotNullParameter((Object)defMap, (String)"defMap");
        ProgressManager.checkCanceled();
        VirtualFile virtualFile = crate.getRootModFile();
        if (virtualFile == null) {
            return false;
        }
        VirtualFile crateRootFile = virtualFile;
        boolean $i$f$testAssert = false;
        if (UtilsKt.isUnitTestMode()) {
            boolean bl = false;
            if (!RsFileKt.shouldIndexFile(crate.getProject(), crateRootFile)) {
                boolean bl2 = false;
                String message$iv = "isCrateChanged should not be called for crates which are not indexed";
                throw new AssertionError((Object)message$iv);
            }
        }
        return !Intrinsics.areEqual((Object)defMap.getMetaData(), (Object)new CrateMetaData(crate)) || CrateModificationTrackerKt.hasAnyMissedFileCreated(defMap, crate.getProject());
    }

    private static final boolean hasAnyMissedFileCreated(CrateDefMap $this$hasAnyMissedFileCreated, Project project) {
        boolean bl;
        block3: {
            VirtualFileManager virtualFileManager = VirtualFileManager.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFileManager, (String)"getInstance(...)");
            VirtualFileManager fileManager = virtualFileManager;
            Iterable $this$any$iv = $this$hasAnyMissedFileCreated.getMissedFiles();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Path it2 = (Path)element$iv;
                    boolean bl2 = false;
                    VirtualFile virtualFile = fileManager.findFileByNioPath(it2);
                    if (!((virtualFile != null && (virtualFile = UtilsKt.toPsiFile(virtualFile, project)) != null ? RsFileKt.getRustFile((PsiFile)virtualFile) : null) != null)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }
}

