/*
 * Decompiled with CFR 0.152.
 */
package org.rust.lang.core.resolve.ref;

import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.AnyPsiChangeListener;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.SimpleMessageBusConnection;
import com.intellij.util.messages.Topic;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.lang.core.psi.RsPsiManager;
import org.rust.lang.core.psi.RsPsiManagerKt;
import org.rust.lang.core.psi.RustStructureChangeListener;
import org.rust.lang.core.psi.ext.RsModificationTrackerOwner;
import org.rust.lang.core.psi.ext.RsModificationTrackerOwnerKt;
import org.rust.lang.core.resolve.ref.ResolveCacheDependency;
import org.rust.lang.core.resolve.ref.RsResolveCacheKt;
import org.rust.openapiext.Testmark;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\b\u0007\u0018\u0000 )2\u00020\u0001:\u0002)*B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0015\u001a\u00020\u0016H\u0016JA\u0010\u0017\u001a\u0004\u0018\u0001H\u0018\"\b\b\u0000\u0010\u0019*\u00020\t\"\u0004\b\u0001\u0010\u00182\u0006\u0010\u001a\u001a\u0002H\u00192\u0006\u0010\u001b\u001a\u00020\u001c2\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u0002H\u0019\u0012\u0004\u0012\u0002H\u00180\u001e\u00a2\u0006\u0002\u0010\u001fJ\u0018\u0010 \u001a\u0004\u0018\u00010\n2\u0006\u0010\u001a\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\u001cJ\u0018\u0010!\u001a\u00020\u001c2\u0006\u0010\u001a\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J$\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b2\u0006\u0010#\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002JC\u0010$\u001a\u00020\u0016\"\b\b\u0000\u0010\u0019*\u00020\t\"\u0004\b\u0001\u0010\u00182\u0012\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b2\u0006\u0010#\u001a\u0002H\u00192\b\u0010&\u001a\u0004\u0018\u0001H\u0018H\u0002\u00a2\u0006\u0002\u0010'J\b\u0010(\u001a\u00020\u0016H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0006\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n\u0018\u00010\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u000b\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n\u0018\u00010\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\f\u001a\u0015\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\t0\t0\r\u00a2\u0006\u0002\b\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R \u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0012\u00a8\u0006+"}, d2={"Lorg/rust/lang/core/resolve/ref/RsResolveCache;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "_rustStructureDependentCache", "Ljava/util/concurrent/atomic/AtomicReference;", "Ljava/util/concurrent/ConcurrentMap;", "Lcom/intellij/psi/PsiElement;", "", "_anyPsiChangeDependentCache", "guard", "Lcom/intellij/openapi/util/RecursionGuard;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "rustStructureDependentCache", "getRustStructureDependentCache", "()Ljava/util/concurrent/ConcurrentMap;", "anyPsiChangeDependentCache", "getAnyPsiChangeDependentCache", "dispose", "", "resolveWithCaching", "V", "K", "key", "dep", "Lorg/rust/lang/core/resolve/ref/ResolveCacheDependency;", "resolver", "Lkotlin/Function1;", "(Lcom/intellij/psi/PsiElement;Lorg/rust/lang/core/resolve/ref/ResolveCacheDependency;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "getCached", "refineDependency", "getCacheFor", "element", "cache", "map", "result", "(Ljava/util/concurrent/ConcurrentMap;Lcom/intellij/psi/PsiElement;Ljava/lang/Object;)V", "onRustStructureChanged", "Companion", "Testmarks", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nRsResolveCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RsResolveCache.kt\norg/rust/lang/core/resolve/ref/RsResolveCache\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,284:1\n1563#2:285\n1634#2,3:286\n1563#2:289\n1634#2,3:290\n*S KotlinDebug\n*F\n+ 1 RsResolveCache.kt\norg/rust/lang/core/resolve/ref/RsResolveCache\n*L\n130#1:285\n130#1:286,3\n137#1:289\n137#1:290,3\n*E\n"})
public final class RsResolveCache
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final AtomicReference<ConcurrentMap<PsiElement, Object>> _rustStructureDependentCache;
    @NotNull
    private final AtomicReference<ConcurrentMap<PsiElement, Object>> _anyPsiChangeDependentCache;
    @NotNull
    private final RecursionGuard<PsiElement> guard;

    public RsResolveCache(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this._rustStructureDependentCache = new AtomicReference<Object>(null);
        this._anyPsiChangeDependentCache = new AtomicReference<Object>(null);
        RecursionGuard recursionGuard = RecursionManager.createGuard((String)"RsResolveCache");
        Intrinsics.checkNotNullExpressionValue((Object)recursionGuard, (String)"createGuard(...)");
        this.guard = recursionGuard;
        RsPsiManager rustPsiManager = RsPsiManagerKt.getRustPsiManager(this.project);
        MessageBusConnection connection = this.project.getMessageBus().connect((Disposable)this);
        rustPsiManager.subscribeRustStructureChange((SimpleMessageBusConnection)connection, new RustStructureChangeListener(){

            @Override
            public void rustStructureChanged(PsiFile file, PsiElement changedElement) {
                this.onRustStructureChanged();
            }
        });
        Topic topic = PsiManagerImpl.ANY_PSI_CHANGE_TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"ANY_PSI_CHANGE_TOPIC");
        connection.subscribe(topic, (Object)new AnyPsiChangeListener(){

            public void afterPsiChanged(boolean isPhysical) {
                _anyPsiChangeDependentCache.set(null);
            }

            public void beforePsiChanged(boolean isPhysical) {
            }
        });
    }

    private final ConcurrentMap<PsiElement, Object> getRustStructureDependentCache() {
        return RsResolveCacheKt.access$getOrCreateMap(this._rustStructureDependentCache);
    }

    private final ConcurrentMap<PsiElement, Object> getAnyPsiChangeDependentCache() {
        return RsResolveCacheKt.access$getOrCreateMap(this._anyPsiChangeDependentCache);
    }

    public void dispose() {
    }

    @Nullable
    public final <K extends PsiElement, V> V resolveWithCaching(@NotNull K key, @NotNull ResolveCacheDependency dep, @NotNull Function1<? super K, ? extends V> resolver) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)((Object)dep), (String)"dep");
        Intrinsics.checkNotNullParameter(resolver, (String)"resolver");
        ProgressManager.checkCanceled();
        ResolveCacheDependency refinedDep = this.refineDependency(key, dep);
        ConcurrentMap<PsiElement, Object> map2 = this.getCacheFor(key, refinedDep);
        Object object = map2.get(key);
        if (object == null) {
            RsResolveCache $this$resolveWithCaching_u24lambda_u240 = this;
            boolean bl = false;
            RecursionGuard.StackStamp stackStamp = RecursionManager.markStack();
            Intrinsics.checkNotNullExpressionValue((Object)stackStamp, (String)"markStack(...)");
            RecursionGuard.StackStamp stamp = stackStamp;
            Object result2 = $this$resolveWithCaching_u24lambda_u240.guard.doPreventingRecursion(key, true, () -> RsResolveCache.resolveWithCaching$lambda$0$0(resolver, key));
            RsResolveCacheKt.access$ensureValidResult(result2);
            if (stamp.mayCacheNow()) {
                $this$resolveWithCaching_u24lambda_u240.cache(map2, key, result2);
            }
            object = result2;
        }
        return object;
    }

    @Nullable
    public final Object getCached(@NotNull PsiElement key, @NotNull ResolveCacheDependency dep) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)((Object)dep), (String)"dep");
        return this.getCacheFor(key, this.refineDependency(key, dep)).get(key);
    }

    private final ResolveCacheDependency refineDependency(PsiElement key, ResolveCacheDependency dep) {
        VirtualFile virtualFile = key.getContainingFile().getVirtualFile();
        return virtualFile == null ? ResolveCacheDependency.ANY_PSI_CHANGE : (virtualFile instanceof VirtualFileWindow ? ResolveCacheDependency.ANY_PSI_CHANGE : dep);
    }

    private final ConcurrentMap<PsiElement, Object> getCacheFor(PsiElement element, ResolveCacheDependency dep) {
        switch (WhenMappings.$EnumSwitchMapping$0[dep.ordinal()]) {
            case 1: 
            case 2: {
                ConcurrentMap concurrentMap;
                List<RsModificationTrackerOwner> owner = RsModificationTrackerOwnerKt.collectModificationTrackerOwners(element);
                if (!((Collection)owner).isEmpty()) {
                    ConcurrentMap concurrentMap2 = dep == ResolveCacheDependency.LOCAL ? (ConcurrentMap)CachedValuesManager.getCachedValue((PsiElement)((PsiElement)CollectionsKt.last(owner)), (Key)RsResolveCacheKt.access$getLOCAL_CACHE_KEY$p(), () -> RsResolveCache.getCacheFor$lambda$0(owner)) : (ConcurrentMap)CachedValuesManager.getCachedValue((PsiElement)((PsiElement)CollectionsKt.last(owner)), (Key)RsResolveCacheKt.access$getLOCAL_CACHE_KEY2$p(), () -> RsResolveCache.getCacheFor$lambda$1(owner, this));
                    Intrinsics.checkNotNull((Object)concurrentMap2);
                    concurrentMap = concurrentMap2;
                } else {
                    concurrentMap = this.getRustStructureDependentCache();
                }
                return concurrentMap;
            }
            case 3: {
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return this.getAnyPsiChangeDependentCache();
    }

    private final <K extends PsiElement, V> void cache(ConcurrentMap<PsiElement, Object> map2, K element, V result2) {
        Object cached = map2.get(element);
        if (cached != null && cached == result2) {
            return;
        }
        Map map3 = map2;
        Object object = result2;
        if (object == null) {
            object = RsResolveCacheKt.access$getNULL_RESULT$p();
        }
        map3.put(element, object);
    }

    private final void onRustStructureChanged() {
        Testmarks.RustStructureDependentCacheCleared.INSTANCE.hit();
        this._rustStructureDependentCache.set(null);
    }

    private static final Object resolveWithCaching$lambda$0$0(Function1 $resolver, PsiElement $key) {
        return $resolver.invoke((Object)$key);
    }

    /*
     * WARNING - void declaration
     */
    private static final CachedValueProvider.Result getCacheFor$lambda$0(List $owner) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = $owner;
        ConcurrentMap concurrentMap = RsResolveCacheKt.access$createWeakMap();
        boolean $i$f$map = false;
        void var3_4 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            RsModificationTrackerOwner rsModificationTrackerOwner = (RsModificationTrackerOwner)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it2.getModificationTracker());
        }
        return CachedValueProvider.Result.create((Object)concurrentMap, (Collection)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    private static final CachedValueProvider.Result getCacheFor$lambda$1(List $owner, RsResolveCache this$0) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = $owner;
        ConcurrentMap concurrentMap = RsResolveCacheKt.access$createWeakMap();
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            RsModificationTrackerOwner rsModificationTrackerOwner = (RsModificationTrackerOwner)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it2.getModificationTracker());
        }
        return CachedValueProvider.Result.create((Object)concurrentMap, (Collection)CollectionsKt.plus((Collection)((List)destination$iv$iv), (Object)RsPsiManagerKt.getRustStructureModificationTracker(this$0.project)));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lorg/rust/lang/core/resolve/ref/RsResolveCache$Companion;", "", "<init>", "()V", "getInstance", "Lorg/rust/lang/core/resolve/ref/RsResolveCache;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.rustrover.core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final RsResolveCache getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Object object = ServiceManager.getService((Project)project, RsResolveCache.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (RsResolveCache)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0004B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lorg/rust/lang/core/resolve/ref/RsResolveCache$Testmarks;", "", "<init>", "()V", "RustStructureDependentCacheCleared", "intellij.rustrover.core"})
    public static final class Testmarks {
        @NotNull
        public static final Testmarks INSTANCE = new Testmarks();

        private Testmarks() {
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lorg/rust/lang/core/resolve/ref/RsResolveCache$Testmarks$RustStructureDependentCacheCleared;", "Lorg/rust/openapiext/Testmark;", "<init>", "()V", "intellij.rustrover.core"})
        public static final class RustStructureDependentCacheCleared
        extends Testmark {
            @NotNull
            public static final RustStructureDependentCacheCleared INSTANCE = new RustStructureDependentCacheCleared();

            private RustStructureDependentCacheCleared() {
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ResolveCacheDependency.values().length];
            try {
                nArray[ResolveCacheDependency.LOCAL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ResolveCacheDependency.LOCAL_AND_RUST_STRUCTURE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ResolveCacheDependency.ANY_PSI_CHANGE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

