/*
 * Decompiled with CFR 0.152.
 */
package org.rust.lang.core.resolve.ref;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiPolyVariantReferenceBase;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.ide.refactoring.RsNamesValidatorKt;
import org.rust.lang.core.psi.RsElementTypes;
import org.rust.lang.core.psi.RsPsiFactory;
import org.rust.lang.core.psi.RsRawIdentifiersKt;
import org.rust.lang.core.psi.ext.PsiElementExtensionsKt;
import org.rust.lang.core.psi.ext.RsElement;
import org.rust.lang.core.psi.ext.RsReferenceElementBase;
import org.rust.lang.core.resolve.ref.RsReference;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b&\u0018\u0000 \"*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u00032\u00020\u0004:\u0001\"B\u000f\u0012\u0006\u0010\u0005\u001a\u00028\u0000\u00a2\u0006\u0004\b\u0006\u0010\u0007J\n\u0010\b\u001a\u0004\u0018\u00010\tH\u0016J\u001d\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a2\u0006\u0002\u0010\u000fJ\u0006\u0010\u0014\u001a\u00020\u0015J\b\u0010\u0016\u001a\u00020\u0015H\u0004J\u0010\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0015\u0010\u001a\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001b0\u000bH\u0016\u00a2\u0006\u0002\u0010\u001cJ\u0013\u0010\u001d\u001a\u00020\u000e2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0096\u0002J\b\u0010 \u001a\u00020!H\u0016R\u001a\u0010\u0010\u001a\u0004\u0018\u00010\u0011*\u00028\u00008VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006#"}, d2={"Lorg/rust/lang/core/resolve/ref/RsReferenceBase;", "T", "Lorg/rust/lang/core/psi/ext/RsReferenceElementBase;", "Lcom/intellij/psi/PsiPolyVariantReferenceBase;", "Lorg/rust/lang/core/resolve/ref/RsReference;", "element", "<init>", "(Lorg/rust/lang/core/psi/ext/RsReferenceElementBase;)V", "resolve", "Lorg/rust/lang/core/psi/ext/RsElement;", "multiResolve", "", "Lcom/intellij/psi/ResolveResult;", "incompleteCode", "", "(Z)[Lcom/intellij/psi/ResolveResult;", "referenceAnchor", "Lcom/intellij/psi/PsiElement;", "getReferenceAnchor", "(Lorg/rust/lang/core/psi/ext/RsReferenceElementBase;)Lcom/intellij/psi/PsiElement;", "getRangeInElement", "Lcom/intellij/openapi/util/TextRange;", "calculateDefaultRangeInElement", "handleElementRename", "newName", "", "getVariants", "Lcom/intellij/codeInsight/lookup/LookupElement;", "()[Lcom/intellij/codeInsight/lookup/LookupElement;", "equals", "other", "", "hashCode", "", "Companion", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nRsReferenceBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RsReferenceBase.kt\norg/rust/lang/core/resolve/ref/RsReferenceBase\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,76:1\n1563#2:77\n1634#2,3:78\n37#3,2:81\n*S KotlinDebug\n*F\n+ 1 RsReferenceBase.kt\norg/rust/lang/core/resolve/ref/RsReferenceBase\n*L\n30#1:77\n30#1:78,3\n30#1:81,2\n*E\n"})
public abstract class RsReferenceBase<T extends RsReferenceElementBase>
extends PsiPolyVariantReferenceBase<T>
implements RsReference {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public RsReferenceBase(@NotNull T element) {
        Intrinsics.checkNotNullParameter(element, (String)"element");
        super((PsiElement)element);
    }

    @Override
    @Nullable
    public RsElement resolve() {
        PsiElement psiElement2 = super.resolve();
        return psiElement2 instanceof RsElement ? (RsElement)psiElement2 : null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public ResolveResult[] multiResolve(boolean incompleteCode) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.multiResolve();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            RsElement rsElement = (RsElement)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new PsiElementResolveResult((PsiElement)it2));
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return (ResolveResult[])thisCollection$iv.toArray(new PsiElementResolveResult[0]);
    }

    @Nullable
    public PsiElement getReferenceAnchor(@NotNull T $this$referenceAnchor) {
        Intrinsics.checkNotNullParameter($this$referenceAnchor, (String)"<this>");
        return $this$referenceAnchor.getReferenceNameElement();
    }

    @NotNull
    public final TextRange getRangeInElement() {
        TextRange textRange = super.getRangeInElement();
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getRangeInElement(...)");
        return textRange;
    }

    @NotNull
    protected final TextRange calculateDefaultRangeInElement() {
        PsiElement psiElement2 = this.getElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"getElement(...)");
        PsiElement psiElement3 = this.getReferenceAnchor((RsReferenceElementBase)psiElement2);
        if (psiElement3 == null) {
            TextRange textRange = TextRange.EMPTY_RANGE;
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"EMPTY_RANGE");
            return textRange;
        }
        PsiElement anchor = psiElement3;
        if (!(anchor.getParent() == this.getElement())) {
            throw new IllegalStateException("Check failed.");
        }
        TextRange textRange = TextRange.from((int)anchor.getStartOffsetInParent(), (int)anchor.getTextLength());
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"from(...)");
        return textRange;
    }

    @NotNull
    public PsiElement handleElementRename(@NotNull String newName) {
        Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
        PsiElement referenceNameElement = ((RsReferenceElementBase)this.getElement()).getReferenceNameElement();
        if (referenceNameElement != null) {
            Companion.doRename(referenceNameElement, newName);
        }
        PsiElement psiElement2 = this.getElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"getElement(...)");
        return psiElement2;
    }

    @NotNull
    public LookupElement[] getVariants() {
        Intrinsics.checkNotNullExpressionValue((Object)LookupElement.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
        return LookupElement.EMPTY_ARRAY;
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof RsReferenceBase && this.getElement() == ((RsReferenceBase)other).getElement();
    }

    public int hashCode() {
        return this.getElement().hashCode();
    }

    @JvmStatic
    public static final void doRename(@NotNull PsiElement identifier, @NotNull String newName) {
        Companion.doRename(identifier, newName);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007\u00a8\u0006\n"}, d2={"Lorg/rust/lang/core/resolve/ref/RsReferenceBase$Companion;", "", "<init>", "()V", "doRename", "", "identifier", "Lcom/intellij/psi/PsiElement;", "newName", "", "intellij.rustrover.core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void doRename(@NotNull PsiElement identifier, @NotNull String newName) {
            PsiElement psiElement2;
            Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
            Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
            Project project = identifier.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            RsPsiFactory factory2 = new RsPsiFactory(project, false, false, 6, null);
            IElementType iElementType = PsiElementExtensionsKt.getElementType(identifier);
            if (Intrinsics.areEqual((Object)iElementType, (Object)RsElementTypes.IDENTIFIER)) {
                String name2 = RsRawIdentifiersKt.escapeIdentifierIfNeeded(StringsKt.replace$default((String)newName, (String)".rs", (String)"", (boolean)false, (int)4, null));
                if (!RsNamesValidatorKt.isValidRustVariableIdentifier(name2)) {
                    return;
                }
                psiElement2 = factory2.createIdentifier(name2);
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)RsElementTypes.QUOTE_IDENTIFIER)) {
                psiElement2 = factory2.createQuoteIdentifier(newName);
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)RsElementTypes.META_VAR_IDENTIFIER)) {
                psiElement2 = factory2.createMetavarIdentifier(newName);
            } else {
                throw new IllegalStateException(("Unsupported identifier type for `" + newName + "` (" + PsiElementExtensionsKt.getElementType(identifier) + ")").toString());
            }
            PsiElement newId = psiElement2;
            identifier.replace(newId);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

