/*
 * Decompiled with CFR 0.152.
 */
package org.rust.lang.core.resolve.ref;

import com.intellij.extapi.psi.StubBasedPsiElementBase;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.rust.lang.core.psi.RsAssocTypeBinding;
import org.rust.lang.core.psi.RsElementTypes;
import org.rust.lang.core.psi.RsEnumVariant;
import org.rust.lang.core.psi.RsPath;
import org.rust.lang.core.psi.RsPathCodeFragment;
import org.rust.lang.core.psi.RsPathExpr;
import org.rust.lang.core.psi.RsPsiFactory;
import org.rust.lang.core.psi.RsTokenTypeKt;
import org.rust.lang.core.psi.RsTypeAlias;
import org.rust.lang.core.psi.RsTypeQual;
import org.rust.lang.core.psi.RsUseSpeck;
import org.rust.lang.core.psi.RsVisRestriction;
import org.rust.lang.core.psi.ext.PsiElementExtensionsKt;
import org.rust.lang.core.psi.ext.RsAbstractable;
import org.rust.lang.core.psi.ext.RsAbstractableKt;
import org.rust.lang.core.psi.ext.RsAbstractableOwner;
import org.rust.lang.core.psi.ext.RsElement;
import org.rust.lang.core.psi.ext.RsElementKt;
import org.rust.lang.core.psi.ext.RsFieldDecl;
import org.rust.lang.core.psi.ext.RsMod;
import org.rust.lang.core.psi.ext.RsModKt;
import org.rust.lang.core.psi.ext.RsNamedElement;
import org.rust.lang.core.psi.ext.RsPathKt;
import org.rust.lang.core.psi.ext.RsQualifiedNamedElementKt;
import org.rust.lang.core.psi.ext.RsReferenceElementBase;
import org.rust.lang.core.resolve.NameResolutionKt;
import org.rust.lang.core.resolve.NamespaceKt;
import org.rust.lang.core.resolve.PathResolutionContext;
import org.rust.lang.core.resolve.ProcessorsKt;
import org.rust.lang.core.resolve.RsPathResolveKind;
import org.rust.lang.core.resolve.RsPathResolveResult;
import org.rust.lang.core.resolve.RsResolveProcessorBase;
import org.rust.lang.core.resolve.ScopeEntry;
import org.rust.lang.core.resolve.ref.ResolveCacheDependency;
import org.rust.lang.core.resolve.ref.RsPathReference;
import org.rust.lang.core.resolve.ref.RsPathReferenceImplKt;
import org.rust.lang.core.resolve.ref.RsReferenceBase;
import org.rust.lang.core.resolve.ref.RsResolveCache;
import org.rust.lang.core.stubs.RsPathStub;
import org.rust.lang.core.types.BoundElement;
import org.rust.lang.core.types.ExtensionsKt;
import org.rust.lang.core.types.infer.FoldKt;
import org.rust.lang.core.types.infer.RsInferenceResult;
import org.rust.lang.core.types.infer.TyLowering;
import org.rust.lang.doc.psi.RsDocPathLinkParent;
import org.rust.lang.utils.evaluation.PathExprResolver;
import org.rust.openapiext.UtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 !2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0002 !B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u0010H\u0016J\n\u0010\u0012\u001a\u0004\u0018\u00010\u0011H\u0016J\u001d\u0010\u0013\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020\bH\u0016\u00a2\u0006\u0002\u0010\u0017J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00110\u0018H\u0016J\u0014\u0010\u0019\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u001a0\u0018H\u0016J\u0016\u0010\u001b\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u001a\u0018\u00010\u0018H\u0002J\u0014\u0010\u001c\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u001a0\u0018H\u0002J\u0010\u0010\u001d\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\n2\u0006\u0010\t\u001a\u00020\u001fH\u0002R\u0018\u0010\r\u001a\u00020\b*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\""}, d2={"Lorg/rust/lang/core/resolve/ref/RsPathReferenceImpl;", "Lorg/rust/lang/core/resolve/ref/RsReferenceBase;", "Lorg/rust/lang/core/psi/RsPath;", "Lorg/rust/lang/core/resolve/ref/RsPathReference;", "element", "<init>", "(Lorg/rust/lang/core/psi/RsPath;)V", "isReferenceTo", "", "target", "Lcom/intellij/psi/PsiElement;", "isReferenceToAssocItem", "isReferenceToNonAssocItem", "isAssociatedItemOrEnumVariantPath", "(Lorg/rust/lang/core/psi/RsPath;)Z", "advancedResolve", "Lorg/rust/lang/core/types/BoundElement;", "Lorg/rust/lang/core/psi/ext/RsElement;", "resolve", "multiResolve", "", "Lcom/intellij/psi/ResolveResult;", "incompleteCode", "(Z)[Lcom/intellij/psi/ResolveResult;", "", "rawMultiResolve", "Lorg/rust/lang/core/resolve/RsPathResolveResult;", "rawMultiResolveUsingInferenceCache", "rawCachedMultiResolve", "bindToElement", "bindToMod", "Lorg/rust/lang/core/psi/ext/RsMod;", "Resolver", "Companion", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nRsPathReferenceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RsPathReferenceImpl.kt\norg/rust/lang/core/resolve/ref/RsPathReferenceImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,809:1\n1761#2,3:810\n1761#2,3:813\n1761#2,3:816\n1761#2,3:819\n1761#2,3:822\n1761#2,3:825\n774#2:828\n865#2,2:829\n1617#2,9:833\n1869#2:842\n1870#2:844\n1626#2:845\n37#3,2:831\n1#4:843\n1#4:846\n*S KotlinDebug\n*F\n+ 1 RsPathReferenceImpl.kt\norg/rust/lang/core/resolve/ref/RsPathReferenceImpl\n*L\n79#1:810,3\n81#1:813,3\n87#1:816,3\n98#1:819,3\n128#1:822,3\n140#1:825,3\n177#1:828\n177#1:829,2\n180#1:833,9\n180#1:842\n180#1:844\n180#1:845\n177#1:831,2\n180#1:843\n*E\n"})
public final class RsPathReferenceImpl
extends RsReferenceBase<RsPath>
implements RsPathReference {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final TokenSet ALLOWED_CACHING_ROOTS;
    @NotNull
    private static final TokenSet ALLOWED_PARENT_FOR_PATH;
    @NotNull
    private static final TokenSet ALLOWED_PARENT_FOR_OTHERS;

    public RsPathReferenceImpl(@NotNull RsPath element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        super((RsReferenceElementBase)element);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isReferenceTo(@NotNull PsiElement target) {
        boolean bl;
        RsAbstractableOwner targetAbstractableOwner;
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        if (target instanceof RsFieldDecl) {
            return false;
        }
        PsiElement psiElement2 = this.getElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"getElement(...)");
        RsPath path = (RsPath)psiElement2;
        PsiElement pathParent = path.getParent();
        if (target instanceof RsMod) {
            if (!(pathParent instanceof RsPath || pathParent instanceof RsUseSpeck || pathParent instanceof RsVisRestriction || pathParent instanceof RsDocPathLinkParent)) {
                if (!(pathParent instanceof RsPathCodeFragment)) return false;
            }
            boolean bl2 = true;
            boolean canReferToMod = bl2;
            if (!canReferToMod) return false;
            boolean bl3 = this.isReferenceToNonAssocItem(target);
            return bl3;
        }
        if (target instanceof RsNamedElement && !org.rust.stdext.CollectionsKt.intersects(RsPathKt.allowedNamespaces$default(path, false, pathParent, 1, null), (Iterable)NamespaceKt.getNamespaces((RsNamedElement)target))) {
            return false;
        }
        RsAbstractable rsAbstractable = target instanceof RsAbstractable ? (RsAbstractable)target : null;
        RsAbstractableOwner rsAbstractableOwner = targetAbstractableOwner = rsAbstractable != null ? RsAbstractableKt.getOwner(rsAbstractable) : null;
        if (pathParent instanceof RsPathExpr) {
            if (targetAbstractableOwner != null && targetAbstractableOwner.isImplOrTrait()) {
                if (target instanceof RsTypeAlias) {
                    return false;
                }
                if (path.getPath() == null && path.getTypeQual() == null) {
                    return false;
                }
                List resolvedRaw = RsPathReferenceImplKt.resolvePathRaw$default(path, null, false, 6, null);
                PsiManager mgr = ((RsAbstractable)target).getManager();
                RsAbstractableOwner rsAbstractableOwner2 = targetAbstractableOwner;
                if (Intrinsics.areEqual((Object)rsAbstractableOwner2, (Object)RsAbstractableOwner.Free.INSTANCE) || Intrinsics.areEqual((Object)rsAbstractableOwner2, (Object)RsAbstractableOwner.Foreign.INSTANCE)) {
                    ScopeEntry it2;
                    Iterable $this$any$iv = resolvedRaw;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        return false;
                    }
                    Iterator iterator2 = $this$any$iv.iterator();
                    do {
                        if (!iterator2.hasNext()) return false;
                        Object element$iv = iterator2.next();
                        it2 = (ScopeEntry)element$iv;
                        boolean bl4 = false;
                    } while (!mgr.areElementsEquivalent((PsiElement)it2.getElement(), target));
                    return true;
                }
                if (rsAbstractableOwner2 instanceof RsAbstractableOwner.Impl) {
                    ScopeEntry it3;
                    if (((RsAbstractableOwner.Impl)targetAbstractableOwner).isInherent()) {
                        ScopeEntry it4;
                        Iterable $this$any$iv = resolvedRaw;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            return false;
                        }
                        Iterator iterator3 = $this$any$iv.iterator();
                        do {
                            if (!iterator3.hasNext()) return false;
                            Object element$iv = iterator3.next();
                            it4 = (ScopeEntry)element$iv;
                            boolean bl5 = false;
                        } while (!mgr.areElementsEquivalent((PsiElement)it4.getElement(), target));
                        return true;
                    }
                    if (resolvedRaw.size() == 1 && mgr.areElementsEquivalent((PsiElement)((ScopeEntry)CollectionsKt.single((List)resolvedRaw)).getElement(), target)) {
                        return true;
                    }
                    RsAbstractable rsAbstractable2 = RsAbstractableKt.getSuperItem((RsAbstractable)target);
                    if (rsAbstractable2 == null) {
                        return false;
                    }
                    RsAbstractable superItem = rsAbstractable2;
                    Iterable $this$any$iv = resolvedRaw;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        return false;
                    }
                    Iterator it4 = $this$any$iv.iterator();
                    do {
                        if (!it4.hasNext()) return false;
                        Object element$iv = it4.next();
                        it3 = (ScopeEntry)element$iv;
                        boolean bl6 = false;
                    } while (!(mgr.areElementsEquivalent((PsiElement)it3.getElement(), target) || mgr.areElementsEquivalent((PsiElement)it3.getElement(), (PsiElement)superItem)));
                    boolean bl7 = true;
                    boolean canBeReferenceTo = bl7;
                    if (!canBeReferenceTo) return false;
                    bl = this.isReferenceToAssocItem(target);
                    return bl;
                } else {
                    ScopeEntry it5;
                    if (!(rsAbstractableOwner2 instanceof RsAbstractableOwner.Trait)) throw new NoWhenBranchMatchedException();
                    Iterable $this$any$iv = resolvedRaw;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        return false;
                    }
                    Iterator iterator4 = $this$any$iv.iterator();
                    do {
                        if (!iterator4.hasNext()) return false;
                        Object element$iv = iterator4.next();
                        it5 = (ScopeEntry)element$iv;
                        boolean bl8 = false;
                    } while (!mgr.areElementsEquivalent((PsiElement)it5.getElement(), target));
                    boolean bl9 = true;
                    boolean canBeReferenceTo = bl9;
                    if (!canBeReferenceTo) return false;
                    bl = this.isReferenceToAssocItem(target);
                }
                return bl;
            } else {
                bl = this.isReferenceToNonAssocItem(target);
            }
            return bl;
        } else if (targetAbstractableOwner != null && targetAbstractableOwner.isImplOrTrait()) {
            if (target instanceof RsTypeAlias && pathParent instanceof RsAssocTypeBinding) {
                return this.isReferenceToAssocItem(target);
            }
            if (pathParent instanceof RsUseSpeck && path.getTypeQual() == null) {
                return false;
            }
            bl = this.isReferenceToAssocItem(target);
            return bl;
        } else {
            bl = this.isReferenceToNonAssocItem(target);
        }
        return bl;
    }

    private final boolean isReferenceToAssocItem(PsiElement target) {
        boolean bl;
        block3: {
            List<RsPathResolveResult<RsElement>> resolved = this.rawMultiResolve();
            Iterable $this$any$iv = resolved;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    RsPathResolveResult it2 = (RsPathResolveResult)element$iv;
                    boolean bl2 = false;
                    if (!target.getManager().areElementsEquivalent(it2.getElement(), target)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final boolean isReferenceToNonAssocItem(PsiElement target) {
        boolean bl;
        block7: {
            boolean canBeReferenceTo;
            if (target instanceof RsEnumVariant) {
                RsTypeQual rsTypeQual = ((RsPath)this.getElement()).getTypeQual();
                v1 = (rsTypeQual != null ? rsTypeQual.getTraitRef() : null) == null;
            } else {
                PsiElement psiElement2 = this.getElement();
                Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"getElement(...)");
                v1 = canBeReferenceTo = !this.isAssociatedItemOrEnumVariantPath((RsPath)psiElement2);
            }
            if (canBeReferenceTo) {
                PsiManager mgr = target.getManager();
                PsiElement psiElement3 = this.getElement();
                Intrinsics.checkNotNullExpressionValue((Object)psiElement3, (String)"getElement(...)");
                Iterable $this$any$iv = RsPathReferenceImplKt.resolvePathRaw$default((RsPath)psiElement3, null, false, 2, null);
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        ScopeEntry it2 = (ScopeEntry)element$iv;
                        boolean bl2 = false;
                        if (!mgr.areElementsEquivalent((PsiElement)it2.getElement(), target)) continue;
                        bl = true;
                        break block7;
                    }
                    bl = false;
                }
            } else {
                bl = false;
            }
        }
        return bl;
    }

    private final boolean isAssociatedItemOrEnumVariantPath(RsPath $this$isAssociatedItemOrEnumVariantPath) {
        if ($this$isAssociatedItemOrEnumVariantPath.getTypeQual() != null) {
            return true;
        }
        RsPath rsPath = $this$isAssociatedItemOrEnumVariantPath.getPath();
        if (rsPath == null) {
            return false;
        }
        RsPath qualifier = rsPath;
        Object object = qualifier.getReference();
        if (object == null || (object = object.resolve()) == null) {
            return false;
        }
        Object resolvedQualifier = object;
        return !(resolvedQualifier instanceof RsMod);
    }

    @Override
    @Nullable
    public BoundElement<RsElement> advancedResolve() {
        List<RsPathResolveResult<RsElement>> resultFromTypeInference = this.rawMultiResolveUsingInferenceCache();
        if (resultFromTypeInference != null) {
            RsPathResolveResult rsPathResolveResult = (RsPathResolveResult)CollectionsKt.singleOrNull(resultFromTypeInference);
            if (rsPathResolveResult == null) {
                return null;
            }
            RsPathResolveResult single = rsPathResolveResult;
            return !single.getHasMissingCSelf() ? new BoundElement((RsElement)single.getElement(), single.getResolvedSubst(), null, 4, null) : null;
        }
        PsiElement psiElement2 = this.getElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"getElement(...)");
        Map<RsPath, List<RsPathResolveResult<RsElement>>> resolvedNestedPaths = Companion.resolveNeighborPaths((RsPath)psiElement2);
        List<RsPathResolveResult<RsElement>> list = resolvedNestedPaths.get(this.getElement());
        if (list == null || (list = (RsPathResolveResult)CollectionsKt.singleOrNull(list)) == null) {
            return null;
        }
        List<RsPathResolveResult<RsElement>> resolved = list;
        if (((RsPathResolveResult)((Object)resolved)).getHasMissingCSelf()) {
            return null;
        }
        PsiElement psiElement3 = this.getElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement3, (String)"getElement(...)");
        return TyLowering.Companion.lowerPathGenerics((RsPath)psiElement3, ((RsPathResolveResult)((Object)resolved)).getElement(), ((RsPathResolveResult)((Object)resolved)).getResolvedSubst(), PathExprResolver.Companion.getDefault(), resolvedNestedPaths);
    }

    @Override
    @Nullable
    public RsElement resolve() {
        return RsPathReferenceImplKt.access$filterRawMultiResolveVariants(this.rawMultiResolve());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public ResolveResult[] multiResolve(boolean incompleteCode) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.rawMultiResolve();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            RsPathResolveResult it2 = (RsPathResolveResult)element$iv$iv;
            boolean bl = false;
            if (!(!it2.getHasMissingCSelf())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new RsPathResolveResult[0]);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<RsElement> multiResolve() {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = this.rawMultiResolve();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            PsiElement it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            RsPathResolveResult it2 = (RsPathResolveResult)element$iv$iv;
            boolean bl2 = false;
            if ((it2.getHasMissingCSelf() ? null : it2.getElement()) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Override
    @NotNull
    public List<RsPathResolveResult<RsElement>> rawMultiResolve() {
        List<RsPathResolveResult<RsElement>> list = this.rawMultiResolveUsingInferenceCache();
        if (list == null) {
            list = this.rawCachedMultiResolve();
        }
        return list;
    }

    private final List<RsPathResolveResult<RsElement>> rawMultiResolveUsingInferenceCache() {
        List list;
        PsiElement psiElement2 = ((RsPath)this.getElement()).getParent();
        RsPathExpr rsPathExpr = psiElement2 instanceof RsPathExpr ? (RsPathExpr)psiElement2 : null;
        if (rsPathExpr == null) {
            return null;
        }
        RsPathExpr path = rsPathExpr;
        RsInferenceResult rsInferenceResult = ExtensionsKt.getInference(path);
        if (rsInferenceResult != null) {
            RsInferenceResult it2 = rsInferenceResult;
            boolean bl = false;
            list = RsPathReferenceImplKt.access$getPathResolveResults(path, it2);
        } else {
            list = null;
        }
        return list;
    }

    private final List<RsPathResolveResult<RsElement>> rawCachedMultiResolve() {
        PsiElement psiElement2 = this.getElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"getElement(...)");
        Object mapOrList = RsPathReferenceImpl.Companion.resolveNeighborPathsInternal((RsPath)psiElement2);
        List rawResult = (List)(mapOrList instanceof Map ? ((Map)mapOrList).get(this.getElement()) : mapOrList);
        List list = rawResult;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @NotNull
    public PsiElement bindToElement(@NotNull PsiElement target) {
        PsiElement psiElement2;
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        if (target instanceof RsMod && (psiElement2 = this.bindToMod((RsMod)target)) != null) {
            PsiElement it2 = psiElement2;
            boolean bl = false;
            return it2;
        }
        PsiElement psiElement3 = super.bindToElement(target);
        Intrinsics.checkNotNullExpressionValue((Object)psiElement3, (String)"bindToElement(...)");
        return psiElement3;
    }

    private final PsiElement bindToMod(RsMod target) {
        PsiElement psiElement2 = this.getElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"getElement(...)");
        if (!RsElementKt.isAtLeastEdition2018(psiElement2)) {
            return null;
        }
        String string = RsQualifiedNamedElementKt.qualifiedNameRelativeTo(target, ((RsPath)this.getElement()).getContainingMod());
        if (string == null) {
            return null;
        }
        String targetPath = string;
        for (RsPath pathPrefix : SequencesKt.generateSequence((Object)this.getElement(), RsPathReferenceImpl::bindToMod$lambda$0)) {
            RsPathReference rsPathReference = pathPrefix.getReference();
            RsElement rsElement = rsPathReference != null ? rsPathReference.resolve() : null;
            RsMod mod = rsElement instanceof RsMod ? (RsMod)rsElement : null;
            if (mod == null || !RsModKt.getSuperMods(target).contains(mod)) continue;
            String modFullPath = RsQualifiedNamedElementKt.qualifiedNameRelativeTo(mod, ((RsPath)this.getElement()).getContainingMod());
            String modShortPath = pathPrefix.getText();
            if (modFullPath == null || !StringsKt.startsWith$default((String)targetPath, (String)modFullPath, (boolean)false, (int)2, null)) break;
            Intrinsics.checkNotNull((Object)modShortPath);
            targetPath = StringsKt.replaceFirst$default((String)targetPath, (String)modFullPath, (String)modShortPath, (boolean)false, (int)4, null);
            break;
        }
        Project project = ((RsPath)this.getElement()).getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        RsPath rsPath = RsPsiFactory.tryCreatePath$default(new RsPsiFactory(project, false, false, 6, null), targetPath, null, 2, null);
        if (rsPath == null) {
            return null;
        }
        RsPath elementNew = rsPath;
        return ((RsPath)this.getElement()).replace(elementNew);
    }

    private static final RsPath bindToMod$lambda$0(RsPath it2) {
        Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
        return it2.getPath();
    }

    static {
        TokenSet[] tokenSetArray = new TokenSet[2];
        tokenSetArray[0] = RsTokenTypeKt.getRS_TYPES();
        IElementType[] iElementTypeArray = new IElementType[2];
        Intrinsics.checkNotNullExpressionValue((Object)RsElementTypes.PATH, (String)"PATH");
        Intrinsics.checkNotNullExpressionValue((Object)RsElementTypes.TYPE_ARGUMENT_LIST, (String)"TYPE_ARGUMENT_LIST");
        tokenSetArray[1] = RsTokenTypeKt.tokenSetOf(iElementTypeArray);
        TokenSet tokenSet = TokenSet.orSet((TokenSet[])tokenSetArray);
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"orSet(...)");
        ALLOWED_CACHING_ROOTS = tokenSet;
        tokenSetArray = new TokenSet[2];
        tokenSetArray[0] = RsTokenTypeKt.getRS_TYPES();
        iElementTypeArray = new IElementType[2];
        Intrinsics.checkNotNullExpressionValue((Object)RsElementTypes.TYPE_ARGUMENT_LIST, (String)"TYPE_ARGUMENT_LIST");
        Intrinsics.checkNotNullExpressionValue((Object)RsElementTypes.TRAIT_REF, (String)"TRAIT_REF");
        tokenSetArray[1] = RsTokenTypeKt.tokenSetOf(iElementTypeArray);
        TokenSet tokenSet2 = TokenSet.orSet((TokenSet[])tokenSetArray);
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet2, (String)"orSet(...)");
        ALLOWED_PARENT_FOR_PATH = tokenSet2;
        tokenSetArray = new TokenSet[2];
        tokenSetArray[0] = RsTokenTypeKt.getRS_TYPES();
        iElementTypeArray = new IElementType[9];
        Intrinsics.checkNotNullExpressionValue((Object)RsElementTypes.TYPE_ARGUMENT_LIST, (String)"TYPE_ARGUMENT_LIST");
        Intrinsics.checkNotNullExpressionValue((Object)RsElementTypes.PATH, (String)"PATH");
        Intrinsics.checkNotNullExpressionValue((Object)RsElementTypes.VALUE_PARAMETER, (String)"VALUE_PARAMETER");
        Intrinsics.checkNotNullExpressionValue((Object)RsElementTypes.VALUE_PARAMETER_LIST, (String)"VALUE_PARAMETER_LIST");
        Intrinsics.checkNotNullExpressionValue((Object)RsElementTypes.RET_TYPE, (String)"RET_TYPE");
        Intrinsics.checkNotNullExpressionValue((Object)RsElementTypes.TRAIT_REF, (String)"TRAIT_REF");
        Intrinsics.checkNotNullExpressionValue((Object)RsElementTypes.BOUND, (String)"BOUND");
        Intrinsics.checkNotNullExpressionValue((Object)RsElementTypes.POLYBOUND, (String)"POLYBOUND");
        Intrinsics.checkNotNullExpressionValue((Object)RsElementTypes.ASSOC_TYPE_BINDING, (String)"ASSOC_TYPE_BINDING");
        tokenSetArray[1] = RsTokenTypeKt.tokenSetOf(iElementTypeArray);
        TokenSet tokenSet3 = TokenSet.orSet((TokenSet[])tokenSetArray);
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet3, (String)"orSet(...)");
        ALLOWED_PARENT_FOR_OTHERS = tokenSet3;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0012\u0010\b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0016\u0010\t\u001a\b\u0012\u0002\b\u0003\u0018\u00010\n2\u0006\u0010\u0006\u001a\u00020\u000bH\u0002J\u001a\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00070\u00172\u0006\u0010\u0018\u001a\u00020\u0005H\u0007J\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00070\u00172\u0006\u0010\u0018\u001a\u00020\u0005H\u0002J\u001a\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00070\u00172\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\nH\u0002J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J&\u0010\u001c\u001a\u001a\u0012\u0004\u0012\u00020\u0007\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u001e0\u00170\u001d2\u0006\u0010\u0006\u001a\u00020\u0007J\u0018\u0010\u001f\u001a\u0004\u0018\u00010\u00052\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#R\u0013\u0010\u0011\u001a\u00070\u0012\u00a2\u0006\u0002\b\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0014\u001a\u00070\u0012\u00a2\u0006\u0002\b\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0015\u001a\u00070\u0012\u00a2\u0006\u0002\b\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lorg/rust/lang/core/resolve/ref/RsPathReferenceImpl$Companion;", "", "<init>", "()V", "getRootCachingElement", "Lorg/rust/lang/core/psi/ext/RsElement;", "path", "Lorg/rust/lang/core/psi/RsPath;", "getRootCachingElementPsi", "getRootCachingElementStub", "Lcom/intellij/psi/stubs/StubElement;", "Lorg/rust/lang/core/stubs/RsPathStub;", "isStepToParentAllowed", "", "child", "Lcom/intellij/psi/tree/IElementType;", "parent", "ALLOWED_CACHING_ROOTS", "Lcom/intellij/psi/tree/TokenSet;", "Lorg/jetbrains/annotations/NotNull;", "ALLOWED_PARENT_FOR_PATH", "ALLOWED_PARENT_FOR_OTHERS", "collectNestedPathsFromRoot", "", "root", "collectNestedPathsFromRootPsi", "collectNestedPathsFromRootStub", "resolveNeighborPathsInternal", "resolveNeighborPaths", "", "Lorg/rust/lang/core/resolve/RsPathResolveResult;", "resolve", "pathExpr", "Lorg/rust/lang/core/psi/RsPathExpr;", "inference", "Lorg/rust/lang/core/types/infer/RsInferenceResult;", "intellij.rustrover.core"})
    @SourceDebugExtension(value={"SMAP\nRsPathReferenceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RsPathReferenceImpl.kt\norg/rust/lang/core/resolve/ref/RsPathReferenceImpl$Companion\n+ 2 PsiElement.kt\norg/rust/lang/core/psi/ext/PsiElementKt\n+ 3 utils.kt\norg/rust/openapiext/UtilsKt\n+ 4 psi.kt\norg/rust/openapiext/PsiKt\n*L\n1#1,809:1\n312#2:810\n305#3,10:811\n305#3,10:821\n305#3,10:840\n305#3,10:850\n27#4,9:831\n*S KotlinDebug\n*F\n+ 1 RsPathReferenceImpl.kt\norg/rust/lang/core/resolve/ref/RsPathReferenceImpl$Companion\n*L\n283#1:810\n368#1:811,10\n376#1:821,10\n392#1:840,10\n400#1:850,10\n381#1:831,9\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @VisibleForTesting
        @Nullable
        public final RsElement getRootCachingElement(@NotNull RsPath path) {
            RsElement rsElement;
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            StubBasedPsiElement $this$greenStub$iv = path;
            boolean $i$f$getGreenStub = false;
            StubBasedPsiElementBase stubBasedPsiElementBase = $this$greenStub$iv instanceof StubBasedPsiElementBase ? (StubBasedPsiElementBase)$this$greenStub$iv : null;
            RsPathStub stub = (RsPathStub)(stubBasedPsiElementBase != null ? stubBasedPsiElementBase.getGreenStub() : null);
            if (stub != null) {
                StubElement<?> stubElement = this.getRootCachingElementStub(stub);
                rsElement = (RsElement)(stubElement != null ? stubElement.getPsi() : null);
            } else {
                rsElement = this.getRootCachingElementPsi(path);
            }
            return rsElement;
        }

        private final RsElement getRootCachingElementPsi(RsPath path) {
            RsElement root = null;
            PsiElement element = path;
            IElementType iElementType = RsElementTypes.PATH;
            Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"PATH");
            IElementType elementType = iElementType;
            IElementType prevElementType = null;
            while (this.isStepToParentAllowed(prevElementType, elementType)) {
                PsiElement parent2 = element.getParent();
                Intrinsics.checkNotNull((Object)parent2);
                IElementType parentType = PsiElementExtensionsKt.getElementType(parent2);
                if (Intrinsics.areEqual((Object)parentType, (Object)RsElementTypes.PATH_EXPR)) break;
                if (ALLOWED_CACHING_ROOTS.contains(elementType)) {
                    PsiElement psiElement2 = element;
                    Intrinsics.checkNotNull((Object)psiElement2, (String)"null cannot be cast to non-null type org.rust.lang.core.psi.ext.RsElement");
                    root = (RsElement)psiElement2;
                }
                prevElementType = elementType;
                element = parent2;
                elementType = parentType;
            }
            return root;
        }

        private final StubElement<?> getRootCachingElementStub(RsPathStub path) {
            StubElement parent2;
            IStubElementType parentType;
            StubElement root = null;
            StubElement element = (StubElement)path;
            IElementType iElementType = RsElementTypes.PATH;
            Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"PATH");
            IElementType elementType = iElementType;
            IElementType prevElementType = null;
            while (this.isStepToParentAllowed(prevElementType, elementType) && !Intrinsics.areEqual((Object)(parentType = (parent2 = element.getParentStub()).getStubType()), (Object)RsElementTypes.PATH_EXPR)) {
                if (ALLOWED_CACHING_ROOTS.contains(elementType)) {
                    root = element;
                }
                prevElementType = elementType;
                Intrinsics.checkNotNull((Object)parent2);
                element = parent2;
                Intrinsics.checkNotNull((Object)parentType);
                elementType = (IElementType)parentType;
            }
            return root;
        }

        private final boolean isStepToParentAllowed(IElementType child, IElementType parent2) {
            TokenSet set = Intrinsics.areEqual((Object)child, (Object)RsElementTypes.PATH) ? ALLOWED_PARENT_FOR_PATH : ALLOWED_PARENT_FOR_OTHERS;
            return set.contains(parent2);
        }

        @VisibleForTesting
        @NotNull
        public final List<RsPath> collectNestedPathsFromRoot(@NotNull RsElement root) {
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            StubBasedPsiElementBase stubBasedPsiElementBase = root instanceof StubBasedPsiElementBase ? (StubBasedPsiElementBase)root : null;
            StubElement stub = stubBasedPsiElementBase != null ? stubBasedPsiElementBase.getGreenStub() : null;
            return stub != null ? this.collectNestedPathsFromRootStub(stub) : this.collectNestedPathsFromRootPsi(root);
        }

        private final List<RsPath> collectNestedPathsFromRootPsi(RsElement root) {
            boolean $i$f$testAssert = false;
            boolean $i$f$testAssert2 = false;
            if (UtilsKt.isUnitTestMode()) {
                boolean bl = false;
                if (!ALLOWED_CACHING_ROOTS.contains(PsiElementExtensionsKt.getElementType(root))) {
                    boolean bl2 = false;
                    String message$iv$iv = "Assertion failed";
                    throw new AssertionError((Object)message$iv$iv);
                }
            }
            SmartList result2 = new SmartList();
            Object[] bl = new RsElement[]{root};
            List queue = CollectionsKt.mutableListOf((Object[])bl);
            while (!((Collection)queue).isEmpty()) {
                Object e = queue.removeLast();
                Intrinsics.checkNotNullExpressionValue(e, (String)"removeLast(...)");
                RsElement nextElement = (RsElement)e;
                if (nextElement instanceof RsPath) {
                    boolean $i$f$testAssert3 = false;
                    boolean $i$f$testAssert4 = false;
                    if (UtilsKt.isUnitTestMode()) {
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual((Object)Companion.getRootCachingElementPsi((RsPath)nextElement), (Object)root)) {
                            boolean bl4 = false;
                            String message$iv$iv = "Assertion failed";
                            throw new AssertionError((Object)message$iv$iv);
                        }
                    }
                    result2.add((Object)nextElement);
                }
                IElementType nextElementType = PsiElementExtensionsKt.getElementType(nextElement);
                PsiElement $this$forEachChild$iv = nextElement;
                boolean $i$f$forEachChild = false;
                for (PsiElement psiChild$iv = $this$forEachChild$iv.getFirstChild(); psiChild$iv != null; psiChild$iv = psiChild$iv.getNextSibling()) {
                    if (!(psiChild$iv.getNode() instanceof CompositeElement)) continue;
                    PsiElement child = psiChild$iv;
                    boolean bl5 = false;
                    if (!(child instanceof RsElement) || !Companion.isStepToParentAllowed(PsiElementExtensionsKt.getElementType(child), nextElementType)) continue;
                    ((Collection)queue).add(child);
                }
            }
            return (List)result2;
        }

        private final List<RsPath> collectNestedPathsFromRootStub(StubElement<?> root) {
            boolean $i$f$testAssert = false;
            boolean $i$f$testAssert2 = false;
            if (UtilsKt.isUnitTestMode()) {
                boolean bl = false;
                if (!ALLOWED_CACHING_ROOTS.contains((IElementType)root.getStubType())) {
                    boolean bl2 = false;
                    String message$iv$iv = "Assertion failed";
                    throw new AssertionError((Object)message$iv$iv);
                }
            }
            SmartList result2 = new SmartList();
            Object[] bl = new StubElement[]{root};
            List queue = CollectionsKt.mutableListOf((Object[])bl);
            while (!((Collection)queue).isEmpty()) {
                Object e = queue.removeLast();
                Intrinsics.checkNotNullExpressionValue(e, (String)"removeLast(...)");
                StubElement nextStub = (StubElement)e;
                if (nextStub instanceof RsPathStub) {
                    boolean $i$f$testAssert3 = false;
                    boolean $i$f$testAssert4 = false;
                    if (UtilsKt.isUnitTestMode()) {
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual(Companion.getRootCachingElementStub((RsPathStub)nextStub), root)) {
                            boolean bl4 = false;
                            String message$iv$iv = "Assertion failed";
                            throw new AssertionError((Object)message$iv$iv);
                        }
                    }
                    result2.add((Object)((RsPathStub)nextStub).getPsi());
                }
                IStubElementType nextStubType = nextStub.getStubType();
                for (StubElement child : nextStub.getChildrenStubs()) {
                    IElementType iElementType = (IElementType)child.getStubType();
                    Intrinsics.checkNotNull((Object)nextStubType);
                    if (!this.isStepToParentAllowed(iElementType, (IElementType)nextStubType)) continue;
                    ((Collection)queue).add(child);
                }
            }
            return (List)result2;
        }

        private final Object resolveNeighborPathsInternal(RsPath path) {
            RsElement rsElement = this.getRootCachingElement(path);
            if (rsElement == null) {
                return null;
            }
            RsElement root = rsElement;
            Project project = path.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            return RsResolveCache.Companion.getInstance(project).resolveWithCaching((PsiElement)root, ResolveCacheDependency.LOCAL_AND_RUST_STRUCTURE, Resolver.INSTANCE);
        }

        @NotNull
        public final Map<RsPath, List<RsPathResolveResult<RsElement>>> resolveNeighborPaths(@NotNull RsPath path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Object object = this.resolveNeighborPathsInternal(path);
            if (object == null) {
                return MapsKt.emptyMap();
            }
            Object mapOrList = object;
            return mapOrList instanceof Map ? (Map)mapOrList : MapsKt.mapOf((Pair)TuplesKt.to((Object)path, (Object)((List)mapOrList)));
        }

        @Nullable
        public final RsElement resolve(@NotNull RsPathExpr pathExpr, @NotNull RsInferenceResult inference) {
            Intrinsics.checkNotNullParameter((Object)pathExpr, (String)"pathExpr");
            Intrinsics.checkNotNullParameter((Object)inference, (String)"inference");
            return RsPathReferenceImplKt.access$filterRawMultiResolveVariants(RsPathReferenceImplKt.access$getPathResolveResults(pathExpr, inference));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\b\u00c2\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0011\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0002H\u0096\u0002\u00a8\u0006\b"}, d2={"Lorg/rust/lang/core/resolve/ref/RsPathReferenceImpl$Resolver;", "Lkotlin/Function1;", "Lorg/rust/lang/core/psi/ext/RsElement;", "", "<init>", "()V", "invoke", "root", "intellij.rustrover.core"})
    @SourceDebugExtension(value={"SMAP\nRsPathReferenceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RsPathReferenceImpl.kt\norg/rust/lang/core/resolve/ref/RsPathReferenceImpl$Resolver\n+ 2 utils.kt\norg/rust/openapiext/UtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,809:1\n305#2,10:810\n2756#3:820\n1563#3:822\n1634#3,3:823\n3301#3,10:826\n1491#3:836\n1516#3,3:837\n1519#3,3:847\n1252#3,2:852\n1563#3:854\n1634#3,3:855\n1255#3:858\n1252#3,4:861\n1267#3,4:865\n1869#3,2:869\n1#4:821\n382#5,7:840\n463#5:850\n413#5:851\n463#5:859\n413#5:860\n*S KotlinDebug\n*F\n+ 1 RsPathReferenceImpl.kt\norg/rust/lang/core/resolve/ref/RsPathReferenceImpl$Resolver\n*L\n244#1:810,10\n251#1:820\n253#1:822\n253#1:823,3\n254#1:826,10\n256#1:836\n256#1:837,3\n256#1:847,3\n257#1:852,2\n257#1:854\n257#1:855,3\n257#1:858\n262#1:861,4\n266#1:865,4\n269#1:869,2\n251#1:821\n256#1:840,7\n257#1:850\n257#1:851\n262#1:859\n262#1:860\n*E\n"})
    private static final class Resolver
    implements Function1<RsElement, Object> {
        @NotNull
        public static final Resolver INSTANCE = new Resolver();

        private Resolver() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public Object invoke(@NotNull RsElement root) {
            void $this$associateTo$iv;
            Map $this$mapValues$iv;
            List list;
            Object $this$map$iv;
            Object k;
            Map $this$associateByTo$iv$iv$iv;
            Map.Entry $this$mapValuesTo$iv$iv2;
            void $this$mapValues$iv2;
            Object value$iv$iv$iv;
            Map.Entry $this$getOrPut$iv$iv$iv;
            Object key$iv$iv$iv;
            void $this$groupByTo$iv$iv;
            Map<RsPath, SmartList<RsPathResolveResult<RsElement>>> $this$groupBy$iv;
            Object element$iv3;
            Object object;
            RsPath it22;
            void $this$mapTo$iv$iv;
            List<RsPath> allPaths;
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            boolean $i$f$testAssert = false;
            boolean $i$f$testAssert2 = false;
            if (UtilsKt.isUnitTestMode()) {
                boolean bl = false;
                if (!(!(root.getParent() instanceof RsPathExpr))) {
                    boolean bl2 = false;
                    String message$iv$iv = "Assertion failed";
                    throw new AssertionError((Object)message$iv$iv);
                }
            }
            if ((allPaths = Companion.collectNestedPathsFromRoot(root)).isEmpty()) {
                return CollectionsKt.emptyList();
            }
            PathResolutionContext ctx = new PathResolutionContext(root, false, true, null);
            if (allPaths.size() == 1) {
                void $this$onEach$iv;
                void var7_16;
                RsPath singlePath = (RsPath)CollectionsKt.single(allPaths);
                Iterable message$iv$iv = RsPathReferenceImplKt.access$resolvePath(ctx, singlePath, ctx.classifyPath(singlePath));
                boolean $i$f$onEach = false;
                void $this$onEach_u24lambda_u240$iv = var7_16 = $this$onEach$iv;
                boolean bl = false;
                for (Object element$iv2 : $this$onEach_u24lambda_u240$iv) {
                    RsPathResolveResult it22 = (RsPathResolveResult)element$iv2;
                    boolean bl3 = false;
                    if (!FoldKt.getHasTyInfer(it22.getResolvedSubst())) continue;
                    throw new IllegalStateException("Check failed.");
                }
                return var7_16;
            }
            Iterable $this$map$iv2 = allPaths;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv2;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it22 = (RsPath)item$iv$iv;
                object = destination$iv$iv;
                boolean bl = false;
                object.add(TuplesKt.to((Object)it22, (Object)ctx.classifyPath(it22)));
            }
            List classifiedPaths = (List)destination$iv$iv;
            Iterable $this$partition$iv = classifiedPaths;
            boolean $i$f$partition = false;
            ArrayList first$iv = new ArrayList();
            Iterable<Object> second$iv = new ArrayList();
            for (Object element$iv3 : $this$partition$iv) {
                it22 = (Pair)element$iv3;
                boolean bl = false;
                boolean bl4 = it22.getSecond() instanceof RsPathResolveKind.UnqualifiedPath ? first$iv.add(element$iv3) : second$iv.add(element$iv3);
            }
            Pair pair = new Pair(first$iv, second$iv);
            List unqualified = (List)pair.component1();
            List others = (List)pair.component2();
            second$iv = unqualified;
            boolean $i$f$groupBy = false;
            element$iv3 = $this$groupBy$iv;
            Map<RsPath, SmartList<RsPathResolveResult<RsElement>>> destination$iv$iv2 = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                Object object2;
                Pair it3 = (Pair)element$iv$iv;
                boolean bl = false;
                RsPathResolveKind key$iv$iv = (RsPathResolveKind)it3.getSecond();
                Map<RsPath, SmartList<RsPathResolveResult<RsElement>>> map2 = destination$iv$iv2;
                key$iv$iv$iv = key$iv$iv;
                boolean $i$f$getOrPut = false;
                value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl5 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv$iv, answer$iv$iv$iv);
                    object2 = answer$iv$iv$iv;
                } else {
                    object2 = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object2;
                list$iv$iv.add(element$iv$iv);
            }
            $this$groupBy$iv = destination$iv$iv2;
            boolean $i$f$mapValues22 = false;
            $this$groupByTo$iv$iv = $this$mapValues$iv2;
            destination$iv$iv2 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv2.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable iterable2 = $this$mapValuesTo$iv$iv2.entrySet();
            Map<RsPath, SmartList<RsPathResolveResult<RsElement>>> destination$iv$iv$iv = destination$iv$iv2;
            boolean $i$f$associateByTo = false;
            Object bl = $this$associateByTo$iv$iv$iv.iterator();
            while (bl.hasNext()) {
                void $this$mapTo$iv$iv2;
                void it$iv$iv;
                Object element$iv$iv$iv = bl.next();
                $this$getOrPut$iv$iv$iv = (Map.Entry)element$iv$iv$iv;
                key$iv$iv$iv = destination$iv$iv$iv;
                boolean bl6 = false;
                value$iv$iv$iv = (Map.Entry)element$iv$iv$iv;
                k = it$iv$iv.getKey();
                object = key$iv$iv$iv;
                boolean bl7 = false;
                List v = (List)value$iv$iv$iv.getValue();
                $this$map$iv = v;
                boolean $i$f$map2 = false;
                Iterable iterable3 = $this$map$iv;
                Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                    void it4;
                    Pair pair2 = (Pair)item$iv$iv;
                    Collection collection = destination$iv$iv3;
                    boolean bl8 = false;
                    collection.add((RsPath)it4.getFirst());
                }
                list = (List)destination$iv$iv3;
                object.put(k, list);
            }
            Map<RsPath, SmartList<RsPathResolveResult<RsElement>>> kindToPathList = destination$iv$iv$iv;
            HashMap resolved = new HashMap();
            for (Map.Entry $this$mapValuesTo$iv$iv2 : kindToPathList.entrySet()) {
                void $this$associateByTo$iv$iv$iv2;
                void $this$mapValuesTo$iv$iv3;
                RsPathResolveKind kind2 = (RsPathResolveKind)$this$mapValuesTo$iv$iv2.getKey();
                List paths = (List)$this$mapValuesTo$iv$iv2.getValue();
                $this$associateByTo$iv$iv$iv = resolved;
                destination$iv$iv$iv = ProcessorsKt.collectMultiplePathResolveVariants(ctx, paths, (Function1<? super RsResolveProcessorBase<? super ScopeEntry>, Unit>)((Function1)arg_0 -> Resolver.invoke$lambda$6(ctx, kind2, arg_0)));
                boolean $i$f$mapValues = false;
                bl = $this$mapValues$iv;
                Map destination$iv$iv4 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
                boolean $i$f$mapValuesTo2 = false;
                key$iv$iv$iv = $this$mapValuesTo$iv$iv3.entrySet();
                Map destination$iv$iv$iv2 = destination$iv$iv4;
                boolean $i$f$associateByTo2 = false;
                for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv2) {
                    void it$iv$iv;
                    $this$map$iv = (Map.Entry)element$iv$iv$iv;
                    Map map3 = destination$iv$iv$iv2;
                    boolean bl9 = false;
                    Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                    k = it$iv$iv.getKey();
                    object = map3;
                    boolean bl10 = false;
                    RsPath path = (RsPath)entry2.getKey();
                    SmartList result2 = (SmartList)entry2.getValue();
                    list = RsPathReferenceImplKt.access$filterResolveResults(path, (List)result2);
                    object.put(k, list);
                }
                $this$mapValues$iv = destination$iv$iv$iv2;
                $this$associateByTo$iv$iv$iv.putAll($this$mapValues$iv);
            }
            Iterable $i$f$mapValues22 = others;
            Map destination$iv = resolved;
            boolean $i$f$associateTo = false;
            for (Object element$iv4 : $this$associateTo$iv) {
                $this$mapValues$iv = destination$iv;
                Pair $i$f$mapValues = (Pair)element$iv4;
                boolean bl11 = false;
                RsPath path = (RsPath)$i$f$mapValues.component1();
                RsPathResolveKind kind3 = (RsPathResolveKind)$i$f$mapValues.component2();
                $i$f$mapValues = TuplesKt.to((Object)path, (Object)RsPathReferenceImplKt.access$resolvePath(ctx, path, kind3));
                $this$mapValues$iv.put($i$f$mapValues.getFirst(), $i$f$mapValues.getSecond());
            }
            Collection collection = resolved.values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
            Iterable $this$forEach$iv = collection;
            boolean $i$f$forEach = false;
            for (Object element$iv5 : $this$forEach$iv) {
                List l = (List)element$iv5;
                boolean bl12 = false;
                Intrinsics.checkNotNull((Object)l);
                Iterable $this$forEach$iv2 = l;
                boolean $i$f$forEach2 = false;
                for (Object element$iv6 : $this$forEach$iv2) {
                    RsPathResolveResult r = (RsPathResolveResult)element$iv6;
                    boolean bl13 = false;
                    if (!FoldKt.getHasTyInfer(r.getResolvedSubst())) continue;
                    throw new IllegalStateException("Check failed.");
                }
            }
            return resolved;
        }

        private static final Unit invoke$lambda$6(PathResolutionContext $ctx, RsPathResolveKind $kind, RsResolveProcessorBase it2) {
            Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
            NameResolutionKt.processPathResolveVariants($ctx, $kind, it2);
            return Unit.INSTANCE;
        }
    }
}

