/*
 * Decompiled with CFR 0.152.
 */
package org.rust.lang.core.resolve.ref;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.ResolveResult;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.lang.core.psi.RsFunction;
import org.rust.lang.core.psi.RsPath;
import org.rust.lang.core.psi.ext.CfgUtilsKt;
import org.rust.lang.core.psi.ext.RsElement;
import org.rust.lang.core.psi.ext.RsMacroDefinitionBase;
import org.rust.lang.core.psi.ext.RsNamedElement;
import org.rust.lang.core.psi.ext.RsReferenceElementBase;
import org.rust.lang.core.resolve.NameResolutionKt;
import org.rust.lang.core.resolve.ProcessorsKt;
import org.rust.lang.core.resolve.RsPathResolveResult;
import org.rust.lang.core.resolve.RsResolveProcessorBase;
import org.rust.lang.core.resolve.ScopeEntry;
import org.rust.lang.core.resolve.VisibilityStatus;
import org.rust.lang.core.resolve.ref.ResolveCacheDependency;
import org.rust.lang.core.resolve.ref.RsPathReference;
import org.rust.lang.core.resolve.ref.RsReferenceBase;
import org.rust.lang.core.resolve.ref.RsResolveCache;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001\u0016B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0004\u001a\u00020\tH\u0016J\u001d\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\bH\u0016\u00a2\u0006\u0002\u0010\u000eJ\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0016J\n\u0010\u0011\u001a\u0004\u0018\u00010\u0010H\u0016J\u0014\u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u00130\u000fH\u0016J\b\u0010\u0015\u001a\u0004\u0018\u00010\u0010\u00a8\u0006\u0017"}, d2={"Lorg/rust/lang/core/resolve/ref/RsMacroPathReferenceImpl;", "Lorg/rust/lang/core/resolve/ref/RsReferenceBase;", "Lorg/rust/lang/core/psi/RsPath;", "Lorg/rust/lang/core/resolve/ref/RsPathReference;", "element", "<init>", "(Lorg/rust/lang/core/psi/RsPath;)V", "isReferenceTo", "", "Lcom/intellij/psi/PsiElement;", "multiResolve", "", "Lcom/intellij/psi/ResolveResult;", "incompleteCode", "(Z)[Lcom/intellij/psi/ResolveResult;", "", "Lorg/rust/lang/core/psi/ext/RsNamedElement;", "resolve", "rawMultiResolve", "Lorg/rust/lang/core/resolve/RsPathResolveResult;", "Lorg/rust/lang/core/psi/ext/RsElement;", "resolveIfCached", "Resolver", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nRsMacroPathReferenceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RsMacroPathReferenceImpl.kt\norg/rust/lang/core/resolve/ref/RsMacroPathReferenceImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,79:1\n1#2:80\n*E\n"})
public final class RsMacroPathReferenceImpl
extends RsReferenceBase<RsPath>
implements RsPathReference {
    public RsMacroPathReferenceImpl(@NotNull RsPath element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        super((RsReferenceElementBase)element);
    }

    public boolean isReferenceTo(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return (element instanceof RsMacroDefinitionBase || element instanceof RsFunction) && super.isReferenceTo(element);
    }

    @Override
    @NotNull
    public ResolveResult[] multiResolve(boolean incompleteCode) {
        ResolveResult[] resolveResultArray;
        RsNamedElement rsNamedElement = this.resolve();
        if (rsNamedElement != null) {
            RsNamedElement it2 = rsNamedElement;
            boolean bl = false;
            PsiElementResolveResult[] psiElementResolveResultArray = new PsiElementResolveResult[]{new PsiElementResolveResult((PsiElement)it2)};
            resolveResultArray = (ResolveResult[])psiElementResolveResultArray;
        } else {
            resolveResultArray = ResolveResult.EMPTY_ARRAY;
            Intrinsics.checkNotNullExpressionValue((Object)ResolveResult.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
        }
        return resolveResultArray;
    }

    @NotNull
    public List<RsNamedElement> multiResolve() {
        return CollectionsKt.listOfNotNull((Object)this.resolve());
    }

    @Override
    @Nullable
    public RsNamedElement resolve() {
        Project project = ((RsPath)this.getElement()).getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        RsResolveCache rsResolveCache = RsResolveCache.Companion.getInstance(project);
        PsiElement psiElement2 = this.getElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"getElement(...)");
        return (RsNamedElement)rsResolveCache.resolveWithCaching(psiElement2, ResolveCacheDependency.LOCAL_AND_RUST_STRUCTURE, Resolver.INSTANCE);
    }

    @Override
    @NotNull
    public List<RsPathResolveResult<RsElement>> rawMultiResolve() {
        RsNamedElement rsNamedElement = this.resolve();
        if (rsNamedElement == null) {
            return CollectionsKt.emptyList();
        }
        RsNamedElement result2 = rsNamedElement;
        VisibilityStatus visibility = CfgUtilsKt.isEnabledByCfg(result2) ? VisibilityStatus.Visible : VisibilityStatus.CfgDisabled;
        return CollectionsKt.listOf(new RsPathResolveResult(result2, null, visibility, null, false, 10, null));
    }

    @Nullable
    public final RsNamedElement resolveIfCached() {
        Project project = ((RsPath)this.getElement()).getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        RsResolveCache rsResolveCache = RsResolveCache.Companion.getInstance(project);
        PsiElement psiElement2 = this.getElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"getElement(...)");
        Object object = rsResolveCache.getCached(psiElement2, ResolveCacheDependency.LOCAL_AND_RUST_STRUCTURE);
        return object instanceof RsNamedElement ? (RsNamedElement)object : null;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c2\u0002\u0018\u00002\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0007\u001a\u00020\u0002H\u0096\u0002\u00a8\u0006\b"}, d2={"Lorg/rust/lang/core/resolve/ref/RsMacroPathReferenceImpl$Resolver;", "Lkotlin/Function1;", "Lorg/rust/lang/core/psi/RsPath;", "Lorg/rust/lang/core/psi/ext/RsNamedElement;", "<init>", "()V", "invoke", "element", "intellij.rustrover.core"})
    private static final class Resolver
    implements Function1<RsPath, RsNamedElement> {
        @NotNull
        public static final Resolver INSTANCE = new Resolver();

        private Resolver() {
        }

        @Nullable
        public RsNamedElement invoke(@NotNull RsPath element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            RsElement rsElement = ProcessorsKt.pickFirstResolveVariant(element.getReferenceName(), true, (Function1<? super RsResolveProcessorBase<? super ScopeEntry>, Unit>)((Function1)arg_0 -> Resolver.invoke$lambda$0(element, arg_0)));
            return rsElement instanceof RsNamedElement ? (RsNamedElement)rsElement : null;
        }

        private static final Unit invoke$lambda$0(RsPath $element, RsResolveProcessorBase it2) {
            Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
            NameResolutionKt.processMacroCallPathResolveVariants($element, false, it2);
            return Unit.INSTANCE;
        }
    }
}

