/*
 * Decompiled with CFR 0.152.
 */
package org.rust.lang.core.resolve.ref;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.util.ProcessingContext;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.rust.lang.core.psi.RsLitExpr;
import org.rust.lang.core.psi.RsLiteralKind;
import org.rust.lang.core.psi.RsLiteralKindKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\"\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J!\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ#\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H$\u00a2\u0006\u0002\u0010\u0014\u00a8\u0006\u0015"}, d2={"Lorg/rust/lang/core/resolve/ref/RsLiteralWebReferenceProviderBase;", "Lcom/intellij/psi/PsiReferenceProvider;", "<init>", "()V", "acceptsTarget", "", "target", "Lcom/intellij/psi/PsiElement;", "getReferencesByElement", "", "Lcom/intellij/psi/PsiReference;", "element", "context", "Lcom/intellij/util/ProcessingContext;", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/util/ProcessingContext;)[Lcom/intellij/psi/PsiReference;", "getReferencesByStringLiteral", "expr", "Lorg/rust/lang/core/psi/RsLitExpr;", "literal", "Lorg/rust/lang/core/psi/RsLiteralKind$String;", "(Lorg/rust/lang/core/psi/RsLitExpr;Lorg/rust/lang/core/psi/RsLiteralKind$String;)[Lcom/intellij/psi/PsiReference;", "intellij.rustrover.core"})
abstract class RsLiteralWebReferenceProviderBase
extends PsiReferenceProvider {
    public boolean acceptsTarget(@NotNull PsiElement target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        return false;
    }

    @NotNull
    public final PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        PsiReference[] psiReferenceArray;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        RsLitExpr rsLitExpr = element instanceof RsLitExpr ? (RsLitExpr)element : null;
        if (rsLitExpr == null) {
            Intrinsics.checkNotNullExpressionValue((Object)PsiReference.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
            return PsiReference.EMPTY_ARRAY;
        }
        RsLitExpr expr = rsLitExpr;
        RsLiteralKind literal = RsLiteralKindKt.getKind(expr);
        if (literal instanceof RsLiteralKind.String) {
            psiReferenceArray = this.getReferencesByStringLiteral(expr, (RsLiteralKind.String)literal);
        } else {
            psiReferenceArray = PsiReference.EMPTY_ARRAY;
            Intrinsics.checkNotNullExpressionValue((Object)PsiReference.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
        }
        return psiReferenceArray;
    }

    @NotNull
    protected abstract PsiReference[] getReferencesByStringLiteral(@NotNull RsLitExpr var1, @NotNull RsLiteralKind.String var2);
}

