/*
 * Decompiled with CFR 0.152.
 */
package org.rust.lang.core.resolve.ref;

import com.intellij.openapi.paths.WebReference;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.rust.cargo.project.workspace.PackageOrigin;
import org.rust.lang.core.psi.RsLitExpr;
import org.rust.lang.core.psi.RsLiteralKind;
import org.rust.lang.core.psi.RsMetaItem;
import org.rust.lang.core.psi.RsMetaItemArgs;
import org.rust.lang.core.psi.ext.RsMetaItemKt;
import org.rust.lang.core.resolve.ref.RsLiteralWebReferenceProviderBase;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J#\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014\u00a2\u0006\u0002\u0010\u000b\u00a8\u0006\r"}, d2={"Lorg/rust/lang/core/resolve/ref/RsLiteralGitHubIssueProvider;", "Lorg/rust/lang/core/resolve/ref/RsLiteralWebReferenceProviderBase;", "<init>", "()V", "getReferencesByStringLiteral", "", "Lcom/intellij/psi/PsiReference;", "expr", "Lorg/rust/lang/core/psi/RsLitExpr;", "literal", "Lorg/rust/lang/core/psi/RsLiteralKind$String;", "(Lorg/rust/lang/core/psi/RsLitExpr;Lorg/rust/lang/core/psi/RsLiteralKind$String;)[Lcom/intellij/psi/PsiReference;", "Companion", "intellij.rustrover.core"})
final class RsLiteralGitHubIssueProvider
extends RsLiteralWebReferenceProviderBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Set<String> RUST_ISSUE_ATTR_NAMES;

    @Override
    @NotNull
    protected PsiReference[] getReferencesByStringLiteral(@NotNull RsLitExpr expr, @NotNull RsLiteralKind.String literal) {
        PsiReference[] psiReferenceArray;
        Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
        Intrinsics.checkNotNullParameter((Object)literal, (String)"literal");
        if (expr.getContainingCrate().getOrigin() != PackageOrigin.STDLIB) {
            Intrinsics.checkNotNullExpressionValue((Object)PsiReference.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
            return PsiReference.EMPTY_ARRAY;
        }
        PsiElement psiElement2 = expr.getParent();
        RsMetaItem rsMetaItem = psiElement2 instanceof RsMetaItem ? (RsMetaItem)psiElement2 : null;
        if (rsMetaItem == null) {
            Intrinsics.checkNotNullExpressionValue((Object)PsiReference.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
            return PsiReference.EMPTY_ARRAY;
        }
        RsMetaItem exprMetaItem = rsMetaItem;
        if (!Intrinsics.areEqual((Object)RsMetaItemKt.getName(exprMetaItem), (Object)"issue")) {
            Intrinsics.checkNotNullExpressionValue((Object)PsiReference.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
            return PsiReference.EMPTY_ARRAY;
        }
        Object object = literal.getValue();
        if (object == null || (object = StringsKt.toLongOrNull((String)object)) == null) {
            Intrinsics.checkNotNullExpressionValue((Object)PsiReference.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
            return PsiReference.EMPTY_ARRAY;
        }
        long issueNumber = (Long)object;
        PsiElement psiElement3 = exprMetaItem.getParent();
        RsMetaItemArgs rsMetaItemArgs = psiElement3 instanceof RsMetaItemArgs ? (RsMetaItemArgs)psiElement3 : null;
        PsiElement psiElement4 = rsMetaItemArgs != null ? rsMetaItemArgs.getParent() : null;
        RsMetaItem rsMetaItem2 = psiElement4 instanceof RsMetaItem ? (RsMetaItem)psiElement4 : null;
        if (rsMetaItem2 == null) {
            Intrinsics.checkNotNullExpressionValue((Object)PsiReference.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
            return PsiReference.EMPTY_ARRAY;
        }
        RsMetaItem metaItem = rsMetaItem2;
        if (RsMetaItemKt.isRootMetaItem$default(metaItem, null, 1, null) && CollectionsKt.contains((Iterable)RUST_ISSUE_ATTR_NAMES, (Object)RsMetaItemKt.getName(metaItem))) {
            PsiReference[] psiReferenceArray2 = new PsiReference[]{new WebReference((PsiElement)expr, literal.getOffsets().getValue(), "https://github.com/rust-lang/rust/issues/" + issueNumber)};
            psiReferenceArray = psiReferenceArray2;
        } else {
            PsiReference[] psiReferenceArray3 = PsiReference.EMPTY_ARRAY;
            Intrinsics.checkNotNull((Object)psiReferenceArray3);
            psiReferenceArray = psiReferenceArray3;
        }
        return psiReferenceArray;
    }

    static {
        Object[] objectArray = new String[]{"unstable", "rustc_const_unstable"};
        RUST_ISSUE_ATTR_NAMES = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/rust/lang/core/resolve/ref/RsLiteralGitHubIssueProvider$Companion;", "", "<init>", "()V", "RUST_ISSUE_ATTR_NAMES", "", "", "intellij.rustrover.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

