/*
 * Decompiled with CFR 0.152.
 */
package org.rust.lang.core.resolve.ref;

import com.intellij.openapi.paths.GlobalPathReferenceProvider;
import com.intellij.openapi.paths.WebReference;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.util.SmartList;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.TuplesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.rust.lang.core.psi.RsLitExpr;
import org.rust.lang.core.psi.RsLiteralKind;
import org.rust.lang.core.psi.RsTokenTypeKt;
import org.rust.lang.core.resolve.ref.RsLiteralWebReferenceProviderBase;
import org.rust.lang.utils.RsEscapesUtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J#\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014\u00a2\u0006\u0002\u0010\u000b\u00a8\u0006\r"}, d2={"Lorg/rust/lang/core/resolve/ref/RsLiteralGeneralUrlProvider;", "Lorg/rust/lang/core/resolve/ref/RsLiteralWebReferenceProviderBase;", "<init>", "()V", "getReferencesByStringLiteral", "", "Lcom/intellij/psi/PsiReference;", "expr", "Lorg/rust/lang/core/psi/RsLitExpr;", "literal", "Lorg/rust/lang/core/psi/RsLiteralKind$String;", "(Lorg/rust/lang/core/psi/RsLitExpr;Lorg/rust/lang/core/psi/RsLiteralKind$String;)[Lcom/intellij/psi/PsiReference;", "Companion", "intellij.rustrover.core"})
final class RsLiteralGeneralUrlProvider
extends RsLiteralWebReferenceProviderBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Regex SPACE_SPLITTER = new Regex("\\s");

    @Override
    @NotNull
    protected PsiReference[] getReferencesByStringLiteral(@NotNull RsLitExpr expr, @NotNull RsLiteralKind.String literal) {
        Pair pair;
        Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
        Intrinsics.checkNotNullParameter((Object)literal, (String)"literal");
        if (!expr.textContains(':')) {
            Intrinsics.checkNotNullExpressionValue((Object)PsiReference.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
            return PsiReference.EMPTY_ARRAY;
        }
        TextRange textRange = literal.getOffsets().getValue();
        if (textRange == null) {
            Intrinsics.checkNotNullExpressionValue((Object)PsiReference.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
            return PsiReference.EMPTY_ARRAY;
        }
        TextRange valueRange = textRange;
        String string = literal.getRawValue();
        if (string == null) {
            Intrinsics.checkNotNullExpressionValue((Object)PsiReference.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
            return PsiReference.EMPTY_ARRAY;
        }
        String rawValue = string;
        if (RsTokenTypeKt.getRS_RAW_LITERALS().contains(literal.getNode().getElementType())) {
            pair = TuplesKt.to((Object)rawValue, RsLiteralGeneralUrlProvider::getReferencesByStringLiteral$lambda$0);
        } else {
            Triple<StringBuilder, int[], Boolean> triple = RsEscapesUtilsKt.parseRustStringCharacters(rawValue);
            StringBuilder content = (StringBuilder)triple.component1();
            int[] indices = (int[])triple.component2();
            pair = TuplesKt.to((Object)content, arg_0 -> RsLiteralGeneralUrlProvider.getReferencesByStringLiteral$lambda$1(indices, arg_0));
        }
        Pair pair2 = pair;
        Object content = pair2.component1();
        Function1 indexFn = (Function1)pair2.component2();
        SmartList references = new SmartList();
        int index = 0;
        CharSequence charSequence = (CharSequence)content;
        Regex regex = SPACE_SPLITTER;
        int n = 0;
        for (String word : regex.split(charSequence, n)) {
            if (((CharSequence)word).length() > 0 && GlobalPathReferenceProvider.isWebReferenceUrl((String)word)) {
                int startOffset = valueRange.getStartOffset() + ((Number)indexFn.invoke((Object)index)).intValue();
                int endOffset = valueRange.getStartOffset() + ((Number)indexFn.invoke((Object)(index + word.length()))).intValue();
                ((Collection)references).add(new WebReference((PsiElement)expr, new TextRange(startOffset, endOffset), word));
            }
            index += word.length() + 1;
        }
        Object[] objectArray = references.toArray((Object[])PsiReference.EMPTY_ARRAY);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"toArray(...)");
        return (PsiReference[])objectArray;
    }

    private static final int getReferencesByStringLiteral$lambda$0(int i2) {
        return i2;
    }

    private static final int getReferencesByStringLiteral$lambda$1(int[] $indices, int i2) {
        return $indices[i2];
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/rust/lang/core/resolve/ref/RsLiteralGeneralUrlProvider$Companion;", "", "<init>", "()V", "SPACE_SPLITTER", "Lkotlin/text/Regex;", "intellij.rustrover.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

