/*
 * Decompiled with CFR 0.152.
 */
package org.rust.lang.core.resolve.ref;

import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.lang.RsFileType;
import org.rust.lang.core.psi.RsIncludeMacroArgument;
import org.rust.lang.core.psi.RsLitExpr;
import org.rust.lang.core.psi.RsMetaItem;
import org.rust.lang.core.psi.RsModDeclItem;
import org.rust.lang.core.psi.ext.PsiElementKt;
import org.rust.lang.core.psi.ext.RsElement;
import org.rust.lang.core.psi.ext.RsElementKt;
import org.rust.lang.core.psi.ext.RsMod;
import org.rust.lang.core.resolve.RsModFileResolutionAnchor;
import org.rust.lang.core.resolve.RsModFileResolutionAnchorKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016J\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0010H\u0014J\n\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0014\u00a8\u0006\u0013"}, d2={"Lorg/rust/lang/core/resolve/ref/RsLiteralFileReferenceSet;", "Lcom/intellij/psi/impl/source/resolve/reference/impl/providers/FileReferenceSet;", "str", "", "element", "Lorg/rust/lang/core/psi/RsLitExpr;", "startOffset", "", "isCaseSensitive", "", "<init>", "(Ljava/lang/String;Lorg/rust/lang/core/psi/RsLitExpr;IZ)V", "getDefaultContexts", "", "Lcom/intellij/psi/PsiFileSystemItem;", "getReferenceCompletionFilter", "Lcom/intellij/openapi/util/Condition;", "getContainingFile", "Lcom/intellij/psi/PsiFile;", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nRsLitExprReferenceContributor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RsLitExprReferenceContributor.kt\norg/rust/lang/core/resolve/ref/RsLiteralFileReferenceSet\n+ 2 PsiElement.kt\norg/rust/lang/core/psi/ext/PsiElementKt\n*L\n1#1,445:1\n84#2:446\n*S KotlinDebug\n*F\n+ 1 RsLitExprReferenceContributor.kt\norg/rust/lang/core/resolve/ref/RsLiteralFileReferenceSet\n*L\n79#1:446\n*E\n"})
final class RsLiteralFileReferenceSet
extends FileReferenceSet {
    public RsLiteralFileReferenceSet(@NotNull String str, @NotNull RsLitExpr element, int startOffset, boolean isCaseSensitive) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        super(str, (PsiElement)element, startOffset, null, isCaseSensitive);
    }

    @NotNull
    public Collection<PsiFileSystemItem> getDefaultContexts() {
        Collection collection;
        PsiElement parent2 = this.getElement().getContext();
        if (parent2 instanceof RsMetaItem) {
            RsElement item;
            Object object;
            RsElement rsElement;
            PsiElement $this$contextStrict$iv = parent2;
            boolean $i$f$contextStrict = false;
            RsModDeclItem rsModDeclItem = (RsModDeclItem)PsiTreeUtil.getContextOfType((PsiElement)$this$contextStrict$iv, RsModDeclItem.class, (boolean)true);
            if (rsModDeclItem != null) {
                rsElement = rsModDeclItem;
            } else {
                $this$contextStrict$iv = parent2;
                $i$f$contextStrict = false;
                rsElement = (RsElement)PsiTreeUtil.getContextOfType((PsiElement)$this$contextStrict$iv, RsMod.class, (boolean)true);
            }
            collection = CollectionsKt.listOfNotNull((object = (item = rsElement)) != null && (object = RsModFileResolutionAnchorKt.getModFileResolutionAnchor((RsElement)object, true)) != null ? RsModFileResolutionAnchor.getOwnedDirectory$default((RsModFileResolutionAnchor)object, false, 1, null) : null);
        } else if (parent2 instanceof RsIncludeMacroArgument) {
            Collection collection2 = this.getParentDirectoryContext();
            collection = collection2;
            Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"getParentDirectoryContext(...)");
        } else {
            PsiElement psiElement2 = this.getElement();
            RsElement rsElement = psiElement2 instanceof RsElement ? (RsElement)psiElement2 : null;
            if (rsElement == null) {
                return CollectionsKt.emptyList();
            }
            RsElement rsElement2 = rsElement;
            Object object = RsElementKt.getContainingCargoPackage(rsElement2);
            if (object == null || (object = object.getWorkspace()) == null || (object = object.getWorkspaceRoot()) == null) {
                return CollectionsKt.emptyList();
            }
            Object workspaceRoot = object;
            VirtualFile[] virtualFileArray = new VirtualFile[]{workspaceRoot};
            Collection collection3 = this.toFileSystemItems(virtualFileArray);
            Intrinsics.checkNotNullExpressionValue((Object)collection3, (String)"toFileSystemItems(...)");
            return collection3;
        }
        return collection;
    }

    @NotNull
    protected Condition<PsiFileSystemItem> getReferenceCompletionFilter() {
        Condition condition;
        if (this.getElement().getContext() instanceof RsMetaItem) {
            condition = RsLiteralFileReferenceSet::getReferenceCompletionFilter$lambda$0;
        } else {
            Condition condition2 = super.getReferenceCompletionFilter();
            condition = condition2;
            Intrinsics.checkNotNullExpressionValue((Object)condition2, (String)"getReferenceCompletionFilter(...)");
        }
        return condition;
    }

    @Nullable
    protected PsiFile getContainingFile() {
        Object object;
        PsiFile cf = this.getElement().getContainingFile();
        PsiFile injectionHostFile = InjectedLanguageManager.getInstance((Project)cf.getProject()).getTopLevelFile((PsiElement)cf);
        if (!Intrinsics.areEqual((Object)injectionHostFile, (Object)cf)) {
            PsiFile psiFile = injectionHostFile;
            object = psiFile != null ? psiFile.getOriginalFile() : null;
        } else {
            PsiElement psiElement2 = this.getElement();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"getElement(...)");
            object = PsiElementKt.getContextualFile(psiElement2).getOriginalFile();
        }
        return object;
    }

    private static final boolean getReferenceCompletionFilter$lambda$0(PsiFileSystemItem item) {
        if (item.isDirectory()) {
            return true;
        }
        return Intrinsics.areEqual((Object)item.getVirtualFile().getFileType(), (Object)((Object)RsFileType.INSTANCE));
    }
}

