/*
 * Decompiled with CFR 0.152.
 */
package org.rust.lang.core.resolve.ref;

import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.util.ProcessingContext;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.rust.lang.core.psi.RsLitExpr;
import org.rust.lang.core.psi.RsLiteralKind;
import org.rust.lang.core.psi.RsLiteralKindKt;
import org.rust.lang.core.psi.ext.PsiElementKt;
import org.rust.lang.core.resolve.ref.RsLiteralFileReferenceSet;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J#\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a2\u0006\u0002\u0010\u000b\u00a8\u0006\f"}, d2={"Lorg/rust/lang/core/resolve/ref/RsFileReferenceProvider;", "Lcom/intellij/psi/PsiReferenceProvider;", "<init>", "()V", "getReferencesByElement", "", "Lcom/intellij/psi/impl/source/resolve/reference/impl/providers/FileReference;", "element", "Lcom/intellij/psi/PsiElement;", "context", "Lcom/intellij/util/ProcessingContext;", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/util/ProcessingContext;)[Lcom/intellij/psi/impl/source/resolve/reference/impl/providers/FileReference;", "intellij.rustrover.core"})
final class RsFileReferenceProvider
extends PsiReferenceProvider {
    @NotNull
    public FileReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        RsLitExpr rsLitExpr = element instanceof RsLitExpr ? (RsLitExpr)element : null;
        RsLiteralKind rsLiteralKind = rsLitExpr != null ? RsLiteralKindKt.getKind(rsLitExpr) : null;
        RsLiteralKind.String string = rsLiteralKind instanceof RsLiteralKind.String ? (RsLiteralKind.String)rsLiteralKind : null;
        if (string == null) {
            return new FileReference[0];
        }
        RsLiteralKind.String stringLiteral = string;
        if (stringLiteral.isByte() || stringLiteral.isCStr()) {
            return new FileReference[0];
        }
        TextRange textRange = stringLiteral.getOffsets().getValue();
        if (textRange == null) {
            return new FileReference[0];
        }
        int startOffset = textRange.getStartOffset();
        VirtualFile virtualFile = PsiElementKt.getContextualFile(element).getOriginalFile().getVirtualFile();
        if (virtualFile == null || (virtualFile = virtualFile.getFileSystem()) == null) {
            return new FileReference[0];
        }
        VirtualFile fs = virtualFile;
        String string2 = stringLiteral.getValue();
        if (string2 == null) {
            string2 = "";
        }
        String literalValue = string2;
        FileReference[] fileReferenceArray = new RsLiteralFileReferenceSet(literalValue, (RsLitExpr)element, startOffset, fs.isCaseSensitive()).getAllReferences();
        Intrinsics.checkNotNullExpressionValue((Object)fileReferenceArray, (String)"getAllReferences(...)");
        return fileReferenceArray;
    }
}

