/*
 * Decompiled with CFR 0.152.
 */
package org.rust.lang.core.resolve;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.lang.core.resolve.Namespace;
import org.rust.lang.core.resolve.ProcessorsKt;
import org.rust.lang.core.resolve.RsResolveProcessorBase;
import org.rust.lang.core.resolve.ScopeEntry;
import org.rust.stdext.CollectionsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u0000*\n\b\u0000\u0010\u0001 \u0000*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003BW\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003\u0012\u0018\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0006\u0012\u0018\u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u000b\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0015\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0015J\u0006\u0010\u0016\u001a\u00020\u0013J\b\u0010\u0017\u001a\u00020\u0007H\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0018"}, d2={"Lorg/rust/lang/core/resolve/ShadowingAndUpdateScopeProcessor;", "T", "Lorg/rust/lang/core/resolve/ScopeEntry;", "Lorg/rust/lang/core/resolve/RsResolveProcessorBase;", "originalProcessor", "prevScope", "", "", "", "Lorg/rust/lang/core/resolve/Namespace;", "currScope", "", "ns", "<init>", "(Lorg/rust/lang/core/resolve/RsResolveProcessorBase;Ljava/util/Map;Ljava/util/Map;Ljava/util/Set;)V", "names", "getNames", "()Ljava/util/Set;", "process", "", "entry", "(Lorg/rust/lang/core/resolve/ScopeEntry;)Z", "shouldStopOnScopeChange", "toString", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nProcessors.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Processors.kt\norg/rust/lang/core/resolve/ShadowingAndUpdateScopeProcessor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,686:1\n1#2:687\n1740#3,3:688\n*S KotlinDebug\n*F\n+ 1 Processors.kt\norg/rust/lang/core/resolve/ShadowingAndUpdateScopeProcessor\n*L\n225#1:688,3\n*E\n"})
public final class ShadowingAndUpdateScopeProcessor<T extends ScopeEntry>
implements RsResolveProcessorBase<T> {
    @NotNull
    private final RsResolveProcessorBase<T> originalProcessor;
    @NotNull
    private final Map<String, Set<Namespace>> prevScope;
    @NotNull
    private final Map<String, Set<Namespace>> currScope;
    @NotNull
    private final Set<Namespace> ns;
    @Nullable
    private final Set<String> names;

    public ShadowingAndUpdateScopeProcessor(@NotNull RsResolveProcessorBase<? super T> originalProcessor, @NotNull Map<String, ? extends Set<? extends Namespace>> prevScope, @NotNull Map<String, Set<Namespace>> currScope, @NotNull Set<? extends Namespace> ns) {
        Intrinsics.checkNotNullParameter(originalProcessor, (String)"originalProcessor");
        Intrinsics.checkNotNullParameter(prevScope, (String)"prevScope");
        Intrinsics.checkNotNullParameter(currScope, (String)"currScope");
        Intrinsics.checkNotNullParameter(ns, (String)"ns");
        this.originalProcessor = originalProcessor;
        this.prevScope = prevScope;
        this.currScope = currScope;
        this.ns = ns;
        this.names = this.originalProcessor.getNames();
    }

    @Override
    @Nullable
    public Set<String> getNames() {
        return this.names;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean process(@NotNull T entry2) {
        Set set;
        String string;
        Map<String, Set<Namespace>> map2;
        T entryWithIntersectedNs;
        block7: {
            Set<Namespace> newNs;
            block6: {
                Object object;
                Intrinsics.checkNotNullParameter(entry2, (String)"entry");
                if (!this.originalProcessor.acceptsName(entry2.getName()) || Intrinsics.areEqual((Object)entry2.getName(), (Object)"_")) {
                    return this.originalProcessor.process(entry2);
                }
                Set prevNs = this.prevScope.get(entry2.getName());
                newNs = entry2.getNamespaces();
                if (prevNs != null) {
                    Set restNs = SetsKt.minus(newNs, (Iterable)prevNs);
                    if (!CollectionsKt.intersects(this.ns, restNs)) return false;
                    object = ProcessorsKt.access$copyWithNs(entry2, restNs);
                } else {
                    object = entry2;
                }
                entryWithIntersectedNs = object;
                map2 = this.currScope;
                string = entry2.getName();
                set = prevNs;
                if (set == null) break block6;
                Set it2 = set;
                boolean bl = false;
                Set set = SetsKt.plus(it2, (Iterable)newNs);
                set = set;
                if (set2 != null) break block7;
            }
            set = newNs;
        }
        Set set3 = set;
        map2.put(string, set3);
        return this.originalProcessor.process(entryWithIntersectedNs);
    }

    public final boolean shouldStopOnScopeChange() {
        boolean bl;
        block5: {
            Set<String> set = this.getNames();
            if (set == null) {
                return false;
            }
            Set<String> names = set;
            Iterable $this$all$iv = names;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    Set namespaces;
                    String it2 = (String)element$iv;
                    boolean bl2 = false;
                    Set set2 = this.currScope.get(it2);
                    if (set2 == null) {
                        set2 = SetsKt.emptySet();
                    }
                    if ((namespaces = set2).containsAll((Collection)this.ns)) continue;
                    bl = false;
                    break block5;
                }
                bl = true;
            }
        }
        return bl;
    }

    @NotNull
    public String toString() {
        return "ShadowingAndUpdateScopeProcessor(" + this.originalProcessor + ", ns = " + this.ns + ")";
    }
}

