/*
 * Decompiled with CFR 0.152.
 */
package org.rust.lang.core.resolve;

import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.lang.core.resolve.Namespace;
import org.rust.lang.core.resolve.RsResolveProcessorBase;
import org.rust.lang.core.resolve.ScopeEntry;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0002\u0018\u0000*\n\b\u0000\u0010\u0001 \u0000*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B=\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003\u0012\u0018\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0006\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0015\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0013J\b\u0010\u0014\u001a\u00020\u0007H\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0015"}, d2={"Lorg/rust/lang/core/resolve/ShadowingAndImmediatelyUpdateScopeProcessor;", "T", "Lorg/rust/lang/core/resolve/ScopeEntry;", "Lorg/rust/lang/core/resolve/RsResolveProcessorBase;", "originalProcessor", "prevScope", "", "", "", "Lorg/rust/lang/core/resolve/Namespace;", "ns", "<init>", "(Lorg/rust/lang/core/resolve/RsResolveProcessorBase;Ljava/util/Map;Ljava/util/Set;)V", "names", "getNames", "()Ljava/util/Set;", "process", "", "entry", "(Lorg/rust/lang/core/resolve/ScopeEntry;)Z", "toString", "intellij.rustrover.core"})
final class ShadowingAndImmediatelyUpdateScopeProcessor<T extends ScopeEntry>
implements RsResolveProcessorBase<T> {
    @NotNull
    private final RsResolveProcessorBase<T> originalProcessor;
    @NotNull
    private final Map<String, Set<Namespace>> prevScope;
    @NotNull
    private final Set<Namespace> ns;
    @Nullable
    private final Set<String> names;

    public ShadowingAndImmediatelyUpdateScopeProcessor(@NotNull RsResolveProcessorBase<? super T> originalProcessor, @NotNull Map<String, Set<Namespace>> prevScope, @NotNull Set<? extends Namespace> ns) {
        Intrinsics.checkNotNullParameter(originalProcessor, (String)"originalProcessor");
        Intrinsics.checkNotNullParameter(prevScope, (String)"prevScope");
        Intrinsics.checkNotNullParameter(ns, (String)"ns");
        this.originalProcessor = originalProcessor;
        this.prevScope = prevScope;
        this.ns = ns;
        this.names = this.originalProcessor.getNames();
    }

    @Override
    @Nullable
    public Set<String> getNames() {
        return this.names;
    }

    @Override
    public boolean process(@NotNull T entry2) {
        Intrinsics.checkNotNullParameter(entry2, (String)"entry");
        if (this.prevScope.containsKey(entry2.getName())) {
            return false;
        }
        boolean result2 = this.originalProcessor.process(entry2);
        if (this.originalProcessor.acceptsName(entry2.getName())) {
            this.prevScope.put(entry2.getName(), this.ns);
        }
        return result2;
    }

    @NotNull
    public String toString() {
        return "ShadowingAndImmediatelyUpdateScopeProcessor(" + this.originalProcessor + ", ns = " + this.ns + ")";
    }
}

