/*
 * Decompiled with CFR 0.152.
 */
package org.rust.lang.core.resolve;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.SimpleMessageBusConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.rust.lang.core.crate.Crate;
import org.rust.lang.core.psi.RsPsiManager;
import org.rust.lang.core.psi.RsPsiManagerKt;
import org.rust.lang.core.psi.RustStructureChangeListener;
import org.rust.lang.core.resolve.RsCachedImplItem;
import org.rust.lang.core.resolve.indexes.RsAliasIndex;
import org.rust.lang.core.resolve.indexes.RsImplIndex;
import org.rust.lang.core.resolve2.CollectedImpls;
import org.rust.lang.core.resolve2.FacadeImplLookupKt;
import org.rust.lang.core.resolve2.TyResolvedFingerprint;
import org.rust.lang.core.types.TyFingerprint;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 .2\u00020\u0001:\u0001.B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010#\u001a\u00020\tJ\u0016\u0010$\u001a\u00020\u00142\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u0013J\u0016\u0010(\u001a\b\u0012\u0004\u0012\u00020\r0\n2\u0006\u0010#\u001a\u00020\tH\u0002J\u0014\u0010)\u001a\b\u0012\u0004\u0012\u00020\r0\n2\u0006\u0010#\u001a\u00020\tJ\u0010\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u001fH\u0002J\b\u0010-\u001a\u00020+H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\u0006\u001a\u001c\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n\u0018\u00010\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\f\u001a\u001c\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\n\u0018\u00010\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\u000e\u001a\u001c\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\n\u0018\u00010\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u000f\u001a&\u0012\"\u0012 \u0012\u0014\u0012\u0012\u0012\b\u0012\u00060\u0011j\u0002`\u0012\u0012\u0004\u0012\u00020\u00130\u0010\u0012\u0004\u0012\u00020\u0014\u0018\u00010\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R0\u0010\u0018\u001a\u001e\u0012\u0014\u0012\u0012\u0012\b\u0012\u00060\u0011j\u0002`\u0012\u0012\u0004\u0012\u00020\u00130\u0010\u0012\u0004\u0012\u00020\u00140\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0017R&\u0010\u001a\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\n0\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0017R&\u0010\u001c\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\n0\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0017R\u001a\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020 0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lorg/rust/lang/core/resolve/RsImplIndexAndTypeAliasCache;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "_implIndexCache", "Ljava/util/concurrent/atomic/AtomicReference;", "Ljava/util/concurrent/ConcurrentMap;", "Lorg/rust/lang/core/types/TyFingerprint;", "", "Lorg/rust/lang/core/resolve/RsCachedImplItem;", "_typeAliasShallowIndexCache", "", "_typeAliasTransitiveIndexCache", "_implIndexCacheFromDefMap", "Lkotlin/Pair;", "", "Lorg/rust/lang/core/crate/CratePersistentId;", "Lorg/rust/lang/core/resolve2/TyResolvedFingerprint;", "Lorg/rust/lang/core/resolve2/CollectedImpls;", "implIndexCache", "getImplIndexCache", "()Ljava/util/concurrent/ConcurrentMap;", "implIndexCacheFromDefMap", "getImplIndexCacheFromDefMap", "typeAliasShallowIndexCache", "getTypeAliasShallowIndexCache", "typeAliasTransitiveIndexCache", "getTypeAliasTransitiveIndexCache", "usedPsiFiles", "Lcom/intellij/psi/PsiFile;", "", "placeholder", "findPotentialImpls", "tyf", "findPotentialImplsInDefMaps", "crate", "Lorg/rust/lang/core/crate/Crate;", "tyResolvedFingerprint", "shallowFindPotentialAliases", "findPotentialAliases", "retainPsi", "", "containingFile", "dispose", "Companion", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nRsImplIndexAndTypeAliasCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RsImplIndexAndTypeAliasCache.kt\norg/rust/lang/core/resolve/RsImplIndexAndTypeAliasCache\n+ 2 MapsJVM.kt\nkotlin/collections/MapsKt__MapsJVMKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,130:1\n72#2,2:131\n72#2,2:137\n72#2,2:142\n72#2,2:145\n774#3:133\n865#3,2:134\n1869#3,2:139\n865#3,2:147\n1#4:136\n1#4:141\n1#4:144\n1#4:149\n*S KotlinDebug\n*F\n+ 1 RsImplIndexAndTypeAliasCache.kt\norg/rust/lang/core/resolve/RsImplIndexAndTypeAliasCache\n*L\n74#1:131,2\n83#1:137,2\n91#1:142,2\n97#1:145,2\n75#1:133\n75#1:134,2\n85#1:139,2\n106#1:147,2\n74#1:136\n83#1:141\n91#1:144\n97#1:149\n*E\n"})
public final class RsImplIndexAndTypeAliasCache
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final AtomicReference<ConcurrentMap<TyFingerprint, List<RsCachedImplItem>>> _implIndexCache;
    @NotNull
    private final AtomicReference<ConcurrentMap<TyFingerprint, List<String>>> _typeAliasShallowIndexCache;
    @NotNull
    private final AtomicReference<ConcurrentMap<TyFingerprint, List<String>>> _typeAliasTransitiveIndexCache;
    @NotNull
    private final AtomicReference<ConcurrentMap<Pair<Integer, TyResolvedFingerprint>, CollectedImpls>> _implIndexCacheFromDefMap;
    @NotNull
    private final ConcurrentMap<PsiFile, Object> usedPsiFiles;
    @NotNull
    private final Object placeholder;

    public RsImplIndexAndTypeAliasCache(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this._implIndexCache = new AtomicReference<Object>(null);
        this._typeAliasShallowIndexCache = new AtomicReference<Object>(null);
        this._typeAliasTransitiveIndexCache = new AtomicReference<Object>(null);
        this._implIndexCacheFromDefMap = new AtomicReference<Object>(null);
        ConcurrentMap concurrentMap = ContainerUtil.createConcurrentSoftMap();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"createConcurrentSoftMap(...)");
        this.usedPsiFiles = concurrentMap;
        this.placeholder = new Object();
        RsPsiManager rustPsiManager = RsPsiManagerKt.getRustPsiManager(this.project);
        MessageBusConnection connection = this.project.getMessageBus().connect((Disposable)this);
        rustPsiManager.subscribeRustStructureChange((SimpleMessageBusConnection)connection, new RustStructureChangeListener(){

            @Override
            public void rustStructureChanged(PsiFile file, PsiElement changedElement) {
                _implIndexCache.getAndSet(null);
                _typeAliasShallowIndexCache.getAndSet(null);
                _typeAliasTransitiveIndexCache.getAndSet(null);
                _implIndexCacheFromDefMap.getAndSet(null);
            }
        });
    }

    private final ConcurrentMap<TyFingerprint, List<RsCachedImplItem>> getImplIndexCache() {
        return RsImplIndexAndTypeAliasCache.Companion.getOrCreateMap(this._implIndexCache);
    }

    private final ConcurrentMap<Pair<Integer, TyResolvedFingerprint>, CollectedImpls> getImplIndexCacheFromDefMap() {
        return RsImplIndexAndTypeAliasCache.Companion.getOrCreateMap(this._implIndexCacheFromDefMap);
    }

    private final ConcurrentMap<TyFingerprint, List<String>> getTypeAliasShallowIndexCache() {
        return RsImplIndexAndTypeAliasCache.Companion.getOrCreateMap(this._typeAliasShallowIndexCache);
    }

    private final ConcurrentMap<TyFingerprint, List<String>> getTypeAliasTransitiveIndexCache() {
        return RsImplIndexAndTypeAliasCache.Companion.getOrCreateMap(this._typeAliasTransitiveIndexCache);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<RsCachedImplItem> findPotentialImpls(@NotNull TyFingerprint tyf) {
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter((Object)tyf, (String)"tyf");
        ConcurrentMap<TyFingerprint, List<RsCachedImplItem>> concurrentMap = this.getImplIndexCache();
        TyFingerprint key$iv = tyf;
        boolean $i$f$getOrPut = false;
        Object object = $this$getOrPut$iv.get(key$iv);
        if (object == null) {
            void $this$filterTo$iv$iv;
            boolean bl = false;
            Iterable $this$filter$iv = RsImplIndex.Helper.INSTANCE.findPotentialImpls(this.project, tyf);
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                RsCachedImplItem it2 = (RsCachedImplItem)element$iv$iv;
                boolean bl2 = false;
                PsiFile psiFile = it2.getImpl().getContainingFile();
                Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
                this.retainPsi(psiFile);
                if (!it2.isValid()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List default$iv = (List)destination$iv$iv;
            boolean bl3 = false;
            object = $this$getOrPut$iv.putIfAbsent(key$iv, default$iv);
            if (object == null) {
                object = default$iv;
            }
        }
        return (List)object;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final CollectedImpls findPotentialImplsInDefMaps(@NotNull Crate crate, @NotNull TyResolvedFingerprint tyResolvedFingerprint) {
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter((Object)crate, (String)"crate");
        Intrinsics.checkNotNullParameter((Object)tyResolvedFingerprint, (String)"tyResolvedFingerprint");
        ConcurrentMap<Pair<Integer, TyResolvedFingerprint>, CollectedImpls> concurrentMap = this.getImplIndexCacheFromDefMap();
        Integer n = crate.getId();
        if (n == null) {
            return CollectedImpls.Companion.getEMPTY();
        }
        Pair key$iv = TuplesKt.to((Object)n, (Object)tyResolvedFingerprint);
        boolean $i$f$getOrPut = false;
        Object object = $this$getOrPut$iv.get(key$iv);
        if (object == null) {
            CollectedImpls collectedImpls;
            boolean bl = false;
            CollectedImpls it2 = collectedImpls = FacadeImplLookupKt.findPotentialImpls(crate, tyResolvedFingerprint);
            boolean bl2 = false;
            Iterable $this$forEach$iv = it2.getImpls();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                RsCachedImplItem impl = (RsCachedImplItem)element$iv;
                boolean bl3 = false;
                PsiFile psiFile = impl.getImpl().getContainingFile();
                Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
                this.retainPsi(psiFile);
            }
            CollectedImpls default$iv = collectedImpls;
            boolean bl4 = false;
            object = $this$getOrPut$iv.putIfAbsent(key$iv, default$iv);
            if (object == null) {
                object = default$iv;
            }
        }
        return (CollectedImpls)object;
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> shallowFindPotentialAliases(TyFingerprint tyf) {
        void $this$getOrPut$iv;
        ConcurrentMap<TyFingerprint, List<String>> concurrentMap = this.getTypeAliasShallowIndexCache();
        TyFingerprint key$iv = tyf;
        boolean $i$f$getOrPut = false;
        Object object = $this$getOrPut$iv.get(key$iv);
        if (object == null) {
            boolean bl = false;
            List<String> default$iv = RsAliasIndex.Helper.INSTANCE.findPotentialAliases(this.project, tyf);
            boolean bl2 = false;
            object = $this$getOrPut$iv.putIfAbsent(key$iv, default$iv);
            if (object == null) {
                object = default$iv;
            }
        }
        return (List)object;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> findPotentialAliases(@NotNull TyFingerprint tyf) {
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter((Object)tyf, (String)"tyf");
        ConcurrentMap<TyFingerprint, List<String>> concurrentMap = this.getTypeAliasTransitiveIndexCache();
        TyFingerprint key$iv = tyf;
        boolean $i$f$getOrPut = false;
        Object object = $this$getOrPut$iv.get(key$iv);
        if (object == null) {
            void $this$filterTo$iv;
            Iterable alias;
            boolean bl = false;
            Object[] objectArray = new String[]{tyf.getName()};
            HashSet result2 = SetsKt.hashSetOf((Object[])objectArray);
            List queue = CollectionsKt.toMutableList((Collection)this.shallowFindPotentialAliases(tyf));
            while ((String)CollectionsKt.removeLastOrNull((List)queue) != null) {
                if (!result2.add(alias)) continue;
                CollectionsKt.addAll((Collection)queue, (Iterable)this.shallowFindPotentialAliases(new TyFingerprint((String)((Object)alias))));
            }
            alias = result2;
            Collection destination$iv = new ArrayList(result2.size());
            boolean $i$f$filterTo = false;
            for (Object element$iv : $this$filterTo$iv) {
                String it2 = (String)element$iv;
                boolean bl2 = false;
                if (!(!Intrinsics.areEqual((Object)it2, (Object)tyf.getName()))) continue;
                destination$iv.add(element$iv);
            }
            List default$iv = (List)destination$iv;
            boolean bl3 = false;
            object = $this$getOrPut$iv.putIfAbsent(key$iv, default$iv);
            if (object == null) {
                object = default$iv;
            }
        }
        return (List)object;
    }

    private final void retainPsi(PsiFile containingFile) {
        ((Map)this.usedPsiFiles).put(containingFile, this.placeholder);
    }

    public void dispose() {
    }

    @JvmStatic
    private static final <K, T> ConcurrentMap<K, T> getOrCreateMap(AtomicReference<ConcurrentMap<K, T>> $this$getOrCreateMap) {
        return RsImplIndexAndTypeAliasCache.Companion.getOrCreateMap($this$getOrCreateMap);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J@\u0010\b\u001a\u000e\u0012\u0004\u0012\u0002H\n\u0012\u0004\u0012\u0002H\u000b0\t\"\b\b\u0000\u0010\n*\u00020\u0001\"\b\b\u0001\u0010\u000b*\u00020\u0001*\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u0002H\n\u0012\u0004\u0012\u0002H\u000b\u0018\u00010\t0\fH\u0003\u00a8\u0006\r"}, d2={"Lorg/rust/lang/core/resolve/RsImplIndexAndTypeAliasCache$Companion;", "", "<init>", "()V", "getInstance", "Lorg/rust/lang/core/resolve/RsImplIndexAndTypeAliasCache;", "project", "Lcom/intellij/openapi/project/Project;", "getOrCreateMap", "Ljava/util/concurrent/ConcurrentMap;", "K", "T", "Ljava/util/concurrent/atomic/AtomicReference;", "intellij.rustrover.core"})
    @SourceDebugExtension(value={"SMAP\nRsImplIndexAndTypeAliasCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RsImplIndexAndTypeAliasCache.kt\norg/rust/lang/core/resolve/RsImplIndexAndTypeAliasCache$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,130:1\n30#2,2:131\n1#3:133\n*S KotlinDebug\n*F\n+ 1 RsImplIndexAndTypeAliasCache.kt\norg/rust/lang/core/resolve/RsImplIndexAndTypeAliasCache$Companion\n*L\n118#1:131,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final RsImplIndexAndTypeAliasCache getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<RsImplIndexAndTypeAliasCache> serviceClass$iv = RsImplIndexAndTypeAliasCache.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (RsImplIndexAndTypeAliasCache)object;
        }

        @JvmStatic
        private final <K, T> ConcurrentMap<K, T> getOrCreateMap(AtomicReference<ConcurrentMap<K, T>> $this$getOrCreateMap) {
            ConcurrentMap map2;
            do {
                ConcurrentMap<K, T> concurrentMap;
                if ((concurrentMap = $this$getOrCreateMap.get()) != null) {
                    ConcurrentMap<K, T> it2 = concurrentMap;
                    boolean bl = false;
                    return it2;
                }
                Intrinsics.checkNotNullExpressionValue((Object)ContainerUtil.createConcurrentSoftValueMap(), (String)"createConcurrentSoftValueMap(...)");
            } while (!$this$getOrCreateMap.compareAndSet(null, map2));
            return map2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

