/*
 * Decompiled with CFR 0.152.
 */
package org.rust.lang.core.resolve;

import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.util.LazyKt;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.cargo.project.workspace.PackageOrigin;
import org.rust.lang.core.crate.Crate;
import org.rust.lang.core.psi.RsFileKt;
import org.rust.lang.core.psi.RsImplItem;
import org.rust.lang.core.psi.RsPsiManagerKt;
import org.rust.lang.core.psi.RsTraitItem;
import org.rust.lang.core.psi.RsTraitRef;
import org.rust.lang.core.psi.RsTypeReference;
import org.rust.lang.core.psi.ext.RsAbstractableAndIsDocAlias;
import org.rust.lang.core.psi.ext.RsElement;
import org.rust.lang.core.psi.ext.RsImplItemImplMixin;
import org.rust.lang.core.psi.ext.RsImplItemKt;
import org.rust.lang.core.psi.ext.RsTraitOrImpl;
import org.rust.lang.core.psi.ext.RsTraitOrImplKt;
import org.rust.lang.core.psi.ext.RsTraitRefKt;
import org.rust.lang.core.resolve.TraitImplSource;
import org.rust.lang.core.types.BoundElement;
import org.rust.lang.core.types.ExtensionsKt;
import org.rust.lang.core.types.consts.CtConstParameter;
import org.rust.lang.core.types.infer.TypeInferenceKt;
import org.rust.lang.core.types.ty.Ty;
import org.rust.lang.core.types.ty.TyTypeParameter;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 .2\u00020\u0001:\u0001.B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011R\u0011\u0010\u0013\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0011R#\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u00158FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u0017\u0010\u0018R;\u0010\u001b\u001a\"\u0012\u0004\u0012\u00020\u001d\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001e0\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001f0\u000b\u0018\u00010\u001c8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\"\u0010\u001a\u001a\u0004\b \u0010!R-\u0010#\u001a\u0014\u0012\u0004\u0012\u00020%\u0012\n\u0012\b\u0012\u0004\u0012\u00020&0\u000b0$8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b)\u0010\u001a\u001a\u0004\b'\u0010(R\u0011\u0010*\u001a\u00020+\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-\u00a8\u0006/"}, d2={"Lorg/rust/lang/core/resolve/RsCachedImplItem;", "", "impl", "Lorg/rust/lang/core/psi/RsImplItem;", "<init>", "(Lorg/rust/lang/core/psi/RsImplItem;)V", "getImpl", "()Lorg/rust/lang/core/psi/RsImplItem;", "traitRef", "Lorg/rust/lang/core/psi/RsTraitRef;", "containingCrates", "", "Lorg/rust/lang/core/crate/Crate;", "getContainingCrates", "()Ljava/util/List;", "isValid", "", "()Z", "isNegativeImpl", "isInherent", "implementedTrait", "Lorg/rust/lang/core/types/BoundElement;", "Lorg/rust/lang/core/psi/RsTraitItem;", "getImplementedTrait", "()Lorg/rust/lang/core/types/BoundElement;", "implementedTrait$delegate", "Lkotlin/Lazy;", "typeAndGenerics", "Lkotlin/Triple;", "Lorg/rust/lang/core/types/ty/Ty;", "Lorg/rust/lang/core/types/ty/TyTypeParameter;", "Lorg/rust/lang/core/types/consts/CtConstParameter;", "getTypeAndGenerics", "()Lkotlin/Triple;", "typeAndGenerics$delegate", "traitOrImplExpandedMembers", "", "", "Lorg/rust/lang/core/psi/ext/RsAbstractableAndIsDocAlias;", "getTraitOrImplExpandedMembers", "()Ljava/util/Map;", "traitOrImplExpandedMembers$delegate", "explicitImpl", "Lorg/rust/lang/core/resolve/TraitImplSource$ExplicitImpl;", "getExplicitImpl", "()Lorg/rust/lang/core/resolve/TraitImplSource$ExplicitImpl;", "Companion", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nRsCachedImplItem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RsCachedImplItem.kt\norg/rust/lang/core/resolve/RsCachedImplItem\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,84:1\n1#2:85\n*E\n"})
public final class RsCachedImplItem {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RsImplItem impl;
    @Nullable
    private final RsTraitRef traitRef;
    @NotNull
    private final List<Crate> containingCrates;
    private final boolean isValid;
    private final boolean isNegativeImpl;
    @NotNull
    private final Lazy implementedTrait$delegate;
    @NotNull
    private final Lazy typeAndGenerics$delegate;
    @NotNull
    private final Lazy traitOrImplExpandedMembers$delegate;
    @NotNull
    private final TraitImplSource.ExplicitImpl explicitImpl;

    public RsCachedImplItem(@NotNull RsImplItem impl) {
        List crates;
        Intrinsics.checkNotNullParameter((Object)impl, (String)"impl");
        this.impl = impl;
        this.traitRef = this.impl.getTraitRef();
        this.isNegativeImpl = RsImplItemKt.isNegativeImpl(this.impl);
        Triple<Boolean, Crate, List<Crate>> triple = RsFileKt.isValidProjectMemberAndContainingCrate(this.impl);
        boolean isValid = (Boolean)triple.component1();
        this.containingCrates = crates = (List)triple.component3();
        this.isValid = isValid && !RsImplItemKt.isReservationImpl(this.impl);
        this.implementedTrait$delegate = LazyKt.recursionSafeLazy$default(null, () -> RsCachedImplItem.implementedTrait_delegate$lambda$0(this), (int)1, null);
        this.typeAndGenerics$delegate = kotlin.LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> RsCachedImplItem.typeAndGenerics_delegate$lambda$0(this));
        this.traitOrImplExpandedMembers$delegate = kotlin.LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> RsCachedImplItem.traitOrImplExpandedMembers_delegate$lambda$0(this));
        this.explicitImpl = new TraitImplSource.ExplicitImpl(this);
    }

    @NotNull
    public final RsImplItem getImpl() {
        return this.impl;
    }

    @NotNull
    public final List<Crate> getContainingCrates() {
        return this.containingCrates;
    }

    public final boolean isValid() {
        return this.isValid;
    }

    public final boolean isNegativeImpl() {
        return this.isNegativeImpl;
    }

    public final boolean isInherent() {
        return this.traitRef == null;
    }

    @Nullable
    public final BoundElement<RsTraitItem> getImplementedTrait() {
        Lazy lazy = this.implementedTrait$delegate;
        return (BoundElement)lazy.getValue();
    }

    @Nullable
    public final Triple<Ty, List<TyTypeParameter>, List<CtConstParameter>> getTypeAndGenerics() {
        Lazy lazy = this.typeAndGenerics$delegate;
        return (Triple)lazy.getValue();
    }

    @NotNull
    public final Map<String, List<RsAbstractableAndIsDocAlias>> getTraitOrImplExpandedMembers() {
        Lazy lazy = this.traitOrImplExpandedMembers$delegate;
        return (Map)lazy.getValue();
    }

    @NotNull
    public final TraitImplSource.ExplicitImpl getExplicitImpl() {
        return this.explicitImpl;
    }

    private static final BoundElement implementedTrait_delegate$lambda$0(RsCachedImplItem this$0) {
        RsTraitRef rsTraitRef = this$0.traitRef;
        return rsTraitRef != null ? RsTraitRefKt.resolveToBoundTrait(rsTraitRef) : null;
    }

    private static final Triple typeAndGenerics_delegate$lambda$0(RsCachedImplItem this$0) {
        Triple triple;
        Object object = this$0.impl.getTypeReference();
        if (object != null && (object = ExtensionsKt.getRawType((RsTypeReference)object)) != null) {
            Object it2 = object;
            boolean bl = false;
            triple = new Triple(it2, TypeInferenceKt.getGenerics(this$0.impl), TypeInferenceKt.getConstGenerics(this$0.impl));
        } else {
            triple = null;
        }
        return triple;
    }

    private static final Map traitOrImplExpandedMembers_delegate$lambda$0(RsCachedImplItem this$0) {
        Object object;
        if (this$0.isInherent()) {
            object = RsTraitOrImplKt.getExpandedMembersByName(this$0.impl);
        } else {
            object = this$0.getImplementedTrait();
            if (object == null || (object = (RsTraitItem)((BoundElement)object).getElement()) == null || (object = RsTraitOrImplKt.getExpandedMembersByName((RsTraitOrImpl)object)) == null) {
                object = MapsKt.emptyMap();
            }
        }
        return object;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J1\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\n0\t\"\u0004\b\u0000\u0010\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u0002H\n\u00a2\u0006\u0002\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lorg/rust/lang/core/resolve/RsCachedImplItem$Companion;", "", "<init>", "()V", "forImpl", "Lorg/rust/lang/core/resolve/RsCachedImplItem;", "impl", "Lorg/rust/lang/core/psi/RsImplItem;", "toCachedResult", "Lcom/intellij/psi/util/CachedValueProvider$Result;", "T", "psi", "Lorg/rust/lang/core/psi/ext/RsElement;", "containingCrate", "Lorg/rust/lang/core/crate/Crate;", "cachedImpl", "(Lorg/rust/lang/core/psi/ext/RsElement;Lorg/rust/lang/core/crate/Crate;Ljava/lang/Object;)Lcom/intellij/psi/util/CachedValueProvider$Result;", "intellij.rustrover.core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final RsCachedImplItem forImpl(@NotNull RsImplItem impl) {
            Intrinsics.checkNotNullParameter((Object)impl, (String)"impl");
            Object object = ((RsImplItemImplMixin)impl).getCachedImplItem().getValue();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
            return (RsCachedImplItem)object;
        }

        @NotNull
        public final <T> CachedValueProvider.Result<T> toCachedResult(@NotNull RsElement psi, @Nullable Crate containingCrate, T cachedImpl) {
            List list;
            ModificationTracker modTracker;
            Intrinsics.checkNotNullParameter((Object)psi, (String)"psi");
            PsiFile containingFile = psi.getContainingFile();
            Crate crate = containingCrate;
            if ((crate != null ? crate.getOrigin() : null) == PackageOrigin.WORKSPACE) {
                Project project = containingFile.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                v2 = RsPsiManagerKt.getRustStructureModificationTracker(project);
            } else {
                Project project = containingFile.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                v2 = modTracker = (ModificationTracker)RsPsiManagerKt.getRustPsiManager(project).getRustStructureModificationTrackerInDependencies();
            }
            if (!containingFile.isPhysical() || containingFile.getVirtualFile() instanceof VirtualFileWindow) {
                Object[] objectArray = new ModificationTracker[]{modTracker, () -> Companion.toCachedResult$lambda$0(containingFile)};
                list = CollectionsKt.listOf((Object[])objectArray);
            } else {
                list = CollectionsKt.listOf((Object)modTracker);
            }
            List deps = list;
            CachedValueProvider.Result result2 = CachedValueProvider.Result.create(cachedImpl, (Collection)deps);
            Intrinsics.checkNotNullExpressionValue((Object)result2, (String)"create(...)");
            return result2;
        }

        private static final long toCachedResult$lambda$0(PsiFile $containingFile) {
            return $containingFile.getModificationStamp();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

