/*
 * Decompiled with CFR 0.152.
 */
package org.rust.lang.core.resolve;

import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.lang.core.psi.ext.RsDocAndAttributeOwner;
import org.rust.lang.core.psi.ext.RsDocAndAttributeOwnerKt;
import org.rust.lang.core.psi.ext.RsElement;
import org.rust.lang.core.resolve.RsResolveProcessorBase;
import org.rust.lang.core.resolve.ScopeEntry;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\"\n\u0002\b\u0005\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0002H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000b\u001a\u0004\u0018\u00010\u00028F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0014"}, d2={"Lorg/rust/lang/core/resolve/PickFirstScopeEntryCollector;", "Lorg/rust/lang/core/resolve/RsResolveProcessorBase;", "Lorg/rust/lang/core/resolve/ScopeEntry;", "referenceName", "", "withCfgDisabled", "", "<init>", "(Ljava/lang/String;Z)V", "resultCfgEnabled", "resultCfgDisabled", "result", "getResult", "()Lorg/rust/lang/core/resolve/ScopeEntry;", "names", "", "getNames", "()Ljava/util/Set;", "process", "entry", "intellij.rustrover.core"})
final class PickFirstScopeEntryCollector
implements RsResolveProcessorBase<ScopeEntry> {
    @NotNull
    private final String referenceName;
    private final boolean withCfgDisabled;
    @Nullable
    private ScopeEntry resultCfgEnabled;
    @Nullable
    private ScopeEntry resultCfgDisabled;
    @NotNull
    private final Set<String> names;

    public PickFirstScopeEntryCollector(@NotNull String referenceName, boolean withCfgDisabled) {
        Intrinsics.checkNotNullParameter((Object)referenceName, (String)"referenceName");
        this.referenceName = referenceName;
        this.withCfgDisabled = withCfgDisabled;
        this.names = SetsKt.setOf((Object)this.referenceName);
    }

    @Nullable
    public final ScopeEntry getResult() {
        ScopeEntry scopeEntry = this.resultCfgEnabled;
        if (scopeEntry == null) {
            scopeEntry = this.resultCfgDisabled;
        }
        return scopeEntry;
    }

    @Override
    @NotNull
    public Set<String> getNames() {
        return this.names;
    }

    @Override
    public boolean process(@NotNull ScopeEntry entry2) {
        Intrinsics.checkNotNullParameter((Object)entry2, (String)"entry");
        if (Intrinsics.areEqual((Object)entry2.getName(), (Object)this.referenceName)) {
            RsElement element = entry2.getElement();
            if (!(element instanceof RsDocAndAttributeOwner) || RsDocAndAttributeOwnerKt.getExistsAfterExpansionSelf((RsDocAndAttributeOwner)element)) {
                this.resultCfgEnabled = entry2;
                return true;
            }
            if (this.withCfgDisabled) {
                ScopeEntry scopeEntry = this.resultCfgDisabled;
                if (scopeEntry == null) {
                    scopeEntry = entry2;
                }
                this.resultCfgDisabled = scopeEntry;
            }
        }
        return false;
    }
}

