/*
 * Decompiled with CFR 0.152.
 */
package org.rust.lang.core.resolve;

import com.intellij.psi.PsiElement;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.cargo.project.workspace.CargoWorkspace;
import org.rust.lang.core.completion.UtilsKt;
import org.rust.lang.core.psi.RsAssocTypeBinding;
import org.rust.lang.core.psi.RsMacroCall;
import org.rust.lang.core.psi.RsPath;
import org.rust.lang.core.psi.RsTypeQual;
import org.rust.lang.core.psi.RsUseSpeck;
import org.rust.lang.core.psi.RsVisRestriction;
import org.rust.lang.core.psi.ext.PsiElementKt;
import org.rust.lang.core.psi.ext.RsElement;
import org.rust.lang.core.psi.ext.RsElementKt;
import org.rust.lang.core.psi.ext.RsMod;
import org.rust.lang.core.psi.ext.RsPathKt;
import org.rust.lang.core.resolve.ImplLookup;
import org.rust.lang.core.resolve.Namespace;
import org.rust.lang.core.resolve.RsPathResolveKind;
import org.rust.lang.core.resolve2.FacadeResolveKt;
import org.rust.lang.core.resolve2.RsModInfo;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u00182\u0006\u0010&\u001a\u00020\u0010J\u000e\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*J\u001e\u0010+\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020.0-H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00100\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0015\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0012R\"\u0010\u0017\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00180\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u0013\u0010\u001d\u001a\u0004\u0018\u00010\u00188F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u001b\u0010 \u001a\u00020\b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b#\u0010$\u001a\u0004\b!\u0010\"R\u0011\u0010%\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b%\u0010\r\u00a8\u0006/"}, d2={"Lorg/rust/lang/core/resolve/PathResolutionContext;", "", "context", "Lorg/rust/lang/core/psi/ext/RsElement;", "isCompletion", "", "processAssocItems", "givenImplLookup", "Lorg/rust/lang/core/resolve/ImplLookup;", "<init>", "(Lorg/rust/lang/core/psi/ext/RsElement;ZZLorg/rust/lang/core/resolve/ImplLookup;)V", "getContext", "()Lorg/rust/lang/core/psi/ext/RsElement;", "()Z", "getProcessAssocItems", "crateRoot", "Lorg/rust/lang/core/psi/ext/RsMod;", "getCrateRoot", "()Lorg/rust/lang/core/psi/ext/RsMod;", "lazyContainingMod", "Lkotlin/Lazy;", "containingMod", "getContainingMod", "lazyContainingModInfo", "Lorg/rust/lang/core/resolve2/RsModInfo;", "getLazyContainingModInfo", "()Lkotlin/Lazy;", "setLazyContainingModInfo", "(Lkotlin/Lazy;)V", "containingModInfo", "getContainingModInfo", "()Lorg/rust/lang/core/resolve2/RsModInfo;", "implLookup", "getImplLookup", "()Lorg/rust/lang/core/resolve/ImplLookup;", "implLookup$delegate", "Lkotlin/Lazy;", "isAtLeastEdition2018", "knownContainingMod", "classifyPath", "Lorg/rust/lang/core/resolve/RsPathResolveKind;", "path", "Lorg/rust/lang/core/psi/RsPath;", "classifyUnqualifiedPath", "ns", "", "Lorg/rust/lang/core/resolve/Namespace;", "intellij.rustrover.core"})
public final class PathResolutionContext {
    @NotNull
    private final RsElement context;
    private final boolean isCompletion;
    private final boolean processAssocItems;
    @Nullable
    private final ImplLookup givenImplLookup;
    @Nullable
    private final RsMod crateRoot;
    @NotNull
    private Lazy<? extends RsMod> lazyContainingMod;
    @NotNull
    private Lazy<RsModInfo> lazyContainingModInfo;
    @NotNull
    private final Lazy implLookup$delegate;

    public PathResolutionContext(@NotNull RsElement context, boolean isCompletion, boolean processAssocItems, @Nullable ImplLookup givenImplLookup) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.isCompletion = isCompletion;
        this.processAssocItems = processAssocItems;
        this.givenImplLookup = givenImplLookup;
        this.crateRoot = this.context.getCrateRoot();
        this.lazyContainingMod = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, () -> PathResolutionContext.lazyContainingMod$lambda$0(this));
        this.lazyContainingModInfo = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, () -> PathResolutionContext.lazyContainingModInfo$lambda$0(this));
        this.implLookup$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, () -> PathResolutionContext.implLookup_delegate$lambda$0(this));
    }

    @NotNull
    public final RsElement getContext() {
        return this.context;
    }

    public final boolean isCompletion() {
        return this.isCompletion;
    }

    public final boolean getProcessAssocItems() {
        return this.processAssocItems;
    }

    @Nullable
    public final RsMod getCrateRoot() {
        return this.crateRoot;
    }

    @NotNull
    public final RsMod getContainingMod() {
        return (RsMod)this.lazyContainingMod.getValue();
    }

    @NotNull
    public final Lazy<RsModInfo> getLazyContainingModInfo() {
        return this.lazyContainingModInfo;
    }

    public final void setLazyContainingModInfo(@NotNull Lazy<RsModInfo> lazy) {
        Intrinsics.checkNotNullParameter(lazy, (String)"<set-?>");
        this.lazyContainingModInfo = lazy;
    }

    @Nullable
    public final RsModInfo getContainingModInfo() {
        return (RsModInfo)this.lazyContainingModInfo.getValue();
    }

    @NotNull
    public final ImplLookup getImplLookup() {
        Lazy lazy = this.implLookup$delegate;
        return (ImplLookup)lazy.getValue();
    }

    public final boolean isAtLeastEdition2018() {
        Object edition;
        Object object = this.crateRoot;
        if (object == null || (object = RsElementKt.getEdition((PsiElement)object)) == null) {
            object = CargoWorkspace.Edition.Companion.getDEFAULT();
        }
        return ((Enum)(edition = object)).compareTo((Enum)CargoWorkspace.Edition.EDITION_2018) >= 0;
    }

    @Nullable
    public final RsModInfo getContainingModInfo(@NotNull RsMod knownContainingMod) {
        Intrinsics.checkNotNullParameter((Object)knownContainingMod, (String)"knownContainingMod");
        if (this.lazyContainingModInfo.isInitialized()) {
            return (RsModInfo)this.lazyContainingModInfo.getValue();
        }
        RsMod knownContainingMod2 = (RsMod)UtilsKt.getOriginalOrSelf((PsiElement)knownContainingMod);
        if (this.lazyContainingMod.isInitialized() && !Intrinsics.areEqual((Object)this.lazyContainingMod.getValue(), (Object)knownContainingMod2)) {
            throw new IllegalStateException("Check failed.");
        }
        RsModInfo modInfo = FacadeResolveKt.getModInfo(knownContainingMod2);
        this.lazyContainingMod = LazyKt.lazyOf((Object)knownContainingMod2);
        this.lazyContainingModInfo = LazyKt.lazyOf((Object)modInfo);
        return modInfo;
    }

    @NotNull
    public final RsPathResolveKind classifyPath(@NotNull RsPath path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        PsiElement parent2 = PsiElementKt.getStubParent(path);
        if (parent2 instanceof RsMacroCall) {
            throw new IllegalStateException("Tried to use `processPathResolveVariants` for macro path. See `RsMacroPathReferenceImpl`".toString());
        }
        if (parent2 instanceof RsAssocTypeBinding) {
            return new RsPathResolveKind.AssocTypeBindingPath((RsAssocTypeBinding)parent2);
        }
        RsPath qualifier = RsPathKt.getQualifier(path);
        RsTypeQual typeQual = path.getTypeQual();
        Set<Namespace> ns = RsPathKt.allowedNamespaces(path, this.isCompletion, parent2);
        return qualifier != null ? (RsPathResolveKind)new RsPathResolveKind.QualifiedPath(path, ns, qualifier, parent2) : (typeQual != null ? (RsPathResolveKind)new RsPathResolveKind.ExplicitTypeQualifiedPath(ns, typeQual) : this.classifyUnqualifiedPath(path, ns));
    }

    private final RsPathResolveKind classifyUnqualifiedPath(RsPath path, Set<? extends Namespace> ns) {
        RsPathResolveKind rsPathResolveKind;
        String referenceName;
        boolean hasColonColon = path.getHasColonColon();
        if (!hasColonColon && Intrinsics.areEqual((Object)(referenceName = path.getReferenceName()), (Object)"IntellijRustDollarCrate")) {
            return new RsPathResolveKind.MacroDollarCrateIdentifier(path);
        }
        boolean isAtLeastEdition2018 = this.isAtLeastEdition2018();
        RsPath rootPath = RsPathKt.rootPath(path);
        PsiElement rootPathParent = rootPath.getParent();
        boolean isCrateRelative = !isAtLeastEdition2018 && (hasColonColon || rootPathParent instanceof RsUseSpeck) || rootPathParent instanceof RsVisRestriction;
        boolean isExternCrate = isAtLeastEdition2018 && hasColonColon;
        if (isCrateRelative) {
            rsPathResolveKind = new RsPathResolveKind.CrateRelativePath(path, ns, hasColonColon);
        } else if (isExternCrate) {
            rsPathResolveKind = RsPathResolveKind.ExternCratePath.INSTANCE;
        } else {
            boolean maybeReexportOfLegacyMacro = Intrinsics.areEqual((Object)path, (Object)rootPath) && rootPathParent instanceof RsUseSpeck && ((RsUseSpeck)rootPathParent).getAlias() != null;
            rsPathResolveKind = new RsPathResolveKind.UnqualifiedPath(ns, maybeReexportOfLegacyMacro);
        }
        return rsPathResolveKind;
    }

    private static final RsMod lazyContainingMod$lambda$0(PathResolutionContext this$0) {
        return this$0.context.getContainingMod();
    }

    private static final RsModInfo lazyContainingModInfo$lambda$0(PathResolutionContext this$0) {
        return FacadeResolveKt.getModInfo(this$0.getContainingMod());
    }

    private static final ImplLookup implLookup_delegate$lambda$0(PathResolutionContext this$0) {
        ImplLookup implLookup = this$0.givenImplLookup;
        if (implLookup == null) {
            implLookup = ImplLookup.Companion.relativeTo(this$0.context);
        }
        return implLookup;
    }
}

