/*
 * Decompiled with CFR 0.152.
 */
package org.rust.lang.core.resolve;

import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.lang.core.resolve.RsResolveProcessorBase;
import org.rust.lang.core.resolve.ScopeEntry;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0002\u0018\u0000*\n\b\u0000\u0010\u0001 \u0000*\u00020\u0002*\n\b\u0001\u0010\u0003 \u0000*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00030\u0004B+\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\u0014\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00028\u0001\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0015\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u0012J\b\u0010\u0013\u001a\u00020\fH\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00028\u0001\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0014"}, d2={"Lorg/rust/lang/core/resolve/NonNullMappingProcessor;", "T", "Lorg/rust/lang/core/resolve/ScopeEntry;", "U", "Lorg/rust/lang/core/resolve/RsResolveProcessorBase;", "originalProcessor", "mapper", "Lkotlin/Function1;", "<init>", "(Lorg/rust/lang/core/resolve/RsResolveProcessorBase;Lkotlin/jvm/functions/Function1;)V", "names", "", "", "getNames", "()Ljava/util/Set;", "process", "", "entry", "(Lorg/rust/lang/core/resolve/ScopeEntry;)Z", "toString", "intellij.rustrover.core"})
final class NonNullMappingProcessor<T extends ScopeEntry, U extends ScopeEntry>
implements RsResolveProcessorBase<U> {
    @NotNull
    private final RsResolveProcessorBase<T> originalProcessor;
    @NotNull
    private final Function1<U, T> mapper;
    @Nullable
    private final Set<String> names;

    public NonNullMappingProcessor(@NotNull RsResolveProcessorBase<? super T> originalProcessor, @NotNull Function1<? super U, ? extends T> mapper) {
        Intrinsics.checkNotNullParameter(originalProcessor, (String)"originalProcessor");
        Intrinsics.checkNotNullParameter(mapper, (String)"mapper");
        this.originalProcessor = originalProcessor;
        this.mapper = mapper;
        this.names = this.originalProcessor.getNames();
    }

    @Override
    @Nullable
    public Set<String> getNames() {
        return this.names;
    }

    @Override
    public boolean process(@NotNull U entry2) {
        Intrinsics.checkNotNullParameter(entry2, (String)"entry");
        ScopeEntry mapped = (ScopeEntry)this.mapper.invoke(entry2);
        return mapped == null ? false : this.originalProcessor.process(mapped);
    }

    @NotNull
    public String toString() {
        return "MappingProcessor(" + this.originalProcessor + ", mapper = " + this.mapper + ")";
    }
}

