/*
 * Decompiled with CFR 0.152.
 */
package org.rust.lang.core.resolve;

import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.rust.lang.core.psi.RsExternCrateItem;
import org.rust.lang.core.psi.RsFile;
import org.rust.lang.core.psi.RsMacro;
import org.rust.lang.core.psi.RsModDeclItem;
import org.rust.lang.core.psi.RsModItem;
import org.rust.lang.core.psi.RsPsiManagerKt;
import org.rust.lang.core.psi.RsUseItem;
import org.rust.lang.core.psi.RsVisitor;
import org.rust.lang.core.psi.ext.RsDocAndAttributeOwnerKt;
import org.rust.lang.core.psi.ext.RsElement;
import org.rust.lang.core.psi.ext.RsExternCrateItemKt;
import org.rust.lang.core.psi.ext.RsItemsOwner;
import org.rust.lang.core.psi.ext.RsItemsOwnerKt;
import org.rust.lang.core.psi.ext.RsMod;
import org.rust.lang.core.psi.ext.RsModDeclItemKt;
import org.rust.lang.core.psi.ext.RsModItemKt;
import org.rust.lang.core.psi.ext.RsNamedElement;
import org.rust.lang.core.resolve.NameResolutionKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u0000 %2\u00020\u0001:\u0001%B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0018J\u0010\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0019\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u0019\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020\u001c2\u0006\u0010\u0019\u001a\u00020!H\u0016J\u0010\u0010\"\u001a\u00020\u001c2\u0006\u0010\u0019\u001a\u00020#H\u0016J\u0010\u0010$\u001a\u00020\u001c2\u0006\u0010\u0019\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00030\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/rust/lang/core/resolve/MacroResolvingVisitor;", "Lorg/rust/lang/core/psi/RsVisitor;", "reverse", "", "ignoreLegacyMacros", "processor", "Lkotlin/Function1;", "Lorg/rust/lang/core/psi/ext/RsNamedElement;", "<init>", "(ZZLkotlin/jvm/functions/Function1;)V", "exportingMacrosCrates", "", "", "Lorg/rust/lang/core/psi/RsFile;", "getExportingMacrosCrates", "()Ljava/util/Map;", "useItems", "", "Lorg/rust/lang/core/psi/RsUseItem;", "getUseItems", "()Ljava/util/List;", "visitorResult", "processMacros", "element", "Lcom/intellij/psi/PsiElement;", "item", "Lorg/rust/lang/core/psi/ext/RsElement;", "visitMacro", "", "Lorg/rust/lang/core/psi/RsMacro;", "visitModItem", "Lorg/rust/lang/core/psi/RsModItem;", "visitModDeclItem", "Lorg/rust/lang/core/psi/RsModDeclItem;", "visitExternCrateItem", "Lorg/rust/lang/core/psi/RsExternCrateItem;", "visitUseItem", "Companion", "intellij.rustrover.core"})
final class MacroResolvingVisitor
extends RsVisitor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean reverse;
    private final boolean ignoreLegacyMacros;
    @NotNull
    private final Function1<RsNamedElement, Boolean> processor;
    @NotNull
    private final Map<String, RsFile> exportingMacrosCrates;
    @NotNull
    private final List<RsUseItem> useItems;
    private boolean visitorResult;

    public MacroResolvingVisitor(boolean reverse, boolean ignoreLegacyMacros, @NotNull Function1<? super RsNamedElement, Boolean> processor2) {
        Intrinsics.checkNotNullParameter(processor2, (String)"processor");
        this.reverse = reverse;
        this.ignoreLegacyMacros = ignoreLegacyMacros;
        this.processor = processor2;
        this.exportingMacrosCrates = new LinkedHashMap();
        this.useItems = new ArrayList();
    }

    @NotNull
    public final Map<String, RsFile> getExportingMacrosCrates() {
        return this.exportingMacrosCrates;
    }

    @NotNull
    public final List<RsUseItem> getUseItems() {
        return this.useItems;
    }

    public final boolean processMacros(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return element instanceof RsElement ? this.processMacros((RsElement)element) : false;
    }

    private final boolean processMacros(RsElement item) {
        item.accept(this);
        return this.visitorResult;
    }

    @Override
    public void visitMacro(@NotNull RsMacro item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        if (this.ignoreLegacyMacros) {
            return;
        }
        this.visitorResult = (Boolean)this.processor.invoke((Object)item);
    }

    @Override
    public void visitModItem(@NotNull RsModItem item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        if (this.ignoreLegacyMacros) {
            return;
        }
        if (RsModItemKt.getHasMacroUse(item) && RsDocAndAttributeOwnerKt.getExistsAfterExpansionSelf(item)) {
            List elements2 = MacroResolvingVisitor.Companion.visibleMacros(item);
            this.visitorResult = MacroResolvingVisitor.Companion.processAll(this.reverse ? CollectionsKt.asReversed((List)elements2) : elements2, (Function1<? super RsNamedElement, Boolean>)this.processor);
        }
    }

    @Override
    public void visitModDeclItem(@NotNull RsModDeclItem item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        if (this.ignoreLegacyMacros) {
            return;
        }
        if (RsModDeclItemKt.getHasMacroUse(item) && RsDocAndAttributeOwnerKt.getExistsAfterExpansionSelf(item)) {
            RsElement rsElement = item.getReference().resolve();
            RsMod rsMod = rsElement instanceof RsMod ? (RsMod)rsElement : null;
            if (rsMod == null) {
                return;
            }
            RsMod mod = rsMod;
            List elements2 = MacroResolvingVisitor.Companion.visibleMacros(mod);
            this.visitorResult = MacroResolvingVisitor.Companion.processAll(this.reverse ? CollectionsKt.asReversed((List)elements2) : elements2, (Function1<? super RsNamedElement, Boolean>)this.processor);
        }
    }

    @Override
    public void visitExternCrateItem(@NotNull RsExternCrateItem item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        if (!RsDocAndAttributeOwnerKt.getExistsAfterExpansionSelf(item)) {
            return;
        }
        RsElement rsElement = item.getReference().resolve();
        RsFile rsFile = rsElement instanceof RsFile ? (RsFile)rsElement : null;
        if (rsFile == null) {
            return;
        }
        RsFile mod = rsFile;
        if (RsExternCrateItemKt.getHasMacroUse(item)) {
            this.visitorResult = MacroResolvingVisitor.Companion.processAll(NameResolutionKt.access$exportedMacros(mod), (Function1<? super RsNamedElement, Boolean>)this.processor);
        } else {
            List reexportedMacros = NameResolutionKt.access$reexportedMacros(item);
            if (reexportedMacros != null) {
                this.visitorResult = MacroResolvingVisitor.Companion.processAll(reexportedMacros, (Function1<? super RsNamedElement, Boolean>)this.processor);
            } else {
                this.exportingMacrosCrates.put(RsExternCrateItemKt.getNameWithAlias(item), mod);
            }
        }
    }

    @Override
    public void visitUseItem(@NotNull RsUseItem item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        ((Collection)this.useItems).add(item);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0002J*\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\f2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\n0\u000eH\u0002\u00a8\u0006\u000f"}, d2={"Lorg/rust/lang/core/resolve/MacroResolvingVisitor$Companion;", "", "<init>", "()V", "visibleMacros", "", "Lorg/rust/lang/core/psi/ext/RsNamedElement;", "scope", "Lorg/rust/lang/core/psi/ext/RsItemsOwner;", "processAll", "", "elements", "", "processor", "Lkotlin/Function1;", "intellij.rustrover.core"})
    @SourceDebugExtension(value={"SMAP\nNameResolution.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NameResolution.kt\norg/rust/lang/core/resolve/MacroResolvingVisitor$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,2140:1\n1761#2,3:2141\n*S KotlinDebug\n*F\n+ 1 NameResolution.kt\norg/rust/lang/core/resolve/MacroResolvingVisitor$Companion\n*L\n1381#1:2141,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final List<RsNamedElement> visibleMacros(RsItemsOwner scope) {
            Object object = CachedValuesManager.getCachedValue((PsiElement)scope, () -> Companion.visibleMacros$lambda$0(scope));
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getCachedValue(...)");
            return (List)object;
        }

        private final boolean processAll(Collection<? extends RsNamedElement> elements2, Function1<? super RsNamedElement, Boolean> processor2) {
            boolean bl;
            block3: {
                Iterable $this$any$iv = elements2;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        RsNamedElement it2 = (RsNamedElement)element$iv;
                        boolean bl2 = false;
                        if (!((Boolean)processor2.invoke((Object)it2)).booleanValue()) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        private static final CachedValueProvider.Result visibleMacros$lambda$0(RsItemsOwner $scope) {
            List visibleMacros = new ArrayList();
            MacroResolvingVisitor visitor2 = new MacroResolvingVisitor(false, false, (Function1<? super RsNamedElement, Boolean>)((Function1)arg_0 -> Companion.visibleMacros$lambda$0$0(visibleMacros, arg_0)));
            for (RsElement item : RsItemsOwnerKt.getItemsAndMacros($scope)) {
                visitor2.processMacros(item);
            }
            Object[] objectArray = new Object[]{RsPsiManagerKt.getRustStructureOrAnyPsiModificationTracker($scope)};
            return CachedValueProvider.Result.create((Object)visibleMacros, (Object[])objectArray);
        }

        private static final boolean visibleMacros$lambda$0$0(List $visibleMacros, RsNamedElement it2) {
            Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
            $visibleMacros.add(it2);
            return false;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

