/*
 * Decompiled with CFR 0.152.
 */
package org.rust.lang.core.resolve;

import com.intellij.extapi.psi.StubBasedPsiElementBase;
import com.intellij.psi.PsiElement;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.rust.lang.core.macros.RsExpandedElement;
import org.rust.lang.core.macros.RsExpandedElementKt;
import org.rust.lang.core.psi.RsFile;
import org.rust.lang.core.psi.RsMacroCall;
import org.rust.lang.core.psi.RsModDeclItem;
import org.rust.lang.core.psi.RsPath;
import org.rust.lang.core.psi.RsUseItem;
import org.rust.lang.core.psi.RsVisitor;
import org.rust.lang.core.psi.ext.PsiElementKt;
import org.rust.lang.core.psi.ext.RsElement;
import org.rust.lang.core.psi.ext.RsItemsOwner;
import org.rust.lang.core.psi.ext.RsMacroCallKt;
import org.rust.lang.core.psi.ext.RsMod;
import org.rust.lang.core.psi.ext.RsNamedElement;
import org.rust.lang.core.psi.ext.RsPathKt;
import org.rust.lang.core.psi.ext.RsPossibleMacroCall;
import org.rust.lang.core.resolve.MacroResolveResult;
import org.rust.lang.core.resolve.MacroResolvingVisitor;
import org.rust.lang.core.resolve.NameResolutionKt;
import org.rust.lang.core.resolve.NamespaceKt;
import org.rust.lang.core.resolve.ProcessorsKt;
import org.rust.lang.core.resolve.RsResolveProcessorBase;
import org.rust.lang.core.resolve.ScopeEntry;
import org.rust.lang.core.resolve.ref.RsMacroPathReferenceImpl;
import org.rust.lang.core.resolve.ref.RsPathReference;
import org.rust.lang.core.resolve2.FacadeResolveKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB+\b\u0002\u0012\u0010\u0010\u0002\u001a\f\u0012\u0004\u0012\u00020\u00040\u0003j\u0002`\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0011\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0011H\u0082\u0010J\u0015\u0010\u0015\u001a\u00020\u000f2\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u0016H\u0082\u0010J\u0010\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0014\u001a\u00020\u0011H\u0002J\b\u0010\u001b\u001a\u00020\u0007H\u0002R\u0018\u0010\u0002\u001a\f\u0012\u0004\u0012\u00020\u00040\u0003j\u0002`\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/rust/lang/core/resolve/MacroResolver;", "Lorg/rust/lang/core/psi/RsVisitor;", "processor", "Lorg/rust/lang/core/resolve/RsResolveProcessorBase;", "Lorg/rust/lang/core/resolve/ScopeEntry;", "Lorg/rust/lang/core/resolve/RsResolveProcessor;", "ignoreLegacyMacros", "", "path", "Lorg/rust/lang/core/psi/RsPath;", "<init>", "(Lorg/rust/lang/core/resolve/RsResolveProcessorBase;ZLorg/rust/lang/core/psi/RsPath;)V", "visitor", "Lorg/rust/lang/core/resolve/MacroResolvingVisitor;", "processMacrosInLexicalOrderUpward", "Lorg/rust/lang/core/resolve/MacroResolveResult;", "startElement", "Lcom/intellij/psi/PsiElement;", "processScopesInLexicalOrderUpward", "psiBasedProcessScopesInLexicalOrderUpward", "element", "stubBasedProcessScopesInLexicalOrderUpward", "Lcom/intellij/psi/stubs/StubElement;", "processExpandedFrom", "expandedFrom", "Lorg/rust/lang/core/psi/RsMacroCall;", "tryProcessAllMacrosUsingNewResolve", "processRemainedExportedMacros", "Companion", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nNameResolution.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NameResolution.kt\norg/rust/lang/core/resolve/MacroResolver\n+ 2 PsiElement.kt\norg/rust/lang/core/psi/ext/PsiElementKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,2140:1\n94#2:2141\n312#2:2142\n1#3:2143\n1761#4,3:2144\n*S KotlinDebug\n*F\n+ 1 NameResolution.kt\norg/rust/lang/core/resolve/MacroResolver\n*L\n1178#1:2141\n1189#1:2142\n1281#1:2144,3\n*E\n"})
final class MacroResolver
extends RsVisitor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RsResolveProcessorBase<ScopeEntry> processor;
    @NotNull
    private final RsPath path;
    @NotNull
    private final MacroResolvingVisitor visitor;

    private MacroResolver(RsResolveProcessorBase<? super ScopeEntry> processor2, boolean ignoreLegacyMacros, RsPath path) {
        this.processor = processor2;
        this.path = path;
        this.visitor = new MacroResolvingVisitor(true, ignoreLegacyMacros, (Function1<? super RsNamedElement, Boolean>)((Function1)arg_0 -> MacroResolver.visitor$lambda$0(this, arg_0)));
    }

    private final MacroResolveResult processMacrosInLexicalOrderUpward(PsiElement startElement) {
        MacroResolveResult result2 = this.processScopesInLexicalOrderUpward(startElement);
        if (result2.getResult() || result2.getUsedNewResolve()) {
            return result2;
        }
        if (this.processRemainedExportedMacros()) {
            return MacroResolveResult.Companion.getTrue();
        }
        PsiElement $this$contextOrSelf$iv = startElement;
        boolean $i$f$contextOrSelf = false;
        RsElement rsElement = (RsElement)PsiTreeUtil.getContextOfType((PsiElement)$this$contextOrSelf$iv, RsElement.class, (boolean)false);
        RsMod rsMod = rsElement != null ? rsElement.getCrateRoot() : null;
        RsFile rsFile = rsMod instanceof RsFile ? (RsFile)rsMod : null;
        if (rsFile == null) {
            return MacroResolveResult.Companion.getFalse();
        }
        RsFile crateRoot = rsFile;
        return org.rust.lang.core.resolve.MacroResolver$Companion.toResult$default(Companion, ProcessorsKt.processAllScopeEntries(NameResolutionKt.access$exportedMacrosAsScopeEntries(crateRoot), this.processor), false, 1, null);
    }

    private final MacroResolveResult processScopesInLexicalOrderUpward(PsiElement startElement) {
        Object object;
        StubBasedPsiElement stubBasedPsiElement = startElement instanceof StubBasedPsiElement ? (StubBasedPsiElement)startElement : null;
        if (stubBasedPsiElement != null) {
            StubBasedPsiElement $this$greenStub$iv = stubBasedPsiElement;
            boolean $i$f$getGreenStub = false;
            StubBasedPsiElementBase stubBasedPsiElementBase = $this$greenStub$iv instanceof StubBasedPsiElementBase ? (StubBasedPsiElementBase)$this$greenStub$iv : null;
            object = stubBasedPsiElementBase != null ? stubBasedPsiElementBase.getGreenStub() : null;
        } else {
            object = null;
        }
        StubElement stub = object;
        return stub != null ? this.stubBasedProcessScopesInLexicalOrderUpward(stub) : this.psiBasedProcessScopesInLexicalOrderUpward(startElement);
    }

    private final MacroResolveResult psiBasedProcessScopesInLexicalOrderUpward(PsiElement element) {
        MacroResolveResult macroResolveResult;
        MacroResolver macroResolver = this;
        while (true) {
            PsiElement psiElement2;
            RsPossibleMacroCall expandedFrom;
            Object object;
            if ((object = macroResolver.tryProcessAllMacrosUsingNewResolve(element)) != null) {
                MacroResolveResult it2 = object;
                boolean bl = false;
                return it2;
            }
            object = PsiElementKt.getLeftSiblings(element).iterator();
            while (object.hasNext()) {
                PsiElement e = (PsiElement)object.next();
                if (!macroResolver.visitor.processMacros(e)) continue;
                return MacroResolveResult.Companion.getTrue();
            }
            RsExpandedElement rsExpandedElement = element instanceof RsExpandedElement ? (RsExpandedElement)element : null;
            RsPossibleMacroCall rsPossibleMacroCall = expandedFrom = rsExpandedElement != null ? RsExpandedElementKt.getExpandedFrom(rsExpandedElement) : null;
            if (expandedFrom instanceof RsMacroCall && macroResolver.processExpandedFrom((RsMacroCall)expandedFrom)) {
                return MacroResolveResult.Companion.getTrue();
            }
            RsPossibleMacroCall rsPossibleMacroCall2 = expandedFrom;
            if (rsPossibleMacroCall2 != null) {
                psiElement2 = rsPossibleMacroCall2;
            } else {
                psiElement2 = element.getContext();
                if (psiElement2 == null) {
                    return MacroResolveResult.Companion.getFalse();
                }
            }
            PsiElement context = psiElement2;
            if (context instanceof RsFile) {
                RsModDeclItem rsModDeclItem = ((RsFile)context).getDeclaration();
                if (rsModDeclItem == null) {
                    return MacroResolveResult.Companion.getFalse();
                }
                RsModDeclItem declaration = rsModDeclItem;
                macroResolveResult = macroResolver.processScopesInLexicalOrderUpward(declaration);
                break;
            }
            if (!Intrinsics.areEqual((Object)context, (Object)element.getParent())) {
                macroResolveResult = macroResolver.processScopesInLexicalOrderUpward(context);
                break;
            }
            element = context;
        }
        return macroResolveResult;
    }

    private final MacroResolveResult stubBasedProcessScopesInLexicalOrderUpward(StubElement<?> element) {
        MacroResolveResult macroResolveResult;
        MacroResolver macroResolver = this;
        while (true) {
            RsPossibleMacroCall expandedFrom;
            List siblings;
            StubElement parentStub;
            PsiElement psiElement2 = element.getPsi();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"getPsi(...)");
            MacroResolveResult macroResolveResult2 = macroResolver.tryProcessAllMacrosUsingNewResolve(psiElement2);
            if (macroResolveResult2 != null) {
                MacroResolveResult it2 = macroResolveResult2;
                boolean bl = false;
                return it2;
            }
            if (element.getParentStub() == null) {
                return MacroResolveResult.Companion.getFalse();
            }
            Intrinsics.checkNotNullExpressionValue((Object)parentStub.getChildrenStubs(), (String)"getChildrenStubs(...)");
            int index = siblings.indexOf(element);
            if (!(index != -1)) {
                boolean $i$a$-check-MacroResolver$stubBasedProcessScopesInLexicalOrderUpward$32 = false;
                String $i$a$-check-MacroResolver$stubBasedProcessScopesInLexicalOrderUpward$32 = "Can't find stub index";
                throw new IllegalStateException($i$a$-check-MacroResolver$stubBasedProcessScopesInLexicalOrderUpward$32.toString());
            }
            List leftSiblings = siblings.subList(0, index);
            for (StubElement it3 : leftSiblings) {
                MacroResolvingVisitor macroResolvingVisitor = macroResolver.visitor;
                PsiElement psiElement3 = it3.getPsi();
                Intrinsics.checkNotNullExpressionValue((Object)psiElement3, (String)"getPsi(...)");
                if (!macroResolvingVisitor.processMacros(psiElement3)) continue;
                return MacroResolveResult.Companion.getTrue();
            }
            PsiElement psiElement4 = element.getPsi();
            RsExpandedElement rsExpandedElement = psiElement4 instanceof RsExpandedElement ? (RsExpandedElement)psiElement4 : null;
            RsPossibleMacroCall rsPossibleMacroCall = expandedFrom = rsExpandedElement != null ? RsExpandedElementKt.getExpandedFrom(rsExpandedElement) : null;
            if (expandedFrom instanceof RsMacroCall && macroResolver.processExpandedFrom((RsMacroCall)expandedFrom)) {
                return MacroResolveResult.Companion.getTrue();
            }
            RsPossibleMacroCall rsPossibleMacroCall2 = expandedFrom;
            PsiElement parentPsi = rsPossibleMacroCall2 != null ? (PsiElement)rsPossibleMacroCall2 : parentStub.getPsi();
            if (parentPsi instanceof RsFile) {
                RsModDeclItem rsModDeclItem = ((RsFile)parentPsi).getDeclaration();
                if (rsModDeclItem == null) {
                    return MacroResolveResult.Companion.getFalse();
                }
                RsModDeclItem declaration = rsModDeclItem;
                macroResolveResult = macroResolver.processScopesInLexicalOrderUpward(declaration);
                break;
            }
            if (!Intrinsics.areEqual((Object)parentPsi, (Object)parentStub.getPsi())) {
                Intrinsics.checkNotNull((Object)parentPsi);
                macroResolveResult = macroResolver.processScopesInLexicalOrderUpward(parentPsi);
                break;
            }
            element = parentStub;
        }
        return macroResolveResult;
    }

    private final boolean processExpandedFrom(RsMacroCall expandedFrom) {
        RsPath rsPath = expandedFrom.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)rsPath, (String)"<get-path>(...)");
        if (RsPathKt.getQualifier(rsPath) == null) {
            RsPathReference rsPathReference = expandedFrom.getPath().getReference();
            Object object = rsPathReference instanceof RsMacroPathReferenceImpl ? (RsMacroPathReferenceImpl)rsPathReference : null;
            if (object == null || (object = ((RsMacroPathReferenceImpl)object).resolveIfCached()) == null) {
                return false;
            }
            Object resolved = object;
            if (ProcessorsKt.process(this.processor, RsMacroCallKt.getMacroName(expandedFrom), NamespaceKt.getMACROS(), (RsElement)resolved)) {
                return true;
            }
        }
        return false;
    }

    private final MacroResolveResult tryProcessAllMacrosUsingNewResolve(PsiElement element) {
        boolean scopeIsTopLevelMod;
        if (!(element instanceof RsElement)) {
            return null;
        }
        PsiElement psiElement2 = ((RsElement)element).getContext();
        RsItemsOwner rsItemsOwner = psiElement2 instanceof RsItemsOwner ? (RsItemsOwner)psiElement2 : null;
        if (rsItemsOwner == null) {
            return null;
        }
        RsItemsOwner scope = rsItemsOwner;
        boolean result2 = FacadeResolveKt.processMacros(scope, this.processor, this.path);
        boolean bl = scopeIsTopLevelMod = scope instanceof RsMod && !FacadeResolveKt.isLocal((RsMod)scope);
        if (!scopeIsTopLevelMod && !result2) {
            return null;
        }
        return MacroResolver.Companion.toResult(result2, true);
    }

    private final boolean processRemainedExportedMacros() {
        boolean bl;
        block3: {
            Iterable $this$any$iv = this.visitor.getUseItems();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    RsUseItem useItem = (RsUseItem)element$iv;
                    boolean bl2 = false;
                    if (!ProcessorsKt.processAllScopeEntries(NameResolutionKt.access$collectMacrosImportedWithUseItem(useItem, this.visitor.getExportingMacrosCrates()), this.processor)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final boolean visitor$lambda$0(MacroResolver this$0, RsNamedElement it2) {
        Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
        return ProcessorsKt.process(this$0.processor, it2, NamespaceKt.getMACROS());
    }

    public /* synthetic */ MacroResolver(RsResolveProcessorBase processor2, boolean ignoreLegacyMacros, RsPath path, DefaultConstructorMarker $constructor_marker) {
        this(processor2, ignoreLegacyMacros, path);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0010\u0010\n\u001a\f\u0012\u0004\u0012\u00020\f0\u000bj\u0002`\rJ\u0016\u0010\u000e\u001a\u00020\u0005*\u00020\t2\b\b\u0002\u0010\u000f\u001a\u00020\tH\u0002\u00a8\u0006\u0010"}, d2={"Lorg/rust/lang/core/resolve/MacroResolver$Companion;", "", "<init>", "()V", "processMacrosInLexicalOrderUpward", "Lorg/rust/lang/core/resolve/MacroResolveResult;", "path", "Lorg/rust/lang/core/psi/RsPath;", "ignoreLegacyMacros", "", "processor", "Lorg/rust/lang/core/resolve/RsResolveProcessorBase;", "Lorg/rust/lang/core/resolve/ScopeEntry;", "Lorg/rust/lang/core/resolve/RsResolveProcessor;", "toResult", "usedNewResolve", "intellij.rustrover.core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final MacroResolveResult processMacrosInLexicalOrderUpward(@NotNull RsPath path, boolean ignoreLegacyMacros, @NotNull RsResolveProcessorBase<? super ScopeEntry> processor2) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter(processor2, (String)"processor");
            return new MacroResolver(processor2, ignoreLegacyMacros, path, null).processMacrosInLexicalOrderUpward(path);
        }

        private final MacroResolveResult toResult(boolean $this$toResult, boolean usedNewResolve) {
            return new MacroResolveResult($this$toResult, usedNewResolve);
        }

        static /* synthetic */ MacroResolveResult toResult$default(Companion companion, boolean bl, boolean bl2, int n, Object object) {
            if ((n & 1) != 0) {
                bl2 = false;
            }
            return companion.toResult(bl, bl2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

