/*
 * Decompiled with CFR 0.152.
 */
package org.rust.lang.core.psi.ext;

import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.StubElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.ide.presentation.UtilsKt;
import org.rust.lang.core.psi.RsElementTypes;
import org.rust.lang.core.psi.RsPsiFactory;
import org.rust.lang.core.psi.RsRawIdentifiersKt;
import org.rust.lang.core.psi.ext.RsNameIdentifierOwner;
import org.rust.lang.core.psi.ext.RsStubbedElementImpl;
import org.rust.lang.core.stubs.RsNamedStub;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u0000*\u0010\b\u0000\u0010\u0001*\u00020\u0002*\u0006\u0012\u0002\b\u00030\u00032\b\u0012\u0004\u0012\u0002H\u00010\u00042\u00020\u0005B\u0011\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tB!\b\u0016\u0012\u0006\u0010\n\u001a\u00028\u0000\u0012\u000e\u0010\u000b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\f\u00a2\u0006\u0004\b\b\u0010\rJ\n\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\n\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0013\u001a\u00020\u0011H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016\u00a8\u0006\u0018"}, d2={"Lorg/rust/lang/core/psi/ext/RsStubbedNamedElementImpl;", "StubT", "Lorg/rust/lang/core/stubs/RsNamedStub;", "Lcom/intellij/psi/stubs/StubElement;", "Lorg/rust/lang/core/psi/ext/RsStubbedElementImpl;", "Lorg/rust/lang/core/psi/ext/RsNameIdentifierOwner;", "node", "Lcom/intellij/lang/ASTNode;", "<init>", "(Lcom/intellij/lang/ASTNode;)V", "stub", "nodeType", "Lcom/intellij/psi/stubs/IStubElementType;", "(Lorg/rust/lang/core/stubs/RsNamedStub;Lcom/intellij/psi/stubs/IStubElementType;)V", "getNameIdentifier", "Lcom/intellij/psi/PsiElement;", "getName", "", "setName", "name", "getTextOffset", "", "getPresentation", "Lcom/intellij/navigation/ItemPresentation;", "intellij.rustrover.core"})
public abstract class RsStubbedNamedElementImpl<StubT extends RsNamedStub & StubElement<?>>
extends RsStubbedElementImpl<StubT>
implements RsNameIdentifierOwner {
    public RsStubbedNamedElementImpl(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        super(node);
    }

    public RsStubbedNamedElementImpl(@NotNull StubT stub, @NotNull IStubElementType<?, ?> nodeType) {
        Intrinsics.checkNotNullParameter(stub, (String)"stub");
        Intrinsics.checkNotNullParameter(nodeType, (String)"nodeType");
        super((StubElement)stub, nodeType);
    }

    @Nullable
    public PsiElement getNameIdentifier() {
        return this.findChildByType(RsElementTypes.IDENTIFIER);
    }

    @Nullable
    public String getName() {
        String string;
        RsNamedStub stub;
        RsNamedStub rsNamedStub = stub = (RsNamedStub)this.getGreenStub();
        if (rsNamedStub != null) {
            string = rsNamedStub.getName();
        } else {
            PsiElement psiElement2 = this.getNameIdentifier();
            string = psiElement2 != null ? RsRawIdentifiersKt.getUnescapedText(psiElement2) : null;
        }
        return string;
    }

    @Nullable
    public PsiElement setName(@NotNull String name2) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            PsiElement psiElement2 = this.getNameIdentifier();
            if (psiElement2 == null) break block0;
            Project project = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            psiElement2.replace(new RsPsiFactory(project, false, false, 6, null).createIdentifier(name2));
        }
        return this;
    }

    public int getTextOffset() {
        PsiElement psiElement2 = this.getNameIdentifier();
        return psiElement2 != null ? psiElement2.getTextOffset() : super.getTextOffset();
    }

    @NotNull
    public ItemPresentation getPresentation() {
        return UtilsKt.getPresentation(this);
    }
}

