/*
 * Decompiled with CFR 0.152.
 */
package org.rust.lang.core.psi.ext;

import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.cargo.project.workspace.CargoWorkspace;
import org.rust.lang.core.crate.CrateKt;
import org.rust.lang.core.psi.ext.RsElement;
import org.rust.lang.core.psi.ext.RsElementKt;
import org.rust.lang.core.psi.ext.RsMod;
import org.rust.lang.core.psi.ext.RsModKt;
import org.rust.lang.core.psi.ext.RsQualifiedNamedElement;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0014\u0010\u0006\u001a\u0004\u0018\u00010\u0001*\u00020\u00032\u0006\u0010\u0007\u001a\u00020\b\u001a\u0014\u0010\t\u001a\u0004\u0018\u00010\u0001*\u00020\u00032\u0006\u0010\u0007\u001a\u00020\n\u001a\u0016\u0010\u000b\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\u0001\"\u001c\u0010\u0000\u001a\t\u0018\u00010\u0001\u00a2\u0006\u0002\b\u0002*\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\r"}, d2={"qualifiedName", "", "Lcom/intellij/openapi/util/NlsSafe;", "Lorg/rust/lang/core/psi/ext/RsQualifiedNamedElement;", "getQualifiedName", "(Lorg/rust/lang/core/psi/ext/RsQualifiedNamedElement;)Ljava/lang/String;", "qualifiedNameInCrate", "context", "Lorg/rust/lang/core/psi/ext/RsElement;", "qualifiedNameRelativeTo", "Lorg/rust/lang/core/psi/ext/RsMod;", "convertPathToRelativeIfPossible", "absolutePath", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nRsQualifiedNamedElement.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RsQualifiedNamedElement.kt\norg/rust/lang/core/psi/ext/RsQualifiedNamedElementKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,508:1\n1761#2,3:509\n*S KotlinDebug\n*F\n+ 1 RsQualifiedNamedElement.kt\norg/rust/lang/core/psi/ext/RsQualifiedNamedElementKt\n*L\n66#1:509,3\n*E\n"})
public final class RsQualifiedNamedElementKt {
    @Nullable
    public static final String getQualifiedName(@NotNull RsQualifiedNamedElement $this$qualifiedName) {
        Intrinsics.checkNotNullParameter((Object)$this$qualifiedName, (String)"<this>");
        Project project = $this$qualifiedName.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        if (DumbService.Companion.isDumb(project)) {
            return $this$qualifiedName.getName();
        }
        String string = $this$qualifiedName.getCrateRelativePath();
        if (string == null) {
            return null;
        }
        String inCratePath = string;
        Object object = CrateKt.getAsNotFake(RsElementKt.getContainingCrate($this$qualifiedName));
        if (object == null || (object = object.getNormName()) == null) {
            return null;
        }
        Object cargoTarget = object;
        return (String)cargoTarget + inCratePath;
    }

    @Nullable
    public static final String qualifiedNameInCrate(@NotNull RsQualifiedNamedElement $this$qualifiedNameInCrate, @NotNull RsElement context) {
        Intrinsics.checkNotNullParameter((Object)$this$qualifiedNameInCrate, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String crateRelativePath = $this$qualifiedNameInCrate.getCrateRelativePath();
        if (!Intrinsics.areEqual((Object)context.getCrateRoot(), (Object)$this$qualifiedNameInCrate.getCrateRoot()) || crateRelativePath == null) {
            return RsQualifiedNamedElementKt.getQualifiedName($this$qualifiedNameInCrate);
        }
        if (!(((CharSequence)crateRelativePath).length() == 0 || StringsKt.startsWith$default((String)crateRelativePath, (String)"::", (boolean)false, (int)2, null))) {
            throw new IllegalStateException("Check failed.");
        }
        return "crate" + crateRelativePath;
    }

    @Nullable
    public static final String qualifiedNameRelativeTo(@NotNull RsQualifiedNamedElement $this$qualifiedNameRelativeTo, @NotNull RsMod context) {
        Intrinsics.checkNotNullParameter((Object)$this$qualifiedNameRelativeTo, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String string = RsQualifiedNamedElementKt.qualifiedNameInCrate($this$qualifiedNameRelativeTo, context);
        if (string == null) {
            return null;
        }
        String absolutePath = string;
        if (!RsModKt.getSuperMods($this$qualifiedNameRelativeTo.getContainingMod()).contains(context)) {
            return absolutePath;
        }
        return RsQualifiedNamedElementKt.convertPathToRelativeIfPossible(context, absolutePath);
    }

    @NotNull
    public static final String convertPathToRelativeIfPossible(@NotNull RsMod context, @NotNull String absolutePath) {
        boolean bl;
        String relativePath;
        block7: {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)absolutePath, (String)"absolutePath");
            String string = context.getCrateRelativePath();
            if (string == null) {
                return absolutePath;
            }
            String contextModPath = string;
            String contextModPathPrefix = "crate" + contextModPath + "::";
            if (!StringsKt.startsWith$default((String)absolutePath, (String)contextModPathPrefix, (boolean)false, (int)2, null)) {
                return absolutePath;
            }
            relativePath = StringsKt.removePrefix((String)absolutePath, (CharSequence)contextModPathPrefix);
            CargoWorkspace cargoWorkspace = RsElementKt.getCargoWorkspace(context);
            if (cargoWorkspace == null) {
                return relativePath;
            }
            CargoWorkspace cargoWorkspace2 = cargoWorkspace;
            Iterable $this$any$iv = cargoWorkspace2.getPackages();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    CargoWorkspace.Package it2 = (CargoWorkspace.Package)element$iv;
                    boolean bl2 = false;
                    if (!StringsKt.startsWith$default((String)relativePath, (String)(it2.getNormName() + "::"), (boolean)false, (int)2, null)) continue;
                    bl = true;
                    break block7;
                }
                bl = false;
            }
        }
        if (bl) {
            return "self::" + relativePath;
        }
        return relativePath;
    }
}

