/*
 * Decompiled with CFR 0.152.
 */
package org.rust.lang.core.psi;

import com.intellij.ProjectTopics;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.rust.cargo.project.model.CargoProjectServiceKt;
import org.rust.cargo.project.model.CargoProjectsService;
import org.rust.cargo.project.workspace.PackageOrigin;
import org.rust.lang.RsFileType;
import org.rust.lang.core.crate.Crate;
import org.rust.lang.core.crate.CrateGraphService;
import org.rust.lang.core.crate.CrateGraphServiceKt;
import org.rust.lang.core.macros.MacroExpansionManager;
import org.rust.lang.core.macros.MacroExpansionManagerKt;
import org.rust.lang.core.macros.MacroExpansionMode;
import org.rust.lang.core.macros.filesystem.MacroExpansionInternalFileSystem;
import org.rust.lang.core.psi.RsFile;
import org.rust.lang.core.psi.RsFunction;
import org.rust.lang.core.psi.RsMacroCall;
import org.rust.lang.core.psi.RsProcMacroPsiUtil;
import org.rust.lang.core.psi.RsPsiManager;
import org.rust.lang.core.psi.RsPsiManagerKt;
import org.rust.lang.core.psi.RsPsiTreeChangeAdapter;
import org.rust.lang.core.psi.RsPsiTreeChangeEvent;
import org.rust.lang.core.psi.RustPsiChangeListener;
import org.rust.lang.core.psi.RustStructureChangeListener;
import org.rust.lang.core.psi.ext.RsMacroDefinitionBase;
import org.rust.lang.core.psi.ext.RsModificationTrackerOwner;
import org.rust.lang.core.psi.ext.RsModificationTrackerOwnerKt;
import org.rust.lang.core.resolve2.DefMapServiceKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002:\u0002 !B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u000f\u001a\u00020\u0010H\u0016J(\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017H\u0002J\u0010\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\b\u0010\u001e\u001a\u00020\u0010H\u0016J \u0010\u001e\u001a\u00020\u00102\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u00132\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0002J\u0012\u0010\u001f\u001a\u00020\u00172\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0014\u0010\u001c\u001a\u00020\u00178BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006\""}, d2={"Lorg/rust/lang/core/psi/RsPsiManagerImpl;", "Lorg/rust/lang/core/psi/RsPsiManager;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "rustStructureModificationTracker", "Lcom/intellij/openapi/util/SimpleModificationTracker;", "getRustStructureModificationTracker", "()Lcom/intellij/openapi/util/SimpleModificationTracker;", "rustStructureModificationTrackerInDependencies", "getRustStructureModificationTrackerInDependencies", "dispose", "", "updateModificationCount", "file", "Lcom/intellij/psi/PsiFile;", "psi", "Lcom/intellij/psi/PsiElement;", "isChildrenChange", "", "isWhitespaceOrComment", "setParentFunctionsHasStructureModification", "owner", "Lorg/rust/lang/core/psi/ext/RsModificationTrackerOwner;", "isMacroExpansionModeNew", "()Z", "incRustStructureModificationCount", "isWorkspaceFile", "CacheInvalidator", "Helper", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nRsPsiManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RsPsiManager.kt\norg/rust/lang/core/psi/RsPsiManagerImpl\n+ 2 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,308:1\n80#2:309\n1761#3,3:310\n*S KotlinDebug\n*F\n+ 1 RsPsiManager.kt\norg/rust/lang/core/psi/RsPsiManagerImpl\n*L\n227#1:309\n257#1:310,3\n*E\n"})
public final class RsPsiManagerImpl
implements RsPsiManager,
Disposable {
    @NotNull
    private final Project project;
    @NotNull
    private final SimpleModificationTracker rustStructureModificationTracker;
    @NotNull
    private final SimpleModificationTracker rustStructureModificationTrackerInDependencies;

    public RsPsiManagerImpl(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.rustStructureModificationTracker = new SimpleModificationTracker();
        this.rustStructureModificationTrackerInDependencies = new SimpleModificationTracker();
        PsiManager.getInstance((Project)this.project).addPsiTreeChangeListener((PsiTreeChangeListener)new CacheInvalidator(), (Disposable)this);
        MessageBusConnection messageBusConnection = this.project.getMessageBus().connect();
        Topic topic = ProjectTopics.PROJECT_ROOTS;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"PROJECT_ROOTS");
        messageBusConnection.subscribe(topic, (Object)new ModuleRootListener(){

            public void rootsChanged(ModuleRootEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.incRustStructureModificationCount();
            }
        });
        this.project.getMessageBus().connect().subscribe(CargoProjectsService.Companion.getCARGO_PROJECTS_TOPIC(), (arg_0, arg_1) -> RsPsiManagerImpl._init_$lambda$0(this, arg_0, arg_1));
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public SimpleModificationTracker getRustStructureModificationTracker() {
        return this.rustStructureModificationTracker;
    }

    @Override
    @NotNull
    public SimpleModificationTracker getRustStructureModificationTrackerInDependencies() {
        return this.rustStructureModificationTrackerInDependencies;
    }

    public void dispose() {
    }

    private final void updateModificationCount(PsiFile file, PsiElement psi, boolean isChildrenChange, boolean isWhitespaceOrComment) {
        boolean bl;
        RsModificationTrackerOwner owner;
        RsModificationTrackerOwner rsModificationTrackerOwner = DumbService.Companion.isDumb(this.project) ? null : (owner = RsModificationTrackerOwnerKt.findModificationTrackerOwner(psi, !isChildrenChange));
        if (isWhitespaceOrComment && !(owner instanceof RsMacroCall) && !(owner instanceof RsMacroDefinitionBase) && !RsProcMacroPsiUtil.INSTANCE.canBeInProcMacroCallBody(psi)) {
            return;
        }
        RsModificationTrackerOwner rsModificationTrackerOwner2 = owner;
        RsModificationTrackerOwner.ModificationPropagationStrategy modificationPropagationStrategy = rsModificationTrackerOwner2 != null ? rsModificationTrackerOwner2.incModificationCount(psi) : null;
        switch (modificationPropagationStrategy == null ? -1 : WhenMappings.$EnumSwitchMapping$0[modificationPropagationStrategy.ordinal()]) {
            case 1: {
                this.updateModificationCount(file, owner, false, false);
                return;
            }
            case 2: {
                bl = false;
                break;
            }
            case -1: 
            case 3: {
                bl = true;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        boolean isStructureModification = bl;
        if (isStructureModification) {
            this.incRustStructureModificationCount(file, psi);
            if (owner != null) {
                this.setParentFunctionsHasStructureModification(owner);
            }
        }
        ((RustPsiChangeListener)this.project.getMessageBus().syncPublisher(RsPsiManagerKt.access$getRUST_PSI_CHANGE_TOPIC$p())).rustPsiChanged(file, psi, isStructureModification);
    }

    private final void setParentFunctionsHasStructureModification(RsModificationTrackerOwner owner) {
        PsiElement $this$parentsOfType_u24default$iv = owner;
        boolean withSelf$iv = true;
        boolean $i$f$parentsOfType = false;
        for (RsFunction function : PsiTreeUtilKt.parentsOfType((PsiElement)$this$parentsOfType_u24default$iv, RsFunction.class, (boolean)withSelf$iv)) {
            function.putUserData(Helper.INSTANCE.getHasStructureModification(), true);
        }
    }

    private final boolean isMacroExpansionModeNew() {
        MacroExpansionManager macroExpansionManager = MacroExpansionManagerKt.getMacroExpansionManagerIfCreated(this.project);
        return (macroExpansionManager != null ? macroExpansionManager.getMacroExpansionMode() : null) instanceof MacroExpansionMode.New;
    }

    @Override
    public void incRustStructureModificationCount() {
        this.incRustStructureModificationCount(null, null);
    }

    private final void incRustStructureModificationCount(PsiFile file, PsiElement psi) {
        this.getRustStructureModificationTracker().incModificationCount();
        if (!this.isWorkspaceFile(file)) {
            this.getRustStructureModificationTrackerInDependencies().incModificationCount();
        }
        ((RustStructureChangeListener)this.project.getMessageBus().syncPublisher(RsPsiManagerKt.access$getRUST_STRUCTURE_CHANGE_TOPIC$p())).rustStructureChanged(file, psi);
    }

    static /* synthetic */ void incRustStructureModificationCount$default(RsPsiManagerImpl rsPsiManagerImpl, PsiFile psiFile, PsiElement psiElement2, int n, Object object) {
        if ((n & 1) != 0) {
            psiFile = null;
        }
        if ((n & 2) != 0) {
            psiElement2 = null;
        }
        rsPsiManagerImpl.incRustStructureModificationCount(psiFile, psiElement2);
    }

    private final boolean isWorkspaceFile(PsiFile file) {
        boolean bl;
        block9: {
            Collection crates;
            if (!(file instanceof RsFile)) {
                return false;
            }
            VirtualFile virtualFile = ((RsFile)file).getVirtualFile();
            if (virtualFile == null) {
                return false;
            }
            VirtualFile virtualFile2 = virtualFile;
            if (virtualFile2.getFileSystem() instanceof MacroExpansionInternalFileSystem) {
                Object object = MacroExpansionManagerKt.getMacroExpansionManagerIfCreated(this.project);
                if (object == null || (object = object.getCrateForExpansionFile(virtualFile2)) == null) {
                    return false;
                }
                int crateId = (Integer)object;
                v2 = CollectionsKt.listOf((Object)crateId);
            } else {
                v2 = crates = DefMapServiceKt.getDefMapService(this.project).findCrates((RsFile)file);
            }
            if (crates.isEmpty()) {
                return false;
            }
            CrateGraphService crateGraph = CrateGraphServiceKt.getCrateGraph(this.project);
            Iterable $this$any$iv = crates;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    int it2 = ((Number)element$iv).intValue();
                    boolean bl2 = false;
                    Crate crate = crateGraph.findCrateById(it2);
                    if (!((crate != null ? crate.getOrigin() : null) != PackageOrigin.WORKSPACE)) continue;
                    bl = true;
                    break block9;
                }
                bl = false;
            }
        }
        return !bl;
    }

    private static final void _init_$lambda$0(RsPsiManagerImpl this$0, CargoProjectsService cargoProjectsService, Collection collection) {
        Intrinsics.checkNotNullParameter((Object)cargoProjectsService, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)collection, (String)"<unused var>");
        this$0.incRustStructureModificationCount();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lorg/rust/lang/core/psi/RsPsiManagerImpl$CacheInvalidator;", "Lorg/rust/lang/core/psi/RsPsiTreeChangeAdapter;", "<init>", "(Lorg/rust/lang/core/psi/RsPsiManagerImpl;)V", "handleEvent", "", "event", "Lorg/rust/lang/core/psi/RsPsiTreeChangeEvent;", "intellij.rustrover.core"})
    public final class CacheInvalidator
    extends RsPsiTreeChangeAdapter {
        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void handleEvent(@NotNull RsPsiTreeChangeEvent event) {
            PsiElement psiElement2;
            block20: {
                RsPsiTreeChangeEvent rsPsiTreeChangeEvent;
                block26: {
                    block25: {
                        block24: {
                            block23: {
                                block22: {
                                    block21: {
                                        block19: {
                                            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                                            rsPsiTreeChangeEvent = event;
                                            if (!(rsPsiTreeChangeEvent instanceof RsPsiTreeChangeEvent.ChildRemoval.Before)) break block19;
                                            psiElement2 = ((RsPsiTreeChangeEvent.ChildRemoval.Before)event).getChild();
                                            break block20;
                                        }
                                        if (!(rsPsiTreeChangeEvent instanceof RsPsiTreeChangeEvent.ChildRemoval.After)) break block21;
                                        psiElement2 = ((RsPsiTreeChangeEvent.ChildRemoval.After)event).getParent();
                                        break block20;
                                    }
                                    if (!(rsPsiTreeChangeEvent instanceof RsPsiTreeChangeEvent.ChildReplacement.Before)) break block22;
                                    psiElement2 = ((RsPsiTreeChangeEvent.ChildReplacement.Before)event).getOldChild();
                                    break block20;
                                }
                                if (!(rsPsiTreeChangeEvent instanceof RsPsiTreeChangeEvent.ChildReplacement.After)) break block23;
                                psiElement2 = ((RsPsiTreeChangeEvent.ChildReplacement.After)event).getNewChild();
                                break block20;
                            }
                            if (!(rsPsiTreeChangeEvent instanceof RsPsiTreeChangeEvent.ChildAddition.After)) break block24;
                            psiElement2 = ((RsPsiTreeChangeEvent.ChildAddition.After)event).getChild();
                            break block20;
                        }
                        if (!(rsPsiTreeChangeEvent instanceof RsPsiTreeChangeEvent.ChildMovement.After)) break block25;
                        psiElement2 = ((RsPsiTreeChangeEvent.ChildMovement.After)event).getChild();
                        break block20;
                    }
                    if (!(rsPsiTreeChangeEvent instanceof RsPsiTreeChangeEvent.ChildrenChange.After)) break block26;
                    if (((RsPsiTreeChangeEvent.ChildrenChange.After)event).isGenericChange()) return;
                    psiElement2 = ((RsPsiTreeChangeEvent.ChildrenChange.After)event).getParent();
                    break block20;
                }
                if (!(rsPsiTreeChangeEvent instanceof RsPsiTreeChangeEvent.PropertyChange.After)) return;
                switch (((RsPsiTreeChangeEvent.PropertyChange.After)event).getPropertyName()) {
                    case "propFileTypes": 
                    case "propUnloadedPsi": {
                        RsPsiManagerImpl.this.incRustStructureModificationCount();
                        return;
                    }
                    case "writable": {
                        return;
                    }
                }
                psiElement2 = ((RsPsiTreeChangeEvent.PropertyChange.After)event).getElement();
                if (psiElement2 == null) {
                    return;
                }
            }
            PsiElement element = psiElement2;
            PsiFile file = event.getFile();
            if (file == null) {
                if (!(element instanceof RsFile) || RsPsiManager.Companion.isIgnorePsiEvents((PsiFile)element)) {
                    if (!(element instanceof PsiDirectory)) return;
                    CargoProjectsService cargoProjectsService = CargoProjectServiceKt.getCargoProjects(RsPsiManagerImpl.this.getProject());
                    VirtualFile virtualFile = ((PsiDirectory)element).getVirtualFile();
                    Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
                    if (cargoProjectsService.findPackageForFile(virtualFile) == null) return;
                }
                boolean bl = true;
                boolean isStructureModification = bl;
                if (!isStructureModification) return;
                PsiElement psiElement3 = element;
                PsiFile psiFile = (PsiFile)(psiElement3 instanceof RsFile ? (RsFile)psiElement3 : null);
                psiElement3 = element;
                RsPsiManagerImpl.this.incRustStructureModificationCount(psiFile, psiElement3 instanceof RsFile ? (RsFile)psiElement3 : null);
                return;
            } else {
                boolean isWhitespaceOrComment;
                if (!Intrinsics.areEqual((Object)file.getFileType(), (Object)((Object)RsFileType.INSTANCE))) {
                    return;
                }
                if (RsPsiManager.Companion.isIgnorePsiEvents(file)) {
                    return;
                }
                boolean bl = isWhitespaceOrComment = element instanceof PsiComment || element instanceof PsiWhiteSpace;
                if (isWhitespaceOrComment && !RsPsiManagerImpl.this.isMacroExpansionModeNew()) {
                    return;
                }
                boolean isChildrenChange = event instanceof RsPsiTreeChangeEvent.ChildrenChange || event instanceof RsPsiTreeChangeEvent.ChildRemoval.After;
                RsPsiManagerImpl.this.updateModificationCount(file, element, isChildrenChange, isWhitespaceOrComment);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lorg/rust/lang/core/psi/RsPsiManagerImpl$Helper;", "", "<init>", "()V", "hasStructureModification", "Lcom/intellij/openapi/util/Key;", "", "getHasStructureModification", "()Lcom/intellij/openapi/util/Key;", "intellij.rustrover.core"})
    public static final class Helper {
        @NotNull
        public static final Helper INSTANCE = new Helper();
        @NotNull
        private static final Key<Boolean> hasStructureModification;

        private Helper() {
        }

        @NotNull
        public final Key<Boolean> getHasStructureModification() {
            return hasStructureModification;
        }

        static {
            Key key = Key.create((String)"org.rust.lang.core.psi.RsPsiManagerImpl.HasStructureModification");
            Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
            hasStructureModification = key;
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RsModificationTrackerOwner.ModificationPropagationStrategy.values().length];
            try {
                nArray[RsModificationTrackerOwner.ModificationPropagationStrategy.PROPAGATE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RsModificationTrackerOwner.ModificationPropagationStrategy.CONSUMED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RsModificationTrackerOwner.ModificationPropagationStrategy.STRUCTURE_MODIFICATION.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

