/*
 * Decompiled with CFR 0.152.
 */
package org.rust.lang.core.psi;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopes;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.cargo.project.workspace.CargoWorkspace;
import org.rust.lang.core.crate.Crate;
import org.rust.lang.core.crate.impl.FakeCrate;
import org.rust.lang.core.macros.RsExpandedElementKt;
import org.rust.lang.core.psi.RsEnumVariant;
import org.rust.lang.core.psi.RsFile;
import org.rust.lang.core.psi.RsForeignModItem;
import org.rust.lang.core.psi.RsImplItem;
import org.rust.lang.core.psi.RsMacroCall;
import org.rust.lang.core.psi.RsPsiImplUtilKt;
import org.rust.lang.core.psi.RsTraitItem;
import org.rust.lang.core.psi.RsTraitRef;
import org.rust.lang.core.psi.ext.RsElement;
import org.rust.lang.core.psi.ext.RsEnumVariantKt;
import org.rust.lang.core.psi.ext.RsFieldDecl;
import org.rust.lang.core.psi.ext.RsFieldsOwner;
import org.rust.lang.core.psi.ext.RsGenericDeclaration;
import org.rust.lang.core.psi.ext.RsItemElement;
import org.rust.lang.core.psi.ext.RsMod;
import org.rust.lang.core.psi.ext.RsModKt;
import org.rust.lang.core.psi.ext.RsNamedElement;
import org.rust.lang.core.psi.ext.RsPossibleMacroCall;
import org.rust.lang.core.psi.ext.RsTraitRefKt;
import org.rust.lang.core.psi.ext.RsVisibility;
import org.rust.lang.core.psi.ext.RsVisibilityKt;
import org.rust.lang.core.psi.ext.RsVisible;
import org.rust.lang.core.resolve2.FacadeMetaInfoKt;
import org.rust.lang.core.resolve2.FacadeResolveKt;
import org.rust.lang.core.resolve2.ModData;
import org.rust.lang.core.resolve2.RsModInfo;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0006\u001a\u00020\rJ\u0010\u0010\u000e\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0006\u001a\u00020\u000fJ\u001a\u0010\u000e\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0006\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\"\u0010\u0012\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0006\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0014\u001a\u0004\u0018\u00010\f2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018\u00a8\u0006\u0019"}, d2={"Lorg/rust/lang/core/psi/RsPsiImplUtil;", "", "<init>", "()V", "crateRelativePath", "", "element", "Lorg/rust/lang/core/psi/ext/RsNamedElement;", "modCrateRelativePath", "mod", "Lorg/rust/lang/core/psi/ext/RsMod;", "getParameterUseScope", "Lcom/intellij/psi/search/SearchScope;", "Lorg/rust/lang/core/psi/ext/RsElement;", "getDeclarationUseScope", "Lorg/rust/lang/core/psi/ext/RsVisible;", "restrictedVis", "Lorg/rust/lang/core/psi/ext/RsVisibility;", "getTopLevelDeclarationUseScope", "containingMod", "getSubmodulesSearchScope", "localOrMacroSearchScope", "Lcom/intellij/psi/search/LocalSearchScope;", "scope", "Lcom/intellij/psi/PsiElement;", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nRsPsiImplUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RsPsiImplUtil.kt\norg/rust/lang/core/psi/RsPsiImplUtil\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 PsiElement.kt\norg/rust/lang/core/psi/ext/PsiElementKt\n*L\n1#1,143:1\n1563#2:144\n1634#2,3:145\n84#3:148\n84#3:149\n*S KotlinDebug\n*F\n+ 1 RsPsiImplUtil.kt\norg/rust/lang/core/psi/RsPsiImplUtil\n*L\n34#1:144\n34#1:145,3\n46#1:148\n65#1:149\n*E\n"})
public final class RsPsiImplUtil {
    @NotNull
    public static final RsPsiImplUtil INSTANCE = new RsPsiImplUtil();

    private RsPsiImplUtil() {
    }

    @Nullable
    public final String crateRelativePath(@NotNull RsNamedElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        String string = element.getName();
        if (string == null) {
            return null;
        }
        String name2 = string;
        String string2 = element.getContainingMod().getCrateRelativePath();
        if (string2 == null) {
            return null;
        }
        String qualifier = string2;
        return qualifier + "::" + name2;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final String modCrateRelativePath(@NotNull RsMod mod) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)mod, (String)"mod");
        Iterable $this$map$iv = CollectionsKt.drop((Iterable)CollectionsKt.asReversed(RsModKt.getSuperMods(mod)), (int)1);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            RsMod rsMod = (RsMod)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = it2.getModName();
            if (string == null) {
                return null;
            }
            collection.add(string);
        }
        List segments = (List)destination$iv$iv;
        if (segments.isEmpty()) {
            return "";
        }
        return "::" + CollectionsKt.joinToString$default((Iterable)segments, (CharSequence)"::", null, null, (int)0, null, null, (int)62, null);
    }

    @Nullable
    public final SearchScope getParameterUseScope(@NotNull RsElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiElement $this$contextStrict$iv = element;
        boolean $i$f$contextStrict = false;
        RsGenericDeclaration owner = (RsGenericDeclaration)PsiTreeUtil.getContextOfType((PsiElement)$this$contextStrict$iv, RsGenericDeclaration.class, (boolean)true);
        if (owner != null) {
            return (SearchScope)this.localOrMacroSearchScope(owner);
        }
        return null;
    }

    @Nullable
    public final SearchScope getDeclarationUseScope(@NotNull RsVisible element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return this.getDeclarationUseScope(element, RsVisibility.Public.INSTANCE);
    }

    private final SearchScope getDeclarationUseScope(RsVisible element, RsVisibility restrictedVis) {
        SearchScope searchScope;
        RsVisible rsVisible = element;
        if (rsVisible instanceof RsEnumVariant) {
            return this.getDeclarationUseScope(RsEnumVariantKt.getParentEnum((RsEnumVariant)element), restrictedVis);
        }
        if (rsVisible instanceof RsFieldDecl) {
            PsiElement $this$contextStrict$iv = element;
            boolean $i$f$contextStrict = false;
            PsiElement psiElement2 = PsiTreeUtil.getContextOfType((PsiElement)$this$contextStrict$iv, RsFieldsOwner.class, (boolean)true);
            Intrinsics.checkNotNull((Object)psiElement2, (String)"null cannot be cast to non-null type org.rust.lang.core.psi.ext.RsVisible");
            return this.getDeclarationUseScope((RsVisible)psiElement2, ((RsFieldDecl)element).getVisibility());
        }
        Class[] classArray = new Class[]{RsItemElement.class, RsMod.class};
        PsiElement $this$contextStrict$iv = PsiTreeUtil.getContextOfType((PsiElement)element, (boolean)true, (Class[])classArray);
        RsElement rsElement = $this$contextStrict$iv instanceof RsElement ? (RsElement)$this$contextStrict$iv : null;
        if (rsElement == null) {
            return null;
        }
        RsElement owner = rsElement;
        RsElement rsElement2 = owner;
        if (rsElement2 instanceof RsTraitItem) {
            searchScope = this.getDeclarationUseScope((RsVisible)owner);
        } else if (rsElement2 instanceof RsImplItem) {
            RsTraitRef traitRef;
            RsTraitRef rsTraitRef = traitRef = ((RsImplItem)owner).getTraitRef();
            if (rsTraitRef != null) {
                RsTraitItem rsTraitItem = RsTraitRefKt.resolveToTrait(rsTraitRef);
                if (rsTraitItem == null) {
                    return null;
                }
                return this.getDeclarationUseScope(rsTraitItem);
            }
            searchScope = this.getTopLevelDeclarationUseScope(element, owner.getContainingMod(), restrictedVis);
        } else {
            searchScope = rsElement2 instanceof RsMod ? this.getTopLevelDeclarationUseScope(element, (RsMod)owner, restrictedVis) : (rsElement2 instanceof RsForeignModItem ? this.getTopLevelDeclarationUseScope(element, owner.getContainingMod(), restrictedVis) : (SearchScope)this.localOrMacroSearchScope(owner));
        }
        return searchScope;
    }

    private final SearchScope getTopLevelDeclarationUseScope(RsVisible element, RsMod containingMod, RsVisibility restrictedVis) {
        RsMod rsMod;
        RsVisibility visibility = RsVisibilityKt.intersect(restrictedVis, element.getVisibility());
        if (Intrinsics.areEqual((Object)visibility, (Object)RsVisibility.Public.INSTANCE)) {
            Crate crate = containingMod.getContainingCrate();
            if (crate instanceof FakeCrate || crate.getKind() instanceof CargoWorkspace.TargetKind.Lib) {
                return null;
            }
            RsFile rsFile = crate.getRootMod();
            if (rsFile == null) {
                return null;
            }
            rsMod = rsFile;
        } else if (Intrinsics.areEqual((Object)visibility, (Object)RsVisibility.Private.INSTANCE)) {
            rsMod = containingMod;
        } else if (visibility instanceof RsVisibility.Restricted) {
            rsMod = ((RsVisibility.Restricted)visibility).getInMod();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        RsMod restrictedMod = rsMod;
        return this.getSubmodulesSearchScope(restrictedMod);
    }

    @Nullable
    public final SearchScope getSubmodulesSearchScope(@NotNull RsMod mod) {
        Intrinsics.checkNotNullParameter((Object)mod, (String)"mod");
        RsModInfo rsModInfo = FacadeResolveKt.getModInfo(mod);
        if (rsModInfo == null) {
            return null;
        }
        ModData modData = rsModInfo.component3();
        LocalSearchScope restrictedModScope = this.localOrMacroSearchScope(mod);
        if (!RsPsiImplUtilKt.access$hasChildFiles(modData)) {
            return (SearchScope)restrictedModScope;
        }
        VirtualFile virtualFile = FacadeMetaInfoKt.getDirectoryContainedAllChildFiles(modData);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile containedDirectory = virtualFile;
        GlobalSearchScope globalSearchScope = GlobalSearchScopes.directoryScope((Project)mod.getProject(), (VirtualFile)containedDirectory, (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"directoryScope(...)");
        GlobalSearchScope containedDirectoryScope = globalSearchScope;
        return (SearchScope)containedDirectoryScope.union(restrictedModScope);
    }

    @NotNull
    public final LocalSearchScope localOrMacroSearchScope(@NotNull PsiElement scope) {
        RsMacroCall macroCall;
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        RsPossibleMacroCall rsPossibleMacroCall = RsExpandedElementKt.findMacroCallExpandedFrom(scope);
        RsMacroCall rsMacroCall = macroCall = rsPossibleMacroCall instanceof RsMacroCall ? (RsMacroCall)rsPossibleMacroCall : null;
        return new LocalSearchScope(rsMacroCall != null ? (PsiElement)rsMacroCall : scope);
    }
}

