/*
 * Decompiled with CFR 0.152.
 */
package org.rust.lang.core.psi;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.tree.IElementType;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.lang.core.psi.LiteralOffsets;
import org.rust.lang.core.psi.RsElementTypes;
import org.rust.lang.core.psi.RsLitExpr;
import org.rust.lang.core.psi.RsLiteralKind;
import org.rust.lang.core.psi.RsTokenTypeKt;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u001a\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n\u001a\u000e\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u001a \u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\n2\b\b\u0002\u0010\u000f\u001a\u00020\u0010\u001a\u0018\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a\u0018\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a-\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00102\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00100\u0016H\u0082\b\"\u0017\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0017"}, d2={"kind", "Lorg/rust/lang/core/psi/RsLiteralKind;", "Lorg/rust/lang/core/psi/RsLitExpr;", "getKind", "(Lorg/rust/lang/core/psi/RsLitExpr;)Lorg/rust/lang/core/psi/RsLiteralKind;", "offsetsForNumber", "Lorg/rust/lang/core/psi/LiteralOffsets;", "node", "Lcom/intellij/lang/ASTNode;", "nodeText", "", "offsetsForText", "elementType", "Lcom/intellij/psi/tree/IElementType;", "text", "textLength", "", "offsetsForRawText", "locatePrefix", "doLocate", "start", "locator", "Lkotlin/Function1;", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nRsLiteralKind.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RsLiteralKind.kt\norg/rust/lang/core/psi/RsLiteralKindKt\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,250:1\n249#1:255\n249#1:256\n249#1:260\n249#1:261\n249#1:262\n249#1:268\n1188#2,3:251\n1188#2,3:257\n1188#2,2:263\n1069#2,2:265\n1190#2:267\n1188#2,3:269\n1#3:254\n*S KotlinDebug\n*F\n+ 1 RsLiteralKind.kt\norg/rust/lang/core/psi/RsLiteralKindKt\n*L\n175#1:255\n182#1:256\n195#1:260\n214#1:261\n219#1:262\n230#1:268\n147#1:251,3\n184#1:257,3\n220#1:263,2\n223#1:265,2\n220#1:267\n239#1:269,3\n*E\n"})
public final class RsLiteralKindKt {
    @Nullable
    public static final RsLiteralKind getKind(@NotNull RsLitExpr $this$kind) {
        Intrinsics.checkNotNullParameter((Object)$this$kind, (String)"<this>");
        ASTNode aSTNode = $this$kind.getNode().findChildByType(RsTokenTypeKt.getRS_LITERALS());
        if (aSTNode == null) {
            return null;
        }
        ASTNode literalAstNode = aSTNode;
        RsLiteralKind rsLiteralKind = RsLiteralKind.Companion.fromAstNode(literalAstNode);
        if (rsLiteralKind == null) {
            throw new IllegalStateException(("Unknown literal: " + literalAstNode + " (`" + $this$kind.getText() + "`)").toString());
        }
        return rsLiteralKind;
    }

    @NotNull
    public static final LiteralOffsets offsetsForNumber(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        String string = node.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return RsLiteralKindKt.offsetsForNumber(string);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final LiteralOffsets offsetsForNumber(@NotNull String nodeText) {
        void $this$forEachIndexed$iv;
        Intrinsics.checkNotNullParameter((Object)nodeText, (String)"nodeText");
        Pair pair = switch (StringsKt.take((String)nodeText, (int)2)) {
            case "0b" -> TuplesKt.to((Object)2, (Object)"01");
            case "0o" -> TuplesKt.to((Object)2, (Object)"012345678");
            case "0x" -> TuplesKt.to((Object)2, (Object)"0123456789abcdefABCDEF");
            default -> TuplesKt.to((Object)0, (Object)"0123456789");
        };
        int start2 = ((Number)pair.component1()).intValue();
        String digits = (String)pair.component2();
        boolean hasExponent = false;
        String string = nodeText.substring(start2);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        CharSequence charSequence = string;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (int j = 0; j < $this$forEachIndexed$iv.length(); ++j) {
            void ch;
            char item$iv = $this$forEachIndexed$iv.charAt(j);
            int n = index$iv++;
            char c = item$iv;
            int i2 = n;
            boolean bl = false;
            if (!hasExponent && StringsKt.contains$default((CharSequence)"eE", (char)ch, (boolean)false, (int)2, null)) {
                hasExponent = true;
                continue;
            }
            if (StringsKt.contains$default((CharSequence)digits, (char)ch, (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)"+-_.", (char)ch, (boolean)false, (int)2, null)) continue;
            return new LiteralOffsets(null, null, TextRange.create((int)0, (int)(i2 + start2)), null, new TextRange(i2 + start2, nodeText.length()), 11, null);
        }
        return new LiteralOffsets(null, null, TextRange.allOf((String)nodeText), null, null, 27, null);
    }

    @NotNull
    public static final LiteralOffsets offsetsForText(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        ASTNode $this$offsetsForText_u24lambda_u240 = node;
        boolean bl = false;
        IElementType iElementType = $this$offsetsForText_u24lambda_u240.getElementType();
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"getElementType(...)");
        String string = $this$offsetsForText_u24lambda_u240.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return RsLiteralKindKt.offsetsForText(iElementType, string, $this$offsetsForText_u24lambda_u240.getTextLength());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final LiteralOffsets offsetsForText(@NotNull IElementType elementType, @NotNull String text, int textLength) {
        int n;
        void textLength$iv;
        int n2;
        int start$iv;
        int openDelimEnd;
        int prefixEnd;
        char quote;
        block12: {
            void textLength$iv2;
            int n3;
            void textLength$iv3;
            Intrinsics.checkNotNullParameter((Object)elementType, (String)"elementType");
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            IElementType iElementType = elementType;
            if (Intrinsics.areEqual((Object)iElementType, (Object)RsElementTypes.RAW_STRING_LITERAL) || Intrinsics.areEqual((Object)iElementType, (Object)RsElementTypes.RAW_BYTE_STRING_LITERAL) || Intrinsics.areEqual((Object)iElementType, (Object)RsElementTypes.RAW_CSTRING_LITERAL)) {
                return RsLiteralKindKt.offsetsForRawText(text, textLength);
            }
            IElementType iElementType2 = elementType;
            quote = Intrinsics.areEqual((Object)iElementType2, (Object)RsElementTypes.BYTE_LITERAL) || Intrinsics.areEqual((Object)iElementType2, (Object)RsElementTypes.CHAR_LITERAL) ? (char)'\'' : '\"';
            prefixEnd = RsLiteralKindKt.locatePrefix(text, textLength);
            int n4 = textLength;
            int start$iv2 = prefixEnd;
            boolean $i$f$doLocate = false;
            if (start$iv2 >= textLength$iv3) {
                n3 = start$iv2;
            } else {
                boolean bl;
                int it2 = start$iv2;
                boolean bl2 = false;
                boolean bl3 = bl = text.charAt(it2) == quote;
                if (_Assertions.ENABLED && !bl) {
                    boolean $i$a$-assert-RsLiteralKindKt$offsetsForText$openDelimEnd$1$22 = false;
                    String $i$a$-assert-RsLiteralKindKt$offsetsForText$openDelimEnd$1$22 = "expected open delimiter `" + quote + "` but found `" + text.charAt(it2) + "` in node (" + elementType + ") with text " + text;
                    throw new AssertionError((Object)$i$a$-assert-RsLiteralKindKt$offsetsForText$openDelimEnd$1$22);
                }
                n3 = it2 + 1;
            }
            openDelimEnd = n3;
            start$iv2 = textLength;
            start$iv = openDelimEnd;
            boolean $i$f$doLocate2 = false;
            if (start$iv >= textLength$iv2) {
                n2 = start$iv;
            } else {
                void $this$forEachIndexed$iv;
                int start2 = start$iv;
                boolean bl = false;
                boolean escape = false;
                String string = text.substring(start2);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                CharSequence charSequence = string;
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                for (int j = 0; j < $this$forEachIndexed$iv.length(); ++j) {
                    void ch;
                    char item$iv = $this$forEachIndexed$iv.charAt(j);
                    int n5 = index$iv++;
                    char c = item$iv;
                    int i2 = n5;
                    boolean bl4 = false;
                    if (escape) {
                        escape = false;
                        continue;
                    }
                    void var21_27 = ch;
                    if (var21_27 == 92) {
                        escape = true;
                        continue;
                    }
                    if (var21_27 != quote) continue;
                    n2 = i2 + start2;
                    break block12;
                }
                n2 = textLength;
            }
        }
        int valueEnd = n2;
        start$iv = textLength;
        int start$iv3 = valueEnd;
        boolean $i$f$doLocate = false;
        if (start$iv3 >= textLength$iv) {
            n = start$iv3;
        } else {
            boolean bl;
            int it3 = start$iv3;
            boolean bl5 = false;
            boolean bl6 = bl = text.charAt(it3) == quote;
            if (_Assertions.ENABLED && !bl) {
                boolean bl7 = false;
                String string = "expected close delimiter `" + quote + "` but found `" + text.charAt(it3) + "`";
                throw new AssertionError((Object)string);
            }
            n = it3 + 1;
        }
        int closeDelimEnd = n;
        return LiteralOffsets.Companion.fromEndOffsets(prefixEnd, openDelimEnd, valueEnd, closeDelimEnd, textLength);
    }

    public static /* synthetic */ LiteralOffsets offsetsForText$default(IElementType iElementType, String string, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = string.length();
        }
        return RsLiteralKindKt.offsetsForText(iElementType, string, n);
    }

    /*
     * WARNING - void declaration
     */
    private static final LiteralOffsets offsetsForRawText(String text, int textLength) {
        int n;
        void textLength$iv;
        int n2;
        int start$iv;
        int openDelimEnd;
        int hashes;
        int prefixEnd;
        block12: {
            void textLength$iv2;
            int n3;
            void textLength$iv3;
            int pos;
            prefixEnd = RsLiteralKindKt.locatePrefix(text, textLength);
            boolean bl = false;
            for (pos = prefixEnd; pos < textLength && text.charAt(pos) == '#'; ++pos) {
            }
            hashes = pos - prefixEnd;
            pos = textLength;
            int start$iv2 = prefixEnd;
            boolean $i$f$doLocate = false;
            if (start$iv2 >= textLength$iv3) {
                n3 = start$iv2;
            } else {
                boolean bl2;
                int it2 = start$iv2;
                boolean bl3 = false;
                boolean bl4 = bl2 = textLength - it2 >= 1 + hashes && text.charAt(it2) == '#' || text.charAt(it2) == '\"';
                if (_Assertions.ENABLED && !bl2) {
                    boolean $i$a$-assert-RsLiteralKindKt$offsetsForRawText$openDelimEnd$1$22 = false;
                    String $i$a$-assert-RsLiteralKindKt$offsetsForRawText$openDelimEnd$1$22 = "expected open delim";
                    throw new AssertionError((Object)$i$a$-assert-RsLiteralKindKt$offsetsForRawText$openDelimEnd$1$22);
                }
                n3 = it2 + 1 + hashes;
            }
            openDelimEnd = n3;
            start$iv2 = textLength;
            start$iv = openDelimEnd;
            boolean $i$f$doLocate2 = false;
            if (start$iv >= textLength$iv2) {
                n2 = start$iv;
            } else {
                void $this$forEachIndexed$iv;
                int start2 = start$iv;
                boolean bl5 = false;
                String string = text.substring(start2);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                CharSequence $i$a$-assert-RsLiteralKindKt$offsetsForRawText$openDelimEnd$1$22 = string;
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                for (int j = 0; j < $this$forEachIndexed$iv.length(); ++j) {
                    boolean bl6;
                    int i2;
                    block11: {
                        void ch;
                        char item$iv = $this$forEachIndexed$iv.charAt(j);
                        int n4 = index$iv++;
                        char c = item$iv;
                        i2 = n4;
                        boolean bl7 = false;
                        if (start2 + i2 + hashes >= textLength || ch != 34) continue;
                        CharSequence $this$all$iv = text.subSequence(start2 + i2 + 1, start2 + i2 + 1 + hashes);
                        boolean $i$f$all = false;
                        for (int k = 0; k < $this$all$iv.length(); ++k) {
                            char element$iv;
                            char it3 = element$iv = $this$all$iv.charAt(k);
                            boolean bl8 = false;
                            if (it3 == '#') continue;
                            bl6 = false;
                            break block11;
                        }
                        bl6 = true;
                    }
                    if (!bl6) continue;
                    n2 = i2 + start2;
                    break block12;
                }
                n2 = textLength;
            }
        }
        int valueEnd = n2;
        start$iv = textLength;
        int start$iv3 = valueEnd;
        boolean $i$f$doLocate = false;
        if (start$iv3 >= textLength$iv) {
            n = start$iv3;
        } else {
            boolean bl;
            int it4 = start$iv3;
            boolean bl9 = false;
            boolean bl10 = bl = textLength - it4 >= 1 + hashes && text.charAt(it4) == '\"';
            if (_Assertions.ENABLED && !bl) {
                boolean bl11 = false;
                String string = "expected close delim";
                throw new AssertionError((Object)string);
            }
            n = it4 + 1 + hashes;
        }
        int closeDelimEnd = n;
        return LiteralOffsets.Companion.fromEndOffsets(prefixEnd, openDelimEnd, valueEnd, closeDelimEnd, textLength);
    }

    /*
     * WARNING - void declaration
     */
    private static final int locatePrefix(String text, int textLength) {
        CharSequence $this$forEachIndexed$iv = text;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (int j = 0; j < $this$forEachIndexed$iv.length(); ++j) {
            void ch;
            char item$iv = $this$forEachIndexed$iv.charAt(j);
            int n = index$iv++;
            char c = item$iv;
            int i2 = n;
            boolean bl = false;
            if (Character.isLetter((char)ch)) continue;
            return i2;
        }
        return textLength;
    }

    private static final int doLocate(int textLength, int start2, Function1<? super Integer, Integer> locator) {
        boolean $i$f$doLocate = false;
        return start2 >= textLength ? start2 : ((Number)locator.invoke((Object)start2)).intValue();
    }
}

