/*
 * Decompiled with CFR 0.152.
 */
package org.rust.lang.core.psi;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiBuilderFactory;
import com.intellij.openapi.project.Project;
import com.intellij.psi.impl.source.tree.ICodeFragmentElementType;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.tree.IElementType;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.lang.RsLanguage;
import org.rust.lang.core.parser.RustParser;
import org.rust.lang.core.psi.RsElementTypes;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/rust/lang/core/psi/RsCodeFragmentElementType;", "Lcom/intellij/psi/impl/source/tree/ICodeFragmentElementType;", "elementType", "Lcom/intellij/psi/tree/IElementType;", "debugName", "", "<init>", "(Lcom/intellij/psi/tree/IElementType;Ljava/lang/String;)V", "parseContents", "Lcom/intellij/lang/ASTNode;", "chameleon", "Companion", "intellij.rustrover.core"})
public final class RsCodeFragmentElementType
extends ICodeFragmentElementType {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IElementType elementType;
    @NotNull
    private static final RsCodeFragmentElementType EXPR;
    @NotNull
    private static final RsCodeFragmentElementType STMT;
    @NotNull
    private static final RsCodeFragmentElementType TYPE_REF;
    @NotNull
    private static final RsCodeFragmentElementType TYPE_PATH;
    @NotNull
    private static final RsCodeFragmentElementType VALUE_PATH;
    @NotNull
    private static final RsCodeFragmentElementType REPL;

    public RsCodeFragmentElementType(@NotNull IElementType elementType, @NotNull String debugName) {
        Intrinsics.checkNotNullParameter((Object)elementType, (String)"elementType");
        Intrinsics.checkNotNullParameter((Object)debugName, (String)"debugName");
        super(debugName, (Language)RsLanguage.INSTANCE);
        this.elementType = elementType;
    }

    @Nullable
    public ASTNode parseContents(@NotNull ASTNode chameleon) {
        Intrinsics.checkNotNullParameter((Object)chameleon, (String)"chameleon");
        if (!(chameleon instanceof TreeElement)) {
            return null;
        }
        Project project = ((TreeElement)chameleon).getManager().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        PsiBuilder psiBuilder = PsiBuilderFactory.getInstance().createBuilder(project2, chameleon);
        Intrinsics.checkNotNullExpressionValue((Object)psiBuilder, (String)"createBuilder(...)");
        PsiBuilder builder = psiBuilder;
        ASTNode aSTNode = new RustParser().parse(this.elementType, builder);
        Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"parse(...)");
        ASTNode root = aSTNode;
        return root.getFirstChildNode();
    }

    static {
        IElementType iElementType = RsElementTypes.EXPRESSION_CODE_FRAGMENT_ELEMENT;
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"EXPRESSION_CODE_FRAGMENT_ELEMENT");
        EXPR = new RsCodeFragmentElementType(iElementType, "RS_EXPR_CODE_FRAGMENT");
        IElementType iElementType2 = RsElementTypes.STATEMENT_CODE_FRAGMENT_ELEMENT;
        Intrinsics.checkNotNullExpressionValue((Object)iElementType2, (String)"STATEMENT_CODE_FRAGMENT_ELEMENT");
        STMT = new RsCodeFragmentElementType(iElementType2, "RS_STMT_CODE_FRAGMENT");
        IElementType iElementType3 = RsElementTypes.TYPE_REFERENCE_CODE_FRAGMENT_ELEMENT;
        Intrinsics.checkNotNullExpressionValue((Object)iElementType3, (String)"TYPE_REFERENCE_CODE_FRAGMENT_ELEMENT");
        TYPE_REF = new RsCodeFragmentElementType(iElementType3, "RS_TYPE_REF_CODE_FRAGMENT");
        IElementType iElementType4 = RsElementTypes.TYPE_PATH_CODE_FRAGMENT_ELEMENT;
        Intrinsics.checkNotNullExpressionValue((Object)iElementType4, (String)"TYPE_PATH_CODE_FRAGMENT_ELEMENT");
        TYPE_PATH = new RsCodeFragmentElementType(iElementType4, "RS_TYPE_PATH_CODE_FRAGMENT");
        IElementType iElementType5 = RsElementTypes.VALUE_PATH_CODE_FRAGMENT_ELEMENT;
        Intrinsics.checkNotNullExpressionValue((Object)iElementType5, (String)"VALUE_PATH_CODE_FRAGMENT_ELEMENT");
        VALUE_PATH = new RsCodeFragmentElementType(iElementType5, "RS_VALUE_PATH_CODE_FRAGMENT");
        IElementType iElementType6 = RsElementTypes.REPL_CODE_FRAGMENT_ELEMENT;
        Intrinsics.checkNotNullExpressionValue((Object)iElementType6, (String)"REPL_CODE_FRAGMENT_ELEMENT");
        REPL = new RsCodeFragmentElementType(iElementType6, "RS_REPL_CODE_FRAGMENT");
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007R\u0011\u0010\f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0007R\u0011\u0010\u000e\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0007R\u0011\u0010\u0010\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lorg/rust/lang/core/psi/RsCodeFragmentElementType$Companion;", "", "<init>", "()V", "EXPR", "Lorg/rust/lang/core/psi/RsCodeFragmentElementType;", "getEXPR", "()Lorg/rust/lang/core/psi/RsCodeFragmentElementType;", "STMT", "getSTMT", "TYPE_REF", "getTYPE_REF", "TYPE_PATH", "getTYPE_PATH", "VALUE_PATH", "getVALUE_PATH", "REPL", "getREPL", "intellij.rustrover.core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final RsCodeFragmentElementType getEXPR() {
            return EXPR;
        }

        @NotNull
        public final RsCodeFragmentElementType getSTMT() {
            return STMT;
        }

        @NotNull
        public final RsCodeFragmentElementType getTYPE_REF() {
            return TYPE_REF;
        }

        @NotNull
        public final RsCodeFragmentElementType getTYPE_PATH() {
            return TYPE_PATH;
        }

        @NotNull
        public final RsCodeFragmentElementType getVALUE_PATH() {
            return VALUE_PATH;
        }

        @NotNull
        public final RsCodeFragmentElementType getREPL() {
            return REPL;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

