/*
 * Decompiled with CFR 0.152.
 */
package org.rust.lang.core.parser;

import com.intellij.lang.ASTNode;
import com.intellij.lang.LanguageUtil;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiParser;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.TokenSet;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.ide.console.RsConsoleCodeFragmentContext;
import org.rust.lang.RsDebugInjectionListener;
import org.rust.lang.core.lexer.RsLexer;
import org.rust.lang.core.parser.RustParser;
import org.rust.lang.core.parser.RustParserUtil;
import org.rust.lang.core.psi.RsBlock;
import org.rust.lang.core.psi.RsDebuggerExpressionCodeFragment;
import org.rust.lang.core.psi.RsElementTypesFactory;
import org.rust.lang.core.psi.RsFile;
import org.rust.lang.core.psi.RsImportsMockFile;
import org.rust.lang.core.psi.RsReplCodeFragment;
import org.rust.lang.core.psi.RsTokenTypeKt;
import org.rust.lang.core.psi.ext.RsElement;
import org.rust.lang.core.stubs.RsFileStub;
import org.rust.lang.core.stubs.RsPathStub;
import org.rust.lang.doc.psi.ext.IElementTypeKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0014\u001a\u00020\u0012H\u0016J\u0012\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\rH\u0016J\u0012\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0016J\u0012\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0016\u00a8\u0006\u001f"}, d2={"Lorg/rust/lang/core/parser/RustParserDefinition;", "Lcom/intellij/lang/ParserDefinition;", "<init>", "()V", "createFile", "Lcom/intellij/psi/PsiFile;", "viewProvider", "Lcom/intellij/psi/FileViewProvider;", "createRsFile", "Lorg/rust/lang/core/psi/RsFile;", "spaceExistenceTypeBetweenTokens", "Lcom/intellij/lang/ParserDefinition$SpaceRequirements;", "left", "Lcom/intellij/lang/ASTNode;", "right", "getFileNodeType", "Lcom/intellij/psi/tree/IFileElementType;", "getStringLiteralElements", "Lcom/intellij/psi/tree/TokenSet;", "getWhitespaceTokens", "getCommentTokens", "createElement", "Lcom/intellij/psi/PsiElement;", "node", "createLexer", "Lcom/intellij/lexer/Lexer;", "project", "Lcom/intellij/openapi/project/Project;", "createParser", "Lcom/intellij/lang/PsiParser;", "Companion", "intellij.rustrover.core"})
public class RustParserDefinition
implements ParserDefinition {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final int LEXER_VERSION = 7;
    public static final int PARSER_VERSION = 90;

    @NotNull
    public PsiFile createFile(@NotNull FileViewProvider viewProvider) {
        Intrinsics.checkNotNullParameter((Object)viewProvider, (String)"viewProvider");
        Function0 function0 = () -> RustParserDefinition.createFile$lambda$0(this, viewProvider);
        Project project = viewProvider.getManager().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        PsiLanguageInjectionHost injectionHost = InjectedLanguageManager.getInstance((Project)project2).getInjectionHost(viewProvider);
        if (injectionHost != null) {
            if (!Intrinsics.areEqual((Object)injectionHost.getClass().getSimpleName(), (Object)"GDBExpressionPlaceholder")) {
                return (PsiFile)function0.invoke();
            }
            RsDebugInjectionListener injectionListener = (RsDebugInjectionListener)project2.getMessageBus().syncPublisher(RsDebugInjectionListener.INJECTION_TOPIC);
            RsDebugInjectionListener.DebugContext contextResult = new RsDebugInjectionListener.DebugContext(null, 1, null);
            injectionListener.evalDebugContext(injectionHost, contextResult);
            RsElement rsElement = contextResult.getElement();
            if (rsElement == null) {
                return (PsiFile)function0.invoke();
            }
            RsElement context = rsElement;
            RsDebuggerExpressionCodeFragment fragment = new RsDebuggerExpressionCodeFragment(viewProvider, context);
            injectionListener.didInject(injectionHost);
            return (PsiFile)fragment;
        }
        if (Intrinsics.areEqual((Object)viewProvider.getVirtualFile().getName(), (Object)"IntellijRustRepl.rs")) {
            RsBlock context = RsConsoleCodeFragmentContext.Companion.createContext$default(RsConsoleCodeFragmentContext.Companion, project2, null, null, 4, null);
            return (PsiFile)new RsReplCodeFragment(viewProvider, context);
        }
        if (Intrinsics.areEqual((Object)viewProvider.getVirtualFile().getName(), (Object)"IntellijRustImportsMock.rs")) {
            return (PsiFile)new RsImportsMockFile(viewProvider);
        }
        return (PsiFile)function0.invoke();
    }

    @NotNull
    protected RsFile createRsFile(@NotNull FileViewProvider viewProvider) {
        Intrinsics.checkNotNullParameter((Object)viewProvider, (String)"viewProvider");
        return new RsFile(viewProvider, null, 2, null);
    }

    @NotNull
    public ParserDefinition.SpaceRequirements spaceExistenceTypeBetweenTokens(@NotNull ASTNode left, @NotNull ASTNode right) {
        Intrinsics.checkNotNullParameter((Object)left, (String)"left");
        Intrinsics.checkNotNullParameter((Object)right, (String)"right");
        IElementType iElementType = left.getElementType();
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"getElementType(...)");
        IElementType leftElementType = iElementType;
        if (Intrinsics.areEqual((Object)leftElementType, (Object)((Object)RustParserUtil.Helper.EOL_COMMENT))) {
            return ParserDefinition.SpaceRequirements.MUST_LINE_BREAK;
        }
        IElementType iElementType2 = right.getElementType();
        Intrinsics.checkNotNullExpressionValue((Object)iElementType2, (String)"getElementType(...)");
        IElementType rightElementType = iElementType2;
        if (IElementTypeKt.isDocCommentLeafToken(leftElementType)) {
            ParserDefinition.SpaceRequirements spaceRequirements;
            if (IElementTypeKt.isDocCommentLeafToken(rightElementType)) {
                spaceRequirements = ParserDefinition.SpaceRequirements.MAY;
            } else {
                ASTNode aSTNode = right.getTreeParent();
                spaceRequirements = Intrinsics.areEqual((Object)(aSTNode != null ? aSTNode.getElementType() : null), (Object)((Object)RsPathStub.Type.INSTANCE)) ? ParserDefinition.SpaceRequirements.MAY : ParserDefinition.SpaceRequirements.MUST_LINE_BREAK;
            }
            return spaceRequirements;
        }
        if (IElementTypeKt.isDocCommentLeafToken(rightElementType)) {
            ASTNode aSTNode = left.getTreeParent();
            if (Intrinsics.areEqual((Object)(aSTNode != null ? aSTNode.getElementType() : null), (Object)((Object)RsPathStub.Type.INSTANCE))) {
                return ParserDefinition.SpaceRequirements.MAY;
            }
        }
        ParserDefinition.SpaceRequirements spaceRequirements = LanguageUtil.canStickTokensTogetherByLexer((ASTNode)left, (ASTNode)right, (Lexer)((Lexer)new RsLexer()));
        Intrinsics.checkNotNullExpressionValue((Object)spaceRequirements, (String)"canStickTokensTogetherByLexer(...)");
        return spaceRequirements;
    }

    @NotNull
    public IFileElementType getFileNodeType() {
        return (IFileElementType)RsFileStub.Type.INSTANCE;
    }

    @NotNull
    public TokenSet getStringLiteralElements() {
        return RsTokenTypeKt.getRS_ALL_STRING_LITERALS();
    }

    @NotNull
    public TokenSet getWhitespaceTokens() {
        IElementType[] iElementTypeArray = new IElementType[]{TokenType.WHITE_SPACE};
        TokenSet tokenSet = TokenSet.create((IElementType[])iElementTypeArray);
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"create(...)");
        return tokenSet;
    }

    @NotNull
    public TokenSet getCommentTokens() {
        return RsTokenTypeKt.getRS_COMMENTS();
    }

    @NotNull
    public PsiElement createElement(@Nullable ASTNode node) {
        PsiElement psiElement2 = RsElementTypesFactory.createElement(node);
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"createElement(...)");
        return psiElement2;
    }

    @NotNull
    public Lexer createLexer(@Nullable Project project) {
        return (Lexer)new RsLexer();
    }

    @NotNull
    public PsiParser createParser(@Nullable Project project) {
        return new RustParser();
    }

    private static final RsFile createFile$lambda$0(RustParserDefinition this$0, FileViewProvider $viewProvider) {
        return this$0.createRsFile($viewProvider);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/rust/lang/core/parser/RustParserDefinition$Companion;", "", "<init>", "()V", "LEXER_VERSION", "", "PARSER_VERSION", "intellij.rustrover.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

