/*
 * Decompiled with CFR 0.152.
 */
package org.rust.lang.core.mir.schemas.impls;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.lang.core.mir.MirBuildErrorReason;
import org.rust.lang.core.mir.MirBuildException;
import org.rust.lang.core.mir.MirBuildParameters;
import org.rust.lang.core.mir.schemas.MirAssertKind;
import org.rust.lang.core.mir.schemas.MirBasicBlock;
import org.rust.lang.core.mir.schemas.MirConstant;
import org.rust.lang.core.mir.schemas.MirLocal;
import org.rust.lang.core.mir.schemas.MirOperand;
import org.rust.lang.core.mir.schemas.MirPlace;
import org.rust.lang.core.mir.schemas.MirRvalue;
import org.rust.lang.core.mir.schemas.MirSourceInfo;
import org.rust.lang.core.mir.schemas.MirStatement;
import org.rust.lang.core.mir.schemas.MirSwitchTargets;
import org.rust.lang.core.mir.schemas.MirTerminator;
import org.rust.lang.core.mir.schemas.UnwindAction;
import org.rust.lang.core.mir.schemas.impls.MirSwitchTargetsImpl;
import org.rust.lang.core.psi.RsFunction;
import org.rust.lang.core.types.RsCallable;
import org.rust.lang.core.types.ty.Ty;
import org.rust.lang.core.types.ty.TyFnDef;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00000\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001aJ\u001e\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u001d\u001a\u00020\u001aJ\u001e\u0010#\u001a\u00020\u00002\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010$\u001a\u00020%2\u0006\u0010\u001d\u001a\u00020\u001aJ\u0016\u0010&\u001a\u00020\u00002\u0006\u0010'\u001a\u00020(2\u0006\u0010\u001d\u001a\u00020\u001aJ\u0016\u0010)\u001a\u00020\u00002\u0006\u0010'\u001a\u00020(2\u0006\u0010\u001d\u001a\u00020\u001aJ\u001e\u0010*\u001a\u00020\u00002\u0006\u0010+\u001a\u00020,2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u001d\u001a\u00020\u001aJ\u0016\u0010-\u001a\u00020\u00002\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010.\u001a\u00020\u001aJ\u0016\u0010/\u001a\u00020\u00002\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u001d\u001a\u00020\u001aJ\u0016\u00100\u001a\u00020\u00002\u0006\u00101\u001a\u00020 2\u0006\u0010\u001d\u001a\u00020\u001aJ\u000e\u00102\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u001aJ\u0010\u00103\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001aJ0\u00104\u001a\u00020\u001c2\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u00020\u00052\u0006\u00108\u001a\u00020\u00002\b\u0010\u001d\u001a\u0004\u0018\u00010\u001a2\u0006\u00109\u001a\u00020:J\u0018\u0010;\u001a\u00020\u001c2\u0006\u0010<\u001a\u00020\u00002\b\u0010\u001d\u001a\u0004\u0018\u00010\u001aJ&\u0010=\u001a\u00020\u001c2\u0006\u0010>\u001a\u0002062\f\u0010?\u001a\b\u0012\u0004\u0012\u00020\u00000@2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001aJ(\u0010A\u001a\u00020\u001c2\u0006\u00105\u001a\u0002062\u0006\u0010B\u001a\u00020\u00002\u0006\u0010C\u001a\u00020\u00002\b\u0010\u001d\u001a\u0004\u0018\u00010\u001aJ\"\u0010D\u001a\u00020\u001c2\u0006\u0010E\u001a\u00020\u00002\b\u0010\u0004\u001a\u0004\u0018\u00010\u00002\b\u0010\u001d\u001a\u0004\u0018\u00010\u001aJ\"\u0010F\u001a\u00020\u001c2\u0006\u0010E\u001a\u00020\u00002\b\u0010G\u001a\u0004\u0018\u00010\u00002\b\u0010\u001d\u001a\u0004\u0018\u00010\u001aJ\u0010\u0010H\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001aJ\u0010\u0010I\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001aJJ\u0010J\u001a\u00020\u001c2\u0006\u0010K\u001a\u0002062\f\u0010L\u001a\b\u0012\u0004\u0012\u0002060M2\u0006\u0010N\u001a\u00020 2\b\u0010<\u001a\u0004\u0018\u00010\u00002\b\u0010\u0004\u001a\u0004\u0018\u00010\u00002\u0006\u0010O\u001a\u00020\u00052\b\u0010\u001d\u001a\u0004\u0018\u00010\u001aJ\u000e\u0010P\u001a\u0004\u0018\u00010Q*\u00020RH\u0002J.\u0010S\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010<\u001a\u00020\u00002\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00000T2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001aJ\u0012\u0010U\u001a\u00020\u001a2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001aH\u0002J\u0010\u0010V\u001a\u00020\u00002\u0006\u0010W\u001a\u00020\bH\u0002J\u000e\u0010X\u001a\u00020\u001c2\u0006\u00108\u001a\u00020\u0000JD\u0010Y\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00000\n2\b\b\u0002\u0010\u000b\u001a\u00020\fJ\b\u0010Z\u001a\u00020[H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R \u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00000\nX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\\"}, d2={"Lorg/rust/lang/core/mir/schemas/impls/MirBasicBlockImpl;", "Lorg/rust/lang/core/mir/schemas/MirBasicBlock;", "index", "", "unwind", "", "statements", "", "Lorg/rust/lang/core/mir/schemas/MirStatement;", "terminator", "Lorg/rust/lang/core/mir/schemas/MirTerminator;", "buildParameters", "Lorg/rust/lang/core/mir/MirBuildParameters;", "<init>", "(IZLjava/util/List;Lorg/rust/lang/core/mir/schemas/MirTerminator;Lorg/rust/lang/core/mir/MirBuildParameters;)V", "getIndex", "()I", "getUnwind", "()Z", "getStatements", "()Ljava/util/List;", "getTerminator", "()Lorg/rust/lang/core/mir/schemas/MirTerminator;", "setTerminator", "(Lorg/rust/lang/core/mir/schemas/MirTerminator;)V", "terminatorSource", "Lorg/rust/lang/core/mir/schemas/MirSourceInfo;", "setTerminatorSource", "", "source", "pushAssign", "place", "Lorg/rust/lang/core/mir/schemas/MirPlace;", "rvalue", "Lorg/rust/lang/core/mir/schemas/MirRvalue;", "pushAssignConstant", "constant", "Lorg/rust/lang/core/mir/schemas/MirConstant;", "pushStorageLive", "local", "Lorg/rust/lang/core/mir/schemas/MirLocal;", "pushStorageDead", "pushFakeRead", "cause", "Lorg/rust/lang/core/mir/schemas/MirStatement$FakeRead$Cause;", "pushPlaceMention", "sourceInfo", "pushDrop", "pushUncontrolled", "places", "pushUncontrolledAll", "terminateWithReturn", "terminateWithAssert", "cond", "Lorg/rust/lang/core/mir/schemas/MirOperand;", "expected", "block", "msg", "Lorg/rust/lang/core/mir/schemas/MirAssertKind;", "terminateWithGoto", "target", "terminateWithSwitchInt", "discriminant", "targets", "Lorg/rust/lang/core/mir/schemas/MirSwitchTargets;", "terminateWithIf", "thenBlock", "elseBlock", "terminateWithFalseUnwind", "realTarget", "terminateWithFalseEdges", "imaginaryTarget", "terminateWithUnreachable", "terminateWithResume", "terminateWithCall", "callee", "args", "", "destination", "fromCall", "getResolvedFunction", "Lorg/rust/lang/core/psi/RsFunction;", "Lorg/rust/lang/core/types/ty/Ty;", "terminateWithDrop", "Lorg/rust/lang/core/mir/schemas/UnwindAction;", "getTerminatorSource", "push", "statement", "unwindTerminatorTo", "copy", "toString", "", "intellij.rustrover.core"})
public final class MirBasicBlockImpl
implements MirBasicBlock {
    private final int index;
    private final boolean unwind;
    @NotNull
    private final List<MirStatement> statements;
    @NotNull
    private MirTerminator<MirBasicBlockImpl> terminator;
    @NotNull
    private final MirBuildParameters buildParameters;
    @Nullable
    private MirSourceInfo terminatorSource;

    public MirBasicBlockImpl(int index, boolean unwind, @NotNull List<MirStatement> statements, @NotNull MirTerminator<MirBasicBlockImpl> terminator, @NotNull MirBuildParameters buildParameters) {
        Intrinsics.checkNotNullParameter(statements, (String)"statements");
        Intrinsics.checkNotNullParameter(terminator, (String)"terminator");
        Intrinsics.checkNotNullParameter((Object)buildParameters, (String)"buildParameters");
        this.index = index;
        this.unwind = unwind;
        this.statements = statements;
        this.terminator = terminator;
        this.buildParameters = buildParameters;
    }

    public /* synthetic */ MirBasicBlockImpl(int n, boolean bl, List list, MirTerminator mirTerminator, MirBuildParameters mirBuildParameters, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            list = new ArrayList();
        }
        if ((n2 & 8) != 0) {
            mirTerminator = MirTerminator.Companion.getDummy();
        }
        this(n, bl, list, mirTerminator, mirBuildParameters);
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public boolean getUnwind() {
        return this.unwind;
    }

    @Override
    @NotNull
    public List<MirStatement> getStatements() {
        return this.statements;
    }

    @NotNull
    public MirTerminator<MirBasicBlockImpl> getTerminator() {
        return this.terminator;
    }

    public void setTerminator(@NotNull MirTerminator<MirBasicBlockImpl> mirTerminator) {
        Intrinsics.checkNotNullParameter(mirTerminator, (String)"<set-?>");
        this.terminator = mirTerminator;
    }

    public final void setTerminatorSource(@NotNull MirSourceInfo source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        this.terminatorSource = source;
    }

    @NotNull
    public final MirBasicBlockImpl pushAssign(@NotNull MirPlace place, @NotNull MirRvalue rvalue, @NotNull MirSourceInfo source) {
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        Intrinsics.checkNotNullParameter((Object)rvalue, (String)"rvalue");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        return this.push(new MirStatement.Assign(place, rvalue, source));
    }

    @NotNull
    public final MirBasicBlockImpl pushAssignConstant(@NotNull MirPlace place, @NotNull MirConstant constant, @NotNull MirSourceInfo source) {
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        Intrinsics.checkNotNullParameter((Object)constant, (String)"constant");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        return this.pushAssign(place, new MirRvalue.Use(new MirOperand.Constant(constant)), source);
    }

    @NotNull
    public final MirBasicBlockImpl pushStorageLive(@NotNull MirLocal local, @NotNull MirSourceInfo source) {
        Intrinsics.checkNotNullParameter((Object)local, (String)"local");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        return this.push(new MirStatement.StorageLive(local, source));
    }

    @NotNull
    public final MirBasicBlockImpl pushStorageDead(@NotNull MirLocal local, @NotNull MirSourceInfo source) {
        Intrinsics.checkNotNullParameter((Object)local, (String)"local");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        return this.push(new MirStatement.StorageDead(local, source));
    }

    @NotNull
    public final MirBasicBlockImpl pushFakeRead(@NotNull MirStatement.FakeRead.Cause cause, @NotNull MirPlace place, @NotNull MirSourceInfo source) {
        Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        return this.push(new MirStatement.FakeRead(cause, place, source));
    }

    @NotNull
    public final MirBasicBlockImpl pushPlaceMention(@NotNull MirPlace place, @NotNull MirSourceInfo sourceInfo) {
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        Intrinsics.checkNotNullParameter((Object)sourceInfo, (String)"sourceInfo");
        return this.push(new MirStatement.PlaceMention(place, sourceInfo));
    }

    @NotNull
    public final MirBasicBlockImpl pushDrop(@NotNull MirPlace place, @NotNull MirSourceInfo source) {
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        return this.push(new MirStatement.Drop(place, source));
    }

    @NotNull
    public final MirBasicBlockImpl pushUncontrolled(@NotNull MirPlace places, @NotNull MirSourceInfo source) {
        Intrinsics.checkNotNullParameter((Object)places, (String)"places");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        return this.push(new MirStatement.Uncontrolled(places, source));
    }

    @NotNull
    public final MirBasicBlockImpl pushUncontrolledAll(@NotNull MirSourceInfo source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        return this.push(new MirStatement.UncontrolledAll(source));
    }

    public final void terminateWithReturn(@Nullable MirSourceInfo source) {
        this.setTerminator(new MirTerminator.Return(this.getTerminatorSource(source)));
    }

    public final void terminateWithAssert(@NotNull MirOperand cond, boolean expected, @NotNull MirBasicBlockImpl block, @Nullable MirSourceInfo source, @NotNull MirAssertKind msg) {
        Intrinsics.checkNotNullParameter((Object)cond, (String)"cond");
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        this.setTerminator((MirTerminator<MirBasicBlockImpl>)new MirTerminator.Assert<Object>(cond, expected, block, msg, null, this.getTerminatorSource(source)));
    }

    public final void terminateWithGoto(@NotNull MirBasicBlockImpl target, @Nullable MirSourceInfo source) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        this.setTerminator((MirTerminator<MirBasicBlockImpl>)new MirTerminator.Goto<MirBasicBlock>(target, this.getTerminatorSource(source)));
    }

    public final void terminateWithSwitchInt(@NotNull MirOperand discriminant, @NotNull MirSwitchTargets<MirBasicBlockImpl> targets, @Nullable MirSourceInfo source) {
        Intrinsics.checkNotNullParameter((Object)discriminant, (String)"discriminant");
        Intrinsics.checkNotNullParameter(targets, (String)"targets");
        this.setTerminator((MirTerminator<MirBasicBlockImpl>)new MirTerminator.SwitchInt<MirBasicBlockImpl>(discriminant, targets, this.getTerminatorSource(source)));
    }

    public final void terminateWithIf(@NotNull MirOperand cond, @NotNull MirBasicBlockImpl thenBlock, @NotNull MirBasicBlockImpl elseBlock, @Nullable MirSourceInfo source) {
        Intrinsics.checkNotNullParameter((Object)cond, (String)"cond");
        Intrinsics.checkNotNullParameter((Object)thenBlock, (String)"thenBlock");
        Intrinsics.checkNotNullParameter((Object)elseBlock, (String)"elseBlock");
        MirSwitchTargetsImpl<MirBasicBlock> targets = MirSwitchTargetsImpl.Companion.if(0L, (MirBasicBlock)elseBlock, (MirBasicBlock)thenBlock);
        this.terminateWithSwitchInt(cond, (MirSwitchTargets<MirBasicBlockImpl>)targets, this.getTerminatorSource(source));
    }

    public final void terminateWithFalseUnwind(@NotNull MirBasicBlockImpl realTarget, @Nullable MirBasicBlockImpl unwind, @Nullable MirSourceInfo source) {
        Intrinsics.checkNotNullParameter((Object)realTarget, (String)"realTarget");
        this.setTerminator((MirTerminator<MirBasicBlockImpl>)new MirTerminator.FalseUnwind<MirBasicBlock>(realTarget, unwind, this.getTerminatorSource(source)));
    }

    public final void terminateWithFalseEdges(@NotNull MirBasicBlockImpl realTarget, @Nullable MirBasicBlockImpl imaginaryTarget, @Nullable MirSourceInfo source) {
        Intrinsics.checkNotNullParameter((Object)realTarget, (String)"realTarget");
        if (imaginaryTarget != null && !Intrinsics.areEqual((Object)imaginaryTarget, (Object)realTarget)) {
            this.setTerminator((MirTerminator<MirBasicBlockImpl>)new MirTerminator.FalseEdge<MirBasicBlock>(realTarget, imaginaryTarget, this.getTerminatorSource(source)));
        } else {
            this.terminateWithGoto(realTarget, source);
        }
    }

    public final void terminateWithUnreachable(@Nullable MirSourceInfo source) {
        this.setTerminator(new MirTerminator.Unreachable(this.getTerminatorSource(source)));
    }

    public final void terminateWithResume(@Nullable MirSourceInfo source) {
        this.setTerminator(new MirTerminator.Resume(this.getTerminatorSource(source)));
    }

    public final void terminateWithCall(@NotNull MirOperand callee, @NotNull List<? extends MirOperand> args, @NotNull MirPlace destination, @Nullable MirBasicBlockImpl target, @Nullable MirBasicBlockImpl unwind, boolean fromCall, @Nullable MirSourceInfo source) {
        Intrinsics.checkNotNullParameter((Object)callee, (String)"callee");
        Intrinsics.checkNotNullParameter(args, (String)"args");
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        this.setTerminator((MirTerminator<MirBasicBlockImpl>)new MirTerminator.Call<MirBasicBlock>(callee, args, destination, target, unwind, fromCall, this.getTerminatorSource(source)));
    }

    private final RsFunction getResolvedFunction(Ty $this$getResolvedFunction) {
        RsCallable def;
        return $this$getResolvedFunction instanceof TyFnDef ? ((def = ((TyFnDef)$this$getResolvedFunction).getDef()) instanceof RsCallable.Function ? ((RsCallable.Function)def).getFn() : null) : null;
    }

    public final void terminateWithDrop(@NotNull MirPlace place, @NotNull MirBasicBlockImpl target, @NotNull UnwindAction<MirBasicBlockImpl> unwind, @Nullable MirSourceInfo source) {
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter(unwind, (String)"unwind");
        this.setTerminator((MirTerminator<MirBasicBlockImpl>)new MirTerminator.Drop<MirBasicBlockImpl>(place, (MirBasicBlockImpl)((MirBasicBlock)target), unwind, this.getTerminatorSource(source)));
    }

    private final MirSourceInfo getTerminatorSource(MirSourceInfo source) {
        if (!(source == null ^ this.terminatorSource == null)) {
            boolean bl = false;
            String string = source != null ? "Source can't be specified when terminator source is specified" : "Source must be specified if terminator source is not specified";
            throw new IllegalArgumentException(string.toString());
        }
        MirSourceInfo mirSourceInfo = source;
        if (mirSourceInfo == null) {
            MirSourceInfo mirSourceInfo2 = this.terminatorSource;
            mirSourceInfo = mirSourceInfo2;
            Intrinsics.checkNotNull((Object)mirSourceInfo2);
        }
        return mirSourceInfo;
    }

    private final MirBasicBlockImpl push(MirStatement statement) {
        MirBasicBlockImpl mirBasicBlockImpl;
        MirBasicBlockImpl $this$push_u24lambda_u240 = mirBasicBlockImpl = this;
        boolean bl = false;
        $this$push_u24lambda_u240.getStatements().add(statement);
        return mirBasicBlockImpl;
    }

    public final void unwindTerminatorTo(@NotNull MirBasicBlockImpl block) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        MirTerminator<MirBasicBlockImpl> terminator = this.getTerminator();
        if (terminator.isDummy()) {
            if (!this.buildParameters.getAllowTerminatorUnwindErrors()) {
                throw new MirBuildException(MirBuildErrorReason.TerminatorIsExpectedToBeSpecifiedByThisMoment, null, 2, null);
            }
        } else if (terminator instanceof MirTerminator.Assert) {
            this.setTerminator(MirTerminator.Assert.copy$default((MirTerminator.Assert)terminator, null, false, null, null, block, null, 47, null));
        } else if (terminator instanceof MirTerminator.FalseUnwind) {
            this.setTerminator(MirTerminator.FalseUnwind.copy$default((MirTerminator.FalseUnwind)terminator, null, block, null, 5, null));
        } else if (terminator instanceof MirTerminator.Call) {
            this.setTerminator(MirTerminator.Call.copy$default((MirTerminator.Call)terminator, null, null, null, null, block, false, null, 111, null));
        } else if (terminator instanceof MirTerminator.Drop) {
            if (((MirTerminator.Drop)terminator).getUnwind() instanceof UnwindAction.Cleanup) {
                MirSourceInfo sourceInfo = ((MirTerminator.Drop)terminator).getSource();
                ((MirBasicBlockImpl)((UnwindAction.Cleanup)((MirTerminator.Drop)terminator).getUnwind()).getCleanup()).terminateWithGoto(block, sourceInfo);
            } else {
                this.setTerminator(MirTerminator.Drop.copy$default((MirTerminator.Drop)terminator, null, null, new UnwindAction.Cleanup<MirBasicBlock>(block), null, 11, null));
            }
        } else if (!this.buildParameters.getAllowTerminatorUnwindErrors()) {
            throw new MirBuildException(MirBuildErrorReason.TerminatorIsNotUnwindable, null, 2, null);
        }
    }

    @NotNull
    public final MirBasicBlockImpl copy(int index, boolean unwind, @NotNull List<MirStatement> statements, @NotNull MirTerminator<MirBasicBlockImpl> terminator, @NotNull MirBuildParameters buildParameters) {
        Intrinsics.checkNotNullParameter(statements, (String)"statements");
        Intrinsics.checkNotNullParameter(terminator, (String)"terminator");
        Intrinsics.checkNotNullParameter((Object)buildParameters, (String)"buildParameters");
        return new MirBasicBlockImpl(index, unwind, statements, terminator, buildParameters);
    }

    public static /* synthetic */ MirBasicBlockImpl copy$default(MirBasicBlockImpl mirBasicBlockImpl, int n, boolean bl, List list, MirTerminator mirTerminator, MirBuildParameters mirBuildParameters, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = mirBasicBlockImpl.getIndex();
        }
        if ((n2 & 2) != 0) {
            bl = mirBasicBlockImpl.getUnwind();
        }
        if ((n2 & 4) != 0) {
            list = mirBasicBlockImpl.getStatements();
        }
        if ((n2 & 8) != 0) {
            mirTerminator = mirBasicBlockImpl.getTerminator();
        }
        if ((n2 & 0x10) != 0) {
            mirBuildParameters = mirBasicBlockImpl.buildParameters;
        }
        return mirBasicBlockImpl.copy(n, bl, list, mirTerminator, mirBuildParameters);
    }

    @NotNull
    public String toString() {
        return "bb" + this.getIndex();
    }
}

