/*
 * Decompiled with CFR 0.152.
 */
package org.rust.lang.core.mir.schemas;

import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.rust.lang.core.mir.schemas.MirAssertKind;
import org.rust.lang.core.mir.schemas.MirBasicBlock;
import org.rust.lang.core.mir.schemas.MirBody;
import org.rust.lang.core.mir.schemas.MirBorrowKind;
import org.rust.lang.core.mir.schemas.MirConstant;
import org.rust.lang.core.mir.schemas.MirLocal;
import org.rust.lang.core.mir.schemas.MirLocation;
import org.rust.lang.core.mir.schemas.MirOperand;
import org.rust.lang.core.mir.schemas.MirPlace;
import org.rust.lang.core.mir.schemas.MirPlaceContext;
import org.rust.lang.core.mir.schemas.MirProjectionElem;
import org.rust.lang.core.mir.schemas.MirRvalue;
import org.rust.lang.core.mir.schemas.MirSourceInfo;
import org.rust.lang.core.mir.schemas.MirSourceScope;
import org.rust.lang.core.mir.schemas.MirSpan;
import org.rust.lang.core.mir.schemas.MirStatement;
import org.rust.lang.core.mir.schemas.MirTerminator;
import org.rust.lang.core.mir.schemas.MirVarDebugInfo;
import org.rust.lang.core.mir.schemas.TyContext;
import org.rust.lang.core.types.consts.Const;
import org.rust.lang.core.types.ty.Mutability;
import org.rust.lang.core.types.ty.Ty;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00a8\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0003H\u0016J\u0018\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J \u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J \u0010\u001a\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\"\u0010\u001b\u001a\u00020\u00052\u0010\u0010\u001c\u001a\f\u0012\u0004\u0012\u00020\u001e0\u001dj\u0002`\u001f2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J \u0010 \u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0018\u0010!\u001a\u00020\u00052\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010$\u001a\u00020\u00052\u0006\u0010%\u001a\u00020&H\u0016J\u0018\u0010'\u001a\u00020\u00052\u0006\u0010(\u001a\u00020)2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J \u0010*\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010+\u001a\u00020,2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0018\u0010-\u001a\u00020\u00052\u0006\u0010+\u001a\u00020,2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u001e\u0010.\u001a\u00020\u00052\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\n002\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0018\u00101\u001a\u00020\u00052\u0006\u00102\u001a\u0002032\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0018\u00104\u001a\u00020\u00052\u0006\u00105\u001a\u0002062\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u00107\u001a\u00020\u00052\u0006\u00108\u001a\u000209H\u0016J\u0018\u0010:\u001a\u00020\u00052\u0006\u0010;\u001a\u00020\u001e2\u0006\u0010\u0016\u001a\u00020<H\u0016J\u0018\u0010=\u001a\u00020\u00052\u0006\u0010>\u001a\u00020?2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006@\u00c0\u0006\u0001"}, d2={"Lorg/rust/lang/core/mir/schemas/MirVisitor;", "", "returnPlace", "Lorg/rust/lang/core/mir/schemas/MirLocal;", "visitBody", "", "body", "Lorg/rust/lang/core/mir/schemas/MirBody;", "visitBasicBlock", "block", "Lorg/rust/lang/core/mir/schemas/MirBasicBlock;", "visitSourceScope", "scope", "Lorg/rust/lang/core/mir/schemas/MirSourceScope;", "visitLocalDecl", "local", "visitVarDebugInfo", "varDebugInfo", "Lorg/rust/lang/core/mir/schemas/MirVarDebugInfo;", "visitPlace", "place", "Lorg/rust/lang/core/mir/schemas/MirPlace;", "context", "Lorg/rust/lang/core/mir/schemas/MirPlaceContext;", "location", "Lorg/rust/lang/core/mir/schemas/MirLocation;", "visitProjection", "visitProjectionElem", "elem", "Lorg/rust/lang/core/mir/schemas/MirProjectionElem;", "Lorg/rust/lang/core/types/ty/Ty;", "Lorg/rust/lang/core/mir/schemas/PlaceElem;", "visitLocal", "visitConstant", "constant", "Lorg/rust/lang/core/mir/schemas/MirConstant;", "visitSpan", "span", "Lorg/rust/lang/core/mir/schemas/MirSpan;", "visitStatement", "statement", "Lorg/rust/lang/core/mir/schemas/MirStatement;", "visitAssign", "rvalue", "Lorg/rust/lang/core/mir/schemas/MirRvalue;", "visitRvalue", "visitTerminator", "terminator", "Lorg/rust/lang/core/mir/schemas/MirTerminator;", "visitOperand", "operand", "Lorg/rust/lang/core/mir/schemas/MirOperand;", "visitAssertMessage", "msg", "Lorg/rust/lang/core/mir/schemas/MirAssertKind;", "visitSourceInfo", "source", "Lorg/rust/lang/core/mir/schemas/MirSourceInfo;", "visitTy", "ty", "Lorg/rust/lang/core/mir/schemas/TyContext;", "visitTyConst", "const", "Lorg/rust/lang/core/types/consts/Const;", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nMirVisitor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MirVisitor.kt\norg/rust/lang/core/mir/schemas/MirVisitor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,409:1\n1#2:410\n*E\n"})
public interface MirVisitor {
    @NotNull
    public MirLocal returnPlace();

    default public void visitBody(@NotNull MirBody body) {
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        for (MirBasicBlock block : body.getBasicBlocks()) {
            this.visitBasicBlock(block);
        }
        for (MirSourceScope scope : body.getSourceScopes()) {
            this.visitSourceScope(scope);
        }
        for (MirLocal local : body.getLocalDecls()) {
            this.visitLocalDecl(local);
        }
        for (MirVarDebugInfo varDebugInfo : body.getVarDebugInfo()) {
            this.visitVarDebugInfo(body, varDebugInfo);
        }
        this.visitSpan(body.getSpan());
    }

    default public void visitBasicBlock(@NotNull MirBasicBlock block) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        Iterator iterator2 = ((Iterable)block.getStatements()).iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int index = n++;
            MirStatement statement = (MirStatement)iterator2.next();
            MirLocation location = new MirLocation(block, index);
            this.visitStatement(statement, location);
        }
        this.visitTerminator(block.getTerminator(), block.getTerminatorLocation());
    }

    default public void visitSourceScope(@NotNull MirSourceScope scope) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
            this.visitSpan(scope.getSpan());
            MirSourceScope mirSourceScope = scope.getParentScope();
            if (mirSourceScope == null) break block0;
            MirSourceScope it2 = mirSourceScope;
            boolean bl = false;
            this.visitSourceScope(it2);
        }
    }

    default public void visitLocalDecl(@NotNull MirLocal local) {
        Intrinsics.checkNotNullParameter((Object)local, (String)"local");
        this.visitTy(local.getTy(), new TyContext.LocalDecl(local, local.getSource()));
        this.visitSourceInfo(local.getSource());
    }

    default public void visitVarDebugInfo(@NotNull MirBody body, @NotNull MirVarDebugInfo varDebugInfo) {
        Object v0;
        block9: {
            Intrinsics.checkNotNullParameter((Object)body, (String)"body");
            Intrinsics.checkNotNullParameter((Object)varDebugInfo, (String)"varDebugInfo");
            this.visitSourceInfo(varDebugInfo.getSource());
            Iterable iterable = body.getBasicBlocks();
            Iterator iterator2 = iterable.iterator();
            while (iterator2.hasNext()) {
                Object t = iterator2.next();
                MirBasicBlock it2 = (MirBasicBlock)t;
                boolean bl = false;
                if (!(it2.getIndex() == 0)) continue;
                v0 = t;
                break block9;
            }
            v0 = null;
        }
        MirBasicBlock mirBasicBlock = v0;
        if (mirBasicBlock == null) {
            return;
        }
        MirBasicBlock firstBlock = mirBasicBlock;
        MirLocation location = new MirLocation(firstBlock, 0);
        MirVarDebugInfo.Contents value = varDebugInfo.getContents();
        if (value instanceof MirVarDebugInfo.Contents.Constant) {
            this.visitConstant(((MirVarDebugInfo.Contents.Constant)value).getConstant(), location);
        } else if (value instanceof MirVarDebugInfo.Contents.Place) {
            this.visitPlace(((MirVarDebugInfo.Contents.Place)value).getPlace(), MirPlaceContext.NonUse.VarDebugInfo.INSTANCE, location);
        } else if (value instanceof MirVarDebugInfo.Contents.Composite) {
            this.visitTy(((MirVarDebugInfo.Contents.Composite)value).getTy(), new TyContext.Location(location));
            for (MirVarDebugInfo.Fragment fragment : ((MirVarDebugInfo.Contents.Composite)value).getFragments()) {
                this.visitPlace(fragment.getContents(), MirPlaceContext.NonUse.VarDebugInfo.INSTANCE, location);
            }
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    default public void visitPlace(@NotNull MirPlace place, @NotNull MirPlaceContext context, @NotNull MirLocation location) {
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        MirPlaceContext currentContext = context;
        if (!((Collection)place.getProjections()).isEmpty() && currentContext.isUse()) {
            currentContext = currentContext.isMutatingUse() ? (MirPlaceContext)MirPlaceContext.MutatingUse.Projection.INSTANCE : (MirPlaceContext)MirPlaceContext.NonMutatingUse.Projection.INSTANCE;
        }
        this.visitLocal(place.getLocal(), currentContext, location);
        this.visitProjection(place, currentContext, location);
    }

    default public void visitProjection(@NotNull MirPlace place, @NotNull MirPlaceContext context, @NotNull MirLocation location) {
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        for (MirProjectionElem elem : CollectionsKt.reversed((Iterable)place.getProjections())) {
            this.visitProjectionElem(elem, location);
        }
    }

    default public void visitProjectionElem(@NotNull MirProjectionElem<? extends Ty> elem, @NotNull MirLocation location) {
        Intrinsics.checkNotNullParameter(elem, (String)"elem");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        MirProjectionElem<? extends Ty> mirProjectionElem = elem;
        if (mirProjectionElem instanceof MirProjectionElem.Field) {
            this.visitTy((Ty)((MirProjectionElem.Field)elem).getElem(), new TyContext.Location(location));
        } else if (mirProjectionElem instanceof MirProjectionElem.Index) {
            this.visitLocal(((MirProjectionElem.Index)elem).getIndex(), MirPlaceContext.NonMutatingUse.Copy.INSTANCE, location);
        } else if (!(mirProjectionElem instanceof MirProjectionElem.Deref || mirProjectionElem instanceof MirProjectionElem.ConstantIndex || mirProjectionElem instanceof MirProjectionElem.Subslice || mirProjectionElem instanceof MirProjectionElem.Downcast)) {
            throw new NoWhenBranchMatchedException();
        }
    }

    default public void visitLocal(@NotNull MirLocal local, @NotNull MirPlaceContext context, @NotNull MirLocation location) {
        Intrinsics.checkNotNullParameter((Object)local, (String)"local");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
    }

    default public void visitConstant(@NotNull MirConstant constant, @NotNull MirLocation location) {
        Intrinsics.checkNotNullParameter((Object)constant, (String)"constant");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        this.visitSpan(constant.getSpan());
    }

    default public void visitSpan(@NotNull MirSpan span) {
        Intrinsics.checkNotNullParameter((Object)span, (String)"span");
    }

    default public void visitStatement(@NotNull MirStatement statement, @NotNull MirLocation location) {
        Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        this.visitSourceInfo(statement.getSource());
        MirStatement mirStatement = statement;
        if (mirStatement instanceof MirStatement.Assign) {
            this.visitAssign(((MirStatement.Assign)statement).getPlace(), ((MirStatement.Assign)statement).getRvalue(), location);
        } else if (mirStatement instanceof MirStatement.FakeRead) {
            this.visitPlace(((MirStatement.FakeRead)statement).getPlace(), MirPlaceContext.NonMutatingUse.Inspect.INSTANCE, location);
        } else if (mirStatement instanceof MirStatement.StorageDead) {
            this.visitLocal(((MirStatement.StorageDead)statement).getLocal(), MirPlaceContext.NonUse.StorageLive.INSTANCE, location);
        } else if (mirStatement instanceof MirStatement.StorageLive) {
            this.visitLocal(((MirStatement.StorageLive)statement).getLocal(), MirPlaceContext.NonUse.StorageDead.INSTANCE, location);
        } else if (mirStatement instanceof MirStatement.PlaceMention) {
            this.visitPlace(((MirStatement.PlaceMention)statement).getPlace(), MirPlaceContext.NonUse.PlaceMention.INSTANCE, location);
        } else if (mirStatement instanceof MirStatement.Drop) {
            this.visitPlace(((MirStatement.Drop)statement).getPlace(), MirPlaceContext.MutatingUse.Drop.INSTANCE, location);
        } else if (mirStatement instanceof MirStatement.Uncontrolled) {
            this.visitPlace(((MirStatement.Uncontrolled)statement).getPlace(), MirPlaceContext.NonMutatingUse.Copy.INSTANCE, location);
        } else if (!(mirStatement instanceof MirStatement.UncontrolledAll)) {
            throw new NoWhenBranchMatchedException();
        }
    }

    default public void visitAssign(@NotNull MirPlace place, @NotNull MirRvalue rvalue, @NotNull MirLocation location) {
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        Intrinsics.checkNotNullParameter((Object)rvalue, (String)"rvalue");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        this.visitPlace(place, MirPlaceContext.MutatingUse.Store.INSTANCE, location);
        this.visitRvalue(rvalue, location);
    }

    default public void visitRvalue(@NotNull MirRvalue rvalue, @NotNull MirLocation location) {
        Intrinsics.checkNotNullParameter((Object)rvalue, (String)"rvalue");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        MirRvalue mirRvalue = rvalue;
        if (mirRvalue instanceof MirRvalue.Use) {
            this.visitOperand(((MirRvalue.Use)rvalue).getOperand(), location);
        } else if (mirRvalue instanceof MirRvalue.Repeat) {
            this.visitOperand(((MirRvalue.Repeat)rvalue).getOperand(), location);
            this.visitTyConst(((MirRvalue.Repeat)rvalue).getCount(), location);
        } else if (!(mirRvalue instanceof MirRvalue.ThreadLocalRef)) {
            if (mirRvalue instanceof MirRvalue.Ref) {
                MirPlaceContext mirPlaceContext;
                MirBorrowKind mirBorrowKind = ((MirRvalue.Ref)rvalue).getBorrowKind();
                if (Intrinsics.areEqual((Object)mirBorrowKind, (Object)MirBorrowKind.Shared.INSTANCE)) {
                    mirPlaceContext = MirPlaceContext.NonMutatingUse.SharedBorrow.INSTANCE;
                } else if (Intrinsics.areEqual((Object)mirBorrowKind, (Object)MirBorrowKind.Shallow.INSTANCE)) {
                    mirPlaceContext = MirPlaceContext.NonMutatingUse.ShallowBorrow.INSTANCE;
                } else if (Intrinsics.areEqual((Object)mirBorrowKind, (Object)MirBorrowKind.Unique.INSTANCE)) {
                    mirPlaceContext = MirPlaceContext.NonMutatingUse.UniqueBorrow.INSTANCE;
                } else if (mirBorrowKind instanceof MirBorrowKind.Mut) {
                    mirPlaceContext = MirPlaceContext.MutatingUse.Borrow.INSTANCE;
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                MirPlaceContext context = mirPlaceContext;
                this.visitPlace(((MirRvalue.Ref)rvalue).getPlace(), context, location);
            } else {
                if (mirRvalue instanceof MirRvalue.CopyForDeref) {
                    throw new NotImplementedError(null, 1, null);
                }
                if (mirRvalue instanceof MirRvalue.AddressOf) {
                    MirPlaceContext context = switch (WhenMappings.$EnumSwitchMapping$0[((MirRvalue.AddressOf)rvalue).getMutability().ordinal()]) {
                        case 1 -> MirPlaceContext.MutatingUse.RawBorrow.INSTANCE;
                        case 2 -> MirPlaceContext.NonMutatingUse.RawBorrow.INSTANCE;
                        default -> throw new NoWhenBranchMatchedException();
                    };
                    this.visitPlace(((MirRvalue.AddressOf)rvalue).getPlace(), context, location);
                } else if (mirRvalue instanceof MirRvalue.BinaryOpUse) {
                    this.visitOperand(((MirRvalue.BinaryOpUse)rvalue).getLeft(), location);
                    this.visitOperand(((MirRvalue.BinaryOpUse)rvalue).getRight(), location);
                } else if (mirRvalue instanceof MirRvalue.CheckedBinaryOpUse) {
                    this.visitOperand(((MirRvalue.CheckedBinaryOpUse)rvalue).getLeft(), location);
                    this.visitOperand(((MirRvalue.CheckedBinaryOpUse)rvalue).getRight(), location);
                } else if (mirRvalue instanceof MirRvalue.UnaryOpUse) {
                    this.visitOperand(((MirRvalue.UnaryOpUse)rvalue).getOperand(), location);
                } else if (mirRvalue instanceof MirRvalue.Discriminant) {
                    this.visitPlace(((MirRvalue.Discriminant)rvalue).getPlace(), MirPlaceContext.NonMutatingUse.Inspect.INSTANCE, location);
                } else {
                    if (mirRvalue instanceof MirRvalue.NullaryOpUse) {
                        throw new NotImplementedError(null, 1, null);
                    }
                    if (mirRvalue instanceof MirRvalue.Aggregate) {
                        MirRvalue.Aggregate aggregate = (MirRvalue.Aggregate)rvalue;
                        if (!(aggregate instanceof MirRvalue.Aggregate.Adt)) {
                            if (aggregate instanceof MirRvalue.Aggregate.Array) {
                                this.visitTy(((MirRvalue.Aggregate.Array)rvalue).getTy(), new TyContext.Location(location));
                            } else if (!(aggregate instanceof MirRvalue.Aggregate.Tuple) && !(aggregate instanceof MirRvalue.Aggregate.Closure)) {
                                throw new NoWhenBranchMatchedException();
                            }
                        }
                        for (MirOperand operand : ((MirRvalue.Aggregate)rvalue).getOperands()) {
                            this.visitOperand(operand, location);
                        }
                    } else if (mirRvalue instanceof MirRvalue.Len) {
                        this.visitPlace(((MirRvalue.Len)rvalue).getPlace(), MirPlaceContext.NonMutatingUse.Inspect.INSTANCE, location);
                    } else if (mirRvalue instanceof MirRvalue.Cast) {
                        this.visitOperand(((MirRvalue.Cast)rvalue).getOperand(), location);
                        this.visitTy(((MirRvalue.Cast)rvalue).getTy(), new TyContext.Location(location));
                    } else if (!(mirRvalue instanceof MirRvalue.SubstitutesUse)) {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
        }
    }

    default public void visitTerminator(@NotNull MirTerminator<? extends MirBasicBlock> terminator, @NotNull MirLocation location) {
        Intrinsics.checkNotNullParameter(terminator, (String)"terminator");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        this.visitSourceInfo(terminator.getSource());
        MirTerminator<? extends MirBasicBlock> mirTerminator = terminator;
        if (mirTerminator instanceof MirTerminator.Assert) {
            this.visitOperand(((MirTerminator.Assert)terminator).getCond(), location);
            this.visitAssertMessage(((MirTerminator.Assert)terminator).getMsg(), location);
        } else if (mirTerminator instanceof MirTerminator.Return) {
            this.visitLocal(this.returnPlace(), MirPlaceContext.NonMutatingUse.Move.INSTANCE, location);
        } else if (mirTerminator instanceof MirTerminator.SwitchInt) {
            this.visitOperand(((MirTerminator.SwitchInt)terminator).getDiscriminant(), location);
        } else if (mirTerminator instanceof MirTerminator.Drop) {
            this.visitPlace(((MirTerminator.Drop)terminator).getPlace(), MirPlaceContext.MutatingUse.Drop.INSTANCE, location);
        } else if (!(mirTerminator instanceof MirTerminator.Goto || mirTerminator instanceof MirTerminator.Resume || mirTerminator instanceof MirTerminator.Unreachable || mirTerminator instanceof MirTerminator.FalseEdge || mirTerminator instanceof MirTerminator.FalseUnwind)) {
            if (mirTerminator instanceof MirTerminator.Call) {
                this.visitOperand(((MirTerminator.Call)terminator).getCallee(), location);
                for (MirOperand arg : ((MirTerminator.Call)terminator).getArgs()) {
                    this.visitOperand(arg, location);
                }
                this.visitPlace(((MirTerminator.Call)terminator).getDestination(), MirPlaceContext.MutatingUse.Call.INSTANCE, location);
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    default public void visitOperand(@NotNull MirOperand operand, @NotNull MirLocation location) {
        Intrinsics.checkNotNullParameter((Object)operand, (String)"operand");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        MirOperand mirOperand = operand;
        if (mirOperand instanceof MirOperand.Copy) {
            this.visitPlace(((MirOperand.Copy)operand).getPlace(), MirPlaceContext.NonMutatingUse.Copy.INSTANCE, location);
        } else if (mirOperand instanceof MirOperand.Move) {
            this.visitPlace(((MirOperand.Move)operand).getPlace(), MirPlaceContext.NonMutatingUse.Move.INSTANCE, location);
        } else if (mirOperand instanceof MirOperand.Constant) {
            this.visitConstant(((MirOperand.Constant)operand).getConstant(), location);
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    default public void visitAssertMessage(@NotNull MirAssertKind msg, @NotNull MirLocation location) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        MirAssertKind mirAssertKind = msg;
        if (mirAssertKind instanceof MirAssertKind.Overflow) {
            this.visitOperand(((MirAssertKind.Overflow)msg).getLeft(), location);
            this.visitOperand(((MirAssertKind.Overflow)msg).getRight(), location);
        } else if (mirAssertKind instanceof MirAssertKind.OverflowNeg) {
            this.visitOperand(((MirAssertKind.OverflowNeg)msg).getArg(), location);
        } else if (mirAssertKind instanceof MirAssertKind.DivisionByZero) {
            this.visitOperand(((MirAssertKind.DivisionByZero)msg).getArg(), location);
        } else if (mirAssertKind instanceof MirAssertKind.ReminderByZero) {
            this.visitOperand(((MirAssertKind.ReminderByZero)msg).getArg(), location);
        } else if (mirAssertKind instanceof MirAssertKind.BoundsCheck) {
            this.visitOperand(((MirAssertKind.BoundsCheck)msg).getLen(), location);
            this.visitOperand(((MirAssertKind.BoundsCheck)msg).getIndex(), location);
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    default public void visitSourceInfo(@NotNull MirSourceInfo source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        this.visitSpan(source.getSpan());
        this.visitSourceScope(source.getScope());
    }

    default public void visitTy(@NotNull Ty ty2, @NotNull TyContext context) {
        Intrinsics.checkNotNullParameter((Object)ty2, (String)"ty");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
    }

    default public void visitTyConst(@NotNull Const const_, @NotNull MirLocation location) {
        Intrinsics.checkNotNullParameter((Object)const_, (String)"const");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Mutability.values().length];
            try {
                nArray[Mutability.MUTABLE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Mutability.IMMUTABLE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

